/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.BooleanArrayFSImpl;
import org.apache.uima.cas.impl.ByteArrayFSImpl;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.DoubleArrayFSImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FloatArrayFSImpl;
import org.apache.uima.cas.impl.IntArrayFSImpl;
import org.apache.uima.cas.impl.ListUtils;
import org.apache.uima.cas.impl.LongArrayFSImpl;
import org.apache.uima.cas.impl.ShortArrayFSImpl;
import org.apache.uima.cas.impl.StringArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.IntStack;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.internal.util.rb_trees.IntRedBlackTree;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class XmiCasSerializer {
    public static final int TYPE_CLASS_INTLIST = 101;
    public static final int TYPE_CLASS_FLOATLIST = 102;
    public static final int TYPE_CLASS_STRINGLIST = 103;
    public static final int TYPE_CLASS_FSLIST = 104;
    private int numChildren;
    public static final String XMLNS_NS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XMI_NS_URI = "http://www.omg.org/XMI";
    public static final String XSI_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMI_NS_PREFIX = "xmi";
    public static final String XMI_TAG_LOCAL_NAME = "XMI";
    public static final String XMI_TAG_QNAME = "xmi:XMI";
    public static final XmlElementName XMI_TAG = new XmlElementName("http://www.omg.org/XMI", "XMI", "xmi:XMI");
    public static final String INDEXED_ATTR_NAME = "_indexed";
    public static final String ID_ATTR_NAME = "xmi:id";
    public static final String XMI_VERSION_LOCAL_NAME = "version";
    public static final String XMI_VERSION_QNAME = "xmi:version";
    public static final String XMI_VERSION_VALUE = "2.0";
    public static final String DEFAULT_NAMESPACE_URI = "http:///uima/noNamespace.ecore";
    private TypeSystemImpl filterTypeSystem;
    private Logger logger;
    private Map nsUriToSchemaLocationMap = null;

    public int getNumChildren() {
        return this.numChildren;
    }

    public XmiCasSerializer(TypeSystem ts, Map nsUriToSchemaLocationMap) {
        this.filterTypeSystem = (TypeSystemImpl)ts;
        this.nsUriToSchemaLocationMap = nsUriToSchemaLocationMap;
        this.logger = UIMAFramework.getLogger(XmiCasSerializer.class);
    }

    public XmiCasSerializer(TypeSystem ts) {
        this(ts, (Map)null);
    }

    public XmiCasSerializer(TypeSystem ts, UimaContext uimaContext, Map nsUriToSchemaLocationMap) {
        this(ts, nsUriToSchemaLocationMap);
    }

    public XmiCasSerializer(TypeSystem ts, UimaContext uimaContext) {
        this(ts);
    }

    public void serialize(CAS cas, ContentHandler contentHandler) throws SAXException {
        this.serialize(cas, contentHandler, null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        contentHandler.startDocument();
        XmiCasDocSerializer ser = new XmiCasDocSerializer(contentHandler, errorHandler, ((CASImpl)cas).getBaseCAS(), null);
        ser.serialize();
        contentHandler.endDocument();
    }

    public void serialize(CAS cas, ContentHandler contentHandler, ErrorHandler errorHandler, XmiSerializationSharedData sharedData) throws SAXException {
        contentHandler.startDocument();
        XmiCasDocSerializer ser = new XmiCasDocSerializer(contentHandler, errorHandler, ((CASImpl)cas).getBaseCAS(), sharedData);
        ser.serialize();
        contentHandler.endDocument();
    }

    public static void serialize(CAS aCAS, OutputStream aStream) throws SAXException {
        XmiCasSerializer.serialize(aCAS, null, aStream, false, null);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream) throws SAXException {
        XmiCasSerializer.serialize(aCAS, aTargetTypeSystem, aStream, false, null);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream, boolean aPrettyPrint, XmiSerializationSharedData aSharedData) throws SAXException {
        XmiCasSerializer xmiCasSerializer = new XmiCasSerializer(aTargetTypeSystem);
        XMLSerializer sax2xml = new XMLSerializer(aStream, aPrettyPrint);
        xmiCasSerializer.serialize(aCAS, sax2xml.getContentHandler(), null, aSharedData);
    }

    private class XmiCasDocSerializer {
        private ContentHandler ch;
        private ErrorHandler eh = null;
        private CASImpl cas;
        private IntRedBlackTree visited;
        private IntVector indexedFSs;
        private IntStack queue;
        private final AttributesImpl emptyAttrs = new AttributesImpl();
        private AttributesImpl workAttrs = new AttributesImpl();
        private static final String cdataType = "CDATA";
        private int fsCount = 0;
        private ListUtils listUtils;
        private IntRedBlackTree arrayAndListFSs;
        private XmiSerializationSharedData sharedData;
        private XmlElementName[] xmiTypeNames;
        private Map nsUriToPrefixMap = new HashMap();
        private Set nsPrefixesUsed = new HashSet();
        boolean isFiltering;

        private XmiCasDocSerializer(ContentHandler ch, ErrorHandler eh, CASImpl cas, XmiSerializationSharedData sharedData) {
            this.ch = ch;
            this.eh = eh;
            this.cas = cas;
            this.visited = new IntRedBlackTree();
            this.queue = new IntStack();
            this.indexedFSs = new IntVector();
            this.listUtils = new ListUtils(cas, XmiCasSerializer.this.logger, eh);
            this.arrayAndListFSs = new IntRedBlackTree();
            this.sharedData = sharedData;
            this.isFiltering = XmiCasSerializer.this.filterTypeSystem != null && XmiCasSerializer.this.filterTypeSystem != cas.getTypeSystemImpl();
        }

        private void reportWarning(String message) throws SAXException {
            XmiCasSerializer.this.logger.log(Level.WARNING, message);
            if (this.eh != null) {
                this.eh.warning(new SAXParseException(message, null));
            }
        }

        private boolean isVisited(int addr) {
            return this.visited.containsKey(addr);
        }

        private void serialize() throws SAXException {
            this.initTypeAndNamespaceMappings();
            int iElementCount = 1;
            this.enqueueIncoming();
            this.enqueueIndexed();
            this.enqueueFeaturesOfIndexed();
            iElementCount += this.indexedFSs.size();
            iElementCount += this.queue.size();
            FSIndex sofaIndex = this.cas.getBaseCAS().indexRepository.getIndex("SofaIndex");
            iElementCount += sofaIndex.size();
            if (this.sharedData != null) {
                iElementCount += this.sharedData.getOutOfTypeSystemElements().size();
            }
            this.workAttrs.clear();
            this.computeNamespaceDeclarationAttrs(this.workAttrs);
            this.workAttrs.addAttribute(XmiCasSerializer.XMI_NS_URI, XmiCasSerializer.XMI_VERSION_LOCAL_NAME, XmiCasSerializer.XMI_VERSION_QNAME, cdataType, XmiCasSerializer.XMI_VERSION_VALUE);
            this.startElement(XMI_TAG, this.workAttrs, iElementCount);
            this.writeNullObject();
            this.encodeIndexed();
            this.encodeQueued();
            this.serializeOutOfTypeSystemElements();
            this.writeViews();
            this.endElement(XMI_TAG);
        }

        private void writeViews() throws SAXException {
            int numViews = this.cas.getBaseSofaCount();
            String sofaXmiId = null;
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                if (sofaNum != 1 || this.cas.isInitialSofaCreated()) {
                    FeatureStructureImpl sofa = (FeatureStructureImpl)((Object)this.cas.getView(sofaNum).getSofa());
                    sofaXmiId = this.getXmiId(sofa.getAddress());
                }
                if (loopIR == null) continue;
                int[] fsarray = loopIR.getIndexedFSs();
                this.writeView(sofaXmiId, fsarray);
            }
        }

        private void writeView(String sofaXmiId, int[] members) throws SAXException {
            List ootsMembers;
            this.workAttrs.clear();
            if (sofaXmiId != null && sofaXmiId.length() > 0) {
                this.addAttribute(this.workAttrs, "sofa", sofaXmiId);
            }
            StringBuffer membersString = new StringBuffer();
            for (int i = 0; i < members.length; ++i) {
                String xmiId = this.getXmiId(members[i]);
                if (xmiId == null) continue;
                membersString.append(xmiId).append(' ');
            }
            if (this.sharedData != null && (ootsMembers = this.sharedData.getOutOfTypeSystemViewMembers(sofaXmiId)) != null) {
                Iterator iter = ootsMembers.iterator();
                while (iter.hasNext()) {
                    membersString.append((String)iter.next()).append(' ');
                }
            }
            if (membersString.length() > 0) {
                this.addAttribute(this.workAttrs, "members", membersString.substring(0, membersString.length() - 1));
            }
            XmlElementName elemName = this.uimaTypeName2XmiElementName("uima.cas.View");
            this.startElement(elemName, this.workAttrs, 0);
            this.endElement(elemName);
        }

        private void writeNullObject() throws SAXException {
            this.workAttrs.clear();
            this.addAttribute(this.workAttrs, XmiCasSerializer.ID_ATTR_NAME, "0");
            XmlElementName elemName = this.uimaTypeName2XmiElementName("uima.cas.NULL");
            this.startElement(elemName, this.workAttrs, 0);
            this.endElement(elemName);
        }

        private void computeNamespaceDeclarationAttrs(AttributesImpl workAttrs2) {
            for (Map.Entry entry : this.nsUriToPrefixMap.entrySet()) {
                String nsUri = (String)entry.getKey();
                String prefix = (String)entry.getValue();
                this.workAttrs.addAttribute(XmiCasSerializer.XMLNS_NS_URI, prefix, "xmlns:" + prefix, cdataType, nsUri);
            }
            if (XmiCasSerializer.this.nsUriToSchemaLocationMap != null) {
                this.workAttrs.addAttribute(XmiCasSerializer.XMLNS_NS_URI, "xsi", "xmlns:xsi", cdataType, XmiCasSerializer.XSI_NS_URI);
                StringBuffer buf = new StringBuffer();
                for (Map.Entry entry : XmiCasSerializer.this.nsUriToSchemaLocationMap.entrySet()) {
                    buf.append(entry.getKey()).append(' ').append(entry.getValue()).append(' ');
                }
                this.workAttrs.addAttribute(XmiCasSerializer.XSI_NS_URI, "xsi", "xsi:schemaLocation", cdataType, buf.toString());
            }
        }

        private void enqueueIncoming() {
            if (this.sharedData == null) {
                return;
            }
            int[] fsAddrs = this.sharedData.getAllFsAddressesInIdMap();
            for (int i = 0; i < fsAddrs.length; ++i) {
                this.enqueueIndexedFs(fsAddrs[i]);
            }
        }

        private void enqueueIndexed() {
            FSIndexRepositoryImpl ir = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getBaseIndexRepository();
            int[] fsarray = ir.getIndexedFSs();
            for (int k = 0; k < fsarray.length; ++k) {
                this.enqueueIndexedFs(fsarray[k]);
            }
            int numViews = this.cas.getBaseSofaCount();
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                if (loopIR == null) continue;
                fsarray = loopIR.getIndexedFSs();
                for (int k = 0; k < fsarray.length; ++k) {
                    this.enqueueIndexedFs(fsarray[k]);
                }
            }
        }

        private void enqueueFeaturesOfIndexed() throws SAXException {
            int max = this.indexedFSs.size();
            for (int i = 0; i < max; ++i) {
                int addr = this.indexedFSs.get(i);
                int heapVal = this.cas.getHeapValue(addr);
                this.enqueueFeatures(addr, heapVal);
            }
        }

        private void enqueueIndexedFs(int addr) {
            if (this.isVisited(addr)) {
                return;
            }
            if (this.isFiltering) {
                String typeName = this.cas.getTypeSystemImpl().ll_getTypeForCode(this.cas.getHeapValue(addr)).getName();
                if (XmiCasSerializer.this.filterTypeSystem.getType(typeName) == null) {
                    return;
                }
            }
            this.visited.put(addr, addr);
            this.indexedFSs.add(addr);
        }

        private void enqueue(int addr) throws SAXException {
            if (this.isVisited(addr)) {
                return;
            }
            int typeCode = this.cas.getHeapValue(addr);
            if (this.isFiltering) {
                String typeName = this.cas.getTypeSystemImpl().ll_getTypeForCode(typeCode).getName();
                if (XmiCasSerializer.this.filterTypeSystem.getType(typeName) == null) {
                    return;
                }
            }
            this.visited.put(addr, addr);
            this.queue.push(addr);
            this.enqueueFeatures(addr, typeCode);
            if (this.cas.isFSArrayType(typeCode)) {
                this.enqueueFSArrayElements(addr);
            }
        }

        private void enqueueFeatures(int addr, int typeCode) throws SAXException {
            boolean insideListNode = this.listUtils.isListType(typeCode);
            int[] feats = this.cas.getTypeSystemImpl().ll_getAppropriateFeatures(typeCode);
            block5: for (int i = 0; i < feats.length; ++i) {
                int featAddr;
                int featVal;
                if (this.isFiltering) {
                    String fullFeatName = this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).getName();
                    if (XmiCasSerializer.this.filterTypeSystem.getFeatureByFullName(fullFeatName) == null) continue;
                }
                if ((featVal = this.cas.getHeapValue(featAddr = addr + this.cas.getFeatureOffset(feats[i]))) == 0) continue;
                int fsClass = this.classifyType(this.cas.getTypeSystemImpl().range(feats[i]));
                switch (fsClass) {
                    case 8: {
                        this.enqueue(featVal);
                        continue block5;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed()) {
                            this.enqueue(featVal);
                            continue block5;
                        }
                        if (fsClass != 7) continue block5;
                        this.enqueueFSArrayElements(featVal);
                        continue block5;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed() || insideListNode) {
                            this.enqueue(featVal);
                            continue block5;
                        }
                        if (fsClass != 104) continue block5;
                        this.enqueueFSListElements(featVal);
                    }
                }
            }
        }

        private void enqueueFSArrayElements(int addr) throws SAXException {
            int size = this.cas.ll_getArraySize(addr);
            int pos = this.cas.getArrayStartAddress(addr);
            for (int i = 0; i < size; ++i) {
                int val = this.cas.getHeapValue(pos);
                if (val != 0) {
                    this.enqueue(val);
                }
                ++pos;
            }
        }

        private void enqueueFSListElements(int addr) throws SAXException {
            int[] addrArray = this.listUtils.fsListToAddressArray(addr);
            for (int j = 0; j < addrArray.length; ++j) {
                if (addrArray[j] == 0) continue;
                this.enqueue(addrArray[j]);
            }
        }

        private void encodeIndexed() throws SAXException {
            int max = this.indexedFSs.size();
            for (int i = 0; i < max; ++i) {
                this.encodeFS(this.indexedFSs.get(i));
            }
        }

        private void encodeQueued() throws SAXException {
            while (!this.queue.empty()) {
                int addr = this.queue.pop();
                this.encodeFS(addr);
            }
        }

        private void encodeFS(int addr) throws SAXException {
            ++this.fsCount;
            this.workAttrs.clear();
            this.addAttribute(this.workAttrs, XmiCasSerializer.ID_ATTR_NAME, this.getXmiId(addr));
            int typeCode = this.cas.getHeapValue(addr);
            XmlElementName xmlElementName = this.xmiTypeNames[typeCode];
            int typeClass = this.classifyType(typeCode);
            switch (typeClass) {
                case 8: 
                case 101: 
                case 102: 
                case 103: 
                case 104: {
                    List childElements = this.encodeFeatures(addr, this.workAttrs, typeClass != 8);
                    this.startElement(xmlElementName, this.workAttrs, childElements.size());
                    this.sendElementEvents(childElements);
                    this.endElement(xmlElementName);
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    this.workAttrs.addAttribute("", "", "elements", cdataType, this.arrayToString(addr, typeClass));
                    this.startElement(xmlElementName, this.workAttrs, 0);
                    this.endElement(xmlElementName);
                    break;
                }
                case 6: {
                    ArrayList childElements = new ArrayList();
                    this.stringArrayToElementList("elements", addr, childElements);
                    this.startElement(xmlElementName, this.workAttrs, childElements.size());
                    this.sendElementEvents(childElements);
                    this.endElement(xmlElementName);
                    break;
                }
                default: {
                    throw new SAXException("Error classifying FS type.");
                }
            }
        }

        private String getXmiId(int addr) {
            if (addr == 0) {
                return null;
            }
            if (this.isFiltering) {
                String typeName = this.cas.getTypeSystemImpl().ll_getTypeForCode(this.cas.getHeapValue(addr)).getName();
                if (XmiCasSerializer.this.filterTypeSystem.getType(typeName) == null) {
                    return null;
                }
            }
            if (this.sharedData == null) {
                return Integer.toString(addr);
            }
            return this.sharedData.getXmiId(addr);
        }

        private void sendElementEvents(List elements) throws SAXException {
            for (XmlElementNameAndContents elem : elements) {
                if (elem.contents != null) {
                    this.startElement(elem.name, this.emptyAttrs, 1);
                    this.addText(elem.contents);
                } else {
                    this.startElement(elem.name, this.emptyAttrs, 0);
                }
                this.endElement(elem.name);
            }
        }

        private List encodeFeatures(int addr, AttributesImpl attrs, boolean insideListNode) throws SAXException {
            XmiSerializationSharedData.OotsElementData oed;
            ArrayList<XmlElementNameAndContents> childElements = new ArrayList<XmlElementNameAndContents>();
            int heapValue = this.cas.getHeapValue(addr);
            int[] feats = this.cas.getTypeSystemImpl().ll_getAppropriateFeatures(heapValue);
            for (int i = 0; i < feats.length; ++i) {
                String attrValue;
                if (this.isFiltering) {
                    String fullFeatName = this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).getName();
                    if (XmiCasSerializer.this.filterTypeSystem.getFeatureByFullName(fullFeatName) == null) continue;
                }
                int featAddr = addr + this.cas.getFeatureOffset(feats[i]);
                int featVal = this.cas.getHeapValue(featAddr);
                String featName = this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).getShortName();
                int fsClass = this.classifyType(this.cas.getTypeSystemImpl().range(feats[i]));
                switch (fsClass) {
                    case 1: 
                    case 2: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        attrValue = this.cas.getFeatureValueAsString(addr, feats[i]);
                        break;
                    }
                    case 3: {
                        if (featVal == 0) {
                            attrValue = null;
                            break;
                        }
                        attrValue = this.cas.getStringForCode(featVal);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed()) {
                            attrValue = this.getXmiId(featVal);
                            break;
                        }
                        attrValue = this.arrayToString(featVal, fsClass);
                        break;
                    }
                    case 6: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed()) {
                            attrValue = this.getXmiId(featVal);
                            break;
                        }
                        this.stringArrayToElementList(featName, featVal, childElements);
                        attrValue = null;
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 104: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed() || insideListNode) {
                            attrValue = this.getXmiId(featVal);
                            break;
                        }
                        attrValue = this.listToString(featVal, fsClass);
                        break;
                    }
                    case 103: {
                        if (this.cas.getTypeSystemImpl().ll_getFeatureForCode(feats[i]).isMultipleReferencesAllowed() || insideListNode) {
                            attrValue = this.getXmiId(featVal);
                            break;
                        }
                        String[] array = this.listUtils.stringListToStringArray(featVal);
                        if (array.length > 0 && !this.arrayAndListFSs.put(featVal, featVal)) {
                            this.reportWarning("Warning: multiple references to a ListFS.  Reference identity will not be preserved.");
                        }
                        for (int j = 0; j < array.length; ++j) {
                            childElements.add(new XmlElementNameAndContents(new XmlElementName(null, featName, featName), array[j]));
                        }
                        attrValue = null;
                        break;
                    }
                    default: {
                        attrValue = this.getXmiId(featVal);
                    }
                }
                if (attrValue == null || featName == null) continue;
                this.addAttribute(attrs, featName, attrValue);
            }
            if (this.sharedData != null && (oed = this.sharedData.getOutOfTypeSystemFeatures(addr)) != null) {
                for (XmlAttribute attr : oed.attributes) {
                    this.addAttribute(this.workAttrs, attr.name, attr.value);
                }
                childElements.addAll(oed.childElements);
            }
            return childElements;
        }

        private void addText(String text) throws SAXException {
            this.ch.characters(text.toCharArray(), 0, text.length());
        }

        private void addAttribute(AttributesImpl attrs, String attrName, String attrValue) {
            attrs.addAttribute(null, null, attrName, cdataType, attrValue);
        }

        private void startElement(XmlElementName name, Attributes attrs, int aNumChildren) throws SAXException {
            XmiCasSerializer.this.numChildren = aNumChildren;
            this.ch.startElement("", name.localName, name.qName, attrs);
        }

        private void endElement(XmlElementName name) throws SAXException {
            this.ch.endElement(name.nsUri, name.localName, name.qName);
        }

        private void stringArrayToElementList(String featName, int addr, List resultList) throws SAXException {
            if (addr == 0) {
                return;
            }
            int size = this.cas.ll_getArraySize(addr);
            if (size > 0 && !this.arrayAndListFSs.put(addr, addr)) {
                this.reportWarning("Warning: multiple references to a String array.  Reference identity will not be preserved.");
            }
            int pos = this.cas.getArrayStartAddress(addr);
            for (int j = 0; j < size; ++j) {
                String s = this.cas.getStringForCode(this.cas.getHeapValue(pos));
                resultList.add(new XmlElementNameAndContents(new XmlElementName(null, featName, featName), s));
                ++pos;
            }
        }

        private String arrayToString(int addr, int arrayType) throws SAXException {
            String[] fsvalues;
            FeatureStructureImplC fs;
            if (addr == 0) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            int size = this.cas.ll_getArraySize(addr);
            if (size > 0 && !this.arrayAndListFSs.put(addr, addr)) {
                this.reportWarning("Warning: multiple references to an array.  Reference identity will not be preserved in XMI.");
            }
            String elemStr = null;
            if (arrayType == 7) {
                int pos = this.cas.getArrayStartAddress(addr);
                List ootsArrayElementsList = this.sharedData == null ? null : this.sharedData.getOutOfTypeSystemArrayElements(addr);
                int ootsIndex = 0;
                for (int j = 0; j < size; ++j) {
                    int heapValue = this.cas.getHeapValue(pos++);
                    elemStr = null;
                    String xmiId = this.getXmiId(heapValue);
                    if (xmiId != null) {
                        elemStr = xmiId;
                    } else {
                        elemStr = "0";
                        if (ootsArrayElementsList != null) {
                            while (ootsIndex < ootsArrayElementsList.size()) {
                                XmiSerializationSharedData.XmiArrayElement arel = (XmiSerializationSharedData.XmiArrayElement)ootsArrayElementsList.get(ootsIndex++);
                                if (arel.index != j) continue;
                                elemStr = arel.xmiId;
                                break;
                            }
                        }
                    }
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(elemStr);
                }
                return buf.toString();
            }
            if (arrayType == 15) {
                ByteArrayFSImpl byteArrayFS = new ByteArrayFSImpl(addr, this.cas);
                int len = byteArrayFS.size();
                for (int i = 0; i < len; ++i) {
                    byte b = byteArrayFS.get(i);
                    if ((b & 0xF0) == 0) {
                        buf.append('0').append(Integer.toHexString(b).toUpperCase());
                        continue;
                    }
                    buf.append(Integer.toHexString(0xFF & b).toUpperCase());
                }
                return buf.toString();
            }
            switch (arrayType) {
                case 4: {
                    fs = new IntArrayFSImpl(addr, this.cas);
                    break;
                }
                case 5: {
                    fs = new FloatArrayFSImpl(addr, this.cas);
                    break;
                }
                case 14: {
                    fs = new BooleanArrayFSImpl(addr, this.cas);
                    break;
                }
                case 16: {
                    fs = new ShortArrayFSImpl(addr, this.cas);
                    break;
                }
                case 17: {
                    fs = new LongArrayFSImpl(addr, this.cas);
                    break;
                }
                case 18: {
                    fs = new DoubleArrayFSImpl(addr, this.cas);
                    break;
                }
                default: {
                    fs = null;
                }
            }
            if (arrayType == 6) {
                StringArrayFSImpl strFS = new StringArrayFSImpl(addr, this.cas);
                fsvalues = strFS.toArray();
            } else {
                fsvalues = fs.toStringArray();
            }
            for (int i = 0; i < fsvalues.length; ++i) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(fsvalues[i]);
            }
            return buf.toString();
        }

        private String listToString(int addr, int arrayType) throws SAXException {
            if (addr == 0) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            String[] array = new String[]{};
            switch (arrayType) {
                case 101: {
                    array = this.listUtils.intListToStringArray(addr);
                    break;
                }
                case 102: {
                    array = this.listUtils.floatListToStringArray(addr);
                    break;
                }
                case 103: {
                    array = this.listUtils.stringListToStringArray(addr);
                    break;
                }
                case 104: {
                    array = this.listUtils.fsListToXmiIdStringArray(addr, this.sharedData);
                }
            }
            if (array.length > 0 && !this.arrayAndListFSs.put(addr, addr)) {
                this.reportWarning("Warning: multiple references to a ListFS.  Reference identity will not be preserved.");
            }
            for (int j = 0; j < array.length; ++j) {
                buf.append(array[j]);
                if (j >= array.length - 1) continue;
                buf.append(' ');
            }
            return buf.toString();
        }

        private final int classifyType(int type) {
            if (this.listUtils.isIntListType(type)) {
                return 101;
            }
            if (this.listUtils.isFloatListType(type)) {
                return 102;
            }
            if (this.listUtils.isStringListType(type)) {
                return 103;
            }
            if (this.listUtils.isFsListType(type)) {
                return 104;
            }
            return this.cas.ll_getTypeClass(type);
        }

        private void initTypeAndNamespaceMappings() {
            this.nsUriToPrefixMap.put(XmiCasSerializer.XMI_NS_URI, XmiCasSerializer.XMI_NS_PREFIX);
            this.xmiTypeNames = new XmlElementName[this.cas.getTypeSystemImpl().getLargestTypeCode() + 1];
            if (this.sharedData != null) {
                for (XmiSerializationSharedData.OotsElementData oed : this.sharedData.getOutOfTypeSystemElements()) {
                    String nsUri = oed.elementName.nsUri;
                    String qname = oed.elementName.qName;
                    String localName = oed.elementName.localName;
                    String prefix = qname.substring(0, qname.indexOf(localName) - 1);
                    this.nsUriToPrefixMap.put(nsUri, prefix);
                    this.nsPrefixesUsed.add(prefix);
                }
            }
            Iterator it = this.cas.getTypeSystemImpl().getTypeIterator();
            while (it.hasNext()) {
                TypeImpl t = (TypeImpl)it.next();
                this.xmiTypeNames[t.getCode()] = this.uimaTypeName2XmiElementName(t.getName());
            }
        }

        private XmlElementName uimaTypeName2XmiElementName(String uimaTypeName) {
            String nsUri;
            String shortName;
            String namespace;
            int lastDotIndex = uimaTypeName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                namespace = null;
                shortName = uimaTypeName;
                nsUri = XmiCasSerializer.DEFAULT_NAMESPACE_URI;
            } else {
                namespace = uimaTypeName.substring(0, lastDotIndex);
                shortName = uimaTypeName.substring(lastDotIndex + 1);
                nsUri = "http:///" + namespace.replace('.', '/') + ".ecore";
            }
            String prefix = (String)this.nsUriToPrefixMap.get(nsUri);
            if (prefix == null) {
                if (namespace != null) {
                    int secondLastDotIndex = namespace.lastIndexOf(46);
                    prefix = namespace.substring(secondLastDotIndex + 1);
                } else {
                    prefix = "noNamespace";
                }
                if (this.nsPrefixesUsed.contains(prefix)) {
                    String basePrefix = prefix;
                    int num = 2;
                    while (this.nsPrefixesUsed.contains(basePrefix + num)) {
                        ++num;
                    }
                    prefix = basePrefix + num;
                }
                this.nsUriToPrefixMap.put(nsUri, prefix);
                this.nsPrefixesUsed.add(prefix);
            }
            return new XmlElementName(nsUri, shortName, prefix + ':' + shortName);
        }

        private void serializeOutOfTypeSystemElements() throws SAXException {
            if (this.sharedData == null) {
                return;
            }
            for (XmiSerializationSharedData.OotsElementData oed : this.sharedData.getOutOfTypeSystemElements()) {
                this.workAttrs.clear();
                this.addAttribute(this.workAttrs, XmiCasSerializer.ID_ATTR_NAME, oed.xmiId);
                for (XmlAttribute attr : oed.attributes) {
                    this.addAttribute(this.workAttrs, attr.name, attr.value);
                }
                this.startElement(oed.elementName, this.workAttrs, oed.childElements.size());
                for (XmlElementNameAndContents child : oed.childElements) {
                    this.workAttrs.clear();
                    for (XmlAttribute attr : child.attributes) {
                        this.addAttribute(this.workAttrs, attr.name, attr.value);
                    }
                    if (child.contents != null) {
                        this.startElement(child.name, this.workAttrs, 1);
                        this.addText(child.contents);
                    } else {
                        this.startElement(child.name, this.workAttrs, 0);
                    }
                    this.endElement(child.name);
                }
                this.endElement(oed.elementName);
            }
        }
    }
}

