/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;

public class XmiSerializationSharedData {
    private RedBlackTree fsAddrToXmiIdMap = new RedBlackTree();
    private RedBlackTree xmiIdToFsAddrMap = new RedBlackTree();
    private List ootsFs = new ArrayList();
    private Map ootsViewMembers = new HashMap();
    private Map ootsFeatures = new HashMap();
    private Map ootsArrayElements = new HashMap();
    private int maxXmiId = 0;

    void addIdMapping(int fsAddr, int xmiId) {
        this.fsAddrToXmiIdMap.put(fsAddr, Integer.toString(xmiId));
        this.xmiIdToFsAddrMap.put(xmiId, fsAddr);
        if (xmiId > this.maxXmiId) {
            this.maxXmiId = xmiId;
        }
    }

    String getXmiId(int fsAddr) {
        String xmiId = (String)this.fsAddrToXmiIdMap.get(fsAddr);
        if (xmiId != null) {
            return xmiId;
        }
        String idStr = Integer.toString(++this.maxXmiId);
        this.fsAddrToXmiIdMap.put(fsAddr, idStr);
        this.xmiIdToFsAddrMap.put(this.maxXmiId, fsAddr);
        return idStr;
    }

    public int getMaxXmiId() {
        return this.maxXmiId;
    }

    public int getFsAddrForXmiId(int xmiId) {
        Integer addr = (Integer)this.xmiIdToFsAddrMap.get(xmiId);
        return addr == null ? -1 : addr;
    }

    public void clearIdMap() {
        this.fsAddrToXmiIdMap.clear();
        this.xmiIdToFsAddrMap.clear();
        this.maxXmiId = 0;
    }

    public void addOutOfTypeSystemElement(OotsElementData elemData) {
        this.ootsFs.add(elemData);
        int xmiId = Integer.parseInt(elemData.xmiId);
        if (xmiId > this.maxXmiId) {
            this.maxXmiId = xmiId;
        }
    }

    public List getOutOfTypeSystemElements() {
        return Collections.unmodifiableList(this.ootsFs);
    }

    public void addOutOfTypeSystemViewMember(String sofaXmiId, String memberXmiId) {
        ArrayList<String> membersList = (ArrayList<String>)this.ootsViewMembers.get(sofaXmiId);
        if (membersList == null) {
            membersList = new ArrayList<String>();
            this.ootsViewMembers.put(sofaXmiId, membersList);
        }
        membersList.add(memberXmiId);
    }

    public List getOutOfTypeSystemViewMembers(String sofaXmiId) {
        List members = (List)this.ootsViewMembers.get(sofaXmiId);
        return members == null ? null : Collections.unmodifiableList(members);
    }

    public void addOutOfTypeSystemAttribute(int addr, String featName, String featVal) {
        Integer key = addr;
        OotsElementData oed = (OotsElementData)this.ootsFeatures.get(key);
        if (oed == null) {
            oed = new OotsElementData();
            this.ootsFeatures.put(key, oed);
        }
        oed.attributes.add(new XmlAttribute(featName, featVal));
    }

    public void addOutOfTypeSystemChildElements(int addr, String featName, List featVals) {
        Integer key = addr;
        OotsElementData oed = (OotsElementData)this.ootsFeatures.get(key);
        if (oed == null) {
            oed = new OotsElementData();
            this.ootsFeatures.put(key, oed);
        }
        Iterator iter = featVals.iterator();
        XmlElementName elemName = new XmlElementName(null, featName, featName);
        while (iter.hasNext()) {
            oed.childElements.add(new XmlElementNameAndContents(elemName, (String)iter.next()));
        }
    }

    public OotsElementData getOutOfTypeSystemFeatures(int addr) {
        Integer key = addr;
        return (OotsElementData)this.ootsFeatures.get(key);
    }

    public int[] getAllFsAddressesInIdMap() {
        return this.fsAddrToXmiIdMap.keySet();
    }

    public List getOutOfTypeSystemArrayElements(int addr) {
        return (List)this.ootsArrayElements.get(addr);
    }

    public void addOutOfTypeSystemArrayElement(int addr, int index, int xmiId) {
        Integer key = addr;
        ArrayList<XmiArrayElement> list = (ArrayList<XmiArrayElement>)this.ootsArrayElements.get(key);
        if (list == null) {
            list = new ArrayList<XmiArrayElement>();
            this.ootsArrayElements.put(key, list);
        }
        list.add(new XmiArrayElement(index, Integer.toString(xmiId)));
    }

    void checkForDups() {
        HashSet<String> ids = new HashSet<String>();
        Iterator iter = this.fsAddrToXmiIdMap.iterator();
        while (iter.hasNext()) {
            String xmiId = (String)iter.next();
            if (ids.add(xmiId)) continue;
            throw new RuntimeException("Duplicate ID " + xmiId + "!");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int[] keys = this.fsAddrToXmiIdMap.keySet();
        for (int i = 0; i < keys.length; ++i) {
            buf.append(keys[i]).append(": ").append(this.fsAddrToXmiIdMap.get(keys[i])).append('\n');
        }
        return buf.toString();
    }

    static class XmiArrayElement {
        int index;
        String xmiId;

        XmiArrayElement(int index, String xmiId) {
            this.index = index;
            this.xmiId = xmiId;
        }
    }

    static class OotsElementData {
        String xmiId;
        XmlElementName elementName;
        List attributes = new ArrayList();
        List childElements = new ArrayList();

        OotsElementData() {
        }
    }
}

