/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer.vinci;

import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.naming.TimeLimitExceededException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.base_cpm.AbortCPMException;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.impl.base_cpm.container.CasProcessorConfiguration;
import org.apache.uima.collection.impl.base_cpm.container.KillPipelineException;
import org.apache.uima.collection.impl.base_cpm.container.ProcessingContainer;
import org.apache.uima.collection.impl.base_cpm.container.ServiceConnectionException;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeployer;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeploymentException;
import org.apache.uima.collection.impl.cpm.container.CPEFactory;
import org.apache.uima.collection.impl.cpm.container.CasProcessorConfigurationJAXBImpl;
import org.apache.uima.collection.impl.cpm.container.NetworkCasProcessorImpl;
import org.apache.uima.collection.impl.cpm.container.ProcessingContainer_Impl;
import org.apache.uima.collection.impl.cpm.container.ServiceProxyPool;
import org.apache.uima.collection.impl.cpm.container.deployer.VinciTAP;
import org.apache.uima.collection.impl.cpm.container.deployer.vns.LocalVNS;
import org.apache.uima.collection.impl.cpm.container.deployer.vns.VNSQuery;
import org.apache.uima.collection.impl.cpm.container.deployer.vns.VinciServiceInfo;
import org.apache.uima.collection.impl.cpm.engine.BoundedWorkQueue;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.utils.CPMUtils;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.utils.Execute;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLInputSource;
import org.apache.vinci.transport.ServiceDownException;
import org.apache.vinci.transport.ServiceException;

public class VinciCasProcessorDeployer
implements CasProcessorDeployer {
    public static final String LOCAL_VNS = "LOCAL_VNS";
    public static final int WAIT_TIME = 150;
    public static final int MAX_WAIT_TRIES = 5000;
    public static final String CONN_RETRY_COUNT = "CONN_RETRY_COUNT";
    public static final String DEFAULT_VNS_PORT = "9005";
    public static final int DEFAULT_SERVICE_PORT = 10000;
    public static final int DEFAULT_SERVICE_PORT_RANGE = 3000;
    public static final int SLEEP_TIME = 1000;
    private ServiceProxyPool casProcessorPool = null;
    private Thread localVNSThread = null;
    private static LocalVNS vns = null;
    private int restartCount = 0;
    private static BoundedWorkQueue portQueue = null;
    private CPEFactory cpeFactory = null;
    private final Object monitor = new Object();
    private ArrayList currentServiceList = null;

    public VinciCasProcessorDeployer(CPEFactory aCpeFactory) {
        this.cpeFactory = aCpeFactory;
    }

    public ProcessingContainer deployCasProcessor(List aCasProcessorList, CPMEngine aEngine, boolean redeploy) throws ResourceConfigurationException {
        return this.deployCasProcessor(aCasProcessorList, redeploy);
    }

    public void deployCasProcessor(ProcessingContainer aProcessingContainer) throws ResourceConfigurationException {
        try {
            CasProcessorConfiguration casProcessorConfig = aProcessingContainer.getCasProcessorConfiguration();
            String name = casProcessorConfig.getName();
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_reeploying_service__FINEST", new Object[]{Thread.currentThread().getName(), name});
            }
            this.deployBasedOnModel(aProcessingContainer, casProcessorConfig, true);
        }
        catch (ResourceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unable_to_deploy_service__SEVERE", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getCasProcessorConfiguration().getName()});
        }
    }

    public ProcessingContainer deployCasProcessor(List aCasProcessorList, boolean redeploy) throws ResourceConfigurationException {
        String name = null;
        CasProcessor casProcessor = null;
        CasProcessorConfiguration casProcessorConfig = null;
        ProcessingContainer processingContainer = null;
        try {
            for (int i = 0; i < aCasProcessorList.size(); ++i) {
                casProcessor = (CasProcessor)aCasProcessorList.get(i);
                if (processingContainer == null) {
                    ProcessingResourceMetaData metaData = casProcessor.getProcessingResourceMetaData();
                    CpeCasProcessor casProcessorType = (CpeCasProcessor)this.cpeFactory.casProcessorConfigMap.get(metaData.getName());
                    this.casProcessorPool = new ServiceProxyPool();
                    casProcessorConfig = new CasProcessorConfigurationJAXBImpl(casProcessorType, this.cpeFactory.getResourceManager());
                    processingContainer = new ProcessingContainer_Impl(casProcessorConfig, metaData, this.casProcessorPool);
                    processingContainer.setCasProcessorDeployer(this);
                    name = casProcessorConfig.getName();
                    if (name == null) {
                        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unable_to_read_meta__SEVERE", Thread.currentThread().getName());
                        }
                        throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_casprocessor_no_name_found__SEVERE", new Object[]{Thread.currentThread().getName()});
                    }
                }
                this.casProcessorPool.addCasProcessor(casProcessor);
            }
            if (processingContainer == null) {
                throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_container__SEVERE", new Object[]{Thread.currentThread().getName()});
            }
            casProcessorConfig = processingContainer.getCasProcessorConfiguration();
            if (casProcessorConfig == null) {
                throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_container_configuration_not_found__SEVERE", new Object[]{Thread.currentThread().getName()});
            }
            this.deployBasedOnModel(processingContainer, casProcessorConfig, false);
        }
        catch (ResourceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceConfigurationException(e);
        }
        return processingContainer;
    }

    private void deployBasedOnModel(ProcessingContainer aProcessingContainer, CasProcessorConfiguration aCasProcessorConfig, boolean redeploy) throws ResourceConfigurationException {
        String deployModel = aCasProcessorConfig.getDeploymentType();
        String name = aCasProcessorConfig.getName();
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploy_with_mode__FINEST", new Object[]{Thread.currentThread().getName(), name, deployModel});
        }
        if ("local".equals(deployModel)) {
            this.deployLocal(aProcessingContainer, redeploy);
        } else if ("remote".equals(deployModel)) {
            this.deployRemote(aProcessingContainer, redeploy);
        } else if ("integrated".equals(deployModel)) {
            this.deployIntegrated(aProcessingContainer, redeploy);
        } else {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unsupported_deploy_mode__SEVERE", new Object[]{Thread.currentThread().getName(), name, deployModel});
            }
            throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unsupported_deploy_mode__SEVERE", new Object[]{Thread.currentThread().getName(), name, deployModel});
        }
    }

    private void deployLocal(ProcessingContainer aProcessingContainer, boolean redeploy) throws ResourceConfigurationException {
        CasProcessorConfiguration casProcessorConfig = aProcessingContainer.getCasProcessorConfiguration();
        String name = casProcessorConfig.getName();
        try {
            if (casProcessorConfig.runInSeparateProcess()) {
                if (!redeploy) {
                    int concurrentThreadCount = this.cpeFactory.getProcessingUnitThreadCount();
                    if (vns == null) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploy_vns__FINEST", new Object[]{Thread.currentThread().getName()});
                        }
                        portQueue = new BoundedWorkQueue(concurrentThreadCount, "Port Queue", null);
                        this.deployVNS(casProcessorConfig, redeploy);
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploy_with_mode__FINEST", new Object[]{Thread.currentThread().getName(), casProcessorConfig.getName(), casProcessorConfig.getDeploymentType()});
                    }
                    this.launchLocalService(aProcessingContainer, casProcessorConfig, redeploy, concurrentThreadCount);
                } else {
                    this.launchLocalService(aProcessingContainer, casProcessorConfig, redeploy, 1);
                }
            } else {
                throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_cpe_descriptor__SEVERE", new Object[]{Thread.currentThread().getName(), name, "runInSeparateProcess"});
            }
            this.associateMetadataWithContainer(aProcessingContainer);
        }
        catch (Exception e) {
            throw new ResourceConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void associateMetadataWithContainer(ProcessingContainer aProcessingContainer) {
        CasProcessor processor = null;
        try {
            block7: {
                try {
                    if (this.casProcessorPool == null || (processor = this.casProcessorPool.checkOut()) == null) break block7;
                    ProcessingResourceMetaData metadata = processor.getProcessingResourceMetaData();
                    if (aProcessingContainer == null || metadata == null) break block7;
                    aProcessingContainer.setMetadata(metadata);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var5_6 = null;
                    if (processor != null) {
                        this.casProcessorPool.checkIn(processor);
                    }
                }
            }
            Object var5_5 = null;
            if (processor != null) {
                this.casProcessorPool.checkIn(processor);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (processor != null) {
                this.casProcessorPool.checkIn(processor);
            }
            throw throwable;
        }
    }

    private void launchLocalService(ProcessingContainer aProcessingContainer, CasProcessorConfiguration casProcessorConfig, boolean redeploy, int howMany) throws CasProcessorDeploymentException {
        try {
            Execute exec = casProcessorConfig.getExecSpec();
            String[] cmd = exec.getCmdLine();
            String[] execCommand = new String[3];
            if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                execCommand[0] = "/bin/sh";
                execCommand[1] = "-c";
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < cmd.length; ++i) {
                if (cmd[i] != null && cmd[i].indexOf("-DVNS_PORT") > -1) {
                    int vnsPort = vns.getVNSPort();
                    cmd[i] = "-DVNS_PORT=" + vnsPort;
                }
                sb.append(" " + cmd[i]);
            }
            String logDir = "";
            if (System.getProperty("LOG_DIR") != null && !(logDir = System.getProperty("LOG_DIR")).endsWith("/") && !logDir.endsWith("\\")) {
                logDir = logDir + System.getProperty("file.separator");
            }
            sb.append(" >> " + logDir + "\"" + casProcessorConfig.getName() + System.currentTimeMillis() + ".log\"" + " 2>&1");
            execCommand[2] = sb.toString();
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_vns_started__FINEST", new Object[]{Thread.currentThread().getName(), casProcessorConfig.getName()});
            }
            int serviceCount = howMany;
            while (serviceCount-- > 0) {
                int i;
                for (int i2 = 0; cmd != null && i2 < cmd.length; ++i2) {
                    if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_launching_with_service_cmd__FINEST", new Object[]{Thread.currentThread().getName(), casProcessorConfig.getName(), String.valueOf(i2), cmd[i2]});
                }
                String[] env = exec.getEnvironment();
                if (env != null && env.length > 0) {
                    for (i = 0; i < env.length; ++i) {
                        if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_launching_with_service_env__FINEST", new Object[]{Thread.currentThread().getName(), casProcessorConfig.getName(), String.valueOf(i), env[i]});
                    }
                    if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                        for (i = 0; execCommand != null && i < execCommand.length; ++i) {
                            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_launching_with_service_exec__FINEST", new Object[]{Thread.currentThread().getName(), casProcessorConfig.getName(), String.valueOf(i), execCommand[i]});
                        }
                        Runtime.getRuntime().exec(execCommand, env);
                        continue;
                    }
                    Runtime.getRuntime().exec(cmd, env);
                    continue;
                }
                if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
                    for (i = 0; execCommand != null && i < execCommand.length; ++i) {
                        if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_launching_with_service_exec__FINEST", new Object[]{Thread.currentThread().getName(), casProcessorConfig.getName(), String.valueOf(i), execCommand[i]});
                    }
                    Runtime.getRuntime().exec(execCommand);
                    continue;
                }
                Runtime.getRuntime().exec(cmd);
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connecting_to_services__FINEST", new Object[]{Thread.currentThread().getName(), casProcessorConfig.getName()});
            }
            this.connectToServices(aProcessingContainer, casProcessorConfig, redeploy, howMany);
        }
        catch (ConnectException e) {
            e.printStackTrace();
            throw new CasProcessorDeploymentException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CasProcessorDeploymentException(e);
        }
    }

    private void deployIntegrated(ProcessingContainer aProcessingContainer, boolean redeploy) throws ResourceConfigurationException {
    }

    private void deployRemote(ProcessingContainer aProcessingContainer, boolean redeploy) throws ResourceConfigurationException {
        CasProcessorConfiguration casProcessorConfig = aProcessingContainer.getCasProcessorConfiguration();
        String name = casProcessorConfig.getName();
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploy_with_mode__FINEST", new Object[]{Thread.currentThread().getName(), name, casProcessorConfig.getDeploymentType()});
        }
        try {
            String serviceUri = this.getServiceUri(casProcessorConfig);
            int concurrentThreadCount = this.cpeFactory.getProcessingUnitThreadCount();
            boolean exclusiveAccess = false;
            String serviceAccess = casProcessorConfig.getDeploymentParameter("service-access");
            if (serviceAccess != null && serviceAccess.equalsIgnoreCase("exclusive")) {
                exclusiveAccess = true;
            }
            int howMany = 1;
            if (!redeploy) {
                howMany = concurrentThreadCount;
            }
            int serviceCount = this.attachToServices(redeploy, serviceUri, howMany, aProcessingContainer);
            if (!redeploy && exclusiveAccess && serviceCount < concurrentThreadCount) {
                ServiceProxyPool pool = aProcessingContainer.getPool();
                int poolSize = pool.getSize();
                for (int i = 0; i < poolSize; ++i) {
                    CasProcessor processor = pool.checkOut();
                    if (!(processor instanceof NetworkCasProcessorImpl)) continue;
                    if (((NetworkCasProcessorImpl)processor).getProxy() == null) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_reducing_cp_instance_count__FINEST", new Object[]{Thread.currentThread().getName(), name, casProcessorConfig.getDeploymentType()});
                        }
                        processor = null;
                        continue;
                    }
                    pool.checkIn(processor);
                }
            }
        }
        catch (ResourceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceConfigurationException(e);
        }
    }

    private int attachToServices(boolean redeploy, String aServiceUri, int howMany, ProcessingContainer aProcessingContainer) throws Exception {
        VinciServiceInfo serviceInfo = null;
        CasProcessorConfiguration casProcessorConfig = aProcessingContainer.getCasProcessorConfiguration();
        ArrayList serviceList = null;
        boolean exclusiveAccess = false;
        String serviceAccess = casProcessorConfig.getDeploymentParameter("service-access");
        if (serviceAccess != null && serviceAccess.equalsIgnoreCase("exclusive")) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_with_exclusive_access__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), casProcessorConfig.getDeploymentType()});
            }
            exclusiveAccess = true;
            if (((ProcessingContainer_Impl)aProcessingContainer).failedCasProcessorList.size() > 0) {
                CasProcessor processor;
                VinciTAP tap;
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_retrieve_cp_from_failed_cplist__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), casProcessorConfig.getDeploymentType()});
                }
                if ((tap = ((NetworkCasProcessorImpl)(processor = (CasProcessor)((ProcessingContainer_Impl)aProcessingContainer).failedCasProcessorList.get(0))).getProxy()) != null) {
                    String service_host = tap.getServiceHost();
                    int service_port = tap.getServicePort();
                    for (int i = 0; this.currentServiceList != null && i < this.currentServiceList.size(); ++i) {
                        VinciServiceInfo si = (VinciServiceInfo)this.currentServiceList.get(i);
                        if (!si.getHost().equals(service_host) || si.getPort() != service_port) continue;
                        si.setAvailable(true);
                    }
                }
            }
            if ((serviceList = this.getNewServiceList(aServiceUri, casProcessorConfig)) == null || serviceList.size() == 0 && !redeploy) {
                throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_service_in_vns__FINEST", new Object[]{Thread.currentThread().getName(), aServiceUri, casProcessorConfig.getDeploymentType(), casProcessorConfig.getDeploymentParameter("vnsHost"), casProcessorConfig.getDeploymentParameter("vnsPort")});
            }
            if (redeploy) {
                howMany = 1;
            }
            if (this.currentServiceList == null) {
                this.currentServiceList = serviceList;
            } else {
                int newServiceCount = VNSQuery.findUnassigned(this.currentServiceList, serviceList);
                if (newServiceCount > 0) {
                    this.currentServiceList.clear();
                    this.currentServiceList = serviceList;
                }
            }
        }
        int succesfullConnections = 0;
        int rC = casProcessorConfig.getMaxRestartCount();
        int maxTimeToWait = casProcessorConfig.getMaxTimeToWaitBetweenRetries();
        if (maxTimeToWait == 0) {
            maxTimeToWait = 150;
        }
        for (int i = 0; i < howMany; ++i) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_activating_service__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), String.valueOf(i), String.valueOf(howMany)});
            }
            int restartCount = 0;
            boolean sleepBetweenRetries = false;
            do {
                try {
                    if (exclusiveAccess && (serviceInfo = this.getNextAvailable(serviceList)) == null) {
                        if (!redeploy) {
                            return succesfullConnections;
                        }
                        sleepBetweenRetries = true;
                    }
                    if (sleepBetweenRetries) {
                        try {
                            Thread.sleep(maxTimeToWait);
                        }
                        catch (InterruptedException iex) {
                            // empty catch block
                        }
                        if (serviceInfo == null && exclusiveAccess) {
                            ++restartCount;
                            serviceList = this.getNewServiceList(aServiceUri, casProcessorConfig);
                            int newServiceCount = VNSQuery.findUnassigned(this.currentServiceList, serviceList);
                            if (newServiceCount <= 0) continue;
                            this.currentServiceList.clear();
                            this.currentServiceList = serviceList;
                            continue;
                        }
                    }
                    if (exclusiveAccess) {
                        this.activateProcessor(casProcessorConfig, serviceInfo.getHost(), serviceInfo.getPort(), aProcessingContainer, redeploy);
                        serviceInfo.setAvailable(false);
                    } else {
                        this.activateProcessor(casProcessorConfig, aServiceUri, aProcessingContainer, redeploy);
                    }
                    ++succesfullConnections;
                    break;
                }
                catch (ResourceInitializationException ex) {
                    if (ex.getCause() instanceof ServiceException || ex.getCause() instanceof ServiceDownException) {
                        if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_activating_service__WARNING", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
                        }
                        ++restartCount;
                        continue;
                    }
                    restartCount = rC + 1;
                }
            } while (restartCount <= rC);
            if (restartCount <= rC) continue;
            this.handleMaxRestartThresholdReached(aProcessingContainer);
        }
        return succesfullConnections;
    }

    private VinciServiceInfo getNextAvailable(ArrayList aServiceList) {
        VinciServiceInfo serviceInfo = null;
        for (int i = 0; i < aServiceList.size(); ++i) {
            serviceInfo = (VinciServiceInfo)aServiceList.get(i);
            if (serviceInfo == null) continue;
            if (serviceInfo.isAvailable()) {
                return serviceInfo;
            }
            serviceInfo = null;
        }
        return serviceInfo;
    }

    private ArrayList getNewServiceList(String aServiceUri, CasProcessorConfiguration aCasProcessorConfig) throws Exception {
        String vnsHost = this.getVNSSettingFor("VNS_HOST", aCasProcessorConfig, "localhost");
        String vnsPort = this.getVNSSettingFor("VNS_PORT", aCasProcessorConfig, "9000");
        VNSQuery vnsQuery = new VNSQuery(vnsHost, Integer.parseInt(vnsPort));
        return vnsQuery.getServices(aServiceUri);
    }

    private void handleMaxRestartThresholdReached(ProcessingContainer aProcessingContainer) throws ResourceConfigurationException {
        CasProcessorConfiguration casProcessorConfig = aProcessingContainer.getCasProcessorConfiguration();
        String name = casProcessorConfig.getName();
        if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_restart_exceeded__WARNING", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), String.valueOf(casProcessorConfig.getMaxRestartCount())});
        }
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_restart_exceeded__WARNING", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), casProcessorConfig.getActionOnMaxRestart()});
        }
        if ("terminate".equals(casProcessorConfig.getActionOnMaxRestart())) {
            if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_terminate_onerrors__INFO", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
            }
            throw new ResourceConfigurationException(new AbortCPMException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_abort__WARNING", new Object[]{Thread.currentThread().getName(), name})));
        }
        if ("kill-pipeline".equals(casProcessorConfig.getActionOnMaxRestart())) {
            if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_terminate_pipeline__INFO", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
            }
            throw new ResourceConfigurationException(new KillPipelineException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_kill_pipeline__WARNING", new Object[]{Thread.currentThread().getName(), name})));
        }
        if ("disable".equals(casProcessorConfig.getActionOnMaxRestart())) {
            aProcessingContainer.setStatus(3);
            if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disable_cp__INFO", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
            }
            return;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disable_cp__INFO", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
        }
    }

    private String getServiceUri(CasProcessorConfiguration aCasProcessorConfig) throws ResourceConfigurationException {
        URL descriptorUrl = aCasProcessorConfig.getDescriptorUrl();
        URISpecifier uriSpecifier = this.getURISpecifier(descriptorUrl);
        String uri = uriSpecifier.getUri();
        if (uri == null || uri.trim().length() == 0) {
            throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_deployment__SEVERE", new Object[]{Thread.currentThread().getName(), descriptorUrl, uri});
        }
        return uri;
    }

    private URISpecifier getURISpecifier(URL aDescriptorUrl) throws ResourceConfigurationException {
        ResourceSpecifier resourceSpecifier = this.getSpecifier(aDescriptorUrl);
        if (!(resourceSpecifier instanceof URISpecifier)) {
            throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_deployment__SEVERE", new Object[]{Thread.currentThread().getName(), aDescriptorUrl, null});
        }
        return (URISpecifier)resourceSpecifier;
    }

    private ResourceSpecifier getSpecifier(URL aUrl) throws ResourceConfigurationException {
        try {
            XMLInputSource in = new XMLInputSource(aUrl);
            return UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_deployment__SEVERE", new Object[]{Thread.currentThread().getName(), aUrl, null});
        }
    }

    private void deployVNS(CasProcessorConfiguration casProcessorConfig, boolean redeploy) throws CasProcessorDeploymentException {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploy_vns_redeploy__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(redeploy), String.valueOf(this.restartCount)});
        }
        int vnsPort = Integer.parseInt(DEFAULT_VNS_PORT);
        int startPort = 10000;
        int maxPort = 13000;
        if (System.getProperty("LOCAL_VNS_PORT") != null) {
            try {
                vnsPort = Integer.parseInt(System.getProperty("LOCAL_VNS_PORT"));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (redeploy) {
            ++this.restartCount;
            try {
                startPort += this.restartCount;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new CasProcessorDeploymentException(e);
            }
        }
        if (vns == null) {
            try {
                vns = new LocalVNS(startPort, maxPort, vnsPort);
                vns.setConnectionPool(portQueue);
                this.localVNSThread = new Thread(vns);
                this.localVNSThread.start();
            }
            catch (Exception e) {
                throw new CasProcessorDeploymentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean activateProcessor(CasProcessorConfiguration aCasProcessorConfig, String aHost, int aPort, ProcessingContainer aProcessingContainer, boolean redeploy) throws Exception {
        VinciTAP tap = this.getTextAnalysisProxy(aCasProcessorConfig);
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_activating_service_on_port__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(aPort)});
        }
        boolean tryAgain = true;
        int maxCount = aCasProcessorConfig.getMaxRestartCount();
        while (tryAgain) {
            try {
                tap.connect(aHost, aPort);
                tryAgain = false;
            }
            catch (Exception e) {
                if (maxCount-- == 0) {
                    e.printStackTrace();
                    if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                        UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, Thread.currentThread().getName() + "", e);
                    }
                    throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_service_connection__SEVERE", new Object[]{Thread.currentThread().getName(), String.valueOf(aPort), aHost, aCasProcessorConfig.getName()});
                }
                try {
                    Object object = this.monitor;
                    synchronized (object) {
                        this.monitor.wait(1000L);
                    }
                }
                catch (InterruptedException ex) {}
            }
        }
        this.bindProxyToNetworkCasProcessor(tap, aProcessingContainer, redeploy);
        return true;
    }

    private synchronized boolean activateProcessor(CasProcessorConfiguration aCasProcessorConfig, String aService, ProcessingContainer aProcessingContainer, boolean redeploy) throws Exception {
        VinciTAP tap = this.getTextAnalysisProxy(aCasProcessorConfig);
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_activating_service_on_port__FINEST", new Object[]{Thread.currentThread().getName(), aService});
        }
        boolean tryAgain = true;
        int maxCount = aCasProcessorConfig.getMaxRestartCount();
        while (tryAgain) {
            try {
                this.wait(1000L);
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connecting_to_service__FINEST", new Object[]{Thread.currentThread().getName(), aService});
                }
                tap.connect(aService);
                tryAgain = false;
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connection_established__FINEST", new Object[]{Thread.currentThread().getName(), aService});
            }
            catch (Exception e) {
                if (maxCount-- != 0) continue;
                e.printStackTrace();
                if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_max_connect_retries_exceeded__FINEST", new Object[]{Thread.currentThread().getName(), aService, String.valueOf(maxCount)});
                }
                throw new ResourceInitializationException("org.apache.uima.collection.impl.cpm.cpm_messages", new Object[]{Thread.currentThread().getName(), aService, String.valueOf(maxCount)}, new ServiceConnectionException("Unable to connect to service :::" + aService));
            }
        }
        this.bindProxyToNetworkCasProcessor(tap, aProcessingContainer, redeploy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bindProxyToNetworkCasProcessor(VinciTAP aTap, ProcessingContainer aProcessingContainer, boolean redeploy) throws Exception {
        CasProcessor processor;
        block18: {
            block19: {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checked_in_cp_to_pool__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), aTap.getServiceHost(), String.valueOf(aTap.getServicePort())});
                }
                processor = null;
                boolean processorAssigned = false;
                try {
                    block22: {
                        block21: {
                            if (!redeploy) break block21;
                            if (((ProcessingContainer_Impl)aProcessingContainer).failedCasProcessorList.isEmpty()) {
                                throw new ResourceProcessException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_cp_instance_in_failed_list__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), aTap.getServiceHost(), String.valueOf(aTap.getServicePort())}, new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_cp_not_in_failed_list__WARNING", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()})));
                            }
                            processor = (CasProcessor)((ProcessingContainer_Impl)aProcessingContainer).failedCasProcessorList.get(0);
                            if (!(processor instanceof NetworkCasProcessorImpl)) break block22;
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_assign_cp_to_service__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), aTap.getServiceHost(), String.valueOf(aTap.getServicePort())});
                            }
                            ((NetworkCasProcessorImpl)processor).setProxy(aTap);
                            processorAssigned = true;
                            Object object = this.monitor;
                            synchronized (object) {
                                this.monitor.notifyAll();
                                break block22;
                            }
                        }
                        int cpPoolSize = this.casProcessorPool.getSize();
                        for (int i = 0; i < cpPoolSize; ++i) {
                            processor = this.casProcessorPool.checkOut();
                            if (processor == null) {
                                if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) continue;
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_get_cp_from_pool_error__SEVERE", new Object[]{Thread.currentThread().getName(), aTap.getServiceHost(), String.valueOf(aTap.getServicePort()), String.valueOf(this.casProcessorPool.getAllInstanceCount())});
                                continue;
                            }
                            if (!(processor instanceof NetworkCasProcessorImpl)) continue;
                            NetworkCasProcessorImpl netProcessor = (NetworkCasProcessorImpl)processor;
                            if (netProcessor.getProxy() != null && netProcessor.getProxy().isConnected()) {
                                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_already_allocated__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(i)});
                                continue;
                            }
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_assign_cp_to_service__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(i), aTap.getServiceHost(), String.valueOf(aTap.getServicePort())});
                            }
                            ((NetworkCasProcessorImpl)processor).setProxy(aTap);
                            processorAssigned = true;
                            Object object = this.monitor;
                            synchronized (object) {
                                this.monitor.notifyAll();
                            }
                            break;
                        }
                    }
                    Object var12_12 = null;
                    if (processor == null) return;
                    if (!processorAssigned) break block18;
                    if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) break block19;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (processor == null) throw throwable;
                    if (!processorAssigned) {
                        ((ProcessingContainer_Impl)aProcessingContainer).failedCasProcessorList.add(processor);
                        throw throwable;
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkin_cp_to_pool__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), aTap.getServiceHost(), String.valueOf(aTap.getServicePort())});
                    }
                    this.casProcessorPool.checkIn(processor);
                    if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) throw throwable;
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checked_in_cp_to_pool__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), aTap.getServiceHost(), String.valueOf(aTap.getServicePort())});
                    throw throwable;
                }
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkin_cp_to_pool__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), aTap.getServiceHost(), String.valueOf(aTap.getServicePort())});
            }
            this.casProcessorPool.checkIn(processor);
            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) return;
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checked_in_cp_to_pool__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), aTap.getServiceHost(), String.valueOf(aTap.getServicePort())});
            return;
        }
        ((ProcessingContainer_Impl)aProcessingContainer).failedCasProcessorList.add(processor);
    }

    private VinciTAP getTextAnalysisProxy(CasProcessorConfiguration aCasProcessorConfig) throws ResourceConfigurationException {
        VinciTAP tap = new VinciTAP();
        String vnsHost = null;
        String vnsPort = null;
        if (aCasProcessorConfig.getDeploymentType() != null && "local".equalsIgnoreCase(aCasProcessorConfig.getDeploymentType())) {
            vnsHost = "localhost";
            vnsPort = "";
            try {
                vnsPort = String.valueOf(vns.getPort());
            }
            catch (Exception e) {
                throw new ResourceConfigurationException(e);
            }
        } else {
            if (vnsHost == null) {
                vnsHost = this.getVNSSettingFor("VNS_HOST", aCasProcessorConfig, "localhost");
            }
            if (vnsPort == null) {
                vnsPort = this.getVNSSettingFor("VNS_PORT", aCasProcessorConfig, "9000");
            }
        }
        long timeout = aCasProcessorConfig.getTimeout();
        String[] keysToDrop = aCasProcessorConfig.getKeysToDrop();
        if (keysToDrop != null) {
            tap.setKeys2Drop(keysToDrop);
        }
        tap.setVNSHost(vnsHost);
        tap.setVNSPort(vnsPort);
        tap.setTimeout((int)timeout);
        String timerClass = "";
        try {
            timerClass = this.cpeFactory.getCPEConfig().getTimerImpl();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (timerClass != null) {
            try {
                tap.setTimer(CPMUtils.getTimer(this.cpeFactory.getCPEConfig().getCpeTimer().get()));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ResourceConfigurationException(e);
            }
        }
        return tap;
    }

    private String getVNSSettingFor(String aVNSParamKey, CasProcessorConfiguration aCasProcessorConfig, String aDefault) throws ResourceConfigurationException {
        String vnsParam = null;
        URL descriptorUrl = aCasProcessorConfig.getDescriptorUrl();
        URISpecifier uriSpecifier = this.getURISpecifier(descriptorUrl);
        Parameter[] params = uriSpecifier.getParameters();
        for (int i = 0; params != null && i < params.length; ++i) {
            if (!aVNSParamKey.equals(params[i].getName())) continue;
            vnsParam = params[i].getValue();
            break;
        }
        if (vnsParam == null) {
            if (aVNSParamKey.equals("VNS_HOST")) {
                vnsParam = aCasProcessorConfig.getDeploymentParameter("vnsHost");
            } else if (aVNSParamKey.equals("VNS_PORT")) {
                vnsParam = aCasProcessorConfig.getDeploymentParameter("vnsPort");
            }
            if (vnsParam == null && (vnsParam = System.getProperty(aVNSParamKey)) == null) {
                vnsParam = aDefault;
            }
        }
        return vnsParam;
    }

    private void connectToServices(ProcessingContainer aProcessingContainer, CasProcessorConfiguration casProcessorConfig, boolean redeploy, int howMany) throws ConnectException {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_thread_count__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), String.valueOf(howMany)});
        }
        for (int i = 0; i < howMany; ++i) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_activating_service_on_port2__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), String.valueOf(i), String.valueOf(howMany)});
            }
            String portObject = null;
            int port = -1;
            try {
                portObject = this.getPort(portQueue);
                port = Integer.parseInt(portObject);
            }
            catch (TimeLimitExceededException e) {
                e.printStackTrace();
                throw new ConnectException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_no_service_port__WARNING", new Object[]{Thread.currentThread().getName()}));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                if (portObject != null && portObject instanceof String) {
                    throw new ConnectException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_service_port__WARNING", new Object[]{Thread.currentThread().getName(), portObject}));
                }
                throw new ConnectException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_service_port__WARNING", new Object[]{Thread.currentThread().getName(), "Not Available"}));
            }
            catch (Exception e) {
                e.printStackTrace();
                if (portObject != null && portObject instanceof String) {
                    throw new ConnectException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_service_port__WARNING", new Object[]{Thread.currentThread().getName(), portObject}));
                }
                throw new ConnectException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_service_port__WARNING", new Object[]{Thread.currentThread().getName(), "Not Available"}));
            }
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_activating_service_on_port__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName(), String.valueOf(port)});
                }
                this.activateProcessor(casProcessorConfig, "127.0.0.1", port, aProcessingContainer, redeploy);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ConnectException(e.getMessage());
            }
        }
    }

    private String getPort(BoundedWorkQueue portQueue) throws TimeLimitExceededException {
        int waitCount = 5000;
        try {
            waitCount = System.getProperty(CONN_RETRY_COUNT) != null ? Integer.parseInt(System.getProperty(CONN_RETRY_COUNT)) : 5000;
        }
        catch (NumberFormatException e) {
            if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_retry_count__INFO", new Object[]{Thread.currentThread().getName()});
            }
            waitCount = 5000;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_got_port_from_queue__INFO", new Object[]{Thread.currentThread().getName(), ""});
        }
        while (portQueue.getCurrentSize() == 0) {
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_port_not_allocated__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(waitCount)});
                }
                Thread.sleep(150L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (waitCount-- > 0) continue;
            throw new TimeLimitExceededException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_timeout_no_service_port__WARNING", new Object[]{Thread.currentThread().getName(), String.valueOf(waitCount * 150 + " millis")}));
        }
        Object portObject = portQueue.dequeue();
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_got_port_from_queue__INFO", new Object[]{Thread.currentThread().getName(), (String)portObject});
        }
        return (String)portObject;
    }

    public void undeploy() throws CasProcessorDeploymentException {
        if (vns != null) {
            vns.shutdown();
            this.localVNSThread = null;
        }
    }

    public void undeploy(URL aURL) throws CasProcessorDeploymentException {
    }
}

