/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.flow;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.flow.CasFlowController_ImplBase;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class WhiteboardFlowController
extends CasFlowController_ImplBase {
    private Logger mLogger;

    public void initialize(FlowControllerContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mLogger = aContext.getLogger();
    }

    public Flow computeFlow(CAS aCAS) throws AnalysisEngineProcessException {
        WhiteboardFlow flow = new WhiteboardFlow();
        flow.setCas(aCAS);
        return flow;
    }

    class WhiteboardFlow
    extends CasFlow_ImplBase {
        private Set mAlreadyCalled = new HashSet();

        WhiteboardFlow() {
        }

        public Step next() throws AnalysisEngineProcessException {
            CAS cas = this.getCas();
            for (Map.Entry entry : WhiteboardFlowController.this.getContext().getAnalysisEngineMetaDataMap().entrySet()) {
                String aeKey = (String)entry.getKey();
                if (this.mAlreadyCalled.contains(aeKey)) continue;
                AnalysisEngineMetaData md = (AnalysisEngineMetaData)entry.getValue();
                Capability[] caps = md.getCapabilities();
                boolean satisfied = true;
                for (int i = 0; i < caps.length && !(satisfied = this.inputsSatisfied(caps[i].getInputs(), cas)); ++i) {
                }
                if (!satisfied) continue;
                this.mAlreadyCalled.add(aeKey);
                if (WhiteboardFlowController.this.mLogger.isLoggable(Level.FINEST)) {
                    WhiteboardFlowController.this.getContext().getLogger().log(Level.FINEST, "Next AE is: " + aeKey);
                }
                return new SimpleStep(aeKey);
            }
            WhiteboardFlowController.this.getContext().getLogger().log(Level.FINEST, "Flow Complete.");
            return new FinalStep();
        }

        private boolean inputsSatisfied(TypeOrFeature[] aInputs, CAS aCAS) {
            for (int i = 0; i < aInputs.length; ++i) {
                TypeOrFeature input = aInputs[i];
                if (!input.isType()) continue;
                Type type = aCAS.getTypeSystem().getType(input.getName());
                if (type == null) {
                    return false;
                }
                FSIterator iter = aCAS.getIndexRepository().getAllIndexedFS(type);
                if (iter.hasNext()) continue;
                return false;
            }
            return true;
        }
    }
}

