/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.xmi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.ecore.UimaTypeSystem2Ecore;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.TypeSystemUtil;
import org.apache.uima.util.XMLSerializer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.xml.sax.SAXException;

public class XmiEcoreCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    public static final String PARAM_WRITE_ECORE_TYPESYSTEM = "WriteEcoreTypeSystem";
    private File mOutputDir;
    private int mDocNum;
    private boolean writeEcoreTypeSystem;
    private boolean isModelGenerated = false;
    private Map schemaLocationMap = null;

    public void initialize() throws ResourceInitializationException {
        this.mDocNum = 0;
        this.mOutputDir = new File((String)this.getConfigParameterValue(PARAM_OUTPUTDIR));
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
        this.writeEcoreTypeSystem = Boolean.TRUE.equals(this.getUimaContext().getConfigParameterValue(PARAM_WRITE_ECORE_TYPESYSTEM));
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        String modelFileName = null;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException(e);
        }
        FSIterator it = jcas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
        File outFile = null;
        if (it.hasNext()) {
            SourceDocumentInformation fileLoc = (SourceDocumentInformation)it.next();
            try {
                File inFile = new File(new URL(fileLoc.getUri()).getPath());
                String outFileName = inFile.getName();
                if (fileLoc.getOffsetInSource() > 0) {
                    outFileName = outFileName + "_" + fileLoc.getOffsetInSource();
                }
                outFileName = outFileName + ".xmi";
                outFile = new File(this.mOutputDir, outFileName);
                modelFileName = this.mOutputDir.getAbsolutePath() + "/" + inFile.getName() + ".ecore";
            }
            catch (MalformedURLException e1) {
                // empty catch block
            }
        }
        if (outFile == null) {
            outFile = new File(this.mOutputDir, "doc" + this.mDocNum++);
        }
        try {
            this.writeXmi(jcas.getCas(), outFile, modelFileName);
        }
        catch (IOException e) {
            throw new ResourceProcessException(e);
        }
        catch (SAXException e) {
            throw new ResourceProcessException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, File name, String modelFileName) throws IOException, SAXException {
        FileOutputStream out = null;
        try {
            if (this.writeEcoreTypeSystem && !this.isModelGenerated) {
                TypeSystemDescription tsDesc = TypeSystemUtil.typeSystem2TypeSystemDescription(aCas.getTypeSystem());
                Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI outputURI = URI.createFileURI((String)new File(this.mOutputDir, "typesystem.ecore").getAbsolutePath());
                Resource outputResource = resourceSet.createResource(outputURI);
                this.schemaLocationMap = new HashMap();
                try {
                    UimaTypeSystem2Ecore.uimaTypeSystem2Ecore(tsDesc, outputResource, null, this.schemaLocationMap);
                }
                catch (InvalidXMLException e) {
                    throw new UIMARuntimeException(e);
                }
                outputResource.save(null);
                this.isModelGenerated = true;
            }
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem(), this.schemaLocationMap);
            XMLSerializer xmlSer = new XMLSerializer(out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

