/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.HashMap;

public class CommandLineParser {
    private HashMap paramMap = new HashMap();
    private HashMap cmdLineMap = null;
    private String[] restArgs;

    public boolean addParameter(String paramName, boolean hasArg) {
        if (this.paramMap.containsKey(paramName)) {
            return false;
        }
        this.paramMap.put(paramName, new CmdLineParam(hasArg));
        return true;
    }

    public boolean addParameter(String paramName) {
        return this.addParameter(paramName, false);
    }

    public boolean addAlias(String param, String alias) {
        if (this.paramMap.containsKey(alias) || !this.paramMap.containsKey(param)) {
            return false;
        }
        this.paramMap.put(alias, this.paramMap.get(param));
        return true;
    }

    public void parseCmdLine(String[] args) throws Exception {
        this.cmdLineMap = new HashMap();
        for (int i = 0; i < args.length; ++i) {
            String cmdLineArg = args[i];
            if (this.paramMap.containsKey(cmdLineArg)) {
                CmdLineParam metaParam = (CmdLineParam)this.paramMap.get(cmdLineArg);
                if (metaParam.hasArg) {
                    if (++i >= args.length) {
                        throw new Exception("Required argument to parameter missing: " + cmdLineArg);
                    }
                    this.cmdLineMap.put(metaParam, args[i]);
                    continue;
                }
                this.cmdLineMap.put(metaParam, null);
                continue;
            }
            this.restArgs = new String[args.length - i];
            System.arraycopy(args, i, this.restArgs, 0, this.restArgs.length);
            return;
        }
        this.restArgs = new String[0];
    }

    public String[] getRestArgs() {
        return this.restArgs;
    }

    public boolean isKnownParameter(String paramName) {
        return this.paramMap.containsKey(paramName);
    }

    public boolean isInArgsList(String paramName) {
        if (!this.paramMap.containsKey(paramName)) {
            return false;
        }
        return this.cmdLineMap.containsKey(this.paramMap.get(paramName));
    }

    public String getParamArgument(String paramName) {
        if (this.isKnownParameter(paramName)) {
            return (String)this.cmdLineMap.get(this.paramMap.get(paramName));
        }
        return null;
    }

    private static class CmdLineParam {
        private final boolean hasArg;

        private CmdLineParam(boolean hasArg) {
            this.hasArg = hasArg;
        }
    }
}

