/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.ArrayList;
import org.apache.uima.internal.util.UtilError;

public class GraphNode {
    protected Object element;
    protected ArrayList successors = new ArrayList();
    protected ArrayList predecessors = new ArrayList();

    public GraphNode(Object element) {
        this.element = element;
    }

    public Object getElement() {
        return this.element;
    }

    public void setElement(Object element) {
        this.element = element;
    }

    public int getNbrSucc() {
        return this.successors.size();
    }

    public GraphNode getSuccessor(int i) {
        if (i >= 0 && i < this.successors.size()) {
            return (GraphNode)this.successors.get(i);
        }
        throw new UtilError(1);
    }

    public void addSuccessor(GraphNode succ) {
        this.successors.add(succ);
    }

    public int getNbrPred() {
        return this.predecessors.size();
    }

    public GraphNode getPredecessor(int i) {
        if (i >= 0 && i < this.predecessors.size()) {
            return (GraphNode)this.predecessors.get(i);
        }
        throw new UtilError(2);
    }

    public void addPredecessor(GraphNode pred) {
        this.predecessors.add(pred);
    }

    public void connect(GraphNode node) {
        this.addSuccessor(node);
        node.addPredecessor(this);
    }
}

