/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18nUtil {
    public static String localizeMessage(String aResourceBundleName, String aMessageKey, Object[] aArguments) {
        return I18nUtil.localizeMessage(aResourceBundleName, Locale.getDefault(), aMessageKey, aArguments, null);
    }

    public static String localizeMessage(String aResourceBundleName, String aMessageKey, Object[] aArguments, ClassLoader aLoader) {
        return I18nUtil.localizeMessage(aResourceBundleName, Locale.getDefault(), aMessageKey, aArguments, aLoader);
    }

    public static String localizeMessage(String aResourceBundleName, Locale aLocale, String aMessageKey, Object[] aArguments) {
        return I18nUtil.localizeMessage(aResourceBundleName, aLocale, aMessageKey, aArguments, null);
    }

    public static String localizeMessage(String aResourceBundleName, Locale aLocale, String aMessageKey, Object[] aArguments, ClassLoader aLoader) {
        try {
            if (aLoader == null && (aLoader = I18nUtil.class.getClassLoader()) == null) {
                aLoader = ClassLoader.getSystemClassLoader();
            }
            ResourceBundle bundle = ResourceBundle.getBundle(aResourceBundleName, aLocale, aLoader);
            String message = bundle.getString(aMessageKey);
            if (aArguments != null && aArguments.length > 0) {
                MessageFormat fmt = new MessageFormat(message);
                fmt.setLocale(aLocale);
                return fmt.format(aArguments);
            }
            return message;
        }
        catch (Exception e) {
            return "MESSAGE LOCALIZATION FAILED: " + e.getMessage();
        }
    }
}

