/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.CommonArray_Type;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.TOP;

public class IntegerArray_Type
extends CommonArray_Type {
    public static final int typeIndexID = IntegerArray.typeIndexID;
    private final FSGenerator fsGenerator = new FSGenerator(){

        public FeatureStructure createFS(int addr, CASImpl cas) {
            if (IntegerArray_Type.this.instanceOf_Type.useExistingInstance) {
                TOP fs = IntegerArray_Type.this.instanceOf_Type.jcas.getJfsFromCaddr(addr);
                if (null == fs) {
                    fs = new IntegerArray(addr, IntegerArray_Type.this.instanceOf_Type);
                    IntegerArray_Type.this.instanceOf_Type.jcas.putJfsFromCaddr(addr, fs);
                    return fs;
                }
                return fs;
            }
            return new IntegerArray(addr, IntegerArray_Type.this.instanceOf_Type);
        }
    };

    protected FSGenerator getFSGenerator() {
        return this.fsGenerator;
    }

    private IntegerArray_Type() {
    }

    public IntegerArray_Type(JCas jcas, Type casType) {
        super(jcas, casType);
        this.casImpl.getFSClassRegistry().addGeneratorForType((TypeImpl)this.casType, this.getFSGenerator());
    }

    public int get(int addr, int i) {
        if (this.lowLevelTypeChecks) {
            return this.ll_cas.ll_getIntArrayValue(addr, i, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        return this.ll_cas.ll_getIntArrayValue(addr, i);
    }

    public void set(int addr, int i, int v) {
        if (this.lowLevelTypeChecks) {
            this.ll_cas.ll_setIntArrayValue(addr, i, v, true);
        }
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, i);
        }
        this.ll_cas.ll_setIntArrayValue(addr, i, v);
    }

    public void copyFromArray(int addr, int[] src, int srcOffset, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, destOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            this.ll_cas.ll_setIntArrayValue(addr, i + destOffset, src[i + srcOffset]);
        }
    }

    public void copyToArray(int addr, int srcOffset, int[] dest, int destOffset, int length) {
        if (this.lowLevelArrayBoundChecks) {
            this.casImpl.checkArrayBounds(addr, srcOffset, length);
        }
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.ll_cas.ll_getIntArrayValue(addr, i + srcOffset);
        }
    }

    public int[] toArray(int addr) {
        int size = this.size(addr);
        int[] outArray = new int[size];
        this.copyToArray(addr, 0, outArray, 0, size);
        return outArray;
    }
}

