/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.TypeDescription_impl;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class TypeSystemDescription_impl
extends MetaDataObject_impl
implements TypeSystemDescription {
    static final long serialVersionUID = -3372766232454730201L;
    private String mName;
    private String mVersion;
    private String mDescription;
    private String mVendor;
    private Import[] mImports = new Import[0];
    private TypeDescription[] mTypes = new TypeDescription[0];
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("typeSystemDescription", new PropertyXmlInfo[]{new PropertyXmlInfo("name", true), new PropertyXmlInfo("description", true), new PropertyXmlInfo("version", true), new PropertyXmlInfo("vendor", true), new PropertyXmlInfo("imports", true), new PropertyXmlInfo("types", true)});

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    public Import[] getImports() {
        return this.mImports;
    }

    public void setImports(Import[] aImports) {
        if (aImports == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aImports", "setImports"});
        }
        this.mImports = aImports;
    }

    public TypeDescription[] getTypes() {
        return this.mTypes;
    }

    public void setTypes(TypeDescription[] aTypes) {
        if (aTypes == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aTypes", "setTypes"});
        }
        this.mTypes = aTypes;
    }

    public TypeDescription addType(String aTypeName, String aDescription, String aSupertypeName) {
        TypeDescription_impl newType = new TypeDescription_impl(aTypeName, aDescription, aSupertypeName);
        TypeDescription[] types = this.getTypes();
        if (types == null) {
            this.setTypes(new TypeDescription[]{newType});
        } else {
            TypeDescription[] newArray = new TypeDescription[types.length + 1];
            System.arraycopy(types, 0, newArray, 0, types.length);
            newArray[types.length] = newType;
            this.setTypes(newArray);
        }
        return newType;
    }

    public TypeDescription getType(String aTypeName) {
        for (int i = 0; i < this.mTypes.length; ++i) {
            if (!aTypeName.equals(this.mTypes[i].getName())) continue;
            return this.mTypes[i];
        }
        return null;
    }

    public void resolveImports() throws InvalidXMLException {
        this.resolveImports(new TreeSet(), UIMAFramework.newDefaultResourceManager());
    }

    public void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(new TreeSet(), aResourceManager);
    }

    public void resolveImports(Collection aAlreadyImportedTypeSystemURLs, ResourceManager aResourceManager) throws InvalidXMLException {
        if (this.getSourceUrl() != null) {
            aAlreadyImportedTypeSystemURLs.add(this.getSourceUrl().toString());
        }
        ArrayList importedTypes = new ArrayList();
        Import[] imports = this.getImports();
        for (int i = 0; i < imports.length; ++i) {
            URL url;
            if (imports[i] instanceof Import_impl) {
                ((Import_impl)imports[i]).setSourceUrlIfNull(this.getSourceUrl());
            }
            if (aAlreadyImportedTypeSystemURLs.contains((url = imports[i].findAbsoluteUrl(aResourceManager)).toString())) continue;
            aAlreadyImportedTypeSystemURLs.add(url.toString());
            try {
                this.resolveImport(url, aAlreadyImportedTypeSystemURLs, importedTypes, aResourceManager);
                continue;
            }
            catch (IOException e) {
                throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{url, imports[i].getSourceUrlString()}, e);
            }
        }
        TypeDescription[] existingTypes = this.getTypes();
        if (existingTypes == null) {
            existingTypes = new TypeDescription[]{};
        }
        TypeDescription[] newTypes = new TypeDescription[existingTypes.length + importedTypes.size()];
        System.arraycopy(existingTypes, 0, newTypes, 0, existingTypes.length);
        for (int i = 0; i < importedTypes.size(); ++i) {
            newTypes[existingTypes.length + i] = (TypeDescription)importedTypes.get(i);
        }
        this.setTypes(newTypes);
        this.setImports(new Import[0]);
    }

    private void resolveImport(URL aURL, Collection aAlreadyImportedTypeSystemURLs, Collection aResults, ResourceManager aResourceManager) throws InvalidXMLException, IOException {
        XMLInputSource input = new XMLInputSource(aURL);
        TypeSystemDescription desc = UIMAFramework.getXMLParser().parseTypeSystemDescription(input);
        desc.resolveImports(aAlreadyImportedTypeSystemURLs, aResourceManager);
        aResults.addAll(Arrays.asList(desc.getTypes()));
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

