/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.internal.util.Timer;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.tools.cpm.PerformanceReportDialog;
import org.apache.uima.tools.cvd.FSNode;
import org.apache.uima.tools.cvd.FSTreeModel;
import org.apache.uima.tools.cvd.IndexTreeNode;
import org.apache.uima.tools.cvd.LogFileViewer;
import org.apache.uima.tools.cvd.StringFsPopupEventAdapter;
import org.apache.uima.tools.cvd.TypeTreeNode;
import org.apache.uima.tools.cvd.control.AboutHandler;
import org.apache.uima.tools.cvd.control.AboutUimaHandler;
import org.apache.uima.tools.cvd.control.AddCPHandler;
import org.apache.uima.tools.cvd.control.AddLanguageHandler;
import org.apache.uima.tools.cvd.control.AnnotatorOpenEventHandler;
import org.apache.uima.tools.cvd.control.AnnotatorRerunEventHandler;
import org.apache.uima.tools.cvd.control.AnnotatorRunOnCasEventHandler;
import org.apache.uima.tools.cvd.control.CaretChangeHandler;
import org.apache.uima.tools.cvd.control.CloseLogViewHandler;
import org.apache.uima.tools.cvd.control.ColorPrefsOpenHandler;
import org.apache.uima.tools.cvd.control.ColorPrefsSaveHandler;
import org.apache.uima.tools.cvd.control.FSTreeSelectionListener;
import org.apache.uima.tools.cvd.control.FileOpenEventHandler;
import org.apache.uima.tools.cvd.control.FileSaveAsEventHandler;
import org.apache.uima.tools.cvd.control.FileSaveEventHandler;
import org.apache.uima.tools.cvd.control.FocusFSAction;
import org.apache.uima.tools.cvd.control.FocusIRAction;
import org.apache.uima.tools.cvd.control.FocusTextAction;
import org.apache.uima.tools.cvd.control.HelpHandler;
import org.apache.uima.tools.cvd.control.IndexPopupListener;
import org.apache.uima.tools.cvd.control.IndexTreeSelectionListener;
import org.apache.uima.tools.cvd.control.LoadRecentDescFileEventHandler;
import org.apache.uima.tools.cvd.control.LoadRecentTextFileEventHandler;
import org.apache.uima.tools.cvd.control.MainFrameClosing;
import org.apache.uima.tools.cvd.control.ManualHandler;
import org.apache.uima.tools.cvd.control.NewTextEventHandler;
import org.apache.uima.tools.cvd.control.PopupHandler;
import org.apache.uima.tools.cvd.control.PopupListener;
import org.apache.uima.tools.cvd.control.RemoveCodePageHandler;
import org.apache.uima.tools.cvd.control.RemoveLanguageHandler;
import org.apache.uima.tools.cvd.control.RestoreCPDefaultsHandler;
import org.apache.uima.tools.cvd.control.RestoreLangDefaultsHandler;
import org.apache.uima.tools.cvd.control.SetCodePageHandler;
import org.apache.uima.tools.cvd.control.SetDataPathHandler;
import org.apache.uima.tools.cvd.control.SetLanguageHandler;
import org.apache.uima.tools.cvd.control.SetLogConfigHandler;
import org.apache.uima.tools.cvd.control.ShowAnnotatedTextHandler;
import org.apache.uima.tools.cvd.control.ShowAnnotationCustomizerHandler;
import org.apache.uima.tools.cvd.control.ShowTypesystemHandler;
import org.apache.uima.tools.cvd.control.SofaSelectionListener;
import org.apache.uima.tools.cvd.control.SystemExitHandler;
import org.apache.uima.tools.cvd.control.TextChangedListener;
import org.apache.uima.tools.cvd.control.TextContextMenuAction;
import org.apache.uima.tools.cvd.control.TextFocusHandler;
import org.apache.uima.tools.cvd.control.TreeFocusHandler;
import org.apache.uima.tools.cvd.control.TypeSystemFileOpenEventHandler;
import org.apache.uima.tools.cvd.control.UndoMgr;
import org.apache.uima.tools.cvd.control.XCASFileOpenEventHandler;
import org.apache.uima.tools.cvd.control.XCASSaveHandler;
import org.apache.uima.tools.cvd.control.XCASSaveTSHandler;
import org.apache.uima.tools.cvd.control.XmiCasFileOpenHandler;
import org.apache.uima.tools.cvd.control.XmiCasSaveHandler;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.XMLInputSource;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -1357410768440678886L;
    public static ArrayList logLevels = new ArrayList(9);
    private static final String loggerPropertiesFileName = "org/apache/uima/tools/annot_view/Logger.properties";
    private static final String defaultText = "Load or edit text here.";
    private static final String titleText = "CAS Visual Debugger (CVD)";
    static final String htmlGrayColor = "<font color=#808080>";
    private static final String indexReposRootLabel = "<html><b>CAS Index Repository</b></html>";
    private static final String noIndexReposLabel = "<html><b><font color=#808080>CAS Index Repository</b></html>";
    private JTextArea textArea;
    private JTree indexTree;
    private JTree fsTree;
    private JPanel statusPanel;
    private JTextField statusBar;
    private JTextField fileStatus;
    private JTextField aeStatus;
    private JTextField caretStatus;
    private Border textTitleBorder;
    private boolean isDirty;
    private JScrollPane textScrollPane;
    private JScrollPane indexTreeScrollPane;
    private JScrollPane fsTreeScrollPane;
    private JMenu fileMenu = null;
    private JMenuItem fileSaveItem = null;
    private JMenu editMenu;
    private JMenuItem undoItem;
    private UndoMgr undoMgr;
    private Action cutAction;
    private Action copyAction;
    private JMenuItem allAnnotationViewerItem;
    private JMenuItem acdItem;
    private JMenuItem tsViewerItem;
    private JMenuItem reRunMenu;
    private JMenuItem runOnCasMenuItem;
    private JMenuItem showPerfReportItem;
    private JPopupMenu textPopup;
    private JMenuItem xcasReadItem;
    private JMenuItem xcasWriteItem;
    private JMenuItem xmiCasReadItem;
    private JMenuItem xmiCasWriteItem;
    private JMenuItem typeSystemWriteItem;
    private JMenuItem typeSystemReadItem;
    private JMenu recentTextFileMenu;
    private JMenu recentDescFileMenu;
    private String codePagePrefsList = null;
    private ArrayList codePages = null;
    private String codePage = null;
    private JMenu cpMenu;
    private ButtonGroup cpButtons;
    private static final String defaultCodePages = "US-ASCII,ISO-8859-1,UTF-8,UTF-16BE,UTF-16LE,UTF-16";
    String languagePrefsList = null;
    private ArrayList languages = null;
    private JMenu langMenu;
    private ButtonGroup langButtons;
    private static final String LANGUAGE_DEFAULT = "en";
    private String language;
    private static final String defaultLanguages = "de,en,fr,ja,ko-kr,pt-br,zh-cn,zh-tw,x-unspecified";
    private File textFile = null;
    private File fileOpenDir = null;
    private File annotOpenDir = null;
    private File xcasFileOpenDir = null;
    private File colorSettingsDir = null;
    private String indexLabel = null;
    private FSIndex index = null;
    private boolean isAnnotationIndex = false;
    private CAS cas = null;
    private File aeDescriptorFile = null;
    private AnalysisEngine ae = null;
    private File logFile = null;
    private Logger log = null;
    private File colorSettingFile;
    private static final Color selectionColor;
    private Properties preferences;
    private ProcessTrace lastRunProcessTrace = null;
    public static final String textDirPref = "dir.open.text";
    public static final String aeDirPref = "dir.open.tae";
    public static final String xcasDirPref = "dir.open.xcas";
    public static final String textSizePref = "textArea.size";
    public static final String indexTreeSizePref = "indexTree.size";
    public static final String fsTreeSizePref = "fsTree.size";
    public static final String tsWindowSizePref = "tsWindow.size";
    public static final String annotViewSizePref = "annotViewWindow.size";
    public static final String logViewSizePref = "logViewWindow.size";
    public static final String widthSuffix = ".width";
    public static final String heightSuffix = ".height";
    private static final String colorFilePref = "colors.file";
    private static final String colorDirPref = "colors.dir";
    private static final String cpCurrentPref = "cp.selected";
    private static final String cpListPref = "cp.list";
    private static final String langCurrentPref = "lang.selected";
    private static final String langListPref = "lang.list";
    private static final String textFileListPref = "file.text.list";
    private static final String descFileListPref = "file.desc.list";
    private static final String dataPathPref = "datapath";
    private static final Dimension textDimensionDefault;
    private static final Dimension fsTreeDimensionDefault;
    private static final Dimension logFileDimensionDefault;
    public static final String DEFAULT_STYLE_NAME = "defaultStyle";
    private HashMap styleMap = new HashMap();
    private ArrayList textFileNameList = new ArrayList();
    private int numRecentTextFiles = 0;
    private int nextToReplaceTextFile = 0;
    private ArrayList descFileNameList = new ArrayList();
    private int numRecentDescFiles = 0;
    private int nextToReplaceDescFile = 0;
    private static final int maxRecentSize = 8;
    private ArrayList cursorOwningComponents = new ArrayList();
    private ArrayList cursorCache = null;
    private String dataPathName;
    private JComboBox sofaSelectionComboBox;
    private JPanel sofaSelectionPanel;
    private boolean exitOnClose = true;

    public MainFrame() {
        this.init();
    }

    public MainFrame(GraphicsConfiguration arg0) {
        super(arg0);
        this.init();
    }

    public MainFrame(String arg0) {
        super(arg0);
        this.init();
    }

    public MainFrame(String arg0, GraphicsConfiguration arg1) {
        super(arg0, arg1);
        this.init();
    }

    public void runAE(boolean doCasReset) {
        this.setStatusbarMessage("Running Annotator.");
        Timer timer = new Timer();
        timer.start();
        if (this.ae == null) {
            JOptionPane.showMessageDialog(this, "No AE loaded.", "Error", 0);
            return;
        }
        this.internalRunAE(doCasReset);
        timer.stop();
        this.setStatusbarMessage("Done running AE " + this.ae.getAnalysisEngineMetaData().getName() + " in " + timer.getTimeSpan() + ".");
        this.updateIndexTree(true);
        this.allAnnotationViewerItem.setEnabled(false);
        this.isDirty = false;
        this.runOnCasMenuItem.setEnabled(true);
    }

    public void setDataPath(String dataPath) {
        this.dataPathName = dataPath;
    }

    public void loadAEDescriptor(File descriptorFile) {
        this.setWaitCursor();
        if (descriptorFile.exists() && descriptorFile.isFile()) {
            this.annotOpenDir = descriptorFile.getParentFile();
        }
        Timer time = new Timer();
        time.start();
        boolean success = false;
        try {
            success = this.setupAE(descriptorFile);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        catch (NoClassDefFoundError e) {
            this.handleException(e);
        }
        time.stop();
        this.addRecentDescFile(descriptorFile);
        if (!success) {
            this.setStatusbarMessage("Failed to load AE specifier: " + descriptorFile.getName());
            this.reRunMenu.setText("Run AE");
            this.setAEStatusMessage();
            this.resetCursor();
            return;
        }
        if (this.ae != null) {
            this.aeDescriptorFile = descriptorFile;
            String annotName = this.ae.getAnalysisEngineMetaData().getName();
            this.reRunMenu.setText("Run " + annotName);
            this.reRunMenu.setEnabled(true);
            this.runOnCasMenuItem.setText("Run " + annotName + " on CAS");
            this.setAEStatusMessage();
            this.setStatusbarMessage("Done loading AE " + annotName + " in " + time.getTimeSpan() + ".");
        }
        if (this.ae != null && this.ae.getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) {
            JOptionPane.showMessageDialog(this, "This analysis engine uses a CAS multiplier component.\nCAS multiplication/merging is not currently supported in CVD.\nYou can run the analysis engine, but will not see any results.", "Warning: unsupported operation", 2);
        }
        this.resetCursor();
    }

    public void handleException(Throwable e) {
        StringBuffer msg = new StringBuffer();
        this.handleException(e, msg);
    }

    protected void handleException(Throwable e, StringBuffer msg) {
        boolean hasAsserts;
        msg.append(e.getClass().getName() + ": ");
        if (e.getMessage() != null) {
            msg.append(e.getMessage());
        }
        if (this.log != null) {
            if (e instanceof Exception) {
                this.log.log(Level.SEVERE, ((Exception)e).getLocalizedMessage(), e);
            } else {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            msg.append("\nMore detailed information is in the log file.");
        }
        if (hasAsserts = false) {
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog(this, msg.toString(), "Exception", 0);
    }

    private void showError(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Error", 0);
    }

    public void loadFile() {
        try {
            if (this.textFile.exists() && this.textFile.canRead()) {
                String text = null;
                text = this.codePage == null ? FileUtils.file2String(this.textFile) : FileUtils.file2String(this.textFile, this.codePage);
                this.setTextNoTitle(text);
                this.setTitle();
                this.addRecentTextFile(this.textFile);
            } else {
                this.handleException(new IOException("File does not exist or is not readable: " + this.textFile.getAbsolutePath()));
            }
        }
        catch (UnsupportedEncodingException e) {
            StringBuffer msg = new StringBuffer("Unsupported text encoding (code page): ");
            this.handleException(e, msg);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private static final int getMnemonic(int i) {
        switch (i) {
            case 1: {
                return 49;
            }
            case 2: {
                return 50;
            }
            case 3: {
                return 51;
            }
            case 4: {
                return 52;
            }
            case 5: {
                return 53;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 55;
            }
            case 8: {
                return 56;
            }
            case 9: {
                return 57;
            }
        }
        return 48;
    }

    private final JMenuItem createRecentTextFileItem(int num, File file) {
        String fileShortName = file.getName();
        JMenuItem item = new JMenuItem(num + " " + fileShortName, MainFrame.getMnemonic(num));
        item.addActionListener(new LoadRecentTextFileEventHandler(this, file.getAbsolutePath()));
        item.setToolTipText(file.getAbsolutePath());
        return item;
    }

    private void addRecentTextFile(File file) {
        if (this.textFileNameList.contains(file.getAbsolutePath())) {
            return;
        }
        if (this.numRecentTextFiles < 8) {
            ++this.numRecentTextFiles;
            ++this.nextToReplaceTextFile;
            this.recentTextFileMenu.add(this.createRecentTextFileItem(this.numRecentTextFiles, file));
            this.textFileNameList.add(file.getAbsolutePath());
        } else {
            if (this.nextToReplaceTextFile >= 8) {
                this.nextToReplaceTextFile = 0;
            }
            this.textFileNameList.set(this.nextToReplaceTextFile, file.getAbsolutePath());
            JMenuItem item = this.createRecentTextFileItem(this.nextToReplaceTextFile + 1, file);
            this.recentTextFileMenu.remove(this.nextToReplaceTextFile);
            this.recentTextFileMenu.insert(item, this.nextToReplaceTextFile);
            ++this.nextToReplaceTextFile;
        }
    }

    private final JMenuItem createRecentDescFileItem(int num, File file) {
        String fileShortName = file.getName();
        JMenuItem item = new JMenuItem(num + " " + fileShortName, MainFrame.getMnemonic(num));
        item.addActionListener(new LoadRecentDescFileEventHandler(this, file.getAbsolutePath()));
        item.setToolTipText(file.getAbsolutePath());
        return item;
    }

    private void addRecentDescFile(File file) {
        if (this.descFileNameList.contains(file.getAbsolutePath())) {
            return;
        }
        if (this.numRecentDescFiles < 8) {
            ++this.numRecentDescFiles;
            ++this.nextToReplaceDescFile;
            this.recentDescFileMenu.add(this.createRecentDescFileItem(this.numRecentDescFiles, file));
            this.descFileNameList.add(file.getAbsolutePath());
        } else {
            if (this.nextToReplaceDescFile >= 8) {
                this.nextToReplaceDescFile = 0;
            }
            this.descFileNameList.set(this.nextToReplaceDescFile, file.getAbsolutePath());
            JMenuItem item = this.createRecentDescFileItem(this.nextToReplaceDescFile + 1, file);
            this.recentDescFileMenu.remove(this.nextToReplaceDescFile);
            this.recentDescFileMenu.insert(item, this.nextToReplaceDescFile);
            ++this.nextToReplaceDescFile;
        }
    }

    public void setText(String text) {
        this.textFile = null;
        this.setTextNoTitle(text);
        this.setTitle();
    }

    public void loadTextFile(File textFile1) {
        this.textFile = textFile1;
        this.loadFile();
    }

    public void setTextNoTitle(String text) {
        this.textArea.setText(text);
        this.textArea.getCaret().setDot(0);
        this.isDirty = false;
    }

    public void setTitle() {
        StringBuffer buf = new StringBuffer();
        buf.append(titleText);
        if (this.textFile != null) {
            buf.append(": \"");
            buf.append(this.textFile.getAbsolutePath());
            buf.append("*");
            buf.append("\"");
        }
        this.setTitle(buf.toString());
    }

    public boolean saveFile() {
        if (this.textFile.exists() && !this.textFile.canWrite()) {
            this.showError("File is not writable: " + this.textFile.getAbsolutePath());
            return false;
        }
        String text = this.textArea.getText();
        FileOutputStream fileOutStream = null;
        try {
            fileOutStream = new FileOutputStream(this.textFile);
        }
        catch (FileNotFoundException e) {
            this.handleException(e);
            return false;
        }
        OutputStreamWriter writer = null;
        if (this.codePage == null) {
            writer = new OutputStreamWriter(fileOutStream);
        } else {
            try {
                writer = new OutputStreamWriter((OutputStream)fileOutStream, this.codePage);
            }
            catch (UnsupportedEncodingException e) {
                this.handleException(e);
                return false;
            }
        }
        try {
            writer.write(text);
            ((Writer)writer).close();
            this.isDirty = false;
            this.setTitle();
        }
        catch (IOException e) {
            this.handleException(e);
            return false;
        }
        return true;
    }

    private void createTextArea() {
        try {
            this.textArea = new JTextArea();
            this.addCursorOwningComponent(this.textArea);
            Border emptyBorder = BorderFactory.createEmptyBorder(2, 4, 2, 2);
            Border grayLineBordre = BorderFactory.createLineBorder(Color.gray, 1);
            this.textArea.setBorder(BorderFactory.createCompoundBorder(grayLineBordre, emptyBorder));
            this.textArea.setSelectionColor(selectionColor);
            this.textArea.setEditable(true);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setText(defaultText);
            this.textArea.addMouseListener(new PopupListener(this));
            this.textArea.addFocusListener(new TextFocusHandler(this));
            this.textArea.getDocument().addDocumentListener(new TextChangedListener(this));
            this.textArea.addCaretListener(new CaretChangeHandler(this));
            this.undoMgr = new UndoMgr(this);
            this.textArea.getDocument().addUndoableEditListener(this.undoMgr);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void populateEditMenu() {
        this.undoItem = new JMenuItem("Undo");
        this.undoItem.addActionListener(this.undoMgr);
        this.undoItem.setEnabled(false);
        this.undoItem.setMnemonic(85);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.editMenu.add(this.undoItem);
        this.editMenu.addSeparator();
        HashMap actionMap = this.createEditActionMap();
        this.cutAction = (Action)actionMap.get("cut-to-clipboard");
        this.cutAction.putValue("MnemonicKey", new Integer(84));
        this.cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        this.cutAction.setEnabled(false);
        JMenuItem cutItem = new JMenuItem(this.cutAction);
        cutItem.setText("Cut");
        this.editMenu.add(cutItem);
        this.copyAction = (Action)actionMap.get("copy-to-clipboard");
        this.copyAction.putValue("MnemonicKey", new Integer(67));
        this.copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        this.copyAction.setEnabled(false);
        JMenuItem copyItem = new JMenuItem(this.copyAction);
        copyItem.setText("Copy");
        this.editMenu.add(copyItem);
        Action pasteAction = (Action)actionMap.get("paste-from-clipboard");
        pasteAction.putValue("MnemonicKey", new Integer(80));
        pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        JMenuItem pasteItem = new JMenuItem(pasteAction);
        pasteItem.setText("Paste");
        this.editMenu.add(pasteItem);
    }

    private HashMap createEditActionMap() {
        HashMap<Object, Action> map = new HashMap<Object, Action>();
        Action[] ar = this.textArea.getActions();
        for (int i = 0; i < ar.length; ++i) {
            Action a = ar[i];
            map.put(a.getValue("Name"), a);
        }
        return map;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.createFileMenu();
        menuBar.add(this.fileMenu);
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createRunMenu());
        menuBar.add(this.createToolsMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private JMenu createEditMenu() {
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic(69);
        this.populateEditMenu();
        return this.editMenu;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        JMenuItem manualItem = new JMenuItem("Manual", 77);
        manualItem.addActionListener(new ManualHandler(this));
        helpMenu.add(manualItem);
        JMenuItem helpInfoItem = new JMenuItem("Help", 72);
        helpInfoItem.addActionListener(new HelpHandler(this));
        helpMenu.add(helpInfoItem);
        helpMenu.addSeparator();
        JMenuItem aboutItem = new JMenuItem("About CVD", 65);
        aboutItem.addActionListener(new AboutHandler(this));
        helpMenu.add(aboutItem);
        JMenuItem aboutUimaItem = new JMenuItem("About UIMA", 85);
        aboutUimaItem.addActionListener(new AboutUimaHandler(this));
        helpMenu.add(aboutUimaItem);
        return helpMenu;
    }

    private void createFileMenu() {
        this.fileMenu = new JMenu("File");
        JMenuItem newTextItem = new JMenuItem("New Text...", 78);
        newTextItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newTextItem.addActionListener(new NewTextEventHandler(this));
        this.fileMenu.add(newTextItem);
        this.fileMenu.setMnemonic(70);
        JMenuItem fileOpen = new JMenuItem("Open Text File", 79);
        fileOpen.addActionListener(new FileOpenEventHandler(this));
        fileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fileMenu.add(fileOpen);
        this.fileSaveItem = new JMenuItem("Save Text File", 83);
        this.fileSaveItem.setEnabled(false);
        this.fileSaveItem.addActionListener(new FileSaveEventHandler(this));
        this.fileSaveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenu.add(this.fileSaveItem);
        JMenuItem fileSaveAsItem = new JMenuItem("Save Text As...", 65);
        fileSaveAsItem.addActionListener(new FileSaveAsEventHandler(this));
        this.fileMenu.add(fileSaveAsItem);
        this.createCPMenu();
        this.cpMenu.setMnemonic(80);
        this.fileMenu.add(this.cpMenu);
        this.fileMenu.addSeparator();
        this.recentTextFileMenu = new JMenu("Recently used ...");
        this.recentTextFileMenu.setMnemonic(85);
        this.fileMenu.add(this.recentTextFileMenu);
        this.fileMenu.addSeparator();
        JMenuItem colorPrefsOpenItem = new JMenuItem("Load Color Settings", 76);
        colorPrefsOpenItem.addActionListener(new ColorPrefsOpenHandler(this));
        this.fileMenu.add(colorPrefsOpenItem);
        JMenuItem colorPrefsSaveItem = new JMenuItem("Save Color Settings", 67);
        colorPrefsSaveItem.addActionListener(new ColorPrefsSaveHandler(this));
        this.fileMenu.add(colorPrefsSaveItem);
        this.fileMenu.addSeparator();
        this.typeSystemReadItem = new JMenuItem("Read Type System File");
        this.typeSystemReadItem.setEnabled(true);
        this.typeSystemReadItem.addActionListener(new TypeSystemFileOpenEventHandler(this));
        this.fileMenu.add(this.typeSystemReadItem);
        this.typeSystemWriteItem = new JMenuItem("Write Type System File");
        this.typeSystemWriteItem.addActionListener(new XCASSaveTSHandler(this));
        this.fileMenu.add(this.typeSystemWriteItem);
        this.fileMenu.addSeparator();
        this.xmiCasReadItem = new JMenuItem("Read XMI CAS File");
        this.xmiCasReadItem.addActionListener(new XmiCasFileOpenHandler(this));
        this.fileMenu.add(this.xmiCasReadItem);
        this.xmiCasWriteItem = new JMenuItem("Write XMI CAS File");
        this.xmiCasWriteItem.addActionListener(new XmiCasSaveHandler(this));
        this.fileMenu.add(this.xmiCasWriteItem);
        this.fileMenu.addSeparator();
        this.xcasReadItem = new JMenuItem("Read XCAS File", 82);
        this.xcasReadItem.addActionListener(new XCASFileOpenEventHandler(this));
        this.fileMenu.add(this.xcasReadItem);
        this.xcasWriteItem = new JMenuItem("Write XCAS File", 87);
        this.xcasWriteItem.addActionListener(new XCASSaveHandler(this));
        this.fileMenu.add(this.xcasWriteItem);
        this.fileMenu.addSeparator();
        JMenuItem exit = new JMenuItem("Exit", 88);
        exit.addActionListener(new SystemExitHandler(this));
        this.fileMenu.add(exit);
        this.typeSystemWriteItem.setEnabled(false);
        this.setEnableCasFileReadingAndWriting();
    }

    public final void setEnableCasFileReadingAndWriting() {
        boolean enable = this.cas != null;
        this.xcasReadItem.setEnabled(enable);
        this.xmiCasReadItem.setEnabled(enable);
        this.xcasWriteItem.setEnabled(enable);
        this.xmiCasWriteItem.setEnabled(enable);
    }

    private final void addCursorOwningComponent(Component comp) {
        this.cursorOwningComponents.add(comp);
    }

    private final void setWaitCursor() {
        this.setEnabled(false);
        this.cursorCache = new ArrayList();
        for (int i = 0; i < this.cursorOwningComponents.size(); ++i) {
            Component comp = (Component)this.cursorOwningComponents.get(i);
            this.cursorCache.add(comp.getCursor());
            comp.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public final void resetCursor() {
        if (this.cursorCache == null) {
            return;
        }
        for (int i = 0; i < this.cursorOwningComponents.size(); ++i) {
            Component comp = (Component)this.cursorOwningComponents.get(i);
            comp.setCursor((Cursor)this.cursorCache.get(i));
        }
        this.setEnabled(true);
    }

    public void addCodePage(String codePage1) {
        this.codePage = codePage1;
        if (!this.codePages.contains(codePage1)) {
            this.codePages.add(codePage1);
        }
        this.resetCPMenu();
    }

    public void createCodePages() {
        this.codePages = new ArrayList();
        if (this.codePagePrefsList == null) {
            this.codePagePrefsList = defaultCodePages;
        }
        String sysCodePage = null;
        try {
            File tmpFile = File.createTempFile("uima", "tmp");
            FileOutputStream fos = new FileOutputStream(tmpFile);
            OutputStreamWriter writer = new OutputStreamWriter(fos);
            sysCodePage = writer.getEncoding();
            writer.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (sysCodePage != null) {
            this.codePages.add(sysCodePage);
            if (this.codePage == null) {
                this.codePage = sysCodePage;
            }
        }
        StringTokenizer tok = new StringTokenizer(this.codePagePrefsList, ",");
        while (tok.hasMoreTokens()) {
            String cp = tok.nextToken();
            if (this.codePages.contains(cp)) continue;
            this.codePages.add(cp);
        }
    }

    public void resetTrees() {
        this.updateIndexTree(false);
    }

    private void createCPMenu() {
        this.createCodePages();
        this.cpMenu = new JMenu("Code Page");
        this.resetCPMenu();
    }

    public void resetCPMenu() {
        this.cpMenu.removeAll();
        this.cpButtons = new ButtonGroup();
        for (int i = 0; i < this.codePages.size(); ++i) {
            String cp = (String)this.codePages.get(i);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(cp);
            if (cp.equals(this.codePage)) {
                item.setSelected(true);
            }
            item.addActionListener(new SetCodePageHandler(this));
            this.cpButtons.add(item);
            this.cpMenu.add(item);
        }
        this.cpMenu.addSeparator();
        JMenuItem addCPItem = new JMenuItem("Add code page");
        addCPItem.addActionListener(new AddCPHandler(this));
        this.cpMenu.add(addCPItem);
        JMenu removeMenu = new JMenu("Remove code page");
        for (int i = 0; i < this.codePages.size(); ++i) {
            JMenuItem rmItem = new JMenuItem((String)this.codePages.get(i));
            rmItem.addActionListener(new RemoveCodePageHandler(this));
            removeMenu.add(rmItem);
        }
        this.cpMenu.add(removeMenu);
        JMenuItem restoreDefaultsItem = new JMenuItem("Restore defaults");
        restoreDefaultsItem.addActionListener(new RestoreCPDefaultsHandler(this));
        this.cpMenu.add(restoreDefaultsItem);
    }

    public void addLanguage(String language1) {
        this.language = language1;
        if (!this.languages.contains(language1)) {
            this.languages.add(language1);
        }
        this.resetLangMenu();
    }

    private void createLangMenu() {
        this.createLanguages();
        this.langMenu = new JMenu("Language");
        this.resetLangMenu();
    }

    public void resetLangMenu() {
        this.langMenu.removeAll();
        this.langButtons = new ButtonGroup();
        for (int i = 0; i < this.languages.size(); ++i) {
            String lang = (String)this.languages.get(i);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(lang);
            if (lang.equals(this.language)) {
                item.setSelected(true);
            }
            item.addActionListener(new SetLanguageHandler(this));
            this.langButtons.add(item);
            this.langMenu.add(item);
        }
        this.langMenu.addSeparator();
        JMenuItem addLangItem = new JMenuItem("Add language");
        addLangItem.addActionListener(new AddLanguageHandler(this));
        this.langMenu.add(addLangItem);
        JMenu removeMenu = new JMenu("Remove language");
        for (int i = 0; i < this.languages.size(); ++i) {
            JMenuItem rmItem = new JMenuItem((String)this.languages.get(i));
            rmItem.addActionListener(new RemoveLanguageHandler(this));
            removeMenu.add(rmItem);
        }
        this.langMenu.add(removeMenu);
        JMenuItem restoreDefaultsItem = new JMenuItem("Restore defaults");
        restoreDefaultsItem.addActionListener(new RestoreLangDefaultsHandler(this));
        this.langMenu.add(restoreDefaultsItem);
    }

    public void createLanguages() {
        this.languages = new ArrayList();
        if (this.languagePrefsList == null) {
            this.languagePrefsList = defaultLanguages;
        }
        if (this.language == null) {
            this.language = LANGUAGE_DEFAULT;
        }
        StringTokenizer tok = new StringTokenizer(this.languagePrefsList, ",");
        while (tok.hasMoreTokens()) {
            String lang = tok.nextToken();
            if (this.languages.contains(lang)) continue;
            this.languages.add(lang);
        }
    }

    private JMenu createRunMenu() {
        JMenu runMenu = new JMenu("Run");
        runMenu.setMnemonic(82);
        JMenuItem runMenuItem = new JMenuItem("Load AE", 76);
        runMenuItem.addActionListener(new AnnotatorOpenEventHandler(this));
        runMenuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        runMenu.add(runMenuItem);
        this.reRunMenu = new JMenuItem("Run AE", 82);
        this.reRunMenu.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        runMenu.add(this.reRunMenu);
        this.reRunMenu.addActionListener(new AnnotatorRerunEventHandler(this));
        this.reRunMenu.setEnabled(false);
        this.runOnCasMenuItem = new JMenuItem("Run AE on CAS", 89);
        this.runOnCasMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        runMenu.add(this.runOnCasMenuItem);
        this.runOnCasMenuItem.addActionListener(new AnnotatorRunOnCasEventHandler(this));
        this.runOnCasMenuItem.setEnabled(false);
        this.showPerfReportItem = new JMenuItem("Performance report");
        this.showPerfReportItem.setEnabled(false);
        this.showPerfReportItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.lastRunProcessTrace == null) {
                    MainFrame.this.showError("No performance report to show.");
                } else {
                    PerformanceReportDialog prd = new PerformanceReportDialog(MainFrame.this);
                    prd.displayStats(MainFrame.this.lastRunProcessTrace, 1, "Process trace");
                }
            }
        });
        runMenu.add(this.showPerfReportItem);
        runMenu.addSeparator();
        this.recentDescFileMenu = new JMenu("Recently used ...");
        this.recentDescFileMenu.setMnemonic(85);
        runMenu.add(this.recentDescFileMenu);
        runMenu.addSeparator();
        this.createLangMenu();
        runMenu.add(this.langMenu);
        this.langMenu.setMnemonic(76);
        JMenuItem dataPathItem = new JMenuItem("Set data path");
        dataPathItem.addActionListener(new SetDataPathHandler(this));
        dataPathItem.setMnemonic(83);
        runMenu.addSeparator();
        runMenu.add(dataPathItem);
        return runMenu;
    }

    private JMenu createToolsMenu() {
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        this.tsViewerItem = new JMenuItem("View Typesystem", 84);
        this.tsViewerItem.addActionListener(new ShowTypesystemHandler(this));
        this.tsViewerItem.setEnabled(false);
        toolsMenu.add(this.tsViewerItem);
        this.allAnnotationViewerItem = new JMenuItem("Show Selected Annotations", 65);
        this.allAnnotationViewerItem.addActionListener(new ShowAnnotatedTextHandler(this));
        toolsMenu.add(this.allAnnotationViewerItem);
        this.allAnnotationViewerItem.setEnabled(false);
        this.acdItem = new JMenuItem("Customize Annotation Display", 67);
        toolsMenu.add(this.acdItem);
        this.acdItem.setEnabled(false);
        this.acdItem.addActionListener(new ShowAnnotationCustomizerHandler(this));
        JMenu logConfig = new JMenu("Set Log Level");
        ButtonGroup levelGroup = new ButtonGroup();
        String curLogLevel = LogManager.getLogManager().getProperty(".level");
        for (Level level : logLevels) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(level.toString());
            if (level.toString().equals(curLogLevel)) {
                item.setSelected(true);
            }
            item.addActionListener(new SetLogConfigHandler());
            levelGroup.add(item);
            logConfig.add(item);
        }
        toolsMenu.add(logConfig);
        JMenuItem logViewer = new JMenuItem("View Log File", 76);
        logViewer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LogFileViewer viewer = new LogFileViewer("Log file: " + MainFrame.this.logFile.getAbsolutePath());
                viewer.addWindowListener(new CloseLogViewHandler(MainFrame.this));
                Dimension dim = MainFrame.this.getDimension(MainFrame.logViewSizePref);
                if (dim == null) {
                    dim = logFileDimensionDefault;
                }
                viewer.init(MainFrame.this.logFile, dim);
            }
        });
        toolsMenu.add(logViewer);
        return toolsMenu;
    }

    private void createStatusBar() {
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
        this.statusBar = new JTextField();
        CompoundBorder innerCompound = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.darkGray), BorderFactory.createEmptyBorder(0, 3, 0, 3));
        CompoundBorder leftCompoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 1), innerCompound);
        CompoundBorder middleCompoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1), innerCompound);
        CompoundBorder rightCompoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0), innerCompound);
        this.statusBar.setBorder(leftCompoundBorder);
        this.statusBar.setEditable(false);
        this.statusBar.setBackground(this.getBackground());
        this.statusBar.setText("Starting up.");
        this.statusBar.setToolTipText("Status Bar");
        this.statusPanel.add(this.statusBar);
        this.fileStatus = new JTextField();
        this.fileStatus.setBorder(rightCompoundBorder);
        this.fileStatus.setMaximumSize(new Dimension(500, 25));
        this.fileStatus.setEditable(false);
        this.aeStatus = new JTextField();
        this.aeStatus.setBorder(middleCompoundBorder);
        this.aeStatus.setMaximumSize(new Dimension(500, 25));
        this.aeStatus.setEditable(false);
        this.statusPanel.add(this.aeStatus);
        this.caretStatus = new JTextField();
        this.caretStatus.setBorder(rightCompoundBorder);
        this.caretStatus.setMaximumSize(new Dimension(500, 25));
        this.caretStatus.setEditable(false);
        this.caretStatus.setToolTipText("Position of cursor or extent of selection");
        this.statusPanel.add(this.caretStatus);
        this.setAEStatusMessage();
    }

    public void setCaretStatus(int dot, int mark) {
        if (dot == mark) {
            this.caretStatus.setText("Cursor: " + dot);
        } else {
            int to;
            int from;
            if (dot < mark) {
                from = dot;
                to = mark;
            } else {
                from = mark;
                to = dot;
            }
            this.caretStatus.setText("Selection: " + from + " - " + to);
        }
        this.statusPanel.revalidate();
        boolean enable = dot != mark;
        this.cutAction.setEnabled(enable);
        this.copyAction.setEnabled(enable);
    }

    public void setFileStatusMessage() {
        TitledBorder textBorder = this.textFile == null ? BorderFactory.createTitledBorder(this.textTitleBorder, "Text") : BorderFactory.createTitledBorder(this.textTitleBorder, this.textFile.getAbsolutePath());
        this.textScrollPane.setBorder(textBorder);
        this.textScrollPane.revalidate();
    }

    private void setAEStatusMessage() {
        if (this.ae == null || this.aeDescriptorFile == null) {
            this.aeStatus.setText("(No AE Loaded)");
            this.aeStatus.setToolTipText("No AE descriptor loaded.");
        } else {
            this.aeStatus.setText(this.aeDescriptorFile.getName());
            this.aeStatus.setToolTipText("<html>Currently loaded AE descriptor file:<br>" + this.aeDescriptorFile.getAbsolutePath() + "</html>");
        }
        this.statusPanel.revalidate();
    }

    public void setStatusbarMessage(String message) {
        Calendar calendar = Calendar.getInstance();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int time = calendar.get(11);
        if (time < 10) {
            buf.append("0");
        }
        buf.append(time);
        buf.append(":");
        time = calendar.get(12);
        if (time < 10) {
            buf.append("0");
        }
        buf.append(time);
        buf.append(":");
        time = calendar.get(13);
        if (time < 10) {
            buf.append("0");
        }
        buf.append(time);
        buf.append("]  ");
        buf.append(message);
        this.statusBar.setText(buf.toString());
        this.statusPanel.revalidate();
    }

    private void initializeLogging() {
        File homeDir = new File(System.getProperty("user.home"));
        this.logFile = new File(homeDir, "uima.log");
        this.logFile.delete();
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration(ClassLoader.getSystemResourceAsStream(loggerPropertiesFileName));
        }
        catch (SecurityException e) {
            this.handleException(e);
            return;
        }
        catch (IOException e) {
            this.handleException(e);
            return;
        }
        this.log = UIMAFramework.getLogger();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
            }
        });
        this.initializeLogging();
        this.addCursorOwningComponent(this);
        this.addWindowListener(new MainFrameClosing(this));
        this.createTextArea();
        this.setTitle(titleText);
        JSplitPane splitPane = new JSplitPane(1);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border grayLineBorder = BorderFactory.createLineBorder(Color.gray, 1);
        splitPane.setBorder(emptyBorder);
        int dividerSize = 5;
        splitPane.setDividerSize(5);
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)splitPane, "Center");
        contentPane.setBorder(emptyBorder);
        this.createStatusBar();
        contentPane.add((Component)this.statusPanel, "South");
        contentPane.setOpaque(true);
        this.setContentPane(contentPane);
        this.initIRTree();
        this.indexTree.addMouseListener(new IndexPopupListener(this));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        this.sofaSelectionPanel = new JPanel();
        this.sofaSelectionComboBox = new JComboBox();
        this.sofaSelectionComboBox.addItem("_InitialView");
        this.sofaSelectionPanel.add(new JLabel("Select View:"));
        this.sofaSelectionPanel.add(this.sofaSelectionComboBox);
        leftPanel.add((Component)this.sofaSelectionPanel, "North");
        this.sofaSelectionPanel.setVisible(false);
        this.sofaSelectionComboBox.addItemListener(new SofaSelectionListener(this));
        this.sofaSelectionComboBox.setToolTipText("This CAS has multiple Views. Select the View to display.");
        JSplitPane treePairPane = new JSplitPane(0);
        treePairPane.setDividerSize(5);
        this.indexTreeScrollPane = new JScrollPane(this.indexTree);
        this.indexTreeScrollPane.setBorder(grayLineBorder);
        leftPanel.add(treePairPane);
        splitPane.setLeftComponent(leftPanel);
        treePairPane.setBorder(BorderFactory.createTitledBorder(grayLineBorder, "Analysis Results"));
        treePairPane.setLeftComponent(this.indexTreeScrollPane);
        this.initFSTree();
        this.fsTreeScrollPane = new JScrollPane(this.fsTree);
        this.fsTreeScrollPane.setBorder(grayLineBorder);
        treePairPane.setRightComponent(this.fsTreeScrollPane);
        this.textScrollPane = new JScrollPane(this.textArea);
        this.textScrollPane.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.textTitleBorder = grayLineBorder;
        this.setFileStatusMessage();
        splitPane.setRightComponent(this.textScrollPane);
        try {
            this.loadProgramPreferences();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        this.setJMenuBar(this.createMenuBar());
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        defaultStyle = StyleContext.getDefaultStyleContext().addStyle("defaultAnnot", defaultStyle);
        StyleConstants.setBackground(defaultStyle, selectionColor);
        this.styleMap.put("uima.tcas.Annotation", defaultStyle);
        this.textPopup = new JPopupMenu();
        this.fsTree.addFocusListener(new TreeFocusHandler(this.fsTree));
        this.indexTree.addFocusListener(new TreeFocusHandler(this.indexTree));
        this.initKeyMap();
        this.initFileLists();
        this.setStatusbarMessage("Ready.");
    }

    private final void initFileLists() {
        int i;
        int numFiles = this.textFileNameList.size();
        int max = numFiles < 8 ? numFiles : 8;
        for (i = 0; i < max; ++i) {
            this.recentTextFileMenu.add(this.createRecentTextFileItem(i + 1, new File((String)this.textFileNameList.get(i))));
        }
        numFiles = this.descFileNameList.size();
        max = numFiles < 8 ? numFiles : 8;
        for (i = 0; i < max; ++i) {
            this.recentDescFileMenu.add(this.createRecentDescFileItem(i + 1, new File((String)this.descFileNameList.get(i))));
        }
    }

    protected boolean setupAE(File aeFile) {
        try {
            ResourceManager rsrcMgr = null;
            if (this.dataPathName != null) {
                try {
                    rsrcMgr = UIMAFramework.newDefaultResourceManager();
                    rsrcMgr.setDataPath(this.dataPathName);
                }
                catch (MalformedURLException e) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Error setting data path in AE,\n");
                    msg.append("data path contains invalid URL or file descriptor.\n");
                    msg.append("You can still run the AE if it doesn't rely on the data path.\n");
                    msg.append("Please correct the data path in the \"Run->Set data path\" menu.\n");
                    this.handleException(e, msg);
                }
            }
            if (this.ae != null) {
                this.destroyAe();
                this.acdItem.setEnabled(false);
                this.setEnableCasFileReadingAndWriting();
                this.tsViewerItem.setEnabled(false);
                this.reRunMenu.setEnabled(false);
                this.runOnCasMenuItem.setEnabled(false);
            }
            XMLInputSource in = new XMLInputSource(aeFile);
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            this.ae = rsrcMgr == null ? UIMAFramework.produceAnalysisEngine(specifier) : UIMAFramework.produceAnalysisEngine(specifier, rsrcMgr, null);
            this.cas = this.ae.newCAS();
            this.initCas();
            this.acdItem.setEnabled(true);
            this.tsViewerItem.setEnabled(true);
            this.typeSystemWriteItem.setEnabled(true);
            this.setEnableCasFileReadingAndWriting();
            this.reRunMenu.setEnabled(true);
            this.sofaSelectionComboBox.removeAllItems();
            this.sofaSelectionComboBox.addItem("_InitialView");
            this.sofaSelectionPanel.setVisible(false);
            this.updateIndexTree(true);
        }
        catch (Exception e) {
            this.handleException(e);
            return false;
        }
        return true;
    }

    private final void initCas() {
        this.cas.setDocumentLanguage(this.language);
        this.cas.setDocumentText(this.textArea.getText());
    }

    protected void internalRunAE(boolean doCasReset) {
        try {
            if (doCasReset) {
                this.cas = this.cas.getView("_InitialView");
                this.cas.reset();
                this.initCas();
                this.sofaSelectionComboBox.setSelectedIndex(0);
            }
            this.lastRunProcessTrace = this.ae.process(this.cas);
            this.showPerfReportItem.setEnabled(true);
            this.log.log(Level.INFO, "Process trace of AE run:\n" + ((Object)this.lastRunProcessTrace).toString());
            int currentViewID = this.sofaSelectionComboBox.getSelectedIndex();
            this.sofaSelectionComboBox.removeAllItems();
            this.sofaSelectionComboBox.addItem("_InitialView");
            FSIterator sofas = ((CASImpl)this.cas).getBaseCAS().getSofaIterator();
            Feature sofaIdFeat = this.cas.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID");
            boolean nonDefaultSofaFound = false;
            while (sofas.hasNext()) {
                SofaFS sofa = (SofaFS)sofas.next();
                String sofaId = sofa.getStringValue(sofaIdFeat);
                if ("_InitialView".equals(sofaId)) continue;
                this.sofaSelectionComboBox.addItem(sofaId);
                nonDefaultSofaFound = true;
            }
            this.sofaSelectionComboBox.setSelectedIndex(currentViewID);
            this.sofaSelectionPanel.setVisible(nonDefaultSofaFound);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        catch (Error e) {
            StringBuffer buf = new StringBuffer();
            buf.append("A severe error has occured:\n");
            this.handleException(e, buf);
            throw e;
        }
    }

    private void initIRTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(noIndexReposLabel);
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.indexTree = new JTree(model);
        this.indexTree.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.indexTree.getSelectionModel().setSelectionMode(1);
        this.indexTree.addTreeSelectionListener(new IndexTreeSelectionListener(this));
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        cellRenderer.setLeafIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setOpenIcon(null);
        this.indexTree.setCellRenderer(cellRenderer);
    }

    private void initFSTree() {
        FSTreeModel treeModel = new FSTreeModel();
        this.fsTree = new JTree(treeModel);
        this.fsTree.addMouseListener(new StringFsPopupEventAdapter());
        this.fsTree.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.fsTree.setLargeModel(true);
        this.fsTree.getSelectionModel().setSelectionMode(1);
        this.fsTree.addTreeSelectionListener(new FSTreeSelectionListener(this));
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        cellRenderer.setLeafIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setOpenIcon(null);
        this.fsTree.setCellRenderer(cellRenderer);
    }

    private void deleteFSTree() {
        ((FSTreeModel)this.fsTree.getModel()).reset();
    }

    public void updateIndexTree(boolean useCAS) {
        this.deleteFSTree();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.indexTree.getModel().getRoot();
        if (useCAS) {
            root.setUserObject(indexReposRootLabel);
        } else {
            root.setUserObject(noIndexReposLabel);
        }
        root.removeAllChildren();
        if (this.cas != null && useCAS) {
            FSIndexRepository ir = this.cas.getIndexRepository();
            Iterator it = ir.getLabels();
            while (it.hasNext()) {
                String label = (String)it.next();
                FSIndex index1 = ir.getIndex(label);
                IndexTreeNode nodeObj = new IndexTreeNode(label, index1.getType(), index1.size());
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(nodeObj);
                root.add(node);
                node.add(this.createTypeTree(index1.getType(), this.cas.getTypeSystem(), label, ir));
            }
        }
        DefaultTreeModel model = (DefaultTreeModel)this.indexTree.getModel();
        TreeModelListener[] listeners = org.apache.uima.tools.cvd.tsview.MainFrame.getTreeModelListeners(model);
        Object[] path = new Object[]{root};
        TreeModelEvent event = new TreeModelEvent((Object)root, path);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].treeStructureChanged(event);
        }
    }

    public void updateFSTree(String indexName, FSIndex index1) {
        FSTreeModel treeModel = (FSTreeModel)this.fsTree.getModel();
        treeModel.update(indexName, index1, this.cas);
    }

    private ArrayList getAnnotationsAtPos(int pos, ArrayList annots) {
        FSNode annot;
        ArrayList<FSNode> res = new ArrayList<FSNode>();
        int max = annots.size();
        for (int i = 0; i < max && (annot = (FSNode)annots.get(i)).getStart() <= pos; ++i) {
            if (annot.getEnd() < pos) continue;
            res.add(annot);
        }
        return res;
    }

    private DefaultMutableTreeNode createTypeTree(Type type, TypeSystem ts, String label, FSIndexRepository ir) {
        int size = ir.getIndex(label, type).size();
        TypeTreeNode typeNode = new TypeTreeNode(type, label, size);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(typeNode);
        List types = ts.getDirectSubtypes(type);
        int max = types.size();
        for (int i = 0; i < max; ++i) {
            if (ir.getIndex(label, (Type)types.get(i)) == null) continue;
            DefaultMutableTreeNode child = this.createTypeTree((Type)types.get(i), ts, label, ir);
            node.add(child);
        }
        return node;
    }

    private void loadProgramPreferences() throws IOException {
        File home = new File(System.getProperty("user.home"));
        File prefFile = new File(home, "annotViewer.pref");
        if (prefFile.exists() && prefFile.isFile() && prefFile.canRead()) {
            String colorDirName;
            String colorFileName;
            String xcasOpenDirName;
            String aeOpenDirName;
            FileInputStream in = new FileInputStream(prefFile);
            this.preferences = new Properties();
            this.preferences.load(in);
            String fileOpenDirName = this.preferences.getProperty(textDirPref);
            if (fileOpenDirName != null) {
                this.fileOpenDir = new File(fileOpenDirName);
            }
            if ((aeOpenDirName = this.preferences.getProperty(aeDirPref)) != null) {
                this.annotOpenDir = new File(aeOpenDirName);
            }
            if ((xcasOpenDirName = this.preferences.getProperty(xcasDirPref)) != null) {
                this.xcasFileOpenDir = new File(xcasOpenDirName);
            }
            if ((colorFileName = this.preferences.getProperty(colorFilePref)) != null) {
                this.colorSettingFile = new File(colorFileName);
                try {
                    this.loadColorPreferences(this.colorSettingFile);
                }
                catch (IOException e) {
                    this.handleException(e);
                }
            }
            if ((colorDirName = this.preferences.getProperty(colorDirPref)) != null) {
                this.colorSettingsDir = new File(colorDirName);
            }
            this.codePage = this.preferences.getProperty(cpCurrentPref);
            this.codePagePrefsList = this.preferences.getProperty(cpListPref);
            this.language = this.preferences.getProperty(langCurrentPref);
            this.languagePrefsList = this.preferences.getProperty(langListPref);
            this.dataPathName = this.preferences.getProperty(dataPathPref);
        }
        if (this.preferences == null) {
            this.textScrollPane.setPreferredSize(textDimensionDefault);
            this.fsTree.setPreferredSize(fsTreeDimensionDefault);
        } else {
            this.setPreferredSize(this.textScrollPane, textSizePref);
            this.setPreferredSize(this.indexTreeScrollPane, indexTreeSizePref);
            this.setPreferredSize(this.fsTreeScrollPane, fsTreeSizePref);
        }
        if (this.preferences != null) {
            int i;
            ArrayList list = MainFrame.stringToArrayList(this.preferences.getProperty(textFileListPref, ""));
            for (i = 0; i < list.size(); ++i) {
                this.textFileNameList.add(list.get(i));
                ++this.numRecentTextFiles;
            }
            list = MainFrame.stringToArrayList(this.preferences.getProperty(descFileListPref, ""));
            for (i = 0; i < list.size(); ++i) {
                this.descFileNameList.add(list.get(i));
                ++this.numRecentDescFiles;
            }
        }
        if (this.preferences == null) {
            this.preferences = new Properties();
        }
    }

    public void setPreferredSize(JComponent comp, String propPrefix) {
        comp.setPreferredSize(this.getDimension(propPrefix));
    }

    public Dimension getDimension(String propPrefix) {
        if (this.preferences == null) {
            return null;
        }
        String width = this.preferences.getProperty(propPrefix + widthSuffix);
        String height = this.preferences.getProperty(propPrefix + heightSuffix);
        if (height == null || width == null) {
            return null;
        }
        double x = 0.0;
        double y = 0.0;
        try {
            x = Double.parseDouble(width);
            y = Double.parseDouble(height);
        }
        catch (NumberFormatException e) {
            this.handleException(e);
            return null;
        }
        Dimension d = new Dimension();
        d.setSize(x, y);
        return d;
    }

    private static final String arrayListToString(ArrayList list) {
        if (list.size() < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(list.get(0).toString());
        for (int i = 1; i < list.size(); ++i) {
            buf.append(',');
            buf.append(list.get(i).toString());
        }
        return buf.toString();
    }

    private static final ArrayList stringToArrayList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        if (s.length() > 0) {
            StringTokenizer tok = new StringTokenizer(s, ",");
            while (tok.hasMoreTokens()) {
                list.add(tok.nextToken());
            }
        }
        return list;
    }

    public void saveProgramPreferences() throws IOException {
        int i;
        StringBuffer buf;
        File home = new File(System.getProperty("user.home"));
        File prefFile = new File(home, "annotViewer.pref");
        if (this.preferences == null) {
            this.preferences = new Properties();
        }
        if (this.fileOpenDir != null) {
            this.preferences.setProperty(textDirPref, this.fileOpenDir.getAbsolutePath());
        }
        if (this.annotOpenDir != null) {
            this.preferences.setProperty(aeDirPref, this.annotOpenDir.getAbsolutePath());
        }
        if (this.xcasFileOpenDir != null) {
            this.preferences.setProperty(xcasDirPref, this.xcasFileOpenDir.getAbsolutePath());
        }
        Dimension d = this.textScrollPane.getSize();
        this.preferences.setProperty("textArea.size.width", Double.toString(d.getWidth()));
        this.preferences.setProperty("textArea.size.height", Double.toString(d.getHeight()));
        d = this.indexTreeScrollPane.getSize();
        this.preferences.setProperty("indexTree.size.width", Double.toString(d.getWidth()));
        this.preferences.setProperty("indexTree.size.height", Double.toString(d.getHeight()));
        d = this.fsTreeScrollPane.getSize();
        this.preferences.setProperty("fsTree.size.width", Double.toString(d.getWidth()));
        this.preferences.setProperty("fsTree.size.height", Double.toString(d.getHeight()));
        if (this.dataPathName != null) {
            this.preferences.setProperty(dataPathPref, this.dataPathName);
        }
        if (this.colorSettingFile != null) {
            this.preferences.setProperty(colorFilePref, this.colorSettingFile.getAbsolutePath());
        }
        if (this.colorSettingsDir != null) {
            this.preferences.setProperty(colorDirPref, this.colorSettingsDir.getAbsolutePath());
        }
        if (this.codePage != null) {
            this.preferences.setProperty(cpCurrentPref, this.codePage);
        }
        if (this.codePages != null && this.codePages.size() > 0) {
            buf = new StringBuffer();
            buf.append((String)this.codePages.get(0));
            for (i = 1; i < this.codePages.size(); ++i) {
                buf.append(",");
                buf.append((String)this.codePages.get(i));
            }
            this.preferences.setProperty(cpListPref, buf.toString());
        }
        if (this.language != null) {
            this.preferences.setProperty(langCurrentPref, this.language);
        }
        if (this.languages != null && this.languages.size() > 0) {
            buf = new StringBuffer();
            buf.append((String)this.languages.get(0));
            for (i = 1; i < this.languages.size(); ++i) {
                buf.append(",");
                buf.append((String)this.languages.get(i));
            }
            this.preferences.setProperty(langListPref, buf.toString());
        }
        this.preferences.setProperty(textFileListPref, MainFrame.arrayListToString(this.textFileNameList));
        this.preferences.setProperty(descFileListPref, MainFrame.arrayListToString(this.descFileNameList));
        FileOutputStream out = new FileOutputStream(prefFile);
        this.preferences.store(out, "Automatically generated preferences file for Annotation Viewer");
    }

    public void saveColorPreferences(File file) throws IOException {
        Properties prefs1 = new Properties();
        for (String type : this.styleMap.keySet()) {
            Style style = (Style)this.styleMap.get(type);
            Color fg = StyleConstants.getForeground(style);
            Color bg = StyleConstants.getBackground(style);
            prefs1.setProperty(type, Integer.toString(fg.getRGB()) + "+" + Integer.toString(bg.getRGB()));
        }
        FileOutputStream out = new FileOutputStream(file);
        prefs1.store(out, "Color preferences for annotation viewer.");
    }

    public void loadColorPreferences(File file) throws IOException {
        Style parent = (Style)this.styleMap.get("uima.tcas.Annotation");
        StyleContext sc = StyleContext.getDefaultStyleContext();
        Properties prefs1 = new Properties();
        FileInputStream in = new FileInputStream(file);
        prefs1.load(in);
        for (String string : prefs1.keySet()) {
            String value = prefs1.getProperty(string);
            Style style = sc.addStyle(string, parent);
            int pos = value.indexOf(43);
            if (pos <= 0) continue;
            Color color = new Color(Integer.parseInt(value.substring(0, pos)));
            StyleConstants.setForeground(style, color);
            color = new Color(Integer.parseInt(value.substring(pos + 1, value.length())));
            StyleConstants.setBackground(style, color);
            this.styleMap.put(string, style);
        }
    }

    private void initKeyMap() {
        FocusIRAction focusIRAction = new FocusIRAction(this);
        String focusIRActionName = "focusIRAction";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(73, 2), focusIRActionName);
        this.getRootPane().getActionMap().put(focusIRActionName, focusIRAction);
        FocusFSAction focusFSAction = new FocusFSAction(this);
        String focusFSActionName = "focusFSAction";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(70, 2), focusFSActionName);
        this.getRootPane().getActionMap().put(focusFSActionName, focusFSAction);
        FocusTextAction focusTextAction = new FocusTextAction(this);
        String focusTextActionName = "focusTextAction";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(84, 2), focusTextActionName);
        this.getRootPane().getActionMap().put(focusTextActionName, focusTextAction);
        TextContextMenuAction textContextAction = new TextContextMenuAction(this);
        String textContextActionName = "textContextAction";
        this.textArea.getInputMap(0).put(KeyStroke.getKeyStroke(10, 8), textContextActionName);
        this.textArea.getActionMap().put(textContextActionName, textContextAction);
    }

    public void showTextPopup(int x, int y) {
        int pos = this.textArea.getCaretPosition();
        this.textPopup.removeAll();
        JMenuItem item = new JMenuItem("Position: " + pos);
        item.setEnabled(false);
        this.textPopup.add(item);
        if (this.isAnnotationIndex) {
            ArrayList annots = ((FSTreeModel)this.fsTree.getModel()).getFSs();
            ArrayList selAnnots = this.getAnnotationsAtPos(pos, annots);
            for (int i = 0; i < selAnnots.size(); ++i) {
                FSNode posAnnot = (FSNode)selAnnots.get(i);
                item = new JMenuItem("[" + posAnnot.getArrayPos() + "] = " + posAnnot.getType().getName());
                item.addActionListener(new PopupHandler(this, posAnnot.getArrayPos()));
                this.textPopup.add(item);
            }
        }
        this.textPopup.show(this.textArea, x, y);
    }

    public JTree getIndexTree() {
        return this.indexTree;
    }

    public JTree getFsTree() {
        return this.fsTree;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public CAS getCas() {
        return this.cas;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    public Properties getPreferences() {
        return this.preferences;
    }

    public String getIndexLabel() {
        return this.indexLabel;
    }

    public FSIndex getIndex() {
        return this.index;
    }

    public HashMap getStyleMap() {
        return this.styleMap;
    }

    public AnalysisEngine getAe() {
        return this.ae;
    }

    public void setIndexLabel(String indexLabel) {
        this.indexLabel = indexLabel;
    }

    public boolean isAnnotationIndex() {
        return this.isAnnotationIndex;
    }

    public void setAnnotationIndex(boolean isAnnotationIndex) {
        this.isAnnotationIndex = isAnnotationIndex;
    }

    public void setIndex(FSIndex index) {
        this.index = index;
    }

    public void setAllAnnotationViewerItemEnable(boolean enabled) {
        this.allAnnotationViewerItem.setEnabled(enabled);
    }

    public File getFileOpenDir() {
        return this.fileOpenDir;
    }

    public void setFileOpenDir(File fileOpenDir) {
        this.fileOpenDir = fileOpenDir;
    }

    public File getTextFile() {
        return this.textFile;
    }

    public void setTextFile(File textFile) {
        this.textFile = textFile;
    }

    public void setSaveTextFileEnable(boolean enabled) {
        this.fileSaveItem.setEnabled(enabled);
    }

    public UndoMgr getUndoMgr() {
        return this.undoMgr;
    }

    public void setUndoEnabled(boolean enabled) {
        this.undoItem.setEnabled(enabled);
    }

    public File getXcasFileOpenDir() {
        return this.xcasFileOpenDir;
    }

    public void setXcasFileOpenDir(File xcasFileOpenDir) {
        this.xcasFileOpenDir = xcasFileOpenDir;
    }

    public void setCas(CAS cas) {
        this.cas = cas;
    }

    public void setRunOnCasEnabled() {
        this.runOnCasMenuItem.setEnabled(this.ae != null && this.cas != null);
    }

    public void destroyAe() {
        this.cas = null;
        if (this.ae != null) {
            this.ae.destroy();
            this.ae = null;
        }
    }

    public void setRerunEnabled(boolean enabled) {
        this.reRunMenu.setEnabled(enabled);
    }

    public void setTypeSystemViewerEnabled(boolean enabled) {
        this.tsViewerItem.setEnabled(enabled);
    }

    public File getColorSettingsDir() {
        return this.colorSettingsDir;
    }

    public void setColorSettingsDir(File colorSettingsDir) {
        this.colorSettingsDir = colorSettingsDir;
    }

    public File getColorSettingFile() {
        return this.colorSettingFile;
    }

    public void setColorSettingFile(File colorSettingFile) {
        this.colorSettingFile = colorSettingFile;
    }

    public File getAnnotOpenDir() {
        return this.annotOpenDir;
    }

    public void setAnnotOpenDir(File annotOpenDir) {
        this.annotOpenDir = annotOpenDir;
    }

    public String getDataPathName() {
        return this.dataPathName;
    }

    public void setDataPathName(String dataPathName) {
        this.dataPathName = dataPathName;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public void setCodePage(String codePage) {
        this.codePage = codePage;
    }

    public ArrayList getCodePages() {
        return this.codePages;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public ArrayList getLanguages() {
        return this.languages;
    }

    public String getLanguagePrefsList() {
        return this.languagePrefsList;
    }

    public void setLanguagePrefsList(String languagePrefsList) {
        this.languagePrefsList = languagePrefsList;
    }

    public void setCodePagePrefsList(String codePagePrefsList) {
        this.codePagePrefsList = codePagePrefsList;
    }

    public void handleSofas() {
        String currentView = (String)this.sofaSelectionComboBox.getSelectedItem();
        this.sofaSelectionComboBox.removeAllItems();
        this.sofaSelectionComboBox.addItem("_InitialView");
        FSIterator sofas = ((CASImpl)this.getCas()).getBaseCAS().getSofaIterator();
        Feature sofaIdFeat = this.getCas().getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID");
        boolean nonDefaultSofaFound = false;
        while (sofas.hasNext()) {
            SofaFS sofa = (SofaFS)sofas.next();
            String sofaId = sofa.getStringValue(sofaIdFeat);
            if ("_InitialView".equals(sofaId)) continue;
            this.sofaSelectionComboBox.addItem(sofaId);
            nonDefaultSofaFound = true;
        }
        int newIndex = 0;
        String newView = "_InitialView";
        for (int i = 0; i < this.sofaSelectionComboBox.getItemCount(); ++i) {
            if (!currentView.equals(this.sofaSelectionComboBox.getItemAt(i))) continue;
            newIndex = i;
            newView = currentView;
            break;
        }
        this.sofaSelectionPanel.setVisible(nonDefaultSofaFound);
        this.setCas(this.getCas().getView(newView));
        this.sofaSelectionComboBox.setSelectedIndex(newIndex);
        String text = this.getCas().getDocumentText();
        if (text == null) {
            text = this.getCas().getSofaDataURI();
            if (text != null) {
                text = "SofaURI = " + text;
            } else if (this.getCas().getSofaDataArray() != null) {
                text = "Sofa array with mime type = " + this.getCas().getSofa().getSofaMime();
            }
        }
        this.setText(text);
        if (text == null) {
            this.getTextArea().repaint();
        }
    }

    public boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public void setExitOnClose(boolean exitOnClose) {
        this.exitOnClose = exitOnClose;
    }

    static {
        logLevels.add(Level.OFF);
        logLevels.add(Level.SEVERE);
        logLevels.add(Level.WARNING);
        logLevels.add(Level.INFO);
        logLevels.add(Level.CONFIG);
        logLevels.add(Level.FINE);
        logLevels.add(Level.FINER);
        logLevels.add(Level.FINEST);
        logLevels.add(Level.ALL);
        selectionColor = Color.orange;
        textDimensionDefault = new Dimension(500, 400);
        fsTreeDimensionDefault = new Dimension(200, 200);
        logFileDimensionDefault = new Dimension(500, 600);
    }
}

