/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.apache.uima.tools.cvd.MainFrame;

public class ManualHandler
implements ActionListener {
    private final MainFrame main;

    public ManualHandler(MainFrame frame) {
        this.main = frame;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            File manDir;
            File manFile;
            String manpath;
            String manFileName = "tools/tools.html";
            JFrame manFrame = new JFrame("CVD Manual");
            JEditorPane editorPane = new JEditorPane();
            editorPane.setEditable(false);
            editorPane.addHyperlinkListener(new Hyperactive());
            URL manURL = ClassLoader.getSystemResource(manFileName);
            if (manURL == null && (manpath = System.getProperty("uima.tools.cvd.manpath", null)) != null && (manFile = new File(manDir = new File(manpath), manFileName)).exists()) {
                manURL = manFile.toURL();
            }
            if (manURL == null) {
                String msg = "Can't find manual. The manual is loaded via the classpath,\nso make sure the manual folder is in the classpath.";
                JOptionPane.showMessageDialog(this.main, msg, "Error loading manual", 0);
                return;
            }
            editorPane.setPage(manURL);
            JScrollPane scrollPane = new JScrollPane(editorPane);
            scrollPane.setPreferredSize(new Dimension(700, 800));
            manFrame.setContentPane(scrollPane);
            manFrame.pack();
            manFrame.setVisible(true);
            URL cvdLinkUrl = new URL(manURL.toString() + "#ugr.tools.cvd");
            HyperlinkEvent e = new HyperlinkEvent(editorPane, HyperlinkEvent.EventType.ACTIVATED, cvdLinkUrl);
            editorPane.fireHyperlinkUpdate(e);
        }
        catch (Exception e) {
            this.main.handleException(e);
        }
    }

    private class Hyperactive
    implements HyperlinkListener {
        private Hyperactive() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane pane = (JEditorPane)e.getSource();
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)pane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        pane.setPage(e.getURL());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }
}

