/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.jcasgen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.jcasgen.GuiErrorImpl;
import org.apache.uima.tools.jcasgen.GuiProgressMonitor;
import org.apache.uima.tools.jcasgen.Jg;
import org.apache.uima.tools.jcasgen.Prefs;
import org.apache.uima.tools.util.gui.AboutDialog;

public class GUI
extends JFrame {
    private static final long serialVersionUID = 1L;
    private AboutDialog aboutDialog;
    static final String NL = System.getProperties().getProperty("line.separator");
    static GUI theGUI;
    final Jg jg;
    G pnG;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        theGUI = new GUI(null);
    }

    public GUI(Jg jg) {
        super("JCasGen");
        theGUI = this;
        this.jg = jg;
        this.pnG = new G(this);
        this.setDefaultCloseOperation(3);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Could not set look and feel: " + e.getMessage());
        }
        try {
            this.setIconImage(Images.getImage("/org/apache/uima/tools/images/Micro_16.gif"));
        }
        catch (IOException e) {
            System.err.println("Image could not be loaded: " + e.getMessage());
        }
        this.getContentPane().setBackground(Color.WHITE);
        this.getContentPane().setLayout(new BorderLayout());
        JLabel banner = new JLabel(Images.getImageIcon("/org/apache/uima/tools/images/UIMA_banner.png"));
        this.getContentPane().add((Component)banner, "North");
        this.getContentPane().add((Component)this.pnG, "Center");
        this.aboutDialog = new AboutDialog(this, "About JCasGen");
        this.setJMenuBar(this.createMenuBar());
        this.pack();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.processWindowEvent(new WindowEvent(GUI.this, 201));
            }
        });
        fileMenu.add(exitMenuItem);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem aboutMenuItem = new JMenuItem("About");
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.aboutDialog.setVisible(true);
            }
        });
        helpMenu.add(aboutMenuItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    class G
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        final GUI gui;
        JLabel lbLabel6;
        JLabel lbLabel1;
        JButton btInputFileBrowse;
        JButton btOutDirBrowse;
        JButton btGenXmlBrowse;
        JLabel lbLabel0;
        JLabel lbLabel9;
        JTextArea tfInputFileName;
        JTextArea tfOutDirName;
        JTextArea tfGenXMLname;
        JLabel lbLabel11;
        JLabel lbLabel12;
        JLabel lbLabel13;
        JButton btGo;
        JTextArea taStatus;
        JScrollPane areaScrollPane;
        JLabel lbLabel15;
        JLabel lbLabel16;
        JLabel lbLabel17;
        JLabel lbLabel10;
        JLabel lbResult;

        public G(GUI gui) {
            this.gui = gui;
            GridBagLayout gbG = new GridBagLayout();
            this.setLayout(gbG);
            GridBagConstraints gbcG = new GridBagConstraints();
            gbcG.insets = new Insets(4, 4, 4, 4);
            gbcG.gridwidth = 1;
            gbcG.gridheight = 1;
            gbcG.weightx = 0.0;
            gbcG.weighty = 0.0;
            gbcG.fill = 0;
            gbcG.anchor = 10;
            this.lbLabel17 = new JLabel("Welcome to the JCasGen tool. You can drag corners to resize.");
            this.lbLabel17.setRequestFocusEnabled(false);
            this.lbLabel17.setToolTipText(null);
            this.lbLabel17.setVerifyInputWhenFocusTarget(false);
            gbcG.gridx = 1;
            gbcG.gridy = 0;
            gbG.setConstraints(this.lbLabel17, gbcG);
            this.add(this.lbLabel17);
            this.lbLabel0 = new JLabel("Input File:");
            gbcG.gridx = 0;
            gbcG.gridy = 2;
            gbG.setConstraints(this.lbLabel0, gbcG);
            this.add(this.lbLabel0);
            this.lbLabel1 = new JLabel("Output Directory:");
            gbcG.gridy = 3;
            gbG.setConstraints(this.lbLabel1, gbcG);
            this.add(this.lbLabel1);
            this.btInputFileBrowse = new JButton("Browse");
            this.btInputFileBrowse.addActionListener(this);
            gbcG.gridx = 3;
            gbcG.gridy = 2;
            gbcG.anchor = 17;
            gbG.setConstraints(this.btInputFileBrowse, gbcG);
            this.add(this.btInputFileBrowse);
            this.btOutDirBrowse = new JButton("Browse");
            this.btOutDirBrowse.addActionListener(this);
            gbcG.gridy = 3;
            gbG.setConstraints(this.btOutDirBrowse, gbcG);
            this.add(this.btOutDirBrowse);
            this.tfInputFileName = new JTextArea();
            gbcG.gridx = 1;
            gbcG.gridy = 2;
            gbcG.fill = 1;
            gbcG.weightx = 1.0;
            gbcG.weighty = 1.0;
            gbcG.anchor = 17;
            gbG.setConstraints(this.tfInputFileName, gbcG);
            this.add(this.tfInputFileName);
            this.tfOutDirName = new JTextArea();
            gbcG.gridy = 3;
            gbG.setConstraints(this.tfOutDirName, gbcG);
            this.add(this.tfOutDirName);
            this.lbLabel16 = new JLabel("Status");
            gbcG.gridy = 5;
            gbcG.fill = 0;
            gbcG.weightx = 1.0;
            gbcG.weighty = 0.0;
            gbcG.anchor = 10;
            gbG.setConstraints(this.lbLabel16, gbcG);
            this.add(this.lbLabel16);
            this.taStatus = new JTextArea();
            gbcG.gridy = 6;
            gbcG.weighty = 5.0;
            gbcG.fill = 1;
            gbcG.anchor = 18;
            this.areaScrollPane = new JScrollPane(this.taStatus);
            this.areaScrollPane.setVerticalScrollBarPolicy(22);
            gbG.setConstraints(this.areaScrollPane, gbcG);
            this.add(this.areaScrollPane);
            this.btGo = new JButton("Go");
            this.btGo.addActionListener(this);
            gbcG.gridx = 0;
            gbcG.gridy = 6;
            gbcG.fill = 0;
            gbcG.weightx = 0.0;
            gbcG.weighty = 0.0;
            gbcG.anchor = 10;
            gbG.setConstraints(this.btGo, gbcG);
            this.add(this.btGo);
            this.lbResult = new JLabel(" ");
            gbcG.gridx = 3;
            gbcG.gridy = 6;
            gbcG.fill = 1;
            gbcG.anchor = 11;
            gbG.setConstraints(this.lbResult, gbcG);
            this.add(this.lbResult);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.btInputFileBrowse) {
                this.browseFile(this.tfInputFileName);
            }
            if (e.getSource() == this.btOutDirBrowse) {
                this.browseDir(this.tfOutDirName);
            }
            if (e.getSource() == this.btGenXmlBrowse) {
                this.browseFile(this.tfGenXMLname);
            }
            if (e.getSource() == this.btGo) {
                this.lbResult.setText("Working");
                this.go();
            }
        }

        void browseFile(JTextArea f) {
            JFileChooser c;
            int returnVal;
            String startingDir = f.getText();
            if (startingDir.length() == 0) {
                startingDir = System.getProperty("user.dir");
            }
            if ((returnVal = (c = new JFileChooser(startingDir)).showOpenDialog(this)) == 0) {
                try {
                    f.setText(c.getSelectedFile().getCanonicalPath());
                    Prefs.set(this.gui);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        void browseDir(JTextArea f) {
            String startingDir = f.getText();
            if (startingDir.length() == 0) {
                startingDir = System.getProperty("user.dir");
            }
            JFileChooser c = new JFileChooser(startingDir);
            c.setFileSelectionMode(1);
            int returnVal = c.showOpenDialog(this.gui);
            if (returnVal == 0) {
                try {
                    f.setText(c.getSelectedFile().getCanonicalPath());
                    Prefs.set(this.gui);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        void go() {
            final String outDirName = this.tfOutDirName.getText();
            final String inFileName = this.tfInputFileName.getText();
            Runnable r = new Runnable(){

                public void run() {
                    GUI.this.jg.main0(new String[]{"-jcasgeninput", inFileName, "-jcasgenoutput", outDirName}, GUI.this.jg.merger, new GuiProgressMonitor(), new GuiErrorImpl());
                }
            };
            new Thread(r).start();
        }

        String showInStatus(String message) {
            this.taStatus.setText(this.taStatus.getText() + message + NL);
            this.areaScrollPane.getVerticalScrollBar().setValue(this.areaScrollPane.getVerticalScrollBar().getMaximum());
            this.gui.repaint();
            return message;
        }
    }
}

