/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tutorial.ex4;

import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.tutorial.DateAnnot;
import org.apache.uima.tutorial.Meeting;
import org.apache.uima.tutorial.RoomNumber;
import org.apache.uima.tutorial.TimeAnnot;

public class MeetingAnnotator
extends JCasAnnotator_ImplBase {
    private int mWindowSize;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mWindowSize = (Integer)aContext.getConfigParameterValue("WindowSize");
    }

    public void process(JCas aJCas) {
        AnnotationIndex roomNumberIndex = aJCas.getAnnotationIndex(RoomNumber.type);
        AnnotationIndex dateIndex = aJCas.getAnnotationIndex(DateAnnot.type);
        AnnotationIndex timeIndex = aJCas.getAnnotationIndex(TimeAnnot.type);
        int lastMeetingEnd = -1;
        FSIterator roomNumberIter = roomNumberIndex.iterator();
        while (roomNumberIter.hasNext()) {
            RoomNumber room = (RoomNumber)roomNumberIter.next();
            FSIterator dateIter = dateIndex.iterator();
            while (dateIter.hasNext()) {
                DateAnnot date = (DateAnnot)dateIter.next();
                FSIterator time1Iter = timeIndex.iterator();
                while (time1Iter.hasNext()) {
                    TimeAnnot time1 = (TimeAnnot)time1Iter.next();
                    FSIterator time2Iter = timeIndex.iterator();
                    while (time2Iter.hasNext()) {
                        TimeAnnot time2 = (TimeAnnot)time2Iter.next();
                        if (time1 == time2) continue;
                        int minBegin = Math.min(Math.min(time1.getBegin(), time2.getBegin()), Math.min(date.getBegin(), room.getBegin()));
                        int maxEnd = Math.max(Math.max(time1.getEnd(), time2.getEnd()), Math.max(date.getEnd(), room.getEnd()));
                        if (maxEnd - minBegin >= this.mWindowSize || minBegin <= lastMeetingEnd) continue;
                        Meeting mtg = new Meeting(aJCas, minBegin, maxEnd, room, date, time1, time2);
                        mtg.addToIndexes();
                        lastMeetingEnd = maxEnd;
                    }
                }
            }
        }
    }
}

