/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.uima.ResourceFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.Level;

public class SimpleResourceFactory
implements ResourceFactory {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class CLASS_NAME = SimpleResourceFactory.class;
    protected Map mClassMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource produceResource(Class aResourceClass, ResourceSpecifier aSpecifier, Map aAdditionalParams) throws ResourceInitializationException {
        Throwable lastException = null;
        Class<?>[] interfaces = aSpecifier.getClass().getInterfaces();
        List resourceClasses = null;
        for (int i = 0; i < interfaces.length && (resourceClasses = (List)this.mClassMap.get(interfaces[i])) == null; ++i) {
        }
        if (resourceClasses != null) {
            ListIterator i = resourceClasses.listIterator(resourceClasses.size());
            while (i.hasPrevious()) {
                Class currentClass = (Class)i.previous();
                Throwable currentException = null;
                try {
                    if (!aResourceClass.isAssignableFrom(currentClass)) continue;
                    Resource resource = (Resource)currentClass.newInstance();
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.CONFIG, CLASS_NAME.getName(), "produceResource", LOG_RESOURCE_BUNDLE, "UIMA_trying_resource_class__CONFIG", currentClass.getName());
                    if (!resource.initialize(aSpecifier, aAdditionalParams)) continue;
                    Resource resource2 = resource;
                    return resource2;
                }
                catch (IllegalAccessException e) {
                    currentException = new ResourceInitializationException("could_not_instantiate", new Object[]{currentClass.getName(), aSpecifier.getSourceUrlString()}, e);
                }
                catch (InstantiationException e) {
                    currentException = new ResourceInitializationException("could_not_instantiate", new Object[]{currentClass.getName(), aSpecifier.getSourceUrlString()}, e);
                }
                catch (Throwable t) {
                    currentException = new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{currentClass.getName(), aSpecifier.getSourceUrlString()}, t);
                }
                finally {
                    if (currentException != null) {
                        currentException.fillInStackTrace();
                        lastException = currentException;
                    }
                }
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return null;
    }

    public void addMapping(Class aSpecifierInterface, Class aResourceClass) {
        ArrayList<Class> mappingList = (ArrayList<Class>)this.mClassMap.get(aSpecifierInterface);
        if (mappingList == null) {
            mappingList = new ArrayList<Class>();
            this.mClassMap.put(aSpecifierInterface, mappingList);
        }
        mappingList.add(aResourceClass);
    }

    public void addMapping(String aSpecifierInterfaceName, String aResourceClassName) throws ClassNotFoundException {
        this.addMapping(Class.forName(aSpecifierInterfaceName), Class.forName(aResourceClassName));
    }
}

