/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.internal.util.XMLUtils;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSerializer {
    private static final SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private TransformerHandler mHandler;
    private Transformer mTransformer;
    private Result mResult;

    public XMLSerializer() {
        this(true);
    }

    public XMLSerializer(boolean isFormattedOutput) {
        try {
            this.mHandler = transformerFactory.newTransformerHandler();
            this.mTransformer = this.mHandler.getTransformer();
            if (isFormattedOutput) {
                this.mTransformer.setOutputProperty("indent", "yes");
                this.mTransformer.setOutputProperty("encoding", "UTF-8");
                this.mTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                this.mTransformer.setOutputProperty("method", "xml");
            }
        }
        catch (TransformerConfigurationException e) {
            throw new UIMARuntimeException(e);
        }
    }

    public XMLSerializer(OutputStream aOutputStream) {
        this();
        this.setOutputStream(aOutputStream);
    }

    public XMLSerializer(OutputStream aOutputStream, boolean isFormattedOutput) {
        this(isFormattedOutput);
        this.setOutputStream(aOutputStream);
    }

    public XMLSerializer(Writer aWriter) {
        this();
        this.setWriter(aWriter);
    }

    public XMLSerializer(Writer aWriter, boolean isFormattedOutput) {
        this(isFormattedOutput);
        this.setWriter(aWriter);
    }

    public void setOutputStream(OutputStream aOutputStream) {
        this.mResult = new StreamResult(aOutputStream);
        this.mHandler.setResult(this.mResult);
    }

    public void setWriter(Writer aWriter) {
        this.mResult = new StreamResult(aWriter);
        this.mHandler.setResult(this.mResult);
    }

    public ContentHandler getContentHandler() {
        String xmlVer = this.mTransformer.getOutputProperty("version");
        boolean xml10 = xmlVer == null || "1.0".equals(xmlVer);
        return new CharacterValidatingContentHandler(!xml10, this.mHandler);
    }

    public void serialize(Node node) {
        try {
            this.mTransformer.transform(new DOMSource(node), this.mResult);
        }
        catch (TransformerException e) {
            throw new UIMARuntimeException(e);
        }
    }

    public void dom2sax(Node node, ContentHandler handler) {
        try {
            this.mTransformer.transform(new DOMSource(node), new SAXResult(handler));
        }
        catch (TransformerException e) {
            throw new UIMARuntimeException(e);
        }
    }

    public void setOutputProperty(String name, String value) {
        try {
            this.mTransformer.setOutputProperty(name, value);
        }
        catch (IllegalArgumentException e) {
            throw new UIMARuntimeException(e);
        }
    }

    static class CharacterValidatingContentHandler
    implements ContentHandler {
        ContentHandler mHandler;
        boolean mXml11;

        CharacterValidatingContentHandler(boolean xml11, ContentHandler serializerHandler) {
            this.mHandler = serializerHandler;
            this.mXml11 = xml11;
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            for (int i = 0; i < atts.getLength(); ++i) {
                String val = atts.getValue(i);
                this.checkForInvalidXmlChars(val, this.mXml11);
            }
            this.mHandler.startElement(uri, localName, qName, atts);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.checkForInvalidXmlChars(ch, start, length, this.mXml11);
            this.mHandler.characters(ch, start, length);
        }

        public void endDocument() throws SAXException {
            this.mHandler.endDocument();
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.mHandler.endElement(uri, localName, qName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.mHandler.endPrefixMapping(prefix);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.mHandler.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.mHandler.processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
            this.mHandler.setDocumentLocator(locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.mHandler.skippedEntity(name);
        }

        public void startDocument() throws SAXException {
            this.mHandler.startDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.mHandler.startPrefixMapping(prefix, uri);
        }

        private final void checkForInvalidXmlChars(String s, boolean xml11) throws SAXParseException {
            int index = XMLUtils.checkForNonXmlCharacters(s, xml11);
            if (index >= 0) {
                throw new SAXParseException("Trying to serialize non-XML " + (xml11 ? "1.1" : "1.0") + " character: " + s.charAt(index) + ", 0x" + Integer.toHexString(s.charAt(index)), null);
            }
        }

        private final void checkForInvalidXmlChars(char[] ch, int start, int length, boolean xml11) throws SAXParseException {
            int index = XMLUtils.checkForNonXmlCharacters(ch, start, length, xml11);
            if (index >= 0) {
                throw new SAXParseException("Trying to serialize non-XML " + (xml11 ? "1.1" : "1.0") + " character: " + ch[index] + ", 0x" + Integer.toHexString(ch[index]), null);
            }
        }
    }
}

