/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Filter;
import org.jdom.IllegalAddException;
import org.jdom.Namespace;

final class AttributeFilter
implements Filter {
    private final Element parent;
    private final Namespace ns;
    private final String name;

    public boolean canAdd(Object obj) {
        if (obj instanceof Attribute) {
            return AttributeFilter.canAdd(this.parent, (Attribute)obj);
        }
        return false;
    }

    public static boolean canAdd(Element parent, Attribute attribute) {
        Iterator itr;
        if (attribute.getParent() != null) {
            throw new IllegalAddException(parent, attribute, "The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        String prefix = attribute.getNamespace().getPrefix();
        String uri = attribute.getNamespace().getURI();
        if (!prefix.equals("")) {
            if (prefix.equals(parent.getNamespacePrefix()) && !uri.equals(parent.getNamespaceURI())) {
                throw new IllegalAddException(parent, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with the element namespace prefix");
            }
            if (parent.additionalNamespaces != null && parent.additionalNamespaces.size() > 0) {
                itr = parent.additionalNamespaces.iterator();
                while (itr.hasNext()) {
                    Namespace ns = (Namespace)itr.next();
                    if (!prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                    throw new IllegalAddException(parent, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with a namespace declared " + "by the element");
                }
            }
        }
        if (parent.attributes != null && parent.attributes.size() > 0) {
            itr = parent.attributes.iterator();
            while (itr.hasNext()) {
                Attribute att = (Attribute)itr.next();
                Namespace ns = att.getNamespace();
                if (prefix.equals("") || !prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                throw new IllegalAddException(parent, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with another attribute namespace on " + "the element");
            }
        }
        attribute.setParent(parent);
        return true;
    }

    public boolean canRemove(Object obj) {
        if (obj instanceof Attribute) {
            return AttributeFilter.canRemove(this.parent, (Attribute)obj);
        }
        return true;
    }

    public static boolean canRemove(Element parent, Attribute attribute) {
        if (parent == attribute.getParent()) {
            attribute.setParent(null);
        }
        return true;
    }

    public boolean matches(Object obj) {
        if (this.name == null && this.ns == null) {
            return true;
        }
        return AttributeFilter.matches((Attribute)obj, this.name, this.ns);
    }

    public boolean matchesAll() {
        return this.name == null && this.ns == null;
    }

    public List getBackingList(boolean create) {
        return this.parent.getAttributeBackingList(create);
    }

    public static boolean matches(Attribute attribute, String name, Namespace ns) {
        return attribute.getName().equals(name) && attribute.getNamespace().equals(ns);
    }

    AttributeFilter(Element parent) {
        this.parent = parent;
        this.name = null;
        this.ns = null;
    }

    AttributeFilter(Element parent, String name, Namespace ns) {
        this.parent = parent;
        this.name = name;
        this.ns = ns;
    }
}

