/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Text;
import org.jdom.Verifier;

public class CDATA
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: CDATA.java,v $ $Revision: 1.17 $ $Date: 2002/01/08 09:17:10 $ $Name:  $";
    protected StringBuffer value;
    protected Element parent;

    public String getText() {
        return this.value.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public CDATA setText(String str) {
        this.value = new StringBuffer();
        if (str == null) {
            return this;
        }
        this.append(str);
        return this;
    }

    public void append(String str) {
        if (str == null) {
            return;
        }
        String reason = Verifier.checkCDATASection(str);
        if (reason != null) {
            throw new IllegalDataException(str, "CDATA section", reason);
        }
        this.value.append(str);
    }

    public void append(CDATA cdata) {
        if (cdata == null) {
            return;
        }
        this.value.append(cdata.getText());
    }

    public Element getParent() {
        return this.parent;
    }

    public Document getDocument() {
        if (this.parent != null) {
            return this.parent.getDocument();
        }
        return null;
    }

    protected CDATA setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public CDATA detach() {
        if (this.parent != null) {
            this.parent.removeContent(this);
        }
        this.parent = null;
        return this;
    }

    public String toString() {
        return new StringBuffer(64).append("[CDATA: ").append(this.getText()).append("]").toString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        CDATA cdata = null;
        try {
            cdata = (CDATA)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        cdata.parent = null;
        cdata.value = new StringBuffer(this.value.toString());
        return cdata;
    }

    public final boolean equals(Object ob) {
        return this == ob;
    }

    protected CDATA() {
    }

    public CDATA(String str) {
        this.setText(str);
    }
}

