/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.DocumentContentFilter;
import org.jdom.Element;
import org.jdom.FilterList;
import org.jdom.IllegalAddException;
import org.jdom.ProcessingInstruction;

public class Document
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Document.java,v $ $Revision: 1.49 $ $Date: 2002/01/08 09:17:10 $ $Name:  $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected List content = new ArrayList(5);
    protected DocType docType;

    public Element getRootElement() {
        Iterator itr = this.content.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof Element)) continue;
            return (Element)obj;
        }
        return null;
    }

    public Document setRootElement(Element rootElement) {
        if (rootElement == null) {
            return this;
        }
        if (rootElement.isRootElement()) {
            throw new IllegalAddException(this, rootElement, "The element already has an existing parent (the document root)");
        }
        if (rootElement.getParent() != null) {
            throw new IllegalAddException(this, rootElement, "The element already has an existing parent \"" + rootElement.getParent().getQualifiedName() + "\"");
        }
        boolean hadRoot = false;
        ListIterator<Element> itr = this.content.listIterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof Element)) continue;
            Element departingRoot = (Element)obj;
            departingRoot.setDocument(null);
            itr.set(rootElement);
            hadRoot = true;
        }
        if (!hadRoot) {
            itr.add(rootElement);
        }
        rootElement.setDocument(this);
        return this;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public Document setDocType(DocType docType) {
        if (docType != null && docType.getDocument() != null) {
            throw new IllegalAddException(this, docType, "The docType already is attached to a document");
        }
        if (docType != null) {
            docType.setDocument(this);
        }
        if (this.docType != null) {
            this.docType.setDocument(null);
        }
        this.docType = docType;
        return this;
    }

    public Document addContent(ProcessingInstruction pi) {
        if (pi.getParent() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent \"" + pi.getParent().getQualifiedName() + "\"");
        }
        if (pi.getDocument() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent (the document root)");
        }
        this.content.add(pi);
        pi.setDocument(this);
        return this;
    }

    public Document addContent(Comment comment) {
        if (comment.getParent() != null) {
            throw new IllegalAddException(this, comment, "The comment already has an existing parent \"" + comment.getParent().getQualifiedName() + "\"");
        }
        if (comment.getDocument() != null) {
            throw new IllegalAddException(this, comment, "The element already has an existing parent (the document root)");
        }
        this.content.add(comment);
        comment.setDocument(this);
        return this;
    }

    public List getContent() {
        return new FilterList(new DocumentContentFilter(this));
    }

    List getContentBackingList() {
        return this.content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document setContent(List newContent) {
        Iterator itr;
        Object obj;
        List oldContent;
        block33: {
            Iterator itr22;
            int itemsAdded;
            RuntimeException ex;
            block36: {
                block34: {
                    Iterator itr22;
                    block35: {
                        if (newContent == null) {
                            return this;
                        }
                        Element oldRoot = this.getRootElement();
                        oldContent = this.content;
                        this.content = new ArrayList(5);
                        ex = null;
                        boolean didRoot = false;
                        itemsAdded = 0;
                        try {
                            Object var8_14;
                            try {
                                Iterator i = newContent.iterator();
                                while (true) {
                                    if (!i.hasNext()) {
                                        if (didRoot) break;
                                        throw new IllegalAddException("A Document must contain a root element");
                                    }
                                    obj = i.next();
                                    if (obj instanceof Element) {
                                        if (didRoot) throw new IllegalAddException("A Document may contain only one root element");
                                        this.setRootElement((Element)obj);
                                        if (oldRoot != null) {
                                            oldRoot.setDocument(null);
                                        }
                                        didRoot = true;
                                    } else if (obj instanceof Comment) {
                                        this.addContent((Comment)obj);
                                    } else if (obj instanceof ProcessingInstruction) {
                                        this.addContent((ProcessingInstruction)obj);
                                    } else {
                                        String string;
                                        StringBuffer stringBuffer = new StringBuffer().append("A Document may directly contain only objects of type Element, Comment, and ProcessingInstruction: ");
                                        if (obj == null) {
                                            string = "null";
                                            throw new IllegalAddException(stringBuffer.append(string).append(" is not allowed").toString());
                                        }
                                        string = obj.getClass().getName();
                                        throw new IllegalAddException(stringBuffer.append(string).append(" is not allowed").toString());
                                    }
                                    ++itemsAdded;
                                }
                                var8_14 = null;
                                if (ex == null) break block33;
                                this.content = oldContent;
                                if (oldRoot == null) break block34;
                            }
                            catch (RuntimeException e) {
                                ex = e;
                                var8_14 = null;
                                if (ex == null) break block33;
                                this.content = oldContent;
                                if (oldRoot != null) {
                                    oldRoot.setDocument(this);
                                }
                                itr22 = newContent.iterator();
                                break block35;
                            }
                            oldRoot.setDocument(this);
                        }
                        catch (Throwable throwable) {
                            Object var8_15 = null;
                            if (ex == null) throw throwable;
                            this.content = oldContent;
                            if (oldRoot != null) {
                                oldRoot.setDocument(this);
                            }
                            itr22 = newContent.iterator();
                            break block36;
                        }
                    }
                    while (true) {
                        if (itemsAdded-- <= 0) {
                            throw ex;
                        }
                        Object obj2 = itr22.next();
                        if (obj2 instanceof Element) {
                            ((Element)obj2).setDocument(null);
                            continue;
                        }
                        if (obj2 instanceof Comment) {
                            ((Comment)obj2).setDocument(null);
                            continue;
                        }
                        if (!(obj2 instanceof ProcessingInstruction)) continue;
                        ((ProcessingInstruction)obj2).setDocument(null);
                    }
                }
                itr = newContent.iterator();
                while (true) {
                    if (itemsAdded-- <= 0) {
                        throw ex;
                    }
                    obj = itr.next();
                    if (obj instanceof Element) {
                        ((Element)obj).setDocument(null);
                        continue;
                    }
                    if (obj instanceof Comment) {
                        ((Comment)obj).setDocument(null);
                        continue;
                    }
                    if (!(obj instanceof ProcessingInstruction)) continue;
                    ((ProcessingInstruction)obj).setDocument(null);
                }
            }
            while (true) {
                if (itemsAdded-- <= 0) {
                    throw ex;
                }
                Object obj2 = itr22.next();
                if (obj2 instanceof Element) {
                    ((Element)obj2).setDocument(null);
                    continue;
                }
                if (obj2 instanceof Comment) {
                    ((Comment)obj2).setDocument(null);
                    continue;
                }
                if (!(obj2 instanceof ProcessingInstruction)) continue;
                ((ProcessingInstruction)obj2).setDocument(null);
            }
        }
        itr = oldContent.iterator();
        while (itr.hasNext()) {
            obj = itr.next();
            if (obj instanceof Element) {
                ((Element)obj).setDocument(null);
                continue;
            }
            if (obj instanceof Comment) {
                ((Comment)obj).setDocument(null);
                continue;
            }
            if (!(obj instanceof ProcessingInstruction)) continue;
            ((ProcessingInstruction)obj).setDocument(null);
        }
        return this;
    }

    public String toString() {
        StringBuffer stringForm = new StringBuffer().append("[Document: ");
        if (this.docType != null) {
            stringForm.append(this.docType.toString()).append(", ");
        } else {
            stringForm.append(" No DOCTYPE declaration, ");
        }
        Element rootElement = this.getRootElement();
        if (rootElement != null) {
            stringForm.append("Root is ").append(rootElement.toString());
        } else {
            stringForm.append(" No root element");
        }
        stringForm.append("]");
        return stringForm.toString();
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Document doc = null;
        try {
            doc = (Document)super.clone();
        }
        catch (CloneNotSupportedException ce) {
            // empty catch block
        }
        doc.content = new ArrayList(5);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Element) {
                doc.setRootElement((Element)((Element)obj).clone());
                continue;
            }
            if (obj instanceof Comment) {
                doc.addContent((Comment)((Comment)obj).clone());
                continue;
            }
            if (!(obj instanceof ProcessingInstruction)) continue;
            doc.addContent((ProcessingInstruction)((ProcessingInstruction)obj).clone());
        }
        if (this.docType != null) {
            doc.docType = (DocType)this.docType.clone();
        }
        return doc;
    }

    public boolean removeContent(ProcessingInstruction pi) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(pi)) {
            pi.setDocument(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(Comment comment) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(comment)) {
            comment.setDocument(null);
            return true;
        }
        return false;
    }

    protected Document() {
    }

    public Document(Element rootElement, DocType docType) {
        this.setRootElement(rootElement);
        this.setDocType(docType);
    }

    public Document(Element rootElement) {
        this(rootElement, null);
    }

    public Document(List content, DocType docType) {
        this.setContent(content);
        this.setDocType(docType);
    }

    public Document(List content) {
        this(content, null);
    }
}

