/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.AttributeFilter;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.ElementContentFilter;
import org.jdom.ElementFilter;
import org.jdom.EntityRef;
import org.jdom.FilterList;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;

public class Element
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Element.java,v $ $Revision: 1.105 $ $Date: 2002/01/08 09:17:10 $ $Name:  $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected String name;
    protected transient Namespace namespace;
    protected transient List additionalNamespaces;
    protected Object parent;
    protected List attributes;
    protected List content;

    public String getName() {
        return this.name;
    }

    public Element setName(String name) {
        String reason = Verifier.checkElementName(name);
        if (reason != null) {
            throw new IllegalNameException(name, "element", reason);
        }
        this.name = name;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace(String prefix) {
        if (prefix == null) {
            return null;
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        List addl = this.getAdditionalNamespaces();
        if (addl.size() > 0) {
            Iterator itr = addl.iterator();
            while (itr.hasNext()) {
                Namespace ns = (Namespace)itr.next();
                if (!prefix.equals(ns.getPrefix())) continue;
                return ns;
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(prefix);
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ":" + this.name;
    }

    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        Namespace ns;
        Iterator itr;
        String prefix = additionalNamespace.getPrefix();
        String uri = additionalNamespace.getURI();
        if (prefix.equals(this.getNamespacePrefix()) && !uri.equals(this.getNamespaceURI())) {
            throw new IllegalAddException(this, additionalNamespace, "The namespace prefix \"" + prefix + "\" collides " + "with the element namespace prefix");
        }
        if (this.additionalNamespaces != null && this.additionalNamespaces.size() > 0) {
            itr = this.additionalNamespaces.iterator();
            while (itr.hasNext()) {
                ns = (Namespace)itr.next();
                if (!prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                throw new IllegalAddException(this, additionalNamespace, "The namespace prefix \"" + prefix + "\" collides with an additional namespace declared " + "by the element");
            }
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            itr = this.attributes.iterator();
            while (itr.hasNext()) {
                ns = ((Attribute)itr.next()).getNamespace();
                if (ns == Namespace.NO_NAMESPACE || !prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                throw new IllegalAddException(this, additionalNamespace, "The namespace prefix \"" + prefix + "\" collides with an attribute namespace on " + "the element");
            }
        }
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList(5);
        }
        this.additionalNamespaces.add(additionalNamespace);
    }

    public void removeNamespaceDeclaration(Namespace additionalNamespace) {
        if (this.additionalNamespaces == null) {
            return;
        }
        this.additionalNamespaces.remove(additionalNamespace);
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    public Element getParent() {
        if (this.parent instanceof Element) {
            return (Element)this.parent;
        }
        return null;
    }

    protected Element setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public Element detach() {
        if (this.parent instanceof Element) {
            ((Element)this.parent).removeContent(this);
        } else if (this.parent instanceof Document) {
            ((Document)this.parent).setRootElement(new Element("root-element-was-detached"));
        }
        return this;
    }

    public boolean isRootElement() {
        return this.parent instanceof Document;
    }

    protected Element setDocument(Document document) {
        this.parent = document;
        return this;
    }

    public Document getDocument() {
        if (this.parent instanceof Document) {
            return (Document)this.parent;
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    public String getText() {
        if (this.content == null || this.content.size() < 1 || this.content.get(0) == null) {
            return "";
        }
        if (this.content.size() == 1) {
            Object obj = this.content.get(0);
            if (obj instanceof Text) {
                return ((Text)obj).getText();
            }
            if (obj instanceof CDATA) {
                return ((CDATA)obj).getText();
            }
            return "";
        }
        StringBuffer textContent = new StringBuffer();
        boolean hasText = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Text) {
                textContent.append(((Text)obj).getText());
                hasText = true;
                continue;
            }
            if (!(obj instanceof CDATA)) continue;
            textContent.append(((CDATA)obj).getText());
            hasText = true;
        }
        if (!hasText) {
            return "";
        }
        return textContent.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getChildText(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildTextTrim(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public String getChildTextNormalize(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getTextNormalize();
    }

    public String getChildText(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildTextTrim(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public String getChildTextNormalize(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getTextNormalize();
    }

    public Element setText(String text) {
        if (this.content != null) {
            this.content.clear();
        } else {
            this.createContentList();
        }
        if (text != null) {
            this.content.add(new Text(text));
        }
        return this;
    }

    public List getContent() {
        return new FilterList(new ElementContentFilter(this));
    }

    private List createContentList() {
        this.content = new ArrayList(5);
        return this.content;
    }

    List getContentBackingList(boolean create) {
        if (this.content == null && create) {
            this.createContentList();
        }
        return this.content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element setContent(List newContent) {
        Object obj;
        List oldContent;
        block50: {
            Iterator i2;
            Iterator i2;
            int itemsAdded;
            RuntimeException ex;
            block51: {
                Iterator i3;
                if (newContent == null) {
                    newContent = new ArrayList(0);
                }
                oldContent = this.content;
                this.createContentList();
                ex = null;
                itemsAdded = 0;
                try {
                    Object var6_12;
                    try {
                        i3 = newContent.iterator();
                        while (i3.hasNext()) {
                            obj = i3.next();
                            if (obj instanceof Element) {
                                this.addContent((Element)obj);
                            } else if (obj instanceof String) {
                                this.addContent(new Text((String)obj));
                            } else if (obj instanceof Text) {
                                this.addContent((Text)obj);
                            } else if (obj instanceof Comment) {
                                this.addContent((Comment)obj);
                            } else if (obj instanceof ProcessingInstruction) {
                                this.addContent((ProcessingInstruction)obj);
                            } else if (obj instanceof CDATA) {
                                this.addContent((CDATA)obj);
                            } else if (obj instanceof EntityRef) {
                                this.addContent((EntityRef)obj);
                            } else {
                                String string;
                                StringBuffer stringBuffer = new StringBuffer().append("An Element may directly contain only objects of type String, Text, Element, Comment, CDATA, EntityRef, and ProcessingInstruction: ");
                                if (obj == null) {
                                    string = "null";
                                    throw new IllegalAddException(stringBuffer.append(string).append(" is not allowed").toString());
                                }
                                string = obj.getClass().getName();
                                throw new IllegalAddException(stringBuffer.append(string).append(" is not allowed").toString());
                            }
                            ++itemsAdded;
                        }
                    }
                    catch (RuntimeException e) {
                        ex = e;
                        var6_12 = null;
                        if (ex == null) break block50;
                        this.content = oldContent;
                        i2 = newContent.iterator();
                        break block51;
                    }
                    var6_12 = null;
                    if (ex == null) break block50;
                    this.content = oldContent;
                    i3 = newContent.iterator();
                }
                catch (Throwable throwable) {
                    Object var6_13 = null;
                    if (ex == null) throw throwable;
                    this.content = oldContent;
                    i2 = newContent.iterator();
                }
                while (true) {
                    if (itemsAdded-- <= 0) {
                        throw ex;
                    }
                    obj = i3.next();
                    if (obj instanceof Element) {
                        ((Element)obj).setParent(null);
                        continue;
                    }
                    if (obj instanceof Text) {
                        ((Text)obj).setParent(null);
                        continue;
                    }
                    if (obj instanceof Comment) {
                        ((Comment)obj).setParent(null);
                        continue;
                    }
                    if (obj instanceof CDATA) {
                        ((CDATA)obj).setParent(null);
                        continue;
                    }
                    if (obj instanceof ProcessingInstruction) {
                        ((ProcessingInstruction)obj).setParent(null);
                        continue;
                    }
                    if (!(obj instanceof EntityRef)) continue;
                    ((EntityRef)obj).setParent(null);
                }
            }
            while (true) {
                if (itemsAdded-- <= 0) {
                    throw ex;
                }
                Object obj2 = i2.next();
                if (obj2 instanceof Element) {
                    ((Element)obj2).setParent(null);
                    continue;
                }
                if (obj2 instanceof Text) {
                    ((Text)obj2).setParent(null);
                    continue;
                }
                if (obj2 instanceof Comment) {
                    ((Comment)obj2).setParent(null);
                    continue;
                }
                if (obj2 instanceof CDATA) {
                    ((CDATA)obj2).setParent(null);
                    continue;
                }
                if (obj2 instanceof ProcessingInstruction) {
                    ((ProcessingInstruction)obj2).setParent(null);
                    continue;
                }
                if (!(obj2 instanceof EntityRef)) continue;
                ((EntityRef)obj2).setParent(null);
            }
            while (true) {
                if (itemsAdded-- <= 0) {
                    throw ex;
                }
                Object obj2 = i2.next();
                if (obj2 instanceof Element) {
                    ((Element)obj2).setParent(null);
                    continue;
                }
                if (obj2 instanceof Text) {
                    ((Text)obj2).setParent(null);
                    continue;
                }
                if (obj2 instanceof Comment) {
                    ((Comment)obj2).setParent(null);
                    continue;
                }
                if (obj2 instanceof CDATA) {
                    ((CDATA)obj2).setParent(null);
                    continue;
                }
                if (obj2 instanceof ProcessingInstruction) {
                    ((ProcessingInstruction)obj2).setParent(null);
                    continue;
                }
                if (!(obj2 instanceof EntityRef)) continue;
                ((EntityRef)obj2).setParent(null);
            }
        }
        if (oldContent == null) {
            return this;
        }
        Iterator itr = oldContent.iterator();
        while (itr.hasNext()) {
            obj = itr.next();
            if (obj instanceof Element) {
                ((Element)obj).setParent(null);
                continue;
            }
            if (obj instanceof Text) {
                ((Text)obj).setParent(null);
                continue;
            }
            if (obj instanceof Comment) {
                ((Comment)obj).setParent(null);
                continue;
            }
            if (obj instanceof CDATA) {
                ((CDATA)obj).setParent(null);
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                ((ProcessingInstruction)obj).setParent(null);
                continue;
            }
            if (!(obj instanceof EntityRef)) continue;
            ((EntityRef)obj).setParent(null);
        }
        return this;
    }

    public boolean hasChildren() {
        if (this.content == null || this.content.size() == 0) {
            return false;
        }
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public List getChildren() {
        return new FilterList(new ElementFilter(this));
    }

    public Element setChildren(List children) {
        return this.setContent(children);
    }

    public List getChildren(String name) {
        return this.getChildren(name, Namespace.NO_NAMESPACE);
    }

    public List getChildren(String name, Namespace ns) {
        return new FilterList(new ElementFilter(this, name, ns));
    }

    public Element getChild(String name, Namespace ns) {
        if (this.content == null) {
            return null;
        }
        String uri = ns.getURI();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public Element getChild(String name) {
        return this.getChild(name, Namespace.NO_NAMESPACE);
    }

    public Element addContent(String str) {
        Object ob;
        int size;
        if (this.content == null) {
            this.createContentList();
        }
        if ((size = this.content.size()) > 0 && (ob = this.content.get(size - 1)) instanceof Text) {
            Text txt = (Text)ob;
            txt.append(str);
            return this;
        }
        Text txt = new Text(str);
        txt.setParent(this);
        this.content.add(txt);
        return this;
    }

    public Element addContent(Text text) {
        Object ob;
        int size;
        if (this.content == null) {
            this.createContentList();
        }
        if ((size = this.content.size()) > 0 && (ob = this.content.get(size - 1)) instanceof Text) {
            Text txt = (Text)ob;
            txt.append(text);
            return this;
        }
        this.content.add(text);
        text.setParent(this);
        return this;
    }

    public Element addContent(Element element) {
        if (element.isRootElement()) {
            throw new IllegalAddException(this, element, "The element already has an existing parent (the document root)");
        }
        if (element.getParent() != null) {
            throw new IllegalAddException(this, element, "The element already has an existing parent \"" + element.getParent().getQualifiedName() + "\"");
        }
        if (element == this) {
            throw new IllegalAddException(this, element, "The element cannot be added to itself");
        }
        if (this.isAncestor(element)) {
            throw new IllegalAddException(this, element, "The element cannot be added as a descendent of itself");
        }
        if (this.content == null) {
            this.createContentList();
        }
        element.setParent(this);
        this.content.add(element);
        return this;
    }

    boolean isAncestor(Element e) {
        Object p = this.parent;
        while (p instanceof Element) {
            if (p == e) {
                return true;
            }
            p = ((Element)p).getParent();
        }
        return false;
    }

    public Element addContent(ProcessingInstruction pi) {
        if (pi.getParent() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent \"" + pi.getParent().getQualifiedName() + "\"");
        }
        if (pi.getDocument() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent (the document root)");
        }
        if (this.content == null) {
            this.createContentList();
        }
        this.content.add(pi);
        pi.setParent(this);
        return this;
    }

    public Element addContent(EntityRef entity) {
        if (entity.getParent() != null) {
            throw new IllegalAddException(this, entity, "The entity reference already has an existing parent \"" + entity.getParent().getQualifiedName() + "\"");
        }
        if (this.content == null) {
            this.createContentList();
        }
        this.content.add(entity);
        entity.setParent(this);
        return this;
    }

    public Element addContent(CDATA cdata) {
        if (this.content == null) {
            this.createContentList();
        }
        this.content.add(cdata);
        cdata.setParent(this);
        return this;
    }

    public Element addContent(Comment comment) {
        if (comment.getParent() != null) {
            throw new IllegalAddException(this, comment, "The comment already has an existing parent \"" + comment.getParent().getQualifiedName() + "\"");
        }
        if (comment.getDocument() != null) {
            throw new IllegalAddException(this, comment, "The comment already has an existing parent (the document root)");
        }
        if (this.content == null) {
            this.createContentList();
        }
        this.content.add(comment);
        comment.setParent(this);
        return this;
    }

    public boolean removeChild(String name) {
        return this.removeChild(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String name, Namespace ns) {
        if (this.content == null) {
            return false;
        }
        String uri = ns.getURI();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            element.setParent(null);
            i.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String name) {
        return this.removeChildren(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String name, Namespace ns) {
        if (this.content == null) {
            return false;
        }
        String uri = ns.getURI();
        boolean deletedSome = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            element.setParent(null);
            i.remove();
            deletedSome = true;
        }
        return deletedSome;
    }

    public boolean removeChildren() {
        boolean deletedSome = false;
        if (this.content != null) {
            Iterator i = this.content.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof Element)) continue;
                Element element = (Element)obj;
                i.remove();
                element.setParent(null);
                deletedSome = true;
            }
        }
        return deletedSome;
    }

    public List getAttributes() {
        return new FilterList(new AttributeFilter(this));
    }

    private List createAttributeList() {
        this.attributes = new ArrayList(5);
        return this.attributes;
    }

    List getAttributeBackingList(boolean create) {
        if (this.attributes == null && create) {
            this.createAttributeList();
        }
        return this.attributes;
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute(name, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String name, Namespace ns) {
        if (this.attributes == null) {
            return null;
        }
        String uri = ns.getURI();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (!att.getNamespaceURI().equals(uri) || !att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String name, Namespace ns) {
        Attribute attrib = this.getAttribute(name, ns);
        if (attrib == null) {
            return null;
        }
        return attrib.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element setAttributes(List attributes) {
        Iterator iter;
        List oldList;
        block14: {
            Throwable throwable2;
            block16: {
                Iterator i22;
                Iterator i22;
                RuntimeException exception;
                int itemsAdded;
                block15: {
                    Iterator i22;
                    Object obj;
                    oldList = this.attributes;
                    this.attributes = null;
                    itemsAdded = 0;
                    exception = null;
                    try {
                        Object var6_12;
                        try {
                            iter = attributes.iterator();
                            while (iter.hasNext()) {
                                obj = iter.next();
                                if (!(obj instanceof Attribute)) {
                                    throw new IllegalAddException("Non-Attribute in list");
                                }
                                this.setAttribute((Attribute)obj);
                                ++itemsAdded;
                            }
                        }
                        catch (RuntimeException re) {
                            exception = re;
                            var6_12 = null;
                            if (exception == null) break block14;
                            this.attributes = oldList;
                            i22 = attributes.iterator();
                            break block15;
                        }
                        var6_12 = null;
                        if (exception == null) break block14;
                        this.attributes = oldList;
                        i22 = attributes.iterator();
                    }
                    catch (Throwable throwable2) {
                        Object var6_13 = null;
                        if (exception == null) break block16;
                        this.attributes = oldList;
                        i22 = attributes.iterator();
                    }
                    while (true) {
                        if (itemsAdded-- <= 0) {
                            throw exception;
                        }
                        obj = i22.next();
                        if (!(obj instanceof Attribute)) continue;
                        ((Attribute)obj).setParent(null);
                    }
                }
                while (true) {
                    if (itemsAdded-- <= 0) {
                        throw exception;
                    }
                    Object obj = i22.next();
                    if (!(obj instanceof Attribute)) continue;
                    ((Attribute)obj).setParent(null);
                }
                while (true) {
                    if (itemsAdded-- <= 0) {
                        throw exception;
                    }
                    Object obj = i22.next();
                    if (!(obj instanceof Attribute)) continue;
                    ((Attribute)obj).setParent(null);
                }
            }
            throw throwable2;
        }
        if (oldList != null && oldList.size() > 0) {
            iter = oldList.iterator();
            while (iter.hasNext()) {
                ((Attribute)iter.next()).setParent(null);
            }
        }
        return this;
    }

    public Element setAttribute(String name, String value) {
        return this.setAttribute(new Attribute(name, value));
    }

    public Element setAttribute(String name, String value, Namespace ns) {
        return this.setAttribute(new Attribute(name, value, ns));
    }

    public Element setAttribute(Attribute attribute) {
        Iterator itr;
        if (attribute.getParent() != null) {
            throw new IllegalAddException(this, attribute, "The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        boolean preExisting = false;
        String prefix = attribute.getNamespace().getPrefix();
        String uri = attribute.getNamespace().getURI();
        if (!prefix.equals("")) {
            if (prefix.equals(this.getNamespacePrefix()) && !uri.equals(this.getNamespaceURI())) {
                throw new IllegalAddException(this, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with the element namespace prefix");
            }
            if (this.additionalNamespaces != null && this.additionalNamespaces.size() > 0) {
                itr = this.additionalNamespaces.iterator();
                while (itr.hasNext()) {
                    Namespace ns = (Namespace)itr.next();
                    if (!prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                    throw new IllegalAddException(this, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with a namespace declared by the element");
                }
            }
        }
        if (this.attributes != null && this.attributes.size() > 0) {
            itr = this.attributes.iterator();
            while (itr.hasNext()) {
                Attribute att = (Attribute)itr.next();
                Namespace ns = att.getNamespace();
                if (attribute.getName().equals(att.getName()) && ns.getURI().equals(att.getNamespaceURI())) {
                    preExisting = true;
                }
                if (prefix.equals("") || !prefix.equals(ns.getPrefix()) || uri.equals(ns.getURI())) continue;
                throw new IllegalAddException(this, attribute, "The attribute namespace prefix \"" + prefix + "\" collides with another attribute namespace on " + "the element");
            }
        }
        if (this.attributes == null) {
            this.createAttributeList();
        } else if (preExisting) {
            this.removeAttribute(attribute.getName(), attribute.getNamespace());
        }
        this.attributes.add(attribute);
        attribute.setParent(this);
        return this;
    }

    public boolean removeAttribute(String name) {
        return this.removeAttribute(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String name, Namespace ns) {
        if (this.attributes == null) {
            return false;
        }
        String uri = ns.getURI();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (!att.getNamespaceURI().equals(uri) || !att.getName().equals(name)) continue;
            i.remove();
            att.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeAttribute(Attribute attribute) {
        if (this.attributes == null || attribute == null || attribute.getParent() != this) {
            return false;
        }
        return this.attributes.remove(attribute);
    }

    public String toString() {
        StringBuffer stringForm = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String nsuri = this.getNamespaceURI();
        if (!nsuri.equals("")) {
            stringForm.append(" [Namespace: ").append(nsuri).append("]");
        }
        stringForm.append("/>]");
        return stringForm.toString();
    }

    public final boolean equals(Object ob) {
        return this == ob;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Iterator i;
        Element element = null;
        try {
            element = (Element)super.clone();
        }
        catch (CloneNotSupportedException ce) {
            // empty catch block
        }
        element.parent = null;
        element.content = this.content == null ? null : new ArrayList(5);
        List list = element.attributes = this.attributes == null ? null : new ArrayList(5);
        if (this.attributes != null) {
            i = this.attributes.iterator();
            while (i.hasNext()) {
                Attribute a = (Attribute)((Attribute)i.next()).clone();
                a.setParent(element);
                element.attributes.add(a);
            }
        }
        if (this.content != null) {
            i = this.content.iterator();
            while (i.hasNext()) {
                Cloneable e;
                Object obj = i.next();
                if (obj instanceof Element) {
                    e = (Element)((Element)obj).clone();
                    ((Element)e).setParent(element);
                    element.content.add(e);
                    continue;
                }
                if (obj instanceof Text) {
                    Text t = (Text)((Text)obj).clone();
                    t.setParent(element);
                    element.content.add(t);
                    continue;
                }
                if (obj instanceof Comment) {
                    Comment c = (Comment)((Comment)obj).clone();
                    c.setParent(element);
                    element.content.add(c);
                    continue;
                }
                if (obj instanceof CDATA) {
                    CDATA d = (CDATA)((CDATA)obj).clone();
                    d.setParent(element);
                    element.content.add(d);
                    continue;
                }
                if (obj instanceof ProcessingInstruction) {
                    ProcessingInstruction p = (ProcessingInstruction)((ProcessingInstruction)obj).clone();
                    element.content.add(p);
                    continue;
                }
                if (!(obj instanceof EntityRef)) continue;
                e = (EntityRef)((EntityRef)obj).clone();
                ((EntityRef)e).setParent(element);
                element.content.add(e);
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList();
            element.additionalNamespaces.addAll(this.additionalNamespaces);
        }
        return element;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.namespace.getPrefix());
        out.writeObject(this.namespace.getURI());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)in.readObject(), (String)in.readObject());
    }

    public boolean removeContent(Element element) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(element)) {
            element.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(ProcessingInstruction pi) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(pi)) {
            pi.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(Comment comment) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(comment)) {
            comment.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(CDATA cdata) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(cdata)) {
            cdata.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(Text text) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(text)) {
            text.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(EntityRef entity) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(entity)) {
            entity.setParent(null);
            return true;
        }
        return false;
    }

    protected Element() {
    }

    public Element(String name, Namespace namespace) {
        this.setName(name);
        this.setNamespace(namespace);
    }

    public Element(String name) {
        this(name, (Namespace)null);
    }

    public Element(String name, String uri) {
        this(name, Namespace.getNamespace("", uri));
    }

    public Element(String name, String prefix, String uri) {
        this(name, Namespace.getNamespace(prefix, uri));
    }
}

