/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jdom.Filter;

public class FilterList
implements List,
Serializable {
    protected Filter filter;

    private List getBackingList(boolean create) {
        return this.filter.getBackingList(create);
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    Filter getFilter() {
        return this.filter;
    }

    public int size() {
        List list = this.getBackingList(false);
        if (list == null) {
            return 0;
        }
        if (this.filter.matchesAll()) {
            return list.size();
        }
        int size = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!this.filter.matches(iter.next())) continue;
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object obj) {
        List list = this.getBackingList(false);
        if (list == null || obj == null) {
            return false;
        }
        if (!this.filter.matches(obj)) {
            return false;
        }
        return list.contains(obj);
    }

    public boolean containsAll(Collection c) {
        List list = this.getBackingList(false);
        if (list == null) {
            return c.size() == 0;
        }
        if (this.filter.matchesAll()) {
            return list.containsAll(c);
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj != null && this.filter.matches(obj) && list.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public Object[] toArray() {
        List list = this.getBackingList(false);
        if (list == null) {
            return new Object[0];
        }
        if (this.filter.matchesAll()) {
            return list.toArray();
        }
        Object[] ret = new Object[this.size()];
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ret[i++] = iter.next();
        }
        return ret;
    }

    public Object[] toArray(Object[] a) {
        List list = this.getBackingList(false);
        if (a == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (list == null) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        if (this.filter.matchesAll()) {
            return list.toArray(a);
        }
        int s = this.size();
        if (a.length < s) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), s);
        }
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            a[i++] = iter.next();
        }
        if (a.length > s) {
            a[s] = null;
        }
        return a;
    }

    public boolean add(Object obj) {
        this.checkAdd(obj);
        List list = this.getBackingList(true);
        return list.add(obj);
    }

    private void checkAdd(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null items not allowed in list");
        }
        if (!this.filter.canAdd(obj)) {
            throw new IllegalArgumentException("The Filter assigned to this list will not allow the supplied object (" + obj.getClass().getName() + ") to be " + "added to the list.");
        }
    }

    private void checkRemove(Object obj) {
        if (!this.filter.canRemove(obj)) {
            throw new IllegalArgumentException("The Filter assigned to this list will not allow the supplied object (" + obj.getClass().getName() + ") to be " + "removed from the list.");
        }
    }

    private boolean checkAdd(Collection c) {
        if (c.size() == 0) {
            return false;
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.checkAdd(iter.next());
        }
        return true;
    }

    public boolean addAll(Collection c) {
        this.checkAdd(c);
        List list = this.getBackingList(true);
        return list.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        this.checkAdd(c);
        List list = this.getBackingList(true);
        if (this.filter.matchesAll() || index == 0) {
            return list.addAll(index, c);
        }
        int cnt = 0;
        int cnt2 = 0;
        Object ret = null;
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            ++cnt2;
            if (!this.filter.matches(obj) || ++cnt != index) continue;
            ret = obj;
            break;
        }
        if (ret == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return list.addAll(cnt2, c);
    }

    public boolean remove(Object obj) {
        if (obj == null) {
            return false;
        }
        this.checkRemove(obj);
        List list = this.getBackingList(true);
        return list.remove(obj);
    }

    public boolean removeAll(Collection c) {
        Object obj = null;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            obj = iter.next();
            this.checkRemove(obj);
        }
        List list = this.getBackingList(true);
        return list.removeAll(c);
    }

    public Object remove(int index) {
        List list = this.getBackingList(true);
        if (this.filter.matchesAll()) {
            Object ret = list.get(index);
            this.checkRemove(ret);
            list.remove(index);
            return ret;
        }
        Object ret = null;
        Iterator iter = list.iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!this.filter.matches(obj)) continue;
            if (cnt == index) {
                this.checkRemove(obj);
                iter.remove();
                ret = obj;
                break;
            }
            ++cnt;
        }
        if (ret == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return ret;
    }

    public boolean retainAll(Collection c) {
        boolean removed = false;
        List list = this.getBackingList(true);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!this.filter.matches(obj) || c.contains(obj)) continue;
            this.checkRemove(obj);
            iter.remove();
            removed = true;
        }
        return removed;
    }

    public void clear() {
        List list = this.getBackingList(false);
        if (list == null) {
            return;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!this.filter.matches(obj)) continue;
            this.checkRemove(obj);
            iter.remove();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        List list = this.getBackingList(false);
        if (list == null) {
            return other.size() == 0;
        }
        Iterator iter = this.iterator();
        Iterator iter2 = other.iterator();
        while (iter.hasNext()) {
            if (!iter2.hasNext()) {
                return false;
            }
            Object child = iter.next();
            Object child2 = iter2.next();
            if (!(child == null && child2 != null || child != null && child2 == null) && child.equals(child2)) continue;
            return false;
        }
        return !iter2.hasNext();
    }

    public int hashCode() {
        List list = this.getBackingList(false);
        if (list == null) {
            return 1;
        }
        int hashCode = 1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public Object get(int index) {
        List list = this.getBackingList(false);
        if (list == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        if (this.filter.matchesAll()) {
            return list.get(index);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " is negative");
        }
        int cnt = 0;
        Object ret = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!this.filter.matches(obj)) continue;
            if (cnt == index) {
                ret = obj;
                break;
            }
            ++cnt;
        }
        if (ret == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return ret;
    }

    public Object set(int index, Object newobj) {
        List list = this.getBackingList(true);
        if (this.filter.matchesAll()) {
            Object ret = list.get(index);
            if (ret != newobj) {
                this.checkAdd(newobj);
                this.checkRemove(ret);
                list.set(index, newobj);
            }
            return ret;
        }
        int cnt = 0;
        Object ret = null;
        ListIterator<Object> iter = list.listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!this.filter.matches(obj)) continue;
            if (cnt == index) {
                if (obj != newobj) {
                    this.checkAdd(newobj);
                    this.checkRemove(obj);
                    iter.set(newobj);
                }
                ret = obj;
                break;
            }
            ++cnt;
        }
        if (ret == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return ret;
    }

    public void add(int index, Object newobj) {
        this.checkAdd(newobj);
        List list = this.getBackingList(true);
        if (this.filter.matchesAll() || index == 0) {
            list.add(index, newobj);
            return;
        }
        int cnt = 0;
        Object ret = null;
        ListIterator<Object> iter = list.listIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!this.filter.matches(obj) || ++cnt != index) continue;
            iter.add(newobj);
            ret = obj;
            break;
        }
        if (ret == null) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    public int indexOf(Object obj) {
        List list = this.getBackingList(false);
        if (list == null) {
            return -1;
        }
        if (this.filter.matchesAll()) {
            return list.indexOf(obj);
        }
        if (!this.filter.matches(obj)) {
            return -1;
        }
        int cnt = 0;
        Object ret = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ret = iter.next();
            if (!this.filter.matches(ret)) continue;
            if (ret.equals(obj)) {
                return cnt;
            }
            ++cnt;
        }
        return -1;
    }

    public int lastIndexOf(Object obj) {
        List list = this.getBackingList(false);
        if (list == null) {
            return -1;
        }
        if (this.filter.matchesAll()) {
            return list.lastIndexOf(obj);
        }
        if (!this.filter.matches(obj)) {
            return -1;
        }
        int cnt = this.size();
        Object ret = null;
        ListIterator iter = list.listIterator(list.size());
        while (iter.hasPrevious()) {
            ret = iter.previous();
            if (!this.filter.matches(ret)) continue;
            --cnt;
            if (!ret.equals(obj)) continue;
            return cnt;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        FilterList filterList = this;
        if (filterList == null) {
            throw null;
        }
        return filterList.new FilterListIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        List list = this.getBackingList(false);
        if (list == null) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + ", Size: " + this.size());
            }
            return this;
        }
        if (this.filter.matchesAll()) {
            FilterList filterList = this;
            if (filterList == null) {
                throw null;
            }
            PassThroughFilter subListFilter = filterList.new PassThroughFilter(list.subList(fromIndex, toIndex), this.filter);
            return new FilterList(subListFilter);
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("Index: " + fromIndex + ", Size: " + this.size());
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + toIndex + ", Size: " + this.size());
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex);
        }
        int cnt = 0;
        int cnt2 = 0;
        int fromIndex2 = -1;
        int toIndex2 = -1;
        Object ret = null;
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            ret = iter.next();
            if (this.filter.matches(ret)) {
                if (cnt == fromIndex) {
                    fromIndex2 = cnt2;
                }
                if (cnt == toIndex) {
                    toIndex2 = cnt2;
                    break;
                }
                ++cnt;
            }
            ++cnt2;
        }
        if (fromIndex2 < 0) {
            fromIndex2 = list.size();
        }
        if (toIndex2 < 0) {
            toIndex2 = list.size();
        }
        FilterList filterList = this;
        if (filterList == null) {
            throw null;
        }
        PassThroughFilter subListFilter = filterList.new PassThroughFilter(list.subList(fromIndex2, toIndex2), this.filter);
        return new FilterList(subListFilter);
    }

    public FilterList(Filter filter) {
        this.setFilter(filter);
    }

    private class PassThroughFilter
    implements Filter {
        private List list;
        private Filter filter;

        public boolean matches(Object obj) {
            return this.filter.matches(obj);
        }

        public boolean matchesAll() {
            return this.filter.matchesAll();
        }

        public boolean canAdd(Object obj) {
            return this.filter.canAdd(obj);
        }

        public boolean canRemove(Object obj) {
            return this.filter.canRemove(obj);
        }

        public List getBackingList(boolean create) {
            return this.list;
        }

        PassThroughFilter(List list, Filter filter) {
            this.list = list;
            this.filter = filter;
        }
    }

    private class FilterListIterator
    implements ListIterator {
        protected Object next;
        protected Object previous;
        protected Object ret;
        protected int stepsNeededToSync;
        protected int lastMoveDirection;
        protected List list;
        protected ListIterator iterator;
        protected int index;

        public boolean hasNext() {
            this.checkList();
            if (this.next != null) {
                return true;
            }
            if (this.list == null) {
                return false;
            }
            this.sync();
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                --this.stepsNeededToSync;
                if (!FilterList.this.filter.matches(this.next)) continue;
                return true;
            }
            this.next = null;
            return false;
        }

        public Object next() {
            this.checkList();
            if (this.next == null) {
                this.hasNext();
            }
            this.ret = this.next;
            this.next = null;
            if (this.ret == null) {
                throw new NoSuchElementException();
            }
            this.stepsNeededToSync = 0;
            this.lastMoveDirection = 1;
            ++this.index;
            return this.ret;
        }

        public boolean hasPrevious() {
            this.checkList();
            if (this.previous != null) {
                return true;
            }
            if (this.list == null) {
                return false;
            }
            this.sync();
            while (this.iterator.hasPrevious()) {
                this.previous = this.iterator.previous();
                ++this.stepsNeededToSync;
                if (!FilterList.this.filter.matches(this.previous)) continue;
                return true;
            }
            this.previous = null;
            return false;
        }

        public Object previous() {
            this.checkList();
            if (this.previous == null) {
                this.hasPrevious();
            }
            this.ret = this.previous;
            this.previous = null;
            if (this.ret == null) {
                throw new NoSuchElementException();
            }
            this.lastMoveDirection = -1;
            this.stepsNeededToSync = 0;
            --this.index;
            return this.ret;
        }

        public int nextIndex() {
            this.checkList();
            return this.index;
        }

        public int previousIndex() {
            this.checkList();
            return this.index - 1;
        }

        public void add(Object o) {
            this.ensureIteratorBackingList();
            this.sync();
            FilterList.this.checkAdd(o);
            this.iterator.add(o);
            this.ret = null;
            this.next = null;
            this.previous = null;
            ++this.index;
        }

        public void remove() {
            this.ensureIteratorBackingList();
            this.sync();
            if (this.ret == null) {
                throw new IllegalStateException("Cannot call remove() now.");
            }
            FilterList.this.checkRemove(this.ret);
            this.iterator.remove();
            this.ret = null;
            this.next = null;
            this.previous = null;
            if (this.lastMoveDirection == 1) {
                --this.index;
            }
        }

        public void set(Object o) {
            this.ensureIteratorBackingList();
            this.sync();
            if (this.ret == null) {
                throw new IllegalStateException("Cannot call set() now.");
            }
            if (this.ret != o) {
                FilterList.this.checkAdd(o);
                FilterList.this.checkRemove(this.ret);
                this.iterator.set(o);
                this.ret = o;
                this.next = null;
                this.previous = null;
            }
        }

        private void sync() {
            if (this.stepsNeededToSync != 0) {
                if (this.stepsNeededToSync > 0) {
                    int i = 0;
                    while (i < this.stepsNeededToSync) {
                        this.iterator.next();
                        ++i;
                    }
                    if (this.lastMoveDirection == -1 && this.iterator.hasNext()) {
                        this.iterator.next();
                        this.iterator.previous();
                    }
                } else {
                    int i = 0;
                    while (i < -this.stepsNeededToSync) {
                        this.iterator.previous();
                        ++i;
                    }
                    if (this.lastMoveDirection == 1 && this.iterator.hasPrevious()) {
                        this.iterator.previous();
                        this.iterator.next();
                    }
                }
                this.next = null;
                this.previous = null;
                this.stepsNeededToSync = 0;
            }
        }

        private void ensureIteratorBackingList() {
            this.checkList();
            if (this.list == null) {
                this.list = FilterList.this.getBackingList(true);
                this.iterator = this.list.listIterator();
            }
        }

        private void checkList() {
            if (this.list != FilterList.this.getBackingList(false)) {
                throw new ConcurrentModificationException();
            }
        }

        FilterListIterator(int index) {
            this.list = FilterList.this.getBackingList(false);
            if (this.list != null) {
                this.iterator = this.list.listIterator();
            }
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + FilterList.this.size());
            }
            int i = 0;
            while (i < index) {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + FilterList.this.size());
                }
                this.next();
                ++i;
            }
            this.ret = null;
        }
    }
}

