/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;

public class Text
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Text.java,v $ $Revision: 1.9 $ $Date: 2002/01/08 09:17:10 $ $Name:  $";
    protected StringBuffer value;
    protected Element parent;

    public String getText() {
        return this.value.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public static String normalizeString(String str) {
        if (str == null) {
            return null;
        }
        char[] c = str.toCharArray();
        char[] n = new char[c.length];
        boolean white = true;
        int pos = 0;
        int i = 0;
        while (i < c.length) {
            if (" \t\n\r".indexOf(c[i]) != -1) {
                if (!white) {
                    n[pos++] = 32;
                    white = true;
                }
            } else {
                n[pos++] = c[i];
                white = false;
            }
            ++i;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    public Text setText(String str) {
        this.value = new StringBuffer();
        if (str == null) {
            return this;
        }
        this.append(str);
        return this;
    }

    public void append(String str) {
        if (str == null) {
            return;
        }
        String reason = Verifier.checkCharacterData(str);
        if (reason != null) {
            throw new IllegalDataException(str, "character content", reason);
        }
        this.value.append(str);
    }

    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.value.append(text.getText());
    }

    public Element getParent() {
        return this.parent;
    }

    public Document getDocument() {
        if (this.parent != null) {
            return this.parent.getDocument();
        }
        return null;
    }

    protected Text setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public Text detach() {
        if (this.parent != null) {
            this.parent.removeContent(this);
        }
        this.parent = null;
        return this;
    }

    public String toString() {
        return new StringBuffer(64).append("[Text: ").append(this.getText()).append("]").toString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Text text = null;
        try {
            text = (Text)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        text.parent = null;
        text.value = new StringBuffer(this.value.toString());
        return text;
    }

    public final boolean equals(Object ob) {
        return this == ob;
    }

    protected Text() {
    }

    public Text(String str) {
        this.setText(str);
    }
}

