/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.IOException;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DTDHandler {
    private static final String CVS_ID = "@(#) $RCSfile: SAXHandler.java,v $ $Revision: 1.29 $ $Date: 2002/01/08 09:17:10 $ $Name:  $";
    private static final Map attrNameToTypeMap = new HashMap(13);
    private Document document;
    protected Stack stack;
    protected boolean atRoot;
    protected boolean inDTD = false;
    protected boolean inInternalSubset = false;
    protected boolean inCDATA = false;
    private boolean expand = true;
    protected boolean suppress = false;
    private int entityDepth = 0;
    protected LinkedList declaredNamespaces;
    protected LinkedList availableNamespaces;
    private StringBuffer buffer = new StringBuffer();
    private Map externalEntities;
    private JDOMFactory factory;
    private boolean ignoringWhite = false;
    private Locator locator;

    public Document getDocument() {
        return this.document;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public void setExpandEntities(boolean expand) {
        this.expand = expand;
    }

    public boolean getExpandEntities() {
        return this.expand;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        this.ignoringWhite = ignoringWhite;
    }

    public boolean getIgnoringElementContentWhitespace() {
        return this.ignoringWhite;
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        this.externalEntities.put(name, new String[]{publicId, systemId});
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ENTITY ").append(name);
        if (publicId != null) {
            this.buffer.append(" PUBLIC \"").append(publicId).append("\" ");
        }
        if (systemId != null) {
            this.buffer.append(" SYSTEM \"").append(systemId).append("\" ");
        }
        this.buffer.append(">\n");
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ATTLIST ").append(eName).append(" ").append(aName).append(" ").append(type).append(" ");
        if (valueDefault != null) {
            this.buffer.append(valueDefault);
        } else {
            this.buffer.append("\"").append(value).append("\"");
        }
        if (valueDefault != null && valueDefault.equals("#FIXED")) {
            this.buffer.append(" \"").append(value).append("\"");
        }
        this.buffer.append(">\n");
    }

    public void elementDecl(String name, String model) throws SAXException {
        this.buffer.append("  <!ELEMENT ").append(name).append(" ").append(model).append(">\n");
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ENTITY ");
        if (name.startsWith("%")) {
            this.buffer.append("% ").append(name.substring(1));
        } else {
            this.buffer.append(name);
        }
        this.buffer.append(" \"").append(value).append("\">\n");
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.suppress) {
            return;
        }
        if (this.atRoot) {
            this.document.addContent(this.factory.processingInstruction(target, data));
        } else {
            this.getCurrentElement().addContent(this.factory.processingInstruction(target, data));
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.suppress) {
            return;
        }
        Namespace ns = Namespace.getNamespace(prefix, uri);
        this.declaredNamespaces.add(ns);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.suppress) {
            return;
        }
        Iterator itr = this.availableNamespaces.iterator();
        while (itr.hasNext()) {
            Namespace ns = (Namespace)itr.next();
            if (!prefix.equals(ns.getPrefix())) continue;
            itr.remove();
            return;
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.suppress) {
            return;
        }
        Element element = null;
        if (namespaceURI != null && !namespaceURI.equals("")) {
            String prefix = "";
            if (localName != qName) {
                int split = qName.indexOf(":");
                prefix = qName.substring(0, split);
            }
            Namespace elementNamespace = Namespace.getNamespace(prefix, namespaceURI);
            element = this.factory.element(localName, elementNamespace);
        } else {
            element = this.factory.element(localName);
        }
        if (this.declaredNamespaces.size() > 0) {
            this.transferNamespaces(element);
        }
        int i = 0;
        int len = atts.getLength();
        while (i < len) {
            Attribute attribute = null;
            String attLocalName = atts.getLocalName(i);
            String attQName = atts.getQName(i);
            int attType = this.getAttributeType(atts.getType(i));
            if (!attQName.startsWith("xmlns:") && !attQName.equals("xmlns")) {
                if (attLocalName != attQName) {
                    String attPrefix = attQName.substring(0, attQName.indexOf(":"));
                    attribute = this.factory.attribute(attLocalName, atts.getValue(i), attType, this.getNamespace(attPrefix));
                } else {
                    attribute = this.factory.attribute(attLocalName, atts.getValue(i), attType);
                }
                element.setAttribute(attribute);
            }
            ++i;
        }
        if (this.atRoot) {
            this.document.setRootElement(element);
            this.stack.push(element);
            this.atRoot = false;
        } else {
            this.getCurrentElement().addContent(element);
            this.stack.push(element);
        }
    }

    private void transferNamespaces(Element element) {
        Iterator i = this.declaredNamespaces.iterator();
        while (i.hasNext()) {
            Namespace ns = (Namespace)i.next();
            this.availableNamespaces.addFirst(ns);
            element.addNamespaceDeclaration(ns);
        }
        this.declaredNamespaces.clear();
    }

    private Namespace getNamespace(String prefix) {
        Iterator i = this.availableNamespaces.iterator();
        while (i.hasNext()) {
            Namespace ns = (Namespace)i.next();
            if (!prefix.equals(ns.getPrefix())) continue;
            return ns;
        }
        return Namespace.NO_NAMESPACE;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.suppress) {
            return;
        }
        if (length == 0) {
            return;
        }
        String data = new String(ch, start, length);
        if (this.inCDATA) {
            this.getCurrentElement().addContent(this.factory.cdata(data));
        } else {
            this.getCurrentElement().addContent(this.factory.text(data));
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.suppress) {
            return;
        }
        if (this.ignoringWhite) {
            return;
        }
        if (length == 0) {
            return;
        }
        String data = new String(ch, start, length);
        this.getCurrentElement().addContent(this.factory.text(data));
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.suppress) {
            return;
        }
        try {
            Element element = (Element)this.stack.pop();
            List addl = element.getAdditionalNamespaces();
            if (addl.size() > 0) {
                this.availableNamespaces.removeAll(addl);
            }
        }
        catch (EmptyStackException ex1) {
            throw new SAXException("Ill-formed XML document (missing opening tag for " + localName + ")");
        }
        if (this.stack.empty()) {
            this.atRoot = true;
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.document.setDocType(this.factory.docType(name, publicId, systemId));
        this.inDTD = true;
        this.inInternalSubset = true;
    }

    public void endDTD() throws SAXException {
        this.document.getDocType().setInternalSubset(this.buffer.toString());
        this.inDTD = false;
        this.inInternalSubset = false;
    }

    public void startEntity(String name) throws SAXException {
        ++this.entityDepth;
        if (this.expand || this.entityDepth > 1) {
            return;
        }
        if (this.inDTD) {
            this.inInternalSubset = false;
            return;
        }
        if (!(this.inDTD || name.equals("amp") || name.equals("lt") || name.equals("gt") || name.equals("apos") || name.equals("quot") || this.expand)) {
            String pub = null;
            String sys = null;
            String[] ids = (String[])this.externalEntities.get(name);
            if (ids != null) {
                pub = ids[0];
                sys = ids[1];
            }
            if (!this.atRoot && !this.stack.isEmpty()) {
                EntityRef entity = this.factory.entityRef(name, pub, sys);
                this.getCurrentElement().addContent(entity);
            }
            this.suppress = true;
        }
    }

    public void endEntity(String name) throws SAXException {
        --this.entityDepth;
        if (this.entityDepth == 0) {
            this.suppress = false;
        }
        if (this.inDTD) {
            this.inInternalSubset = true;
        }
    }

    public void startCDATA() throws SAXException {
        if (this.suppress) {
            return;
        }
        this.inCDATA = true;
    }

    public void endCDATA() throws SAXException {
        if (this.suppress) {
            return;
        }
        this.inCDATA = false;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.suppress) {
            return;
        }
        String commentText = new String(ch, start, length);
        if (this.inDTD && this.inInternalSubset && !this.expand) {
            this.buffer.append("  <!--").append(commentText).append("-->\n");
            return;
        }
        if (!this.inDTD && !commentText.equals("")) {
            if (this.stack.empty()) {
                this.document.addContent(this.factory.comment(commentText));
            } else {
                this.getCurrentElement().addContent(this.factory.comment(commentText));
            }
        }
    }

    public void notationDecl(String name, String publicID, String systemID) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!NOTATION ").append(name).append(" \"").append(systemID).append("\">\n");
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ENTITY ").append(name);
        if (publicId != null) {
            this.buffer.append(" PUBLIC \"").append(publicId).append("\" ");
        }
        if (systemId != null) {
            this.buffer.append(" SYSTEM \"").append(systemId).append("\" ");
        }
        this.buffer.append(" NDATA ").append(notationName);
        this.buffer.append(">\n");
    }

    protected Element getCurrentElement() throws SAXException {
        try {
            return (Element)this.stack.peek();
        }
        catch (EmptyStackException ex1) {
            throw new SAXException("Ill-formed XML document (multiple root elements detected)");
        }
    }

    private int getAttributeType(String typeName) {
        Integer type = (Integer)attrNameToTypeMap.get(typeName);
        if (type == null) {
            if (typeName.charAt(0) == '(') {
                return 10;
            }
            return 0;
        }
        return type;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public SAXHandler(Document document) throws IOException {
        this(new DefaultJDOMFactory());
        this.document = document;
    }

    public SAXHandler() throws IOException {
        this((JDOMFactory)null);
    }

    public SAXHandler(JDOMFactory factory) throws IOException {
        this.factory = factory != null ? factory : new DefaultJDOMFactory();
        this.atRoot = true;
        this.stack = new Stack();
        this.declaredNamespaces = new LinkedList();
        this.availableNamespaces = new LinkedList();
        this.availableNamespaces.add(Namespace.XML_NAMESPACE);
        this.externalEntities = new HashMap();
        this.document = this.factory.document(null);
    }

    static {
        attrNameToTypeMap.put("CDATA", new Integer(1));
        attrNameToTypeMap.put("ID", new Integer(2));
        attrNameToTypeMap.put("IDREF", new Integer(3));
        attrNameToTypeMap.put("IDREFS", new Integer(4));
        attrNameToTypeMap.put("ENTITY", new Integer(5));
        attrNameToTypeMap.put("ENTITIES", new Integer(6));
        attrNameToTypeMap.put("NMTOKEN", new Integer(7));
        attrNameToTypeMap.put("NMTOKENS", new Integer(8));
        attrNameToTypeMap.put("NOTATION", new Integer(9));
        attrNameToTypeMap.put("ENUMERATION", new Integer(10));
    }
}

