/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.ParallelFlux;
import io.micrometer.shaded.reactor.core.publisher.SourceProducer;

final class ParallelArraySource<T>
extends ParallelFlux<T>
implements SourceProducer<T> {
    final Publisher<T>[] sources;

    ParallelArraySource(Publisher<T>[] sources) {
        if (sources == null || sources.length == 0) {
            throw new IllegalArgumentException("Zero publishers not supported");
        }
        this.sources = sources;
    }

    @Override
    public int parallelism() {
        return this.sources.length;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        for (int i = 0; i < n; ++i) {
            Flux.from(this.sources[i]).subscribe(subscribers[i]);
        }
    }
}

