/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.statsd;

import io.micrometer.core.instrument.AbstractMeter;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.util.MeterEquivalence;
import io.micrometer.shaded.org.reactorstreams.Subscriber;
import io.micrometer.statsd.StatsdLineBuilder;
import java.util.concurrent.atomic.DoubleAdder;

public class StatsdCounter
extends AbstractMeter
implements Counter {
    private final StatsdLineBuilder lineBuilder;
    private final Subscriber<String> subscriber;
    private DoubleAdder count = new DoubleAdder();
    private volatile boolean shutdown = false;

    StatsdCounter(Meter.Id id, StatsdLineBuilder lineBuilder, Subscriber<String> subscriber) {
        super(id);
        this.lineBuilder = lineBuilder;
        this.subscriber = subscriber;
    }

    public void increment(double amount) {
        if (!this.shutdown && amount > 0.0) {
            this.count.add(amount);
            this.subscriber.onNext(this.lineBuilder.count((long)amount));
        }
    }

    public double count() {
        return this.count.doubleValue();
    }

    public boolean equals(Object o) {
        return MeterEquivalence.equals((Meter)this, (Object)o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode((Meter)this);
    }

    void shutdown() {
        this.shutdown = true;
    }
}

