/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.AbstractGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseMultigraph<V, E>
extends AbstractGraph<V, E>
implements MultiGraph<V, E> {
    protected Map<V, Pair<Set<E>>> vertices = new HashMap<V, Pair<Set<E>>>();
    protected Map<E, Pair<V>> edges = new HashMap<E, Pair<V>>();
    protected Set<E> directedEdges = new HashSet();

    public static <V, E> Factory<Graph<V, E>> getFactory() {
        return new Factory<Graph<V, E>>(){

            public Graph<V, E> create() {
                return new SparseMultigraph();
            }
        };
    }

    public Collection<E> getEdges() {
        return Collections.unmodifiableCollection(this.edges.keySet());
    }

    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertices.keySet());
    }

    public boolean containsVertex(V vertex) {
        return this.vertices.keySet().contains(vertex);
    }

    public boolean containsEdge(E edge) {
        return this.edges.keySet().contains(edge);
    }

    protected Collection<E> getIncoming_internal(V vertex) {
        return (Collection)this.vertices.get(vertex).getFirst();
    }

    protected Collection<E> getOutgoing_internal(V vertex) {
        return (Collection)this.vertices.get(vertex).getSecond();
    }

    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.vertices.containsKey(vertex)) {
            this.vertices.put((Pair)vertex, (Pair<Set<E>>)new Pair(new HashSet(), new HashSet()));
            return true;
        }
        return false;
    }

    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        HashSet<E> incident = new HashSet<E>(this.getIncoming_internal(vertex));
        incident.addAll(this.getOutgoing_internal(vertex));
        for (Object edge : incident) {
            this.removeEdge(edge);
        }
        this.vertices.remove(vertex);
        return true;
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        Pair<? extends V> new_endpoints = this.getValidatedEndpoints(edge, endpoints);
        if (new_endpoints == null) {
            return false;
        }
        Object v1 = new_endpoints.getFirst();
        Object v2 = new_endpoints.getSecond();
        if (!this.vertices.containsKey(v1)) {
            this.addVertex(v1);
        }
        if (!this.vertices.containsKey(v2)) {
            this.addVertex(v2);
        }
        ((Set)this.vertices.get(v1).getSecond()).add(edge);
        ((Set)this.vertices.get(v2).getFirst()).add(edge);
        this.edges.put(edge, new_endpoints);
        if (edgeType == EdgeType.DIRECTED) {
            this.directedEdges.add(edge);
        } else {
            ((Set)this.vertices.get(v1).getFirst()).add(edge);
            ((Set)this.vertices.get(v2).getSecond()).add(edge);
        }
        return true;
    }

    public boolean removeEdge(E edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        Pair<V> endpoints = this.getEndpoints(edge);
        Object v1 = endpoints.getFirst();
        Object v2 = endpoints.getSecond();
        ((Set)this.vertices.get(v1).getSecond()).remove(edge);
        ((Set)this.vertices.get(v2).getFirst()).remove(edge);
        if (!this.directedEdges.remove(edge)) {
            ((Set)this.vertices.get(v2).getSecond()).remove(edge);
            ((Set)this.vertices.get(v1).getFirst()).remove(edge);
        }
        this.edges.remove(edge);
        return true;
    }

    public Collection<E> getInEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection((Collection)this.vertices.get(vertex).getFirst());
    }

    public Collection<E> getOutEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection((Collection)this.vertices.get(vertex).getSecond());
    }

    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> preds = new HashSet<V>();
        for (E edge : this.getIncoming_internal(vertex)) {
            if (this.getEdgeType(edge) == EdgeType.DIRECTED) {
                preds.add(this.getSource(edge));
                continue;
            }
            preds.add(this.getOpposite(vertex, edge));
        }
        return Collections.unmodifiableCollection(preds);
    }

    public Collection<V> getSuccessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> succs = new HashSet<V>();
        for (E edge : this.getOutgoing_internal(vertex)) {
            if (this.getEdgeType(edge) == EdgeType.DIRECTED) {
                succs.add(this.getDest(edge));
                continue;
            }
            succs.add(this.getOpposite(vertex, edge));
        }
        return Collections.unmodifiableCollection(succs);
    }

    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> out = new HashSet<V>();
        out.addAll(this.getPredecessors(vertex));
        out.addAll(this.getSuccessors(vertex));
        return out;
    }

    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<E> out = new HashSet<E>();
        out.addAll(this.getInEdges(vertex));
        out.addAll(this.getOutEdges(vertex));
        return out;
    }

    @Override
    public E findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        for (E edge : this.getOutgoing_internal(v1)) {
            if (!this.getOpposite(v1, edge).equals(v2)) continue;
            return edge;
        }
        return null;
    }

    public Pair<V> getEndpoints(E edge) {
        return this.edges.get(edge);
    }

    public V getSource(E edge) {
        if (this.directedEdges.contains(edge)) {
            return (V)this.getEndpoints(edge).getFirst();
        }
        return null;
    }

    public V getDest(E edge) {
        if (this.directedEdges.contains(edge)) {
            return (V)this.getEndpoints(edge).getSecond();
        }
        return null;
    }

    public boolean isSource(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return this.getSource(edge).equals(vertex);
    }

    public boolean isDest(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return this.getDest(edge).equals(vertex);
    }

    public EdgeType getEdgeType(E edge) {
        return this.directedEdges.contains(edge) ? EdgeType.DIRECTED : EdgeType.UNDIRECTED;
    }

    public Collection<E> getEdges(EdgeType edgeType) {
        if (edgeType == EdgeType.DIRECTED) {
            return Collections.unmodifiableSet(this.directedEdges);
        }
        if (edgeType == EdgeType.UNDIRECTED) {
            HashSet<E> edges = new HashSet<E>(this.getEdges());
            edges.removeAll(this.directedEdges);
            return edges;
        }
        return Collections.EMPTY_SET;
    }

    public int getEdgeCount() {
        return this.edges.keySet().size();
    }

    public int getVertexCount() {
        return this.vertices.keySet().size();
    }

    public int getEdgeCount(EdgeType edge_type) {
        return this.getEdges(edge_type).size();
    }

    public EdgeType getDefaultEdgeType() {
        return EdgeType.UNDIRECTED;
    }
}

