/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.security;

import java.security.SecureRandom;
import java.util.random.RandomGenerator;

import javax.annotation.Nullable;

import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.binary.Hex;

import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.security.IdentifierGenerationStrategy.ParameterSpec;

/**
 * Captures the supported parameters for the {@link IdentifierGenerationStrategy.ProviderType#RANDOM}
 * and {@link IdentifierGenerationStrategy.ProviderType#SECURE} strategy types.
 * 
 * @param source random generator (this MUST be thread-safe), defaults to standard Java {@link SecureRandom} 
 * @param identifierSize size of identifiers to generate, defaults to 16
 * @param identifierEncoder an encoder to apply to the random data, defaults to {@link Hex}
 */
public record RandomIdentifierParameterSpec(@Nullable @ParameterName(name="source") RandomGenerator source,
        @Nullable @NonNegative @ParameterName(name="identifierSize") Integer identifierSize,
        @Nullable @ParameterName(name="identifierEncoder") BinaryEncoder identifierEncoder) implements ParameterSpec {
}