/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Unique;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.Method;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Retry$minusAfter$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static final Retry$ MODULE$ = new Retry$();
    private static final SelfAwareStructuredLogger<SyncIO> logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.client.middleware.Retry");
    private static final Key<Object> AttemptCountKey = (Key)((SyncIO)Key$.MODULE$.newKey((Functor)SyncIO$.MODULE$.syncForSyncIO(), (Unique)SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();

    public Key<Object> AttemptCountKey() {
        return AttemptCountKey;
    }

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CIString, Object> redactHeaderWhen, Client<F> client, GenTemporal<F, Throwable> F) {
        return this.create(policy, redactHeaderWhen, this.create$default$3(), client, F);
    }

    public <F> Function1<CIString, Object> apply$default$2() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)Retry$.$anonfun$apply$default$2$1(elem));
    }

    public <F> Client<F> create(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CIString, Object> redactHeaderWhen, boolean logRetries, Client<F> client, GenTemporal<F, Throwable> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> Hotswap$.MODULE$.create((GenConcurrent)F).flatMap((Function1 & Serializable)hotswap -> Resource$.MODULE$.eval(this.retryLoop$1((Request)req, 1, (Hotswap)hotswap, F, client, policy, logRetries, (Function1)redactHeaderWhen))), F);
    }

    public <F> Function1<CIString, Object> create$default$2() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)Retry$.$anonfun$create$default$2$1(elem));
    }

    public <F> boolean create$default$3() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$2$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private static final String showRequest$1(Request request, Function1 redactWhen) {
        String headers = Headers$.MODULE$.mkString$extension(request.headers(), ",", redactWhen);
        String uri = request.uri().renderString();
        Method method = request.method();
        return new StringBuilder(21).append("method=").append(method).append(" uri=").append(uri).append(" headers=").append(headers).toString();
    }

    private final Object nextAttempt$1(Request req, int attempts, FiniteDuration duration, Option retryHeader, Hotswap hotswap, GenTemporal F$1, Client client$1, Function3 policy$1, boolean logRetries$1, Function1 redactHeaderWhen$1) {
        Object headerDuration = retryHeader.map((Function1 & Serializable)h -> {
            Either either = h.retry();
            if (either instanceof Left) {
                Left left = (Left)either;
                HttpDate date = (HttpDate)left.value();
                return package.all$.MODULE$.toFunctorOps(F$1.realTime(), (Functor)F$1).map((Function1 & Serializable)x$1 -> date.toDuration().$minus(x$1));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                long secs = BoxesRunTime.unboxToLong((Object)right.value());
                return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(secs)).seconds()), (Applicative)F$1);
            }
            throw new MatchError((Object)either);
        }).getOrElse((Function0 & Serializable)() -> ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(0)).seconds()), (Applicative)F$1));
        Object sleepDuration = package.all$.MODULE$.toFunctorOps(headerDuration, (Functor)F$1).map((Function1 & Serializable)x$2 -> x$2.max(duration));
        return FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(package.all$.MODULE$.toFlatMapOps(sleepDuration, (FlatMap)F$1).flatMap((Function1 & Serializable)x$3 -> F$1.sleep((Duration)x$3)), (FlatMap)F$1), (Function0 & Serializable)() -> this.retryLoop$1(req, attempts + 1, hotswap, F$1, client$1, policy$1, logRetries$1, redactHeaderWhen$1), (FlatMap)F$1);
    }

    private final Object retryLoop$1(Request req, int attempts, Hotswap hotswap, GenTemporal F$1, Client client$1, Function3 policy$1, boolean logRetries$1, Function1 redactHeaderWhen$1) {
        return package.all$.MODULE$.catsSyntaxApply(hotswap.clear(), (Apply)F$1).$times$greater(package.all$.MODULE$.toFlatMapOps(hotswap.swap(client$1.run((Request)req.withAttribute(this.AttemptCountKey(), (Object)BoxesRunTime.boxToInteger((int)attempts))).map((Function1 & Serializable)x$4 -> (Response)x$4.withAttribute(MODULE$.AttemptCountKey(), (Object)BoxesRunTime.boxToInteger((int)attempts))).attempt((ApplicativeError)F$1)), (FlatMap)F$1).flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Right) {
                Right right = (Right)either;
                Response response = (Response)right.value();
                Option option = (Option)policy$1.apply((Object)req, (Object)package$.MODULE$.Right().apply((Object)response), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    Object object = logRetries$1 ? ((SyncIO)logger.info((Function0 & Serializable)() -> new StringBuilder(63).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" has failed on attempt #").append(attempts).append(" with reason ").append(response.status()).append(". Retrying after ").append(duration).append(".").toString())).unsafeRunSync() : BoxedUnit.UNIT;
                    return this.nextAttempt$1(req, attempts, duration, Headers$.MODULE$.get$extension(response.headers(), Header.Select$.MODULE$.singleHeaders(Retry$minusAfter$.MODULE$.headerInstance())), hotswap, F$1, client$1, policy$1, logRetries$1, redactHeaderWhen$1);
                }
                if (None$.MODULE$.equals(option)) {
                    return F$1.pure((Object)response);
                }
                throw new MatchError((Object)option);
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable e = (Throwable)left.value();
                Option option = (Option)policy$1.apply((Object)req, (Object)package$.MODULE$.Left().apply((Object)e), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    Object object = logRetries$1 ? ((SyncIO)logger.info(e, (Function0 & Serializable)() -> new StringBuilder(56).append("Request threw an exception on attempt #").append(attempts).append(". Retrying after ").append(duration).toString())).unsafeRunSync() : BoxedUnit.UNIT;
                    return this.nextAttempt$1(req, attempts, duration, (Option)None$.MODULE$, hotswap, F$1, client$1, policy$1, logRetries$1, redactHeaderWhen$1);
                }
                if (None$.MODULE$.equals(option)) {
                    Object object = logRetries$1 ? ((SyncIO)logger.info(e, (Function0 & Serializable)() -> new StringBuilder(52).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" threw an exception on attempt #").append(attempts).append(". Giving up.").toString())).unsafeRunSync() : BoxedUnit.UNIT;
                    return F$1.raiseError((Object)e);
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)either);
        }));
    }

    public static final /* synthetic */ boolean $anonfun$create$default$2$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private Retry$() {
    }
}

