/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.net.ProtocolException;
import org.http4s.websocket.ReservedOpcodeException;
import org.http4s.websocket.UnknownOpcodeException;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketFrame$Text$;
import scodec.bits.ByteVector;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final int OP_CODE = 15;
    private static final int FINISHED = 128;
    private static final int MASK = 128;
    private static final int LENGTH = 127;
    private static final int RESERVED = 14;
    private static final int CONTINUATION = 0;
    private static final int TEXT = 1;
    private static final int BINARY = 2;
    private static final int CLOSE = 8;
    private static final int PING = 9;
    private static final int PONG = 10;

    public int OP_CODE() {
        return OP_CODE;
    }

    public int FINISHED() {
        return FINISHED;
    }

    public int MASK() {
        return MASK;
    }

    public int LENGTH() {
        return LENGTH;
    }

    public int RESERVED() {
        return RESERVED;
    }

    public int CONTINUATION() {
        return CONTINUATION;
    }

    public int TEXT() {
        return TEXT;
    }

    public int BINARY() {
        return BINARY;
    }

    public int CLOSE() {
        return CLOSE;
    }

    public int PING() {
        return PING;
    }

    public int PONG() {
        return PONG;
    }

    public WebSocketFrame makeFrame(int opcode, ByteVector data, boolean last) throws ProtocolException {
        int n = opcode;
        switch (n) {
            case 0: {
                return new WebSocketFrame.Continuation(data, last);
            }
            case 1: {
                return WebSocketFrame$Text$.MODULE$.apply(data, last);
            }
            case 2: {
                return new WebSocketFrame.Binary(data, last);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                throw new ReservedOpcodeException(opcode);
            }
            case 8: {
                if (data.length() == 1L) {
                    throw new ProtocolException("Close frame must have 0 data bits or at least 2");
                }
                if (!last) {
                    throw new ProtocolException("Control frame cannot be fragmented: Close");
                }
                return new WebSocketFrame.Close(data);
            }
            case 9: {
                if (!last) {
                    throw new ProtocolException("Control frame cannot be fragmented: Ping");
                }
                return new WebSocketFrame.Ping(data);
            }
            case 10: {
                if (!last) {
                    throw new ProtocolException("Control frame cannot be fragmented: Pong");
                }
                return new WebSocketFrame.Pong(data);
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new ReservedOpcodeException(opcode);
            }
        }
        throw new UnknownOpcodeException(opcode);
    }

    private package$() {
    }
}

