/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IOFiber$;
import cats.effect.Trace;
import cats.effect.tracing.Tracing$;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.Scheduler;
import cats.effect.unsafe.TimerSkipList;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPoolConstants;
import cats.effect.unsafe.WorkerThread;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.Comparator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\u0015g!B!C\u0005\u0011C\u0005\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0013y\u0003!Q1A\u0005\u0002\t{\u0006\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u00131\u0004!Q1A\u0005\u0002\t{\u0006\u0002C7\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u00139\u0004!Q1A\u0005\u0002\t{\u0007\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0013]\u0004!Q1A\u0005\u0002\tC\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0011u\u0004!\u0011!Q\u0001\nyDq!a\u0007\u0001\t\u0003\ti\u0002\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0018\u0011)\tY\u0004\u0001b\u0001\n\u0003\u0011\u0015Q\b\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002@!Q\u0011\u0011\n\u0001C\u0002\u0013\u0005!)a\u0013\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001bB!\"a\u0016\u0001\u0005\u0004%\tAQA-\u0011!\t\u0019\b\u0001Q\u0001\n\u0005m\u0003BCA;\u0001\t\u0007I\u0011\u0001\"\u0002x!A\u0011Q\u0012\u0001!\u0002\u0013\tI\b\u0003\u0005\u0002\u0010\u0002\u0001\u000b\u0011BA/\u0011!\t\t\n\u0001Q\u0001\n\u0005M\u0005\u0002CAM\u0001\u0001\u0006I!a'\t\u0015\u0005\u0005\u0006A1A\u0005\u0002\t\u000b\u0019\u000b\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAS\u0011)\ty\u000b\u0001b\u0001\n\u0003\u0011\u0015\u0011\u0017\u0005\t\u0003g\u0003\u0001\u0015!\u0003\u0002^!Q\u0011Q\u0017\u0001C\u0002\u0013\u0005!)a.\t\u0011\u0005e\u0006\u0001)A\u0005\u00037C!\"a/\u0001\u0005\u0004%\tAQA\\\u0011!\ti\f\u0001Q\u0001\n\u0005m\u0005\u0002CA`\u0001\u0011\u0005!)!1\t\u0011\u0005\r\u0007\u0001\"\u0001C\u0003\u000bD\u0001\"!7\u0001\t\u0003\u0011\u00151\u001c\u0005\t\u0003S\u0004A\u0011\u0001\"\u0002l\"A\u0011q\u001e\u0001!\n\u001b\t\t\u0010\u0003\u0005\u0002x\u0002\u0001K\u0011BA}\u0011!\tY\u0010\u0001C\u0001\u0005\u0006u\b\u0002\u0003B\u0001\u0001\u0011\u0005!)!?\t\u0011\t\r\u0001\u0001\"\u0001C\u0005\u000bA\u0001B!\u0003\u0001\t\u0003\u0011\u0015\u0011 \u0005\t\u0005\u0017\u0001A\u0011\u0001\"\u0003\u000e!A!q\u0002\u0001\u0005\u0002\t\u0013i\u0001\u0003\u0005\u0003\u0012\u0001!\tA\u0011B\n\u0011!\u0011Y\u0002\u0001C\u0001\t\nu\u0001\u0002\u0003B\u0012\u0001\u0011\u0005A)!?\t\u0011\t\u0015\u0002\u0001)C\u0005\u0005OA\u0001B!\f\u0001\t\u0003\u0011%q\u0006\u0005\b\u0005G\u0002A\u0011\tB3\u0011\u001d\u0011I\u0007\u0001C!\u0005WBqA!\u001d\u0001\t\u0003\u0012\u0019\bC\u0004\u0003v\u0001!\tEa\u001d\t\u000f\t]\u0004\u0001\"\u0011\u0003t!A!\u0011\u0010\u0001!\u0002\u0013\u0011Y\bC\u0004\u0003\f\u0002!\tA!$\t\u0011\t\r\u0006\u0001)C\u0007\u0005KCqAa+\u0001\t\u0003\u0012i\u000bC\u0004\u00036\u0002!\tA!\u0004\t\u0011\t]\u0006\u0001\"\u0001C\u0005sC\u0001Ba/\u0001\t\u0003\u0011%\u0011\u0018\u0005\t\u0005{\u0003A\u0011\u0001\"\u0003:\"A!q\u0018\u0001\u0005\u0002\t\u0013I\f\u0003\u0005\u0003B\u0002!\tA\u0011B:\u0011!\u0011\u0019\r\u0001C\u0001\u0005\nM$AF,pe.\u001cF/Z1mS:<G\u000b\u001b:fC\u0012\u0004vn\u001c7\u000b\u0005\r#\u0015AB;og\u00064WM\u0003\u0002F\r\u00061QM\u001a4fGRT\u0011aR\u0001\u0005G\u0006$8o\u0005\u0003\u0001\u0013>+\u0006C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%AB!osJ+g\r\u0005\u0002Q'6\t\u0011K\u0003\u0002S\u0017\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Q\u000b&\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peB\u0011akV\u0007\u0002\u0005&\u0011\u0001L\u0011\u0002\n'\u000eDW\rZ;mKJ\f1\u0002\u001e5sK\u0006$7i\\;oi\u000e\u0001\u0001C\u0001&]\u0013\ti6JA\u0002J]R\fA\u0002\u001e5sK\u0006$\u0007K]3gSb,\u0012\u0001\u0019\t\u0003C\"t!A\u00194\u0011\u0005\r\\U\"\u00013\u000b\u0005\u0015T\u0016A\u0002\u001fs_>$h(\u0003\u0002h\u0017\u00061\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t97*A\u0007uQJ,\u0017\r\u001a)sK\u001aL\u0007\u0010I\u0001\u0014E2|7m[3s)\"\u0014X-\u00193Qe\u00164\u0017\u000e_\u0001\u0015E2|7m[3s)\"\u0014X-\u00193Qe\u00164\u0017\u000e\u001f\u0011\u00023I,h\u000e^5nK\ncwnY6j]\u001e,\u0005\u0010]5sCRLwN\\\u000b\u0002aB\u0011\u0011\u000f^\u0007\u0002e*\u00111/U\u0001\tIV\u0014\u0018\r^5p]&\u0011QO\u001d\u0002\t\tV\u0014\u0018\r^5p]\u0006Q\"/\u001e8uS6,'\t\\8dW&tw-\u0012=qSJ\fG/[8oA\u0005i\"\r\\8dW\u0016$G\u000b\u001b:fC\u0012$U\r^3di&|g.\u00128bE2,G-F\u0001z!\tQ%0\u0003\u0002|\u0017\n9!i\\8mK\u0006t\u0017A\b2m_\u000e\\W\r\u001a+ie\u0016\fG\rR3uK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3!\u00039\u0011X\r]8si\u001a\u000b\u0017\u000e\\;sKB\u0002bAS@\u0002\u0004\u0005U\u0011bAA\u0001\u0017\nIa)\u001e8di&|g.\r\t\u0005\u0003\u000b\tyA\u0004\u0003\u0002\b\u0005-abA2\u0002\n%\tA*C\u0002\u0002\u000e-\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0012\u0005M!!\u0003+ie><\u0018M\u00197f\u0015\r\tia\u0013\t\u0004\u0015\u0006]\u0011bAA\r\u0017\n!QK\\5u\u0003\u0019a\u0014N\\5u}Qq\u0011qDA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0002C\u0001,\u0001\u0011\u0015I6\u00021\u0001\\\u0011\u0015q6\u00021\u0001a\u0011\u0015a7\u00021\u0001a\u0011\u0015q7\u00021\u0001q\u0011\u001598\u00021\u0001z\u0011\u0015i8\u00021\u0001\u007f\u000359xN]6feRC'/Z1egB)!*!\r\u00026%\u0019\u00111G&\u0003\u000b\u0005\u0013(/Y=\u0011\u0007Y\u000b9$C\u0002\u0002:\t\u0013AbV8sW\u0016\u0014H\u000b\u001b:fC\u0012\f1\u0002\\8dC2\fV/Z;fgV\u0011\u0011q\b\t\u0006\u0015\u0006E\u0012\u0011\t\t\u0004-\u0006\r\u0013bAA#\u0005\nQAj\\2bYF+X-^3\u0002\u00191|7-\u00197Rk\u0016,Xm\u001d\u0011\u0002\u0011MdW-\u001a9feN,\"!!\u0014\u0011\u000b)\u000b\t$a\u0014\u0011\u0007Y\u000b\t&C\u0002\u0002T\t\u0013Q\u0002V5nKJ\u001c6.\u001b9MSN$\u0018!C:mK\u0016\u0004XM]:!\u00035\u0001\u0018M]6fINKwM\\1mgV\u0011\u00111\f\t\u0006\u0015\u0006E\u0012Q\f\t\u0005\u0003?\ny'\u0004\u0002\u0002b)!\u00111MA3\u0003\u0019\tGo\\7jG*\u0019!+a\u001a\u000b\t\u0005%\u00141N\u0001\u0005kRLGN\u0003\u0002\u0002n\u0005!!.\u0019<b\u0013\u0011\t\t(!\u0019\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u00039\u0001\u0018M]6fINKwM\\1mg\u0002\n\u0011BZ5cKJ\u0014\u0015mZ:\u0016\u0005\u0005e\u0004#\u0002&\u00022\u0005m\u0004#\u0002,\u0002~\u0005\u0005\u0015bAA@\u0005\n9q+Z1l\u0005\u0006<\u0007\u0003BAB\u0003\u0013k!!!\"\u000b\t\u0005\u001d\u00151N\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\f\u0006\u0015%\u0001\u0003*v]:\f'\r\\3\u0002\u0015\u0019L'-\u001a:CC\u001e\u001c\b%A\u000bx_J\\WM\u001d+ie\u0016\fG\rU;cY&\u001c\b.\u001a:\u0002\u001b\u0015DH/\u001a:oC2\fV/Z;f!\u00111\u0016QS%\n\u0007\u0005]%IA\u0005TG\u0006d\u0017+^3vK\u0006)1\u000f^1uKB!\u0011qLAO\u0013\u0011\ty*!\u0019\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u00035\u0019\u0017m\u00195fIRC'/Z1egV\u0011\u0011Q\u0015\t\u0007\u0003O\u000bI+!\u000e\u000e\u0005\u0005\u0015\u0014\u0002BAV\u0003K\u0012QcQ8oGV\u0014(/\u001a8u'.L\u0007\u000fT5tiN+G/\u0001\bdC\u000eDW\r\u001a+ie\u0016\fGm\u001d\u0011\u0002\t\u0011|g.Z\u000b\u0003\u0003;\nQ\u0001Z8oK\u0002\n!D\u00197pG.,GmV8sW\u0016\u0014H\u000b\u001b:fC\u0012\u001cu.\u001e8uKJ,\"!a'\u00027\tdwnY6fI^{'o[3s)\"\u0014X-\u00193D_VtG/\u001a:!\u0003y\u0011Gn\\2lK\u0012<vN]6feRC'/Z1e\u001d\u0006l\u0017N\\4J]\u0012,\u00070A\u0010cY>\u001c7.\u001a3X_J\\WM\u001d+ie\u0016\fGMT1nS:<\u0017J\u001c3fq\u0002\n\u0001cZ3u/>\u00148.\u001a:UQJ,\u0017\rZ:\u0016\u0005\u0005=\u0012AG:uK\u0006dgI]8n\u001fRDWM],pe.,'\u000f\u00165sK\u0006$G\u0003CAA\u0003\u000f\fY-!6\t\r\u0005%\u0017\u00051\u0001\\\u0003\u0011!Wm\u001d;\t\u000f\u00055\u0017\u00051\u0001\u0002P\u00061!/\u00198e_6\u0004B!a*\u0002R&!\u00111[A3\u0005E!\u0006N]3bI2{7-\u00197SC:$w.\u001c\u0005\b\u0003/\f\u0003\u0019AA\u001b\u0003)!Wm\u001d;X_J\\WM]\u0001\fgR,\u0017\r\u001c+j[\u0016\u00148\u000fF\u0003z\u0003;\f9\u000fC\u0004\u0002`\n\u0002\r!!9\u0002\u00079|w\u000fE\u0002K\u0003GL1!!:L\u0005\u0011auN\\4\t\u000f\u00055'\u00051\u0001\u0002P\u0006aan\u001c;jMf\u0004\u0016M]6fIR\u0019\u00110!<\t\u000f\u000557\u00051\u0001\u0002P\u0006qan\u001c;jMf4uN\u001d+j[\u0016\u0014H\u0003BA\u000b\u0003gDa!!>%\u0001\u0004Y\u0016!B5oI\u0016D\u0018A\u00058pi&4\u0017p\u00155pk2$w+Y6fkB$\u0012!_\u0001\u0014]>$\u0018NZ=JM^{'o\u001b)f]\u0012Lgn\u001a\u000b\u0005\u0003+\ty\u0010C\u0004\u0002N\u001a\u0002\r!a4\u00027Q\u0014\u0018M\\:ji&|gnV8sW\u0016\u0014Hk\\*fCJ\u001c\u0007.\u001b8h\u0003u!(/\u00198tSRLwN\\,pe.,'O\u0012:p[N+\u0017M]2iS:<G\u0003BA\u000b\u0005\u000fAq!!4)\u0001\u0004\ty-A\u0013ue\u0006t7/\u001b;j_:<vN]6feR{\u0007+\u0019:lK\u0012<\u0006.\u001a8TK\u0006\u00148\r[5oO\u0006ABO]1og&$\u0018n\u001c8X_J\\WM\u001d+p!\u0006\u00148.\u001a3\u0015\u0005\u0005U\u0011\u0001\u00043p]\u0016\u001cF.Z3qS:<\u0017!\u0004:fa2\f7-Z,pe.,'\u000f\u0006\u0004\u0002\u0016\tU!q\u0003\u0005\u0007\u0003kd\u0003\u0019A.\t\u000f\teA\u00061\u0001\u00026\u0005Ia.Z<X_J\\WM]\u0001\u000be\u0016\u001c8\r[3ek2,G\u0003BA\u000b\u0005?AqA!\t.\u0001\u0004\t\t)\u0001\u0005sk:t\u0017M\u00197f\u0003Y\u0019\u0017M\\#yK\u000e,H/\u001a\"m_\u000e\\\u0017N\\4D_\u0012,\u0017\u0001E:dQ\u0016$W\u000f\\3FqR,'O\\1m)\u0011\t)B!\u000b\t\u000f\t-r\u00061\u0001\u0002\u0002\u0006)a-\u001b2fe\u0006QA.\u001b<f)J\f7-Z:\u0015\u0005\tE\u0002#\u0003&\u00034\t]\"Q\tB\u001c\u0013\r\u0011)d\u0013\u0002\u0007)V\u0004H.Z\u001a\u0011\u000f\u0005\u0014I$!!\u0003>%\u0019!1\b6\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003@\t\u0005S\"\u0001#\n\u0007\t\rCIA\u0003Ue\u0006\u001cW\rE\u0004b\u0005s\t)Da\u0012\u0011\u0013)\u0013\u0019D!\u0013\u0003X\t]\u0002\u0003\u0002B&\u0005#rA!a!\u0003N%!!qJAC\u0003\u0019!\u0006N]3bI&!!1\u000bB+\u0005\u0015\u0019F/\u0019;f\u0015\u0011\u0011y%!\"\u0011\u000b)\u0013IF!\u0018\n\u0007\tm3J\u0001\u0004PaRLwN\u001c\t\b\u0015\n}\u0013\u0011\u0011B\u001f\u0013\r\u0011\tg\u0013\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u000f\u0015DXmY;uKR!\u0011Q\u0003B4\u0011\u001d\u0011\t#\ra\u0001\u0003\u0003\u000bQB]3q_J$h)Y5mkJ,G\u0003BA\u000b\u0005[BqAa\u001c3\u0001\u0004\t\u0019!A\u0003dCV\u001cX-\u0001\bn_:|Go\u001c8jG:\u000bgn\\:\u0015\u0005\u0005\u0005\u0018!\u00038po6KG\u000e\\5t\u0003%qwn^'jGJ|7/A\u0005SS\u001eDG/\u00168jiBA!Q\u0010BA\u0005\u000b\u000b)\"\u0004\u0002\u0003\u0000)\u0019\u0011\u0011N&\n\t\t\r%q\u0010\u0002\u0006%&<\u0007\u000e\u001e\t\u0004\u0015\n\u001d\u0015b\u0001BE\u0017\n9aj\u001c;iS:<\u0017!D:mK\u0016\u0004\u0018J\u001c;fe:\fG\u000e\u0006\u0004\u0002\u0002\n=%\u0011\u0014\u0005\b\u0005#;\u0004\u0019\u0001BJ\u0003\u0015!W\r\\1z!\r\t(QS\u0005\u0004\u0005/\u0013(A\u0004$j]&$X\rR;sCRLwN\u001c\u0005\b\u00057;\u0004\u0019\u0001BO\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007C\u0002&\u0000\u0005?\u000b)\u0002\u0005\u0005\u0002\u0006\t\u0005&QQA\u000b\u0013\u0011\u0011\u0019)a\u0005\u0002\u001bMdW-\u001a9FqR,'O\\1m)\u0019\t\tIa*\u0003*\"9!\u0011\u0013\u001dA\u0002\tM\u0005b\u0002BNq\u0001\u0007!QT\u0001\u0006g2,W\r\u001d\u000b\u0007\u0003\u0003\u0013yK!-\t\u000f\tE\u0015\b1\u0001\u0003\u0014\"9!1W\u001dA\u0002\u0005\u0005\u0015\u0001\u0002;bg.\f\u0001b\u001d5vi\u0012|wO\\\u0001\u0015O\u0016$xk\u001c:lKJ$\u0006N]3bI\u000e{WO\u001c;\u0015\u0003m\u000bAcZ3u\u0003\u000e$\u0018N^3UQJ,\u0017\rZ\"pk:$\u0018aF4fiN+\u0017M]2iS:<G\u000b\u001b:fC\u0012\u001cu.\u001e8u\u0003m9W\r\u001e\"m_\u000e\\W\rZ,pe.,'\u000f\u00165sK\u0006$7i\\;oi\u00069r-\u001a;M_\u000e\fG.U;fk\u00164\u0015NY3s\u0007>,h\u000e^\u0001\u0017O\u0016$8+^:qK:$W\r\u001a$jE\u0016\u00148i\\;oi\u0002")
public final class WorkStealingThreadPool
implements ExecutionContextExecutor,
Scheduler {
    private final int threadCount;
    private final String threadPrefix;
    private final String blockerThreadPrefix;
    private final Duration runtimeBlockingExpiration;
    private final boolean blockedThreadDetectionEnabled;
    private final Function1<Throwable, BoxedUnit> reportFailure0;
    private final WorkerThread[] workerThreads;
    private final LocalQueue[] localQueues;
    private final TimerSkipList[] sleepers;
    private final AtomicBoolean[] parkedSignals;
    private final WeakBag<Runnable>[] fiberBags;
    private final AtomicBoolean workerThreadPublisher;
    private final ScalQueue<Object> externalQueue;
    private final AtomicInteger state;
    private final ConcurrentSkipListSet<WorkerThread> cachedThreads;
    private final AtomicBoolean done;
    private final AtomicInteger blockedWorkerThreadCounter;
    private final AtomicInteger blockedWorkerThreadNamingIndex;
    private final Right<Nothing$, BoxedUnit> RightUnit;

    public ExecutionContext prepare() {
        return ExecutionContext.prepare$((ExecutionContext)this);
    }

    public String threadPrefix() {
        return this.threadPrefix;
    }

    public String blockerThreadPrefix() {
        return this.blockerThreadPrefix;
    }

    public Duration runtimeBlockingExpiration() {
        return this.runtimeBlockingExpiration;
    }

    public boolean blockedThreadDetectionEnabled() {
        return this.blockedThreadDetectionEnabled;
    }

    public LocalQueue[] localQueues() {
        return this.localQueues;
    }

    public TimerSkipList[] sleepers() {
        return this.sleepers;
    }

    public AtomicBoolean[] parkedSignals() {
        return this.parkedSignals;
    }

    public WeakBag<Runnable>[] fiberBags() {
        return this.fiberBags;
    }

    public ConcurrentSkipListSet<WorkerThread> cachedThreads() {
        return this.cachedThreads;
    }

    public AtomicBoolean done() {
        return this.done;
    }

    public AtomicInteger blockedWorkerThreadCounter() {
        return this.blockedWorkerThreadCounter;
    }

    public AtomicInteger blockedWorkerThreadNamingIndex() {
        return this.blockedWorkerThreadNamingIndex;
    }

    public WorkerThread[] getWorkerThreads() {
        return this.workerThreads;
    }

    public Runnable stealFromOtherWorkerThread(int dest, ThreadLocalRandom random, WorkerThread destWorker) {
        LocalQueue destQueue = this.localQueues()[dest];
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            Runnable res;
            int index = (from + i) % this.threadCount;
            if (index == dest || (res = this.localQueues()[index].stealInto(destQueue, destWorker)) == null) continue;
            return res;
        }
        Object element = this.externalQueue.poll(random);
        if (element instanceof Runnable[]) {
            Runnable[] batch = (Runnable[])element;
            return destQueue.enqueueBatch(batch, destWorker);
        }
        if (element instanceof Runnable) {
            Runnable fiber = (Runnable)element;
            if (TracingConstants.isStackTracing) {
                destWorker.active_$eq(fiber);
                this.parkedSignals()[dest].lazySet(false);
            }
            return fiber;
        }
        return null;
    }

    public boolean stealTimers(long now, ThreadLocalRandom random) {
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            TimerSkipList tsl = this.sleepers()[index];
            boolean invoked = false;
            boolean cont = true;
            while (cont) {
                Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cb = tsl.pollFirstIfTriggered(now);
                if (cb != null) {
                    cb.apply(this.RightUnit);
                    invoked = true;
                    continue;
                }
                cont = false;
            }
            if (!invoked) continue;
            return true;
        }
        return false;
    }

    public boolean notifyParked(ThreadLocalRandom random) {
        if (!this.notifyShouldWakeup()) {
            return false;
        }
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            AtomicBoolean signal = this.parkedSignals()[index];
            if (!signal.getAndSet(false)) continue;
            this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
            this.workerThreadPublisher.get();
            WorkerThread worker = this.workerThreads[index];
            LockSupport.unpark(worker);
            return true;
        }
        return false;
    }

    private final void notifyForTimer(int index) {
        AtomicBoolean signal = this.parkedSignals()[index];
        if (signal.getAndSet(false)) {
            this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
            this.workerThreadPublisher.get();
            WorkerThread worker = this.workerThreads[index];
            LockSupport.unpark(worker);
            return;
        }
    }

    private boolean notifyShouldWakeup() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.SearchMask) == 0 && (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16 < this.threadCount;
    }

    public void notifyIfWorkPending(ThreadLocalRandom random) {
        for (int i = 0; i < this.threadCount; ++i) {
            if (!this.localQueues()[i].nonEmpty()) continue;
            this.notifyParked(random);
            return;
        }
        if (this.externalQueue.nonEmpty()) {
            this.notifyParked(random);
            return;
        }
    }

    public boolean transitionWorkerToSearching() {
        int st = this.state.get();
        if (2 * (st & WorkStealingThreadPoolConstants.SearchMask) >= this.threadCount) {
            return false;
        }
        this.state.getAndIncrement();
        return true;
    }

    public void transitionWorkerFromSearching(ThreadLocalRandom random) {
        int prev = this.state.getAndDecrement();
        if (prev == 1) {
            this.notifyParked(random);
            return;
        }
    }

    public boolean transitionWorkerToParkedWhenSearching() {
        int prev = this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaSearching);
        return (prev & WorkStealingThreadPoolConstants.SearchMask) == 1;
    }

    public void transitionWorkerToParked() {
        this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaNotSearching);
    }

    public void doneSleeping() {
        this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
    }

    public void replaceWorker(int index, WorkerThread newWorker) {
        this.workerThreads[index] = newWorker;
        this.workerThreadPublisher.lazySet(true);
    }

    public void reschedule(Runnable runnable) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.reschedule(runnable);
                return;
            }
            this.scheduleExternal(runnable);
            return;
        }
        this.scheduleExternal(runnable);
    }

    public boolean canExecuteBlockingCode() {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            return worker.canExecuteBlockingCodeOn(this);
        }
        return false;
    }

    private void scheduleExternal(Runnable fiber) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.externalQueue.offer(fiber, random);
        this.notifyParked(random);
    }

    public Tuple3<Map<Runnable, Trace>, Map<WorkerThread, Tuple3<Thread.State, Option<Tuple2<Runnable, Trace>>, Map<Runnable, Trace>>>, Map<Runnable, Trace>> liveTraces() {
        Map externalFibers = this.externalQueue.snapshot().iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof Runnable[]) {
                Runnable[] runnableArray = (Runnable[])object;
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])runnableArray), (Function1 & Serializable)r -> Tracing$.MODULE$.captureTrace((Runnable)r), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if (object instanceof Runnable) {
                Runnable runnable = (Runnable)object;
                return Option$.MODULE$.option2Iterable(Tracing$.MODULE$.captureTrace(runnable)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return Predef$.MODULE$.Map().empty();
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Map suspended = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        for (int i = 0; i < this.threadCount; ++i) {
            Map localFibers = this.localQueues()[i].snapshot().iterator().flatMap((Function1 & Serializable)r -> Tracing$.MODULE$.captureTrace((Runnable)r)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            WorkerThread worker = this.workerThreads[i];
            boolean bl = this.parkedSignals()[i].get();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Option active = Option$.MODULE$.apply((Object)worker.active());
            map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)worker), (Object)new Tuple3((Object)worker.getState(), (Object)active.flatMap((Function1 & Serializable)a -> Tracing$.MODULE$.captureTrace((Runnable)a)), (Object)localFibers)));
            suspended.$plus$plus$eq(worker.suspendedTraces());
        }
        return new Tuple3((Object)externalFibers, (Object)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)suspended.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void execute(Runnable runnable) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.schedule(runnable);
                return;
            }
            this.scheduleExternal(runnable);
            return;
        }
        this.scheduleExternal(runnable);
    }

    public void reportFailure(Throwable cause) {
        this.reportFailure0.apply((Object)cause);
    }

    @Override
    public long monotonicNanos() {
        return System.nanoTime();
    }

    @Override
    public long nowMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long nowMicros() {
        Instant now = Instant.now();
        return now.getEpochSecond() * 1000000L + now.getLong(ChronoField.MICRO_OF_SECOND);
    }

    public Runnable sleepInternal(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(this)) {
                return worker.sleep(delay, callback);
            }
            return this.sleepExternal(delay, callback);
        }
        return this.sleepExternal(delay, callback);
    }

    private final Runnable sleepExternal(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int idx = random.nextInt(this.threadCount);
        TimerSkipList tsl = this.sleepers()[idx];
        Runnable cancel = tsl.insert(System.nanoTime(), delay.toNanos(), callback, random);
        this.notifyForTimer(idx);
        return cancel;
    }

    @Override
    public Runnable sleep(FiniteDuration delay, Runnable task) {
        return this.sleepInternal(delay, (Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>)(Function1 & Serializable)x$3 -> {
            task.run();
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        boolean interruptCalling = Thread.interrupted();
        if (this.done().compareAndSet(false, true)) {
            this.workerThreadPublisher.get();
            for (int i = 0; i < this.threadCount; ++i) {
                this.workerThreads[i].interrupt();
            }
            Thread.interrupted();
            WorkerThread t = null;
            while ((t = this.cachedThreads().pollFirst()) != null) {
                t.interrupt();
            }
            this.externalQueue.clear();
            if (interruptCalling) {
                Thread.currentThread().interrupt();
                return;
            }
            return;
        }
    }

    public int getWorkerThreadCount() {
        return this.threadCount;
    }

    public int getActiveThreadCount() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16;
    }

    public int getSearchingThreadCount() {
        int st = this.state.get();
        return st & WorkStealingThreadPoolConstants.SearchMask;
    }

    public int getBlockedWorkerThreadCount() {
        return this.blockedWorkerThreadCounter().get();
    }

    public long getLocalQueueFiberCount() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.localQueues()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.size()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long getSuspendedFiberCount() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.workerThreads), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getSuspendedFiberCount()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public WorkStealingThreadPool(int threadCount, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, boolean blockedThreadDetectionEnabled, Function1<Throwable, BoxedUnit> reportFailure0) {
        int i;
        this.threadCount = threadCount;
        this.threadPrefix = threadPrefix;
        this.blockerThreadPrefix = blockerThreadPrefix;
        this.runtimeBlockingExpiration = runtimeBlockingExpiration;
        this.blockedThreadDetectionEnabled = blockedThreadDetectionEnabled;
        this.reportFailure0 = reportFailure0;
        ExecutionContext.$init$((ExecutionContext)this);
        Scheduler.$init$(this);
        this.workerThreads = new WorkerThread[threadCount];
        this.localQueues = new LocalQueue[threadCount];
        this.sleepers = new TimerSkipList[threadCount];
        this.parkedSignals = new AtomicBoolean[threadCount];
        this.fiberBags = new WeakBag[threadCount];
        this.workerThreadPublisher = new AtomicBoolean(false);
        this.externalQueue = new ScalQueue(threadCount << 2);
        this.state = new AtomicInteger(threadCount << 16);
        this.cachedThreads = new ConcurrentSkipListSet<WorkerThread>(Comparator.comparingInt(x$1 -> x$1.nameIndex()));
        this.done = new AtomicBoolean(false);
        this.blockedWorkerThreadCounter = new AtomicInteger(0);
        this.blockedWorkerThreadNamingIndex = new AtomicInteger(0);
        for (i = 0; i < threadCount; ++i) {
            WorkerThread thread;
            AtomicBoolean parkedSignal;
            TimerSkipList sleepersList;
            LocalQueue queue;
            this.localQueues()[i] = queue = new LocalQueue();
            this.sleepers()[i] = sleepersList = new TimerSkipList();
            this.parkedSignals()[i] = parkedSignal = new AtomicBoolean(false);
            int index = i;
            WeakBag<Runnable> fiberBag = new WeakBag<Runnable>();
            this.fiberBags()[i] = fiberBag;
            this.workerThreads[i] = thread = new WorkerThread(index, queue, parkedSignal, this.externalQueue, fiberBag, sleepersList, this);
        }
        this.workerThreadPublisher.set(true);
        for (i = 0; i < threadCount; ++i) {
            this.workerThreads[i].start();
        }
        this.RightUnit = IOFiber$.MODULE$.RightUnit();
    }
}

