/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.Head;
import cats.effect.unsafe.LocalQueueConstants;
import cats.effect.unsafe.LocalQueuePadding;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.Tail;
import cats.effect.unsafe.WorkerThread;
import java.util.concurrent.ThreadLocalRandom;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\u0011#\r%BQA\f\u0001\u0005\u0002=Ba!\r\u0001!\u0002\u0013\u0011\u0004B\u0002!\u0001A\u0003&\u0011\t\u0003\u0004E\u0001\u0001\u0006K!\u0011\u0005\u0007\u000b\u0002\u0001\u000b\u0015B!\t\r\u0019\u0003\u0001\u0015)\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u00151\b\u0001\"\u0001x\u0011\u0015Y\b\u0001\"\u0001x\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bA\u0001\"a\u0002\u0001A\u0013%\u0011\u0011\u0002\u0005\t\u0003\u001f\u0001\u0001\u0015\"\u0003\u0002\u0012!A\u0011Q\u0003\u0001!\n\u0013\t9\u0002\u0003\u0005\u0002\u001c\u0001\u0001K\u0011BA\u000f\u0011!\t\u0019\u0003\u0001Q\u0005\n\u0005\u0015\u0002\u0002CA\u0018\u0001\u0001&I!!\r\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!1\u0011\u0011\u000b\u0001\u0005\u0002uDa!a\u0015\u0001\t\u0003i\bBBA+\u0001\u0011\u0005Q\u0010C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005m\u0003\u0001\"\u0001\u0002Z!9\u0011Q\f\u0001\u0005\u0002\u0005e\u0003bBA0\u0001\u0011\u0005\u0011\u0011\f\u0005\u0007\u0003C\u0002A\u0011A?\t\r\u0005\r\u0004\u0001\"\u0001~\u0011\u0019\t)\u0007\u0001C\u0001{\nQAj\\2bYF+X-^3\u000b\u0005\r\"\u0013AB;og\u00064WM\u0003\u0002&M\u00051QM\u001a4fGRT\u0011aJ\u0001\u0005G\u0006$8o\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016-\u001b\u0005\u0011\u0013BA\u0017#\u0005EaunY1m#V,W/\u001a)bI\u0012LgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"a\u000b\u0001\u0002\r\t,hMZ3s!\r\u0019d\u0007O\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t)\u0011I\u001d:bsB\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$\u0001\u0003*v]:\f'\r\\3\u0002\u001fQ|G/\u00197GS\n,'oQ8v]R\u0004\"a\r\"\n\u0005\r#$\u0001\u0002'p]\u001e\f1\u0003^8uC2\u001c\u0006/\u001b7m_Z,'oQ8v]R\f1d];dG\u0016\u001c8OZ;m'R,\u0017\r\\!ui\u0016l\u0007\u000f^\"pk:$\u0018\u0001E:u_2,gNR5cKJ\u001cu.\u001e8u\u0003\u001d)g.];fk\u0016$B!\u0013'O-B\u00111GS\u0005\u0003\u0017R\u0012A!\u00168ji\")Qj\u0002a\u0001q\u0005)a-\u001b2fe\")qj\u0002a\u0001!\u0006AQ\r\u001f;fe:\fG\u000eE\u0002,#NK!A\u0015\u0012\u0003\u0013M\u001b\u0017\r\\)vKV,\u0007CA\u001aU\u0013\t)FG\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/\u001e\u0001\r\u0001W\u0001\u0007e\u0006tGm\\7\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016AC2p]\u000e,(O]3oi*\u0011Q\fP\u0001\u0005kRLG.\u0003\u0002`5\n\tB\u000b\u001b:fC\u0012dunY1m%\u0006tGm\\7\u0002\u0019\u0015t\u0017/^3vK\n\u000bGo\u00195\u0015\u0007a\u0012G\rC\u0003d\u0011\u0001\u0007!'A\u0003cCR\u001c\u0007\u000eC\u0003f\u0011\u0001\u0007a-\u0001\u0004x_J\\WM\u001d\t\u0003W\u001dL!\u0001\u001b\u0012\u0003\u0019]{'o[3s)\"\u0014X-\u00193\u0002\u000f\u0011,\u0017/^3vKR\u0011\u0001h\u001b\u0005\u0006K&\u0001\rAZ\u0001\ngR,\u0017\r\\%oi>$2\u0001\u000f8q\u0011\u0015y'\u00021\u00011\u0003\r!7\u000f\u001e\u0005\u0006c*\u0001\rAZ\u0001\nIN$xk\u001c:lKJ\f!\u0002\u001a:bS:\u0014\u0015\r^2i)\rIE/\u001e\u0005\u0006\u001f.\u0001\r\u0001\u0015\u0005\u0006/.\u0001\r\u0001W\u0001\bSN,U\u000e\u001d;z)\u0005A\bCA\u001az\u0013\tQHGA\u0004C_>dW-\u00198\u0002\u00119|g.R7qif\fAa]5{KR\ta\u0010\u0005\u00024\u007f&\u0019\u0011\u0011\u0001\u001b\u0003\u0007%sG/A\bck\u001a4WM\u001d$pe^\f'\u000fZ3s+\u0005\u0011\u0014!B5oI\u0016DHc\u0001@\u0002\f!1\u0011Q\u0002\tA\u0002y\f\u0011A\\\u0001\u0004YN\u0014Gc\u0001@\u0002\u0014!1\u0011QB\tA\u0002y\f1!\\:c)\rq\u0018\u0011\u0004\u0005\u0007\u0003\u001b\u0011\u0002\u0019\u0001@\u0002\tA\f7m\u001b\u000b\u0006}\u0006}\u0011\u0011\u0005\u0005\u0007\u0003+\u0019\u0002\u0019\u0001@\t\r\u0005=1\u00031\u0001\u007f\u0003U)hn]5h]\u0016$7\u000b[8si\u0006#G-\u001b;j_:$RA`A\u0014\u0003WAa!!\u000b\u0015\u0001\u0004q\u0018!\u0001=\t\r\u00055B\u00031\u0001\u007f\u0003\u0005I\u0018\u0001G;og&<g.\u001a3TQ>\u0014HoU;ciJ\f7\r^5p]R)a0a\r\u00026!1\u0011\u0011F\u000bA\u0002yDa!!\f\u0016\u0001\u0004q\u0018\u0001C:oCB\u001c\bn\u001c;\u0015\u0005\u0005m\u0002#BA\u001f\u0003\u0017Bd\u0002BA \u0003\u000f\u00022!!\u00115\u001b\t\t\u0019EC\u0002\u0002F!\na\u0001\u0010:p_Rt\u0014bAA%i\u00051\u0001K]3eK\u001aLA!!\u0014\u0002P\t\u00191+\u001a;\u000b\u0007\u0005%C'A\u0007hKR4\u0015NY3s\u0007>,h\u000e^\u0001\rO\u0016$\b*Z1e\u0013:$W\r_\u0001\rO\u0016$H+Y5m\u0013:$W\r_\u0001\u0013O\u0016$Hk\u001c;bY\u001aK'-\u001a:D_VtG\u000fF\u0001B\u0003Y9W\r\u001e+pi\u0006d7\u000b]5mY>4XM]\"pk:$\u0018AH4fiN+8mY3tg\u001a,Hn\u0015;fC2\fE\u000f^3naR\u001cu.\u001e8u\u0003M9W\r^*u_2,gNR5cKJ\u001cu.\u001e8u\u000399W\r\u001e*fC2DU-\u00193UC\u001e\fqbZ3u'R,\u0017\r\u001c%fC\u0012$\u0016mZ\u0001\u000bO\u0016$H+Y5m)\u0006<\u0007")
public final class LocalQueue
extends LocalQueuePadding {
    private final Runnable[] buffer = new Runnable[256];
    private long totalFiberCount = 0L;
    private long totalSpilloverCount = 0L;
    private long successfulStealAttemptCount = 0L;
    private long stolenFiberCount = 0L;

    public void enqueue(Runnable fiber, ScalQueue<Object> external, ThreadLocalRandom random) {
        int tl = this.tail;
        while (true) {
            int hd;
            int steal;
            if (this.unsignedShortSubtraction(tl, steal = this.msb(hd = Head.updater.get(this))) < 256) {
                int idx = this.index(tl);
                this.buffer[idx] = fiber;
                if (TracingConstants.isStackTracing) {
                    ++this.totalFiberCount;
                }
                int newTl = this.unsignedShortAddition(tl, 1);
                Tail.updater.lazySet(this, newTl);
                this.tail = newTl;
                return;
            }
            int real = this.lsb(hd);
            if (steal != real) {
                if (TracingConstants.isStackTracing) {
                    ++this.totalSpilloverCount;
                    Tail.updater.lazySet(this, tl);
                }
                external.offer(fiber, random);
                return;
            }
            int realPlusHalf = this.unsignedShortAddition(real, LocalQueueConstants.HalfLocalQueueCapacity);
            int newHd = this.pack(realPlusHalf, realPlusHalf);
            if (!Head.updater.compareAndSet(this, hd, newHd)) continue;
            Runnable[][] batches = new Runnable[LocalQueueConstants.BatchesInHalfQueueCapacity][];
            int offset = 0;
            for (int b = 0; b < LocalQueueConstants.BatchesInHalfQueueCapacity; ++b) {
                Runnable[] batch = new Runnable[32];
                int i = 0;
                while (i < 32) {
                    int idx = this.index(real + offset);
                    Runnable f = this.buffer[idx];
                    this.buffer[idx] = null;
                    batch[i] = f;
                    ++i;
                    ++offset;
                }
                if (TracingConstants.isStackTracing) {
                    this.totalSpilloverCount += 32L;
                }
                batches[b] = batch;
            }
            external.offerAll((Object[])batches, random);
        }
    }

    public Runnable enqueueBatch(Runnable[] batch, WorkerThread worker) {
        int hd;
        int steal;
        int len;
        int tl = this.tail;
        while ((len = this.unsignedShortSubtraction(tl, steal = this.msb(hd = Head.updater.get(this)))) > LocalQueueConstants.LocalQueueCapacityMinusBatch) {
        }
        int startPos = tl - 1;
        for (int i = 1; i < 32; ++i) {
            int idx = this.index(startPos + i);
            this.buffer[idx] = batch[i];
        }
        Runnable fiber = batch[0];
        if (TracingConstants.isStackTracing) {
            this.totalFiberCount += 32L;
            worker.active_$eq(fiber);
        }
        int newTl = this.unsignedShortAddition(tl, 31);
        Tail.updater.lazySet(this, newTl);
        this.tail = newTl;
        return fiber;
    }

    public Runnable dequeue(WorkerThread worker) {
        Runnable fiber;
        int newHd;
        int hd;
        int tl = this.tail;
        do {
            int real;
            if ((real = this.lsb(hd = Head.updater.get(this))) == tl) {
                return null;
            }
            int newReal = this.unsignedShortAddition(real, 1);
            int steal = this.msb(hd);
            newHd = steal == real ? this.pack(newReal, newReal) : this.pack(steal, newReal);
            int idx = this.index(real);
            fiber = this.buffer[idx];
            if (!TracingConstants.isStackTracing) continue;
            worker.active_$eq(fiber);
        } while (!Head.updater.compareAndSet(this, hd, newHd));
        this.buffer[idx] = null;
        return fiber;
    }

    public Runnable stealInto(LocalQueue dst, WorkerThread dstWorker) {
        int n;
        int real;
        int newReal;
        int steal;
        int newHd;
        int hd;
        int dstTl = dst.tail;
        int dstHd = Head.updater.get(dst);
        int dstSteal = this.msb(dstHd);
        if (this.unsignedShortSubtraction(dstTl, dstSteal) > LocalQueueConstants.HalfLocalQueueCapacity) {
            return null;
        }
        do {
            if ((steal = this.msb(hd = Head.updater.get(this))) != (real = this.lsb(hd))) {
                return null;
            }
            int tl = Tail.updater.get(this);
            n = this.unsignedShortSubtraction(tl, real);
            if ((n -= n / 2) != 0) continue;
            return null;
        } while (!Head.updater.compareAndSet(this, hd, newHd = this.pack(steal, newReal = this.unsignedShortAddition(real, n))));
        Runnable[] dstBuffer = dst.bufferForwarder();
        int headFiberIdx = this.index(steal);
        Runnable headFiber = this.buffer[headFiberIdx];
        this.buffer[headFiberIdx] = null;
        if (TracingConstants.isStackTracing) {
            dstWorker.active_$eq(headFiber);
        }
        int sourcePos = steal + 1;
        int end = n - 1;
        for (int i = 0; i < end; ++i) {
            int srcIdx = this.index(sourcePos + i);
            int dstIdx = this.index(dstTl + i);
            Runnable fiber = this.buffer[srcIdx];
            this.buffer[srcIdx] = null;
            dstBuffer[dstIdx] = fiber;
        }
        if (TracingConstants.isStackTracing) {
            ++this.successfulStealAttemptCount;
            this.stolenFiberCount += (long)n;
        }
        hd = newHd;
        while (true) {
            if (Head.updater.compareAndSet(this, hd, newHd = this.pack(newReal, newReal))) {
                if (n == 1) {
                    if (TracingConstants.isStackTracing) {
                        Tail.updater.lazySet(dst, dstTl);
                        dst.tail = dstTl;
                    }
                    return headFiber;
                }
                int newDstTl = this.unsignedShortAddition(dstTl, --n);
                Tail.updater.lazySet(dst, newDstTl);
                dst.tail = newDstTl;
                return headFiber;
            }
            hd = Head.updater.get(this);
            newReal = this.lsb(hd);
        }
    }

    public void drainBatch(ScalQueue<Object> external, ThreadLocalRandom random) {
        int newReal;
        int real;
        int steal;
        int newHd;
        int hd;
        int tl = this.tail;
        do {
            if (this.unsignedShortSubtraction(tl, real = this.lsb(hd = Head.updater.get(this))) <= LocalQueueConstants.LocalQueueCapacityMinusBatch) {
                return;
            }
            newReal = this.unsignedShortAddition(real, 32);
        } while (!Head.updater.compareAndSet(this, hd, newHd = (steal = this.msb(hd)) == real ? this.pack(newReal, newReal) : this.pack(steal, newReal)));
        Runnable[] batch = new Runnable[32];
        for (int i = 0; i < 32; ++i) {
            int idx = this.index(real + i);
            Runnable f = this.buffer[idx];
            this.buffer[idx] = null;
            batch[i] = f;
        }
        if (TracingConstants.isStackTracing) {
            this.totalSpilloverCount += 32L;
            Tail.updater.lazySet(this, tl);
        }
        external.offer(batch, random);
    }

    public boolean isEmpty() {
        int hd = Head.updater.get(this);
        int tl = Tail.updater.get(this);
        return this.lsb(hd) == tl;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int size() {
        int hd = Head.updater.get(this);
        int tl = Tail.updater.get(this);
        return this.unsignedShortSubtraction(tl, this.lsb(hd));
    }

    public Runnable[] bufferForwarder() {
        return this.buffer;
    }

    private int index(int n) {
        return n & LocalQueueConstants.LocalQueueCapacityMask;
    }

    private int lsb(int n) {
        return n & LocalQueueConstants.UnsignedShortMask;
    }

    private int msb(int n) {
        return n >>> 16;
    }

    private int pack(int msb, int lsb) {
        return msb << 16 | lsb;
    }

    private int unsignedShortAddition(int x, int y) {
        return this.lsb(x + y);
    }

    private int unsignedShortSubtraction(int x, int y) {
        return this.lsb(x - y);
    }

    public Set<Runnable> snapshot() {
        int n = this.size();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return (Set)Predef$.MODULE$.wrapRefArray((Object[])this.buffer).toSet().$minus(null);
    }

    public int getFiberCount() {
        return this.size();
    }

    public int getHeadIndex() {
        int hd = Head.updater.get(this);
        return this.index(this.lsb(hd));
    }

    public int getTailIndex() {
        int tl = Tail.updater.get(this);
        return this.index(tl);
    }

    public long getTotalFiberCount() {
        int n = Tail.updater.get(this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.totalFiberCount;
    }

    public long getTotalSpilloverCount() {
        int n = Tail.updater.get(this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.totalSpilloverCount;
    }

    public long getSuccessfulStealAttemptCount() {
        int n = Head.updater.get(this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.successfulStealAttemptCount;
    }

    public long getStolenFiberCount() {
        int n = Head.updater.get(this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.stolenFiberCount;
    }

    public int getRealHeadTag() {
        int hd = Head.updater.get(this);
        return this.lsb(hd);
    }

    public int getStealHeadTag() {
        int hd = Head.updater.get(this);
        return this.msb(hd);
    }

    public int getTailTag() {
        return Tail.updater.get(this);
    }
}

