/*
 * Decompiled with CFR 0.152.
 */
package fs2.timeseries;

import cats.effect.kernel.GenTemporal;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.Scan;
import fs2.Scan$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.timeseries.TimeStamped;
import fs2.timeseries.TimeStamped$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TimeSeries$ {
    public static final TimeSeries$ MODULE$ = new TimeSeries$();

    public <F, A> Stream<F, TimeStamped<Option<A>>> apply(Stream<F, TimeStamped<A>> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, GenTemporal<F, Throwable> evidence$1) {
        return this.apply(source, tickPeriod, reorderOver, false, evidence$1);
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> apply(Stream<F, TimeStamped<A>> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, boolean monotonic, GenTemporal<F, Throwable> evidence$2) {
        Stream src = source.map((Function1 & Serializable)tsa -> tsa.map((Function1 & Serializable)x$1 -> new Some(x$1)));
        Stream ticks = this.timeTicks(tickPeriod, monotonic, evidence$2).map((Function1 & Serializable)tsu -> tsu.map((Function1 & Serializable)x$2 -> None$.MODULE$));
        return src.merge(ticks, evidence$2).through(TimeStamped$.MODULE$.reorderLocally(reorderOver));
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> timePulled(Stream<F, A> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, GenTemporal<F, Throwable> evidence$3) {
        return this.apply(source.map((Function1 & Serializable)a -> TimeStamped$.MODULE$.unsafeRealTime(a)), tickPeriod, reorderOver, evidence$3);
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> timePulled(Stream<F, A> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, boolean monotonic, GenTemporal<F, Throwable> evidence$4) {
        return this.apply(source.map((Function1 & Serializable)a -> {
            if (monotonic) {
                return TimeStamped$.MODULE$.unsafeMonotonic(a);
            }
            return TimeStamped$.MODULE$.unsafeRealTime(a);
        }), tickPeriod, reorderOver, monotonic, evidence$4);
    }

    public <F, A, B> Function1<Stream<F, TimeStamped<Option<A>>>, Stream<F, TimeStamped<Option<B>>>> lift(Function1<A, B> f) {
        return (Function1 & Serializable)x$3 -> x$3.map((Function1 & Serializable)x$4 -> x$4.map((Function1 & Serializable)x$5 -> x$5.map(f)));
    }

    public <F, L, R> Function1<Stream<F, TimeStamped<Option<Either<L, R>>>>, Stream<F, TimeStamped<Option<L>>>> drainRight() {
        return (Function1 & Serializable)x$6 -> x$6.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends TimeStamped<Option<Either<L, R>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Either<L, R>> option;
                A1 A1 = x1;
                if (A1 != null && None$.MODULE$.equals(option = A1.value())) {
                    return (B1)A1;
                }
                if (A1 != null) {
                    Some some;
                    Either either;
                    FiniteDuration ts = A1.time();
                    Option<Either<L, R>> option2 = A1.value();
                    if (option2 instanceof Some && (either = (Either)(some = (Some)option2).value()) instanceof Left) {
                        Left left = (Left)either;
                        Object l = left.value();
                        return (B1)new TimeStamped<Some>(ts, new Some(l));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(TimeStamped<Option<Either<L, R>>> x1) {
                Some some;
                Either either;
                Option<Either<L, R>> option;
                Option<Either<L, R>> option2;
                TimeStamped<Option<Either<L, R>>> timeStamped = x1;
                if (timeStamped != null && None$.MODULE$.equals(option2 = timeStamped.value())) {
                    return true;
                }
                return timeStamped != null && (option = timeStamped.value()) instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Left;
            }
        });
    }

    public <F, L, R> Function1<Stream<F, TimeStamped<Option<Either<L, R>>>>, Stream<F, TimeStamped<Option<R>>>> drainLeft() {
        return (Function1 & Serializable)x$7 -> x$7.collect(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends TimeStamped<Option<Either<L, R>>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Either<L, R>> option;
                A1 A1 = x1;
                if (A1 != null && None$.MODULE$.equals(option = A1.value())) {
                    return (B1)A1;
                }
                if (A1 != null) {
                    Some some;
                    Either either;
                    FiniteDuration ts = A1.time();
                    Option<Either<L, R>> option2 = A1.value();
                    if (option2 instanceof Some && (either = (Either)(some = (Some)option2).value()) instanceof Right) {
                        Right right = (Right)either;
                        Object r = right.value();
                        return (B1)new TimeStamped<Some>(ts, new Some(r));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(TimeStamped<Option<Either<L, R>>> x1) {
                Some some;
                Either either;
                Option<Either<L, R>> option;
                Option<Either<L, R>> option2;
                TimeStamped<Option<Either<L, R>>> timeStamped = x1;
                if (timeStamped != null && None$.MODULE$.equals(option2 = timeStamped.value())) {
                    return true;
                }
                return timeStamped != null && (option = timeStamped.value()) instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Right;
            }
        });
    }

    private <F> Stream<F, TimeStamped<BoxedUnit>> timeTicks(FiniteDuration tickPeriod, boolean monotonic, GenTemporal<F, Throwable> evidence$5) {
        return Stream$.MODULE$.awakeEvery(tickPeriod, evidence$5).map((Function1 & Serializable)x$8 -> {
            if (monotonic) {
                return TimeStamped$.MODULE$.unsafeMonotonic(BoxedUnit.UNIT);
            }
            return TimeStamped$.MODULE$.unsafeRealTime(BoxedUnit.UNIT);
        });
    }

    public <F, A> Function1<Stream<F, TimeStamped<A>>, Stream<F, TimeStamped<Option<A>>>> interpolateTicks(FiniteDuration tickPeriod) {
        return (Function1 & Serializable)in -> Pull$StreamPullOps$.MODULE$.stream$extension(Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.uncons1$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(in))).flatMap((Function1 & Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                TimeStamped hd = (TimeStamped)tuple2._1();
                Stream tl = (Stream)tuple2._2();
                return Pull$.MODULE$.output1(hd.map((Function1 & Serializable)x$15 -> new Some(x$15))).$greater$greater((Function0 & Serializable)() -> TimeSeries$.go$1(hd.time().$plus(tickPeriod), tl, tickPeriod));
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError((Object)option);
        })));
    }

    public <S, I, O> Scan<S, TimeStamped<Option<I>>, TimeStamped<Option<O>>> preserve(Scan<S, I, O> t) {
        return this.preserveTicks(TimeStamped$.MODULE$.preserve(t));
    }

    public <S, I, O> Scan<S, TimeStamped<Option<I>>, TimeStamped<Option<O>>> preserveTicks(Scan<S, TimeStamped<I>, TimeStamped<O>> t) {
        return t.semilens((Function1 & Serializable)tsi -> (Either)((Option)tsi.value()).map((Function1 & Serializable)v -> package$.MODULE$.Right().apply(new TimeStamped<Object>(tsi.time(), v))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Left().apply(TimeStamped$.MODULE$.tick(tsi.time()))), (Function2 & Serializable)(x$16, tso) -> tso.map((Function1 & Serializable)x$17 -> new Some(x$17)));
    }

    public <LS, L, RS, R, O> Scan<Tuple2<LS, RS>, TimeStamped<Option<Either<L, R>>>, O> choice(Scan<LS, TimeStamped<Option<L>>, O> l, Scan<RS, TimeStamped<Option<R>>, O> r) {
        return Scan$.MODULE$.apply(new Tuple2(l.initial(), r.initial()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                TimeStamped tsv = (TimeStamped)tuple2._2();
                if (tuple22 != null) {
                    Object lState = tuple22._1();
                    Object rState = tuple22._2();
                    TimeStamped timeStamped = tsv;
                    if (timeStamped != null) {
                        Some some;
                        Either either;
                        FiniteDuration t = timeStamped.time();
                        Option option = (Option)timeStamped.value();
                        if (option instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Left) {
                            Left left = (Left)either;
                            Object lValue = left.value();
                            Tuple2 tuple23 = l.transform(lState, new TimeStamped<Some>(t, new Some(lValue)));
                            if (tuple23 == null) {
                                throw new MatchError(tuple23);
                            }
                            Object s = tuple23._1();
                            Chunk out = (Chunk)tuple23._2();
                            Tuple2 tuple24 = new Tuple2(s, (Object)out);
                            Object s2 = tuple24._1();
                            Chunk out2 = (Chunk)tuple24._2();
                            return new Tuple2((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s2), rState), (Object)out2);
                        }
                    }
                    if (timeStamped != null) {
                        Some some;
                        Either either;
                        FiniteDuration t = timeStamped.time();
                        Option option = (Option)timeStamped.value();
                        if (option instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Right) {
                            Right right = (Right)either;
                            Object rValue = right.value();
                            Tuple2 tuple25 = r.transform(rState, new TimeStamped<Some>(t, new Some(rValue)));
                            if (tuple25 == null) {
                                throw new MatchError(tuple25);
                            }
                            Object s = tuple25._1();
                            Chunk out = (Chunk)tuple25._2();
                            Tuple2 tuple26 = new Tuple2(s, (Object)out);
                            Object s3 = tuple26._1();
                            Chunk out3 = (Chunk)tuple26._2();
                            return new Tuple2((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(lState), s3), (Object)out3);
                        }
                    }
                    if (timeStamped != null) {
                        FiniteDuration t = timeStamped.time();
                        Option option = (Option)timeStamped.value();
                        if (None$.MODULE$.equals(option)) {
                            Tuple2 tuple27 = l.transform(lState, new TimeStamped<None$>(t, None$.MODULE$));
                            if (tuple27 == null) {
                                throw new MatchError(tuple27);
                            }
                            Object ls = tuple27._1();
                            Chunk lout = (Chunk)tuple27._2();
                            Tuple2 tuple28 = new Tuple2(ls, (Object)lout);
                            Object ls2 = tuple28._1();
                            Chunk lout2 = (Chunk)tuple28._2();
                            Tuple2 tuple29 = r.transform(rState, new TimeStamped<None$>(t, None$.MODULE$));
                            if (tuple29 == null) {
                                throw new MatchError(tuple29);
                            }
                            Object rs = tuple29._1();
                            Chunk rout = (Chunk)tuple29._2();
                            Tuple2 tuple210 = new Tuple2(rs, (Object)rout);
                            Object rs2 = tuple210._1();
                            Chunk rout2 = (Chunk)tuple210._2();
                            return new Tuple2((Object)new Tuple2(ls2, rs2), lout2.$plus$plus(rout2));
                        }
                    }
                    throw new MatchError((Object)timeStamped);
                }
            }
            throw new MatchError((Object)tuple2);
        }, (Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object lState = tuple2._1();
                Object rState = tuple2._2();
                return l.onComplete(lState).$plus$plus(r.onComplete(rState));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final FiniteDuration tickTime$1(int x, FiniteDuration nextTick$1, FiniteDuration tickPeriod$1) {
        return nextTick$1.$plus(package.IntMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.IntMult(x), tickPeriod$1));
    }

    public static final /* synthetic */ boolean $anonfun$interpolateTicks$2(FiniteDuration nextTick$1, TimeStamped x$9) {
        return x$9.time().$greater$eq((Object)nextTick$1);
    }

    private static final Pull go$1(FiniteDuration nextTick, Stream s, FiniteDuration tickPeriod$1) {
        return Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(s))).flatMap((Function1 & Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Chunk hd = (Chunk)tuple2._1();
                Stream tl = (Stream)tuple2._2();
                Option<Object> option2 = hd.indexWhere((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TimeSeries$.$anonfun$interpolateTicks$2(nextTick, x$9)));
                if (None$.MODULE$.equals(option2)) {
                    return Pull$.MODULE$.output(hd.map((Function1 & Serializable)x$10 -> x$10.map((Function1 & Serializable)x$11 -> new Some(x$11)))).$greater$greater((Function0 & Serializable)() -> TimeSeries$.go$1(nextTick, tl, tickPeriod$1));
                }
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int idx = BoxesRunTime.unboxToInt((Object)some2.value());
                    Tuple2 tuple22 = hd.splitAt(idx);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Chunk prefix = (Chunk)tuple22._1();
                    Chunk suffix = (Chunk)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)prefix, (Object)suffix);
                    Chunk prefix2 = (Chunk)tuple23._1();
                    Chunk suffix2 = (Chunk)tuple23._2();
                    Pull out = Pull$.MODULE$.output(prefix2.map((Function1 & Serializable)x$13 -> x$13.map((Function1 & Serializable)x$14 -> new Some(x$14))));
                    TimeStamped next = (TimeStamped)suffix2.apply(0);
                    int tickCount = (int)((next.time().toMillis() - nextTick.toMillis()) / tickPeriod$1.toMillis() + 1L);
                    Stream ticks = Stream$.MODULE$.range(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)tickCount), Numeric.IntIsIntegral$.MODULE$).map((Function1 & Serializable)i -> TimeStamped$.MODULE$.tick(TimeSeries$.tickTime$1(BoxesRunTime.unboxToInt((Object)i), nextTick, tickPeriod$1)));
                    Pull rest = Stream$ToPull$.MODULE$.echo$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(ticks))).$greater$greater((Function0 & Serializable)() -> TimeSeries$.go$1(TimeSeries$.tickTime$1(tickCount, nextTick, tickPeriod$1), tl.cons(suffix2), tickPeriod$1));
                    return out.$greater$greater((Function0 & Serializable)() -> rest);
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError((Object)option);
        });
    }

    private TimeSeries$() {
    }
}

