/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Contravariant;
import cats.Functor;
import cats.Invariant;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.effect.std.Queue$State$;
import cats.effect.std.Queue$SyncState$;
import cats.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class Queue$ {
    public static final Queue$ MODULE$ = new Queue$();
    private static final Either<Nothing$, BoxedUnit> cats$effect$std$Queue$$EitherUnit = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);

    public <F, A> F bounded(int capacity, GenConcurrent<F, ?> F) {
        this.assertNonNegative(capacity);
        if (1 < capacity && capacity < Short.MAX_VALUE * 2) {
            GenConcurrent<F, ?> genConcurrent = F;
            if (genConcurrent instanceof Async) {
                Async async = (Async)genConcurrent;
                return this.boundedForAsync(capacity, async);
            }
            return this.boundedForConcurrent(capacity, F);
        }
        if (capacity > 0) {
            return this.boundedForConcurrent(capacity, F);
        }
        return this.synchronous(F);
    }

    public <F, A> F boundedForConcurrent(int capacity, GenConcurrent<F, ?> F) {
        return (F)package.all$.MODULE$.toFunctorOps(F.ref(Queue$State$.MODULE$.empty()), F).map((Function1 & Serializable)x$1 -> new Queue.BoundedQueue(capacity, x$1, F));
    }

    public <F, A> F boundedForAsync(int capacity, Async<F> F) {
        return (F)F.delay((Function0 & Serializable)() -> new Queue.BoundedAsyncQueue(capacity, F));
    }

    public <F, A> F unboundedForConcurrent(GenConcurrent<F, ?> F) {
        return this.boundedForConcurrent(Integer.MAX_VALUE, F);
    }

    public <F, A> F unboundedForAsync(Async<F> F) {
        return (F)F.delay((Function0 & Serializable)() -> new Queue.UnboundedAsyncQueue(F));
    }

    public <F, A> F synchronous(GenConcurrent<F, ?> F) {
        return (F)package.all$.MODULE$.toFunctorOps(F.ref(Queue$SyncState$.MODULE$.empty()), F).map((Function1 & Serializable)x$2 -> new Queue.Synchronous(x$2, F));
    }

    public <F, A> F unbounded(GenConcurrent<F, ?> F) {
        GenConcurrent<F, ?> genConcurrent = F;
        if (genConcurrent instanceof Async) {
            Async async = (Async)genConcurrent;
            return this.unboundedForAsync(async);
        }
        return this.unboundedForConcurrent(F);
    }

    public <F, A> F dropping(int capacity, GenConcurrent<F, ?> F) {
        this.assertPositive(capacity, "Dropping");
        return (F)package.all$.MODULE$.toFunctorOps(F.ref(Queue$State$.MODULE$.empty()), F).map((Function1 & Serializable)x$3 -> new Queue.DroppingQueue(capacity, x$3, F));
    }

    public <F, A> F circularBuffer(int capacity, GenConcurrent<F, ?> F) {
        this.assertPositive(capacity, "CircularBuffer");
        return (F)package.all$.MODULE$.toFunctorOps(F.ref(Queue$State$.MODULE$.empty()), F).map((Function1 & Serializable)x$4 -> new Queue.CircularBufferQueue(capacity, x$4, F));
    }

    private void assertNonNegative(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Bounded queue capacity must be non-negative, was: ").append(capacity).toString());
        }
    }

    private void assertPositive(int capacity, String name) {
        if (capacity <= 0) {
            throw new IllegalArgumentException(new StringBuilder(39).append(name).append(" queue capacity must be positive, was: ").append(capacity).toString());
        }
    }

    public Either<Nothing$, BoxedUnit> cats$effect$std$Queue$$EitherUnit() {
        return cats$effect$std$Queue$$EitherUnit;
    }

    public <F> Invariant<?> catsInvariantForQueue(Functor<F> evidence$1) {
        return new Invariant<?>(evidence$1){
            public final Functor evidence$1$1;

            public <G> Invariant<?> compose(Invariant<G> evidence$1) {
                return Invariant.compose$((Invariant)this, evidence$1);
            }

            public <G> Invariant<?> composeFunctor(Functor<G> evidence$2) {
                return Invariant.composeFunctor$((Invariant)this, evidence$2);
            }

            public <G> Invariant<?> composeContravariant(Contravariant<G> evidence$3) {
                return Invariant.composeContravariant$((Invariant)this, evidence$3);
            }

            public <A, B> Queue<F, B> imap(Queue<F, A> fa, Function1<A, B> f, Function1<B, A> g) {
                return new Queue<F, B>(this, fa, g, f){
                    private final /* synthetic */ anon.3 $outer;
                    private final Queue fa$1;
                    private final Function1 g$1;
                    private final Function1 f$2;

                    public F offer(B b) {
                        return this.fa$1.offer(this.g$1.apply(b));
                    }

                    public F tryOffer(B b) {
                        return this.fa$1.tryOffer(this.g$1.apply(b));
                    }

                    public F take() {
                        return (F)package.all$.MODULE$.toFunctorOps(this.fa$1.take(), this.$outer.evidence$1$1).map(this.f$2);
                    }

                    public F tryTake() {
                        return (F)package.all$.MODULE$.toFunctorOps(this.fa$1.tryTake(), this.$outer.evidence$1$1).map((Function1 & Serializable)x$33 -> x$33.map($this.f$2));
                    }

                    public F size() {
                        return this.fa$1.size();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fa$1 = fa$1;
                        this.g$1 = g$1;
                        this.f$2 = f$2;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$tryTake$6(cats.effect.std.Queue$$anon$3$$anon$4 scala.Option )}, serializedLambda);
                    }
                };
            }
            {
                this.evidence$1$1 = evidence$1$1;
                Invariant.$init$((Invariant)this);
            }
        };
    }

    private Queue$() {
    }
}

