/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.http4sclienttest;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.implicits$;
import java.io.Serializable;
import net.shrine.config.ConfigSource$;
import net.shrine.http4s.client.Http4sHttpClient;
import net.shrine.http4s.client.Http4sHttpClient$;
import net.shrine.utilities.http4sclienttest.Http4sClientTest;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Uri;
import org.http4s.Uri$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Right;

public final class Http4sClientTest$ {
    public static final Http4sClientTest$ MODULE$ = new Http4sClientTest$();
    private static volatile boolean bitmap$init$0;

    public void main(String[] args) {
        block7: {
            try {
                String urlString;
                Either uri;
                if (args.length != 2) {
                    throw new Http4sClientTest.WrongNumberOfArguments("Requires two arguments: the http verb (PUT or GET) and the URL to call.");
                }
                String verbString = args[0];
                Either verb = Method$.MODULE$.fromString(verbString);
                Tuple2 tuple2 = new Tuple2((Object)verb, (Object)(uri = Uri$.MODULE$.fromString(urlString = args[1])));
                if (tuple2 != null) {
                    Either either = (Either)tuple2._1();
                    Either either2 = (Either)tuple2._2();
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        Method v = (Method)right.value();
                        if (either2 instanceof Right) {
                            Right right2 = (Right)either2;
                            Uri u = (Uri)right2.value();
                            IO<String> requestResponseIo = this.testHttpRequest(v, u);
                            requestResponseIo.unsafeRunTimed(new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds(), implicits$.MODULE$.global()).fold((Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.println((Object)"No response after 30 seconds"), (Function1 & Serializable)x$1 -> {
                                Predef$.MODULE$.println((Object)x$1);
                                return BoxedUnit.UNIT;
                            });
                            System.exit(0);
                            break block7;
                        }
                    }
                }
                Predef$.MODULE$.println((Object)new StringBuilder(26).append("something went wrong with ").append(tuple2).toString());
            }
            catch (Http4sClientTest.WrongNumberOfArguments wrongNumberOfArguments) {
                this.printUsage();
                System.exit(1);
            }
            catch (Throwable x) {
                x.printStackTrace();
                System.exit(2);
            }
        }
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Usage: ./http4sClientTest VERB URL\n        |\n        |Try the URL using the http VERB via the http4s client. This is primarily meant to test the http4s client in\n        |environments with https client-side proxies, and to detect other potential barriers between a downstream node\n        |and a hub in a SHRINE network.\n        |\n        |Exit codes: 0 success\n        |            1 known error\n        |            2 unknown error (with an accompanying stack trace).\n        |\n        |Examples:\n        |./http4sClientTest GET https://shrine-dev-hub.catalyst.harvard.edu:6443/shrine-api/hub/ping\n        |./http4sClientTest PUT https://shrine-dev-hub.catalyst.harvard.edu:6443/shrine-api/mom/createQueue/HarmlessTestQueue\n      ")));
    }

    public IO<String> testHttpRequest(Method verb, Uri uri) {
        Request request = Request$.MODULE$.apply(verb, uri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6());
        Http4sHttpClient http4sHttpClient = Http4sHttpClient$.MODULE$.apply(ConfigSource$.MODULE$.config().getConfig("shrine.hub.client"), Http4sHttpClient$.MODULE$.apply$default$2(), Http4sHttpClient$.MODULE$.apply$default$3());
        return http4sHttpClient.webFetchAndDecodeIO(request, (Function2 & Serializable)(status, bodyString) -> IO$.MODULE$.apply((Function0 & Serializable)() -> new StringBuilder(10).append("Received ").append(status).append(" ").append((String)bodyString).toString()));
    }

    private Http4sClientTest$() {
    }
}

