/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsResponse;

public class CreateTopicsRequest
extends AbstractRequest {
    private final CreateTopicsRequestData data;
    public static final int NO_NUM_PARTITIONS = -1;
    public static final short NO_REPLICATION_FACTOR = -1;

    public CreateTopicsRequest(CreateTopicsRequestData data, short version) {
        super(ApiKeys.CREATE_TOPICS, version);
        this.data = data;
    }

    @Override
    public CreateTopicsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        CreateTopicsResponseData response = new CreateTopicsResponseData();
        if (this.version() >= 2) {
            response.setThrottleTimeMs(throttleTimeMs);
        }
        ApiError apiError = ApiError.fromThrowable(e);
        for (CreateTopicsRequestData.CreatableTopic topic : this.data.topics()) {
            response.topics().add(new CreateTopicsResponseData.CreatableTopicResult().setName(topic.name()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
        }
        return new CreateTopicsResponse(response);
    }

    public static CreateTopicsRequest parse(ByteBuffer buffer, short version) {
        return new CreateTopicsRequest(new CreateTopicsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateTopicsRequest> {
        private final CreateTopicsRequestData data;

        public Builder(CreateTopicsRequestData data) {
            super(ApiKeys.CREATE_TOPICS);
            this.data = data;
        }

        @Override
        public CreateTopicsRequest build(short version) {
            if (this.data.validateOnly() && version == 0) {
                throw new UnsupportedVersionException("validateOnly is not supported in version 0 of CreateTopicsRequest");
            }
            List topicsWithDefaults = this.data.topics().stream().filter(topic -> topic.assignments().isEmpty()).filter(topic -> topic.numPartitions() == -1 || topic.replicationFactor() == -1).map(CreateTopicsRequestData.CreatableTopic::name).collect(Collectors.toList());
            if (!topicsWithDefaults.isEmpty() && version < 4) {
                throw new UnsupportedVersionException("Creating topics with default partitions/replication factor are only supported in CreateTopicRequest version 4+. The following topics need values for partitions and replicas: " + topicsWithDefaults);
            }
            return new CreateTopicsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }

        public boolean equals(Object other) {
            return other instanceof Builder && this.data.equals(((Builder)other).data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }
}

