/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.internal;

import cats.ApplicativeError;
import cats.Functor;
import cats.effect.kernel.GenConcurrent;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.text$;
import java.io.Serializable;
import org.http4s.Charset;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.internal.PosixQuoting$;
import org.typelevel.ci.CIString;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class CurlConverter$ {
    public static final CurlConverter$ MODULE$ = new CurlConverter$();

    private String newline() {
        return " \\\n  ";
    }

    private String prepareMethodName(Method method) {
        return new StringBuilder(10).append(this.newline()).append("--request ").append(method.name()).toString();
    }

    private String prepareUri(Uri uri) {
        return new StringBuilder(6).append(this.newline()).append("--url ").append(PosixQuoting$.MODULE$.quote(uri.renderString())).toString();
    }

    private String prepareHeaders(List<Header.Raw> headers, Function1<CIString, Object> redactHeadersWhen) {
        String preparedHeaders = Headers$.MODULE$.redactSensitive$extension(headers, redactHeadersWhen).iterator().map((Function1 & Serializable)header -> new StringBuilder(9).append("--header ").append(PosixQuoting$.MODULE$.quote(new StringBuilder(2).append(header.name()).append(": ").append(header.value()).toString())).toString()).mkString(this.newline());
        if (preparedHeaders.isEmpty()) {
            return "";
        }
        return new StringBuilder(0).append(this.newline()).append(preparedHeaders).toString();
    }

    public <F> String requestToCurlWithoutBody(Request<F> request, Function1<CIString, Object> redactHeadersWhen) {
        String params = new .colon.colon((Object)this.prepareMethodName(request.method()), (List)new .colon.colon((Object)this.prepareUri(request.uri()), (List)new .colon.colon((Object)this.prepareHeaders((List<Header.Raw>)request.headers(), redactHeadersWhen), (List)Nil$.MODULE$))).mkString();
        return new StringBuilder(4).append("curl").append(params).toString();
    }

    public <F> F requestToCurlWithBody(Request<F> request, Function1<CIString, Object> redactHeadersWhen, GenConcurrent<F, Throwable> evidence$1, Charset defaultCharset) {
        return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(request.body().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(evidence$1))).toVector(), evidence$1).map((Function1 & Serializable)x$1 -> Stream$.MODULE$.emits((Seq)x$1)), evidence$1).flatMap((Function1 & Serializable)cachedBodyStream -> {
            java.nio.charset.Charset cs = ((Charset)request.charset().getOrElse((Function0 & Serializable)() -> defaultCharset)).nioCharset();
            return package.all$.MODULE$.toFunctorOps(cachedBodyStream.through(text$.MODULE$.decodeWithCharset(cs, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)evidence$1))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(evidence$1))).string((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Functor)evidence$1).map((Function1 & Serializable)bodyString -> {
                String bodyArg = bodyString.isEmpty() ? "" : new StringBuilder(7).append(MODULE$.newline()).append("--data ").append(PosixQuoting$.MODULE$.quote((String)bodyString)).toString();
                String curl = new StringBuilder(0).append(request.asCurl(redactHeadersWhen)).append(bodyArg).toString();
                Request refreshedRequest = (Request)request.withBodyStream((Stream)cachedBodyStream);
                return new Tuple2((Object)curl, (Object)refreshedRequest);
            });
        });
    }

    private CurlConverter$() {
    }
}

