/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.implicits$;
import ch.qos.logback.classic.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import net.shrine.adapter.QueryQueuedTimeToLiveExceeded;
import net.shrine.adapter.QueryResultNotAvailable;
import net.shrine.adapter.QueuedQueryInterrogator;
import net.shrine.adapter.QueuedQueryInterrogator$;
import net.shrine.adapter.dao.QueryResultStatus;
import net.shrine.adapter.i2b2Protocol.ErrorResponse;
import net.shrine.adapter.i2b2Protocol.ReadInstanceResultsResponse;
import net.shrine.adapter.i2b2Protocol.ReadQueryInstancesResponse;
import net.shrine.adapter.i2b2Protocol.ReadQueryResultResponse;
import net.shrine.adapter.i2b2Protocol.ShrineResponse;
import net.shrine.config.ConfigSource$;
import net.shrine.config.package$;
import net.shrine.http4s.catsio.RepeatedIOTask;
import net.shrine.http4s.catsio.RepeatedIOTask$;
import net.shrine.hub.mom.ShrineMomClient$;
import net.shrine.log.Loggable;
import net.shrine.problem.JsonProblemDigest;
import net.shrine.problem.JsonProblemDigest$;
import net.shrine.problem.Problem;
import net.shrine.problem.RawProblem;
import net.shrine.protocol.i2b2.AuthenticationInfo;
import net.shrine.protocol.i2b2.AuthenticationInfo$;
import net.shrine.protocol.i2b2.QueryResult;
import net.shrine.protocol.version.DateStamp$;
import net.shrine.protocol.version.EnvelopeContents;
import net.shrine.protocol.version.EnvelopeContentsCompanion;
import net.shrine.protocol.version.Id;
import net.shrine.protocol.version.NodeKey$;
import net.shrine.protocol.version.QueryId;
import net.shrine.protocol.version.v2.ResultStatus;
import net.shrine.protocol.version.v2.UpdateCrcQueuedResult;
import net.shrine.protocol.version.v2.UpdateCrcQueuedResult$;
import net.shrine.protocol.version.v2.UpdateCrcQueuedResultWithError;
import net.shrine.protocol.version.v2.UpdateCrcQueuedResultWithError$;
import net.shrine.protocol.version.v2.UpdateCrcQueuedResultWithProgress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.UninitializedFieldError;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class QueuedQueriesPoller$
implements Loggable {
    public static final QueuedQueriesPoller$ MODULE$ = new QueuedQueriesPoller$();
    private static QueuedQueryInterrogator readQueryResultAdapter;
    private static final FiniteDuration queuedQueryTimeToLive;
    private static final FiniteDuration queuedQueryPollInterval;
    private static final FiniteDuration queuedQueryRestTimeBeforePolling;
    private static final FiniteDuration queuedQueryCrcPollHttpCallTimeout;
    private static final FiniteDuration crcRunQueryTimeLimit;
    private static final RepeatedIOTask scheduler;
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile byte bitmap$init$0;
    private static volatile byte bitmap$0;

    static {
        Loggable.$init$((Loggable)MODULE$);
        queuedQueryTimeToLive = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.queuedQueryTimeToLive");
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        queuedQueryPollInterval = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.queuedQueryPollInterval");
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        queuedQueryRestTimeBeforePolling = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.queuedQueryRestTimeBeforePolling");
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        queuedQueryCrcPollHttpCallTimeout = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.queuedQueryCrcPollHttpCallTimeout");
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
        crcRunQueryTimeLimit = package$.MODULE$.ConfigExtensions(ConfigSource$.MODULE$.config()).getFiniteDuration("shrine.adapter.crcRunQueryTimeLimit");
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x10);
        scheduler = RepeatedIOTask$.MODULE$.scheduleIndefinitely(MODULE$.queuedQueryRestTimeBeforePolling(), MODULE$.queuedQueryPollInterval(), (Function0 & Serializable)() -> MODULE$.checkForQueuedQueries(), "QueuedQueriesPoller");
        bitmap$init$0 = (byte)(bitmap$init$0 | 0x20);
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        QueuedQueriesPoller$ queuedQueriesPoller$ = this;
        synchronized (queuedQueriesPoller$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.net$shrine$log$Loggable$$internalLogger$lzycompute();
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public FiniteDuration queuedQueryTimeToLive() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueuedQueriesPoller.scala: 30");
        }
        return queuedQueryTimeToLive;
    }

    private FiniteDuration queuedQueryPollInterval() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueuedQueriesPoller.scala: 32");
        }
        return queuedQueryPollInterval;
    }

    private FiniteDuration queuedQueryRestTimeBeforePolling() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueuedQueriesPoller.scala: 34");
        }
        return queuedQueryRestTimeBeforePolling;
    }

    private FiniteDuration queuedQueryCrcPollHttpCallTimeout() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueuedQueriesPoller.scala: 36");
        }
        return queuedQueryCrcPollHttpCallTimeout;
    }

    public FiniteDuration crcRunQueryTimeLimit() {
        if ((byte)(bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueuedQueriesPoller.scala: 38");
        }
        return crcRunQueryTimeLimit;
    }

    private RepeatedIOTask scheduler() {
        if ((byte)(bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: QueuedQueriesPoller.scala: 40");
        }
        return scheduler;
    }

    public IO<BoxedUnit> startIO() {
        return this.scheduler().startIO();
    }

    public IO<BoxedUnit> stopIO() {
        return this.scheduler().stopIO();
    }

    private QueuedQueryInterrogator readQueryResultAdapter$lzycompute() {
        QueuedQueriesPoller$ queuedQueriesPoller$ = this;
        synchronized (queuedQueriesPoller$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                readQueryResultAdapter = QueuedQueryInterrogator$.MODULE$.apply(ConfigSource$.MODULE$.config());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return readQueryResultAdapter;
    }

    private QueuedQueryInterrogator readQueryResultAdapter() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.readQueryResultAdapter$lzycompute();
        }
        return readQueryResultAdapter;
    }

    private IO<BoxedUnit> checkForQueuedQueries() {
        IO queuedQueriesIO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.info((Function0<String>)(Function0 & Serializable)() -> "Starting checkForQueuedQueries")).flatMap((Function1 & Serializable)x$1 -> MODULE$.readQueryResultAdapter().selectQueuedQueryIds());
        IO oldEnoughIO = queuedQueriesIO.map((Function1 & Serializable)queuedQueries -> {
            MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(25).append("Found ").append(queuedQueries.size()).append(" queries to check: ").append(queuedQueries.mkString(", ")).toString());
            long now = System.currentTimeMillis();
            return (Seq)queuedQueries.filter((Function1 & Serializable)queuedQuery -> BoxesRunTime.boxToBoolean((boolean)QueuedQueriesPoller$.$anonfun$checkForQueuedQueries$6(now, queuedQuery)));
        });
        return oldEnoughIO.flatMap((Function1 & Serializable)oldEnough -> {
            Seq oldQueryIds = (Seq)((SeqOps)oldEnough.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.networkQueryId()))).distinct();
            Seq oldEnoughAndDistinct = (Seq)oldQueryIds.flatMap((Function1 & Serializable)id -> oldEnough.collectFirst((PartialFunction)new Serializable(BoxesRunTime.unboxToLong((Object)id)){
                private static final long serialVersionUID = 0L;
                private final long id$1;

                public final <A1 extends QueryResultStatus, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1;
                    A1 A12 = x1;
                    if (A12 != null && (A1 = A12).networkQueryId() == this.id$1) {
                        return (B1)A1;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(QueryResultStatus x1) {
                    QueryResultStatus queryResultStatus;
                    QueryResultStatus queryResultStatus2 = x1;
                    return queryResultStatus2 != null && (queryResultStatus = queryResultStatus2).networkQueryId() == this.id$1;
                }
                {
                    this.id$1 = id$1;
                }
            }));
            MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Found ").append(oldEnoughAndDistinct.size()).append(" queries old enough to check: ").append(oldEnoughAndDistinct.mkString(", ")).toString());
            Seq askCrcIOs = (Seq)oldEnoughAndDistinct.map((Function1 & Serializable)queuedQuery -> {
                MODULE$.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Will ask the CRC about query ").append(queuedQuery.networkQueryId()).toString());
                AuthenticationInfo auth = AuthenticationInfo$.MODULE$.noPassword(queuedQuery.username(), queuedQuery.domain());
                return MODULE$.readQueryResultAdapter().askCrc(queuedQuery.networkQueryId(), (Duration)MODULE$.queuedQueryCrcPollHttpCallTimeout(), auth).flatMap((Function1 & Serializable)x$3 -> MODULE$.interpretAndMaybeSendAnUpdate((QueryResultStatus)queuedQuery, (Either<ErrorResponse, ShrineResponse>)x$3)).handleErrorWith((Function1 & Serializable)x0$1 -> {
                    Option option;
                    Throwable throwable = x0$1;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable x = (Throwable)option.get();
                        return IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Caught exception in QueuedQueriesPoller while checking on query ").append(queuedQuery.networkQueryId()).toString(), x));
                    }
                    throw new MatchError((Object)throwable);
                });
            });
            Seq itOfStreams = (Seq)askCrcIOs.map((Function1 & Serializable)fo -> Stream$.MODULE$.eval(fo));
            IO seqResultStatus = (IO)((Stream)itOfStreams.foldLeft((Object)Stream$.MODULE$.empty(), (Function2 & Serializable)(soFar, next) -> soFar.append((Function0 & Serializable)() -> next))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
            return seqResultStatus.flatMap((Function1 & Serializable)x$4 -> IO$.MODULE$.unit());
        }).handleErrorWith((Function1 & Serializable)x0$2 -> {
            Option option;
            Throwable throwable = x0$2;
            if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                Throwable x = (Throwable)option.get();
                MODULE$.error((Function0<String>)(Function0 & Serializable)() -> "Caught exception in QueuedQueriesPoller.checkForQueuedQueries", x);
                return IO$.MODULE$.unit();
            }
            throw new MatchError((Object)throwable);
        });
    }

    private IO<BoxedUnit> interpretAndMaybeSendAnUpdate(QueryResultStatus oldQueryResult, Either<ErrorResponse, ShrineResponse> crcResponse) {
        long queryId = oldQueryResult.networkQueryId();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(15).append(new QueryId(queryId)).append("'s response is ").append(crcResponse).toString());
        IO maybeUpdateFromCrcIO = (IO)crcResponse.fold((Function1 & Serializable)errorResponse -> MODULE$.readQueryResultAdapter().storeErrorFromShrineIO(oldQueryResult, errorResponse.problem()).map((Function1 & Serializable)x$5 -> {
            Problem problem = errorResponse.problem();
            if (problem instanceof QueryResultNotAvailable) {
                QueryResultNotAvailable queryResultNotAvailable = (QueryResultNotAvailable)problem;
                MODULE$.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(128).append("Not reporting ").append(queryResultNotAvailable).append(" to the hub. If it is recurring please set the status for this query to FINISHED in the ADAPTER.QUERY_RESULT table").toString());
                return None$.MODULE$;
            }
            if (problem instanceof RawProblem) {
                RawProblem rawProblem = (RawProblem)problem;
                long x$1 = queryId;
                String x$2 = NodeKey$.MODULE$.localNodeKey();
                JsonProblemDigest x$3 = JsonProblemDigest$.MODULE$.apply(rawProblem);
                ResultStatus.ErrorFromCrc$ x$4 = ResultStatus.ErrorFromCrc$.MODULE$;
                Option x$52 = Option$.MODULE$.apply((Object)errorResponse.errorMessage());
                long x$6 = DateStamp$.MODULE$.now();
                Option x$7 = UpdateCrcQueuedResultWithError$.MODULE$.apply$default$6();
                UpdateCrcQueuedResultWithError updateWithError = new UpdateCrcQueuedResultWithError(x$1, x$2, x$3, (ResultStatus)x$4, x$52, x$7, x$6);
                return Option$.MODULE$.apply((Object)updateWithError);
            }
            throw new IllegalStateException("Error response problems must be subclasses of RawProblem");
        }), (Function1 & Serializable)shrineResponse -> {
            Option option;
            MODULE$.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("interpretAndMaybeSendAnUpdate shrineResponse is ").append(shrineResponse).toString());
            ShrineResponse shrineResponse2 = shrineResponse;
            if (shrineResponse2 instanceof ReadQueryResultResponse) {
                ReadQueryResultResponse readQueryResultResponse = (ReadQueryResultResponse)shrineResponse2;
                UpdateCrcQueuedResult updateResult = readQueryResultResponse.singleNodeResult().createUpdateCrcQueuedResult(queryId, readQueryResultResponse.queryId(), MODULE$.readQueryResultAdapter().obfuscator().obfuscatorParameters());
                if (updateResult.status().isFinal()) {
                    UpdateCrcQueuedResult updateCrcQueuedResult = updateResult;
                    if (updateCrcQueuedResult instanceof UpdateCrcQueuedResultWithError) {
                        UpdateCrcQueuedResultWithError updateCrcQueuedResultWithError = (UpdateCrcQueuedResultWithError)updateCrcQueuedResult;
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)MODULE$.readQueryResultAdapter().storeErrorFromShrineIO(oldQueryResult, (Problem)updateCrcQueuedResultWithError.problem()).unsafeRunSync(implicits$.MODULE$.global());
                    }
                    option = Option$.MODULE$.apply((Object)updateResult);
                } else {
                    option = None$.MODULE$;
                }
            } else if (shrineResponse2 instanceof ReadInstanceResultsResponse) {
                ReadInstanceResultsResponse readInstanceResultsResponse = (ReadInstanceResultsResponse)shrineResponse2;
                UpdateCrcQueuedResult updateResult = ((QueryResult)readInstanceResultsResponse.results().head()).createUpdateCrcQueuedResult(queryId, ((QueryResult)readInstanceResultsResponse.results().head()).resultId(), MODULE$.readQueryResultAdapter().obfuscator().obfuscatorParameters());
                UpdateCrcQueuedResult updateCrcQueuedResult = updateResult;
                if (updateCrcQueuedResult instanceof UpdateCrcQueuedResultWithError) {
                    UpdateCrcQueuedResultWithError updateCrcQueuedResultWithError = (UpdateCrcQueuedResultWithError)updateCrcQueuedResult;
                    MODULE$.readQueryResultAdapter().storeErrorFromShrineIO(oldQueryResult, (Problem)updateCrcQueuedResultWithError.problem()).unsafeRunSync(implicits$.MODULE$.global());
                    option = Option$.MODULE$.apply((Object)updateCrcQueuedResultWithError);
                } else {
                    option = None$.MODULE$;
                }
            } else if (shrineResponse2 instanceof ReadQueryInstancesResponse) {
                ReadQueryInstancesResponse readQueryInstancesResponse = (ReadQueryInstancesResponse)shrineResponse2;
                Option maybeUpdateResult = readQueryInstancesResponse.createUpdateResult(queryId);
                maybeUpdateResult.foreach((Function1 & Serializable)x0$1 -> {
                    QueuedQueriesPoller$.$anonfun$interpretAndMaybeSendAnUpdate$7(oldQueryResult, x0$1);
                    return BoxedUnit.UNIT;
                });
                option = maybeUpdateResult;
            } else {
                throw new IllegalArgumentException(new StringBuilder(24).append("Code does not handle a ").append(shrineResponse.getClass().getSimpleName()).append(" ").append(shrineResponse).toString());
            }
            Option maybeUpdateResultFromCrc = option;
            return IO$.MODULE$.apply((Function0 & Serializable)() -> maybeUpdateResultFromCrc);
        });
        IO maybeUpdateIO = maybeUpdateFromCrcIO.map((Function1 & Serializable)maybeUpdateFromCrc -> (Option)maybeUpdateFromCrc.fold((Function0 & Serializable)() -> MODULE$.maybeQueryTooOld(oldQueryResult), (Function1 & Serializable)x0$2 -> {
            UpdateCrcQueuedResult updateCrcQueuedResult = x0$2;
            if (updateCrcQueuedResult instanceof UpdateCrcQueuedResultWithProgress) {
                UpdateCrcQueuedResultWithProgress updateCrcQueuedResultWithProgress = (UpdateCrcQueuedResultWithProgress)updateCrcQueuedResult;
                return MODULE$.maybeQueryTooOld(oldQueryResult).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)updateCrcQueuedResultWithProgress));
            }
            return Option$.MODULE$.apply((Object)updateCrcQueuedResult);
        }));
        return maybeUpdateIO.flatMap((Function1 & Serializable)maybeUpdate -> (IO)maybeUpdate.fold((Function0 & Serializable)() -> IO$.MODULE$.unit(), (Function1 & Serializable)updateResult -> MODULE$.sendUpdateResultMessageIO((UpdateCrcQueuedResult)updateResult)));
    }

    private Option<UpdateCrcQueuedResult> maybeQueryTooOld(QueryResultStatus oldQueryResult) {
        long now = System.currentTimeMillis();
        if (now - oldQueryResult.timestamp().getTime() > this.queuedQueryTimeToLive().toMillis()) {
            long queryId = oldQueryResult.networkQueryId();
            QueryQueuedTimeToLiveExceeded problem = new QueryQueuedTimeToLiveExceeded(queryId, this.queuedQueryTimeToLive());
            this.readQueryResultAdapter().storeErrorFromShrineIO(oldQueryResult, (Problem)problem).unsafeRunSync(implicits$.MODULE$.global());
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("should have stored 'too old' error for ").append(new QueryId(queryId)).toString());
            long x$1 = queryId;
            String x$2 = NodeKey$.MODULE$.localNodeKey();
            JsonProblemDigest x$3 = JsonProblemDigest$.MODULE$.apply((RawProblem)problem);
            ResultStatus.ErrorFromCrc$ x$4 = ResultStatus.ErrorFromCrc$.MODULE$;
            Option x$5 = Option$.MODULE$.apply((Object)problem.description());
            long x$6 = DateStamp$.MODULE$.now();
            Option x$7 = UpdateCrcQueuedResultWithError$.MODULE$.apply$default$6();
            return Option$.MODULE$.apply((Object)new UpdateCrcQueuedResultWithError(x$1, x$2, x$3, (ResultStatus)x$4, x$5, x$7, x$6));
        }
        return None$.MODULE$;
    }

    private IO<BoxedUnit> sendUpdateResultMessageIO(UpdateCrcQueuedResult updateResult) {
        return ShrineMomClient$.MODULE$.sendToHubIO((Id)new QueryId(updateResult.queryId()), (EnvelopeContents)updateResult, (EnvelopeContentsCompanion)UpdateCrcQueuedResult$.MODULE$, new StringBuilder(29).append(" updateResult for ").append(new QueryId(updateResult.queryId())).append(" to the hub").toString());
    }

    public static final /* synthetic */ boolean $anonfun$checkForQueuedQueries$6(long now$1, QueryResultStatus queuedQuery) {
        return now$1 - queuedQuery.timestamp().getTime() > MODULE$.queuedQueryRestTimeBeforePolling().toMillis() + MODULE$.crcRunQueryTimeLimit().toMillis();
    }

    public static final /* synthetic */ void $anonfun$interpretAndMaybeSendAnUpdate$7(QueryResultStatus oldQueryResult$1, UpdateCrcQueuedResult x0$1) {
        UpdateCrcQueuedResult updateCrcQueuedResult = x0$1;
        if (updateCrcQueuedResult instanceof UpdateCrcQueuedResultWithError) {
            UpdateCrcQueuedResultWithError updateCrcQueuedResultWithError = (UpdateCrcQueuedResultWithError)updateCrcQueuedResult;
            BoxedUnit cfr_ignored_0 = (BoxedUnit)MODULE$.readQueryResultAdapter().storeErrorFromShrineIO(oldQueryResult$1, (Problem)updateCrcQueuedResultWithError.problem()).unsafeRunSync(implicits$.MODULE$.global());
            return;
        }
    }

    private QueuedQueriesPoller$() {
    }
}

