/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.adapter.i2b2Protocol;

import java.io.Serializable;
import net.shrine.adapter.i2b2Protocol.RunQueryRequest;
import net.shrine.adapter.i2b2Protocol.ShrineRequestUnmarshaller;
import net.shrine.adapter.i2b2Protocol.XmlNodeName;
import net.shrine.adapter.i2b2Protocol.XmlNodeName$;
import net.shrine.crypto.SecureRandomSource$;
import net.shrine.protocol.i2b2.AuthenticationInfo;
import net.shrine.protocol.i2b2.I2b2XmlUnmarshaller;
import net.shrine.protocol.i2b2.RequestHeader;
import net.shrine.protocol.i2b2.ResultOutputType;
import net.shrine.protocol.i2b2.ResultOutputType$;
import net.shrine.protocol.i2b2.ShrineXmlUnmarshaller;
import net.shrine.protocol.i2b2.query.I2b2QueryDefinition;
import net.shrine.protocol.i2b2.query.I2b2QueryDefinition$;
import net.shrine.protocol.i2b2.serialization.I2b2UnmarshallingHelpers;
import net.shrine.util.Tries$;
import net.shrine.xml.NodeSeqEnrichments;
import net.shrine.xml.XmlUtil$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;

public final class RunQueryRequest$
implements I2b2XmlUnmarshaller<RunQueryRequest>,
ShrineXmlUnmarshaller<RunQueryRequest>,
ShrineRequestUnmarshaller,
I2b2UnmarshallingHelpers,
Serializable {
    public static final RunQueryRequest$ MODULE$ = new RunQueryRequest$();
    private static final String neededI2b2Namespace;
    private static volatile boolean bitmap$init$0;

    static {
        I2b2XmlUnmarshaller.$init$((I2b2XmlUnmarshaller)MODULE$);
        ShrineXmlUnmarshaller.$init$((ShrineXmlUnmarshaller)MODULE$);
        ShrineRequestUnmarshaller.$init$(MODULE$);
        I2b2UnmarshallingHelpers.$init$((I2b2UnmarshallingHelpers)MODULE$);
        neededI2b2Namespace = "http://www.i2b2.org/xsd/cell/crc/psm/1.1/";
        bitmap$init$0 = true;
    }

    public final Try<RequestHeader> i2b2Header(NodeSeq xml) {
        return I2b2UnmarshallingHelpers.i2b2Header$((I2b2UnmarshallingHelpers)this, (NodeSeq)xml);
    }

    public final Try<String> i2b2ProjectId(NodeSeq xml) {
        return I2b2UnmarshallingHelpers.i2b2ProjectId$((I2b2UnmarshallingHelpers)this, (NodeSeq)xml);
    }

    public final Try<Duration> i2b2WaitTime(NodeSeq xml) {
        return I2b2UnmarshallingHelpers.i2b2WaitTime$((I2b2UnmarshallingHelpers)this, (NodeSeq)xml);
    }

    public final Try<AuthenticationInfo> i2b2AuthenticationInfo(NodeSeq xml) {
        return I2b2UnmarshallingHelpers.i2b2AuthenticationInfo$((I2b2UnmarshallingHelpers)this, (NodeSeq)xml);
    }

    @Override
    public final Try<RequestHeader> shrineHeader(NodeSeq xml) {
        return ShrineRequestUnmarshaller.shrineHeader$(this, xml);
    }

    @Override
    public final Try<String> shrineProjectId(NodeSeq xml) {
        return ShrineRequestUnmarshaller.shrineProjectId$(this, xml);
    }

    @Override
    public final Try<Duration> shrineWaitTime(NodeSeq xml) {
        return ShrineRequestUnmarshaller.shrineWaitTime$(this, xml);
    }

    @Override
    public final Try<AuthenticationInfo> shrineAuthenticationInfo(NodeSeq xml) {
        return ShrineRequestUnmarshaller.shrineAuthenticationInfo$(this, xml);
    }

    public Try<RunQueryRequest> fromXmlString(Set<ResultOutputType> breakdownTypes, String xmlString) {
        return ShrineXmlUnmarshaller.fromXmlString$((ShrineXmlUnmarshaller)this, breakdownTypes, (String)xmlString);
    }

    public Try<RunQueryRequest> fromI2b2String(Set<ResultOutputType> breakdownTypes, String xmlString) {
        return I2b2XmlUnmarshaller.fromI2b2String$((I2b2XmlUnmarshaller)this, breakdownTypes, (String)xmlString);
    }

    public Option<XmlNodeName> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public RunQueryRequest apply(String projectId, Duration waitTime, AuthenticationInfo authn, Set<ResultOutputType> outputTypes, I2b2QueryDefinition queryDefinition) {
        return new RunQueryRequest(projectId, waitTime, authn, SecureRandomSource$.MODULE$.nextId(), outputTypes, queryDefinition, this.apply$default$7());
    }

    public Option<XmlNodeName> apply$default$7() {
        return None$.MODULE$;
    }

    public String neededI2b2Namespace() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: RunQueryRequest.scala: 103");
        }
        return neededI2b2Namespace;
    }

    public Try<RunQueryRequest> fromI2b2(Set<ResultOutputType> breakdownTypes, NodeSeq xml) {
        NodeSeq queryDefNode = xml.$bslash("message_body").$bslash("request").$bslash("query_definition");
        Node node = (Node)queryDefNode.head();
        if (!(node instanceof Elem)) {
            throw new Exception(new StringBuilder(106).append("When unmarshalling a RunQueryRequest, encountered unexpected XML: '").append(queryDefNode).append("', <query_definition> might be missing.").toString());
        }
        Elem elem = (Elem)node;
        Elem queryDefXml = elem.copy(elem.scope().getPrefix(this.neededI2b2Namespace()), elem.copy$default$2(), elem.copy$default$3(), elem.copy$default$4(), elem.copy$default$5(), elem.copy$default$6());
        Try attempt = this.i2b2ProjectId(xml).flatMap((Function1 & Serializable)projectId -> MODULE$.i2b2WaitTime(xml).flatMap((Function1 & Serializable)waitTime -> MODULE$.i2b2AuthenticationInfo(xml).map((Function1 & Serializable)authn -> {
            Set<ResultOutputType> outputTypes = MODULE$.determineI2b2OutputTypes(breakdownTypes, xml.$bslash("message_body").$bslash("request").$bslash("result_output_list"));
            return new Tuple2(authn, outputTypes);
        }).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 != null) {
                AuthenticationInfo authn = (AuthenticationInfo)tuple2._1();
                Set outputTypes = (Set)tuple2._2();
                return I2b2QueryDefinition$.MODULE$.fromI2b2((NodeSeq)queryDefXml).map((Function1 & Serializable)queryDef -> MODULE$.apply((String)projectId, (Duration)waitTime, authn, (Set<ResultOutputType>)outputTypes, (I2b2QueryDefinition)queryDef));
            }
            throw new MatchError((Object)tuple2);
        })));
        return attempt.map((Function1 & Serializable)req -> MODULE$.addPatientCountXmlIfNecessary((RunQueryRequest)req));
    }

    private Set<ResultOutputType> determineI2b2OutputTypes(Set<ResultOutputType> breakdownTypes, NodeSeq nodeSeq) {
        Seq sequence = (Seq)nodeSeq.$bslash("result_output").flatMap((Function1 & Serializable)breakdownXml -> {
            String breakdownName = XmlUtil$.MODULE$.trim(breakdownXml.$bslash("@name"));
            return ResultOutputType$.MODULE$.valueOf(breakdownTypes, breakdownName);
        });
        return sequence.toSet();
    }

    private Set<ResultOutputType> determineShrineOutputTypes(NodeSeq nodeSeq) {
        Seq attempts = (Seq)nodeSeq.$bslash("resultType").map((Function1 & Serializable)xml -> ResultOutputType$.MODULE$.fromXml(xml));
        return (Set)Tries$.MODULE$.sequence((Iterable)attempts).map((Function1 & Serializable)x$8 -> x$8.toSet()).get();
    }

    public RunQueryRequest addPatientCountXmlIfNecessary(RunQueryRequest req) {
        if (req.outputTypes().contains((Object)ResultOutputType$.MODULE$.PATIENT_COUNT_XML())) {
            return req;
        }
        Set x$1 = (Set)req.outputTypes().$plus((Object)ResultOutputType$.MODULE$.PATIENT_COUNT_XML());
        String x$2 = req.copy$default$1();
        Duration x$3 = req.copy$default$2();
        AuthenticationInfo x$4 = req.copy$default$3();
        long x$5 = req.copy$default$4();
        I2b2QueryDefinition x$6 = req.copy$default$6();
        Option<XmlNodeName> x$7 = req.copy$default$7();
        return req.copy(x$2, x$3, x$4, x$5, (Set<ResultOutputType>)x$1, x$6, x$7);
    }

    public Try<RunQueryRequest> fromXml(Set<ResultOutputType> breakdownTypes, NodeSeq xml) {
        Try attempt = this.shrineProjectId(xml).flatMap((Function1 & Serializable)projectId -> MODULE$.shrineWaitTime(xml).flatMap((Function1 & Serializable)waitTime -> MODULE$.shrineAuthenticationInfo(xml).flatMap((Function1 & Serializable)authn -> NodeSeqEnrichments.Strictness$.HasStrictNodeSeqEnrichments$.MODULE$.withChild$extension(NodeSeqEnrichments.Strictness$.MODULE$.HasStrictNodeSeqEnrichments(xml), "queryId").map((Function1 & Serializable)xml -> BoxesRunTime.boxToLong((long)XmlUtil$.MODULE$.toLong(xml))).flatMap((Function1 & Serializable)queryId -> RunQueryRequest$.$anonfun$fromXml$5(xml, projectId, waitTime, authn, BoxesRunTime.unboxToLong((Object)queryId))))));
        return attempt.map((Function1 & Serializable)req -> MODULE$.addPatientCountXmlIfNecessary((RunQueryRequest)req));
    }

    public RunQueryRequest apply(String projectId, Duration waitTime, AuthenticationInfo authn, long networkQueryId, Set<ResultOutputType> outputTypes, I2b2QueryDefinition queryDefinition, Option<XmlNodeName> nodeId) {
        return new RunQueryRequest(projectId, waitTime, authn, networkQueryId, outputTypes, queryDefinition, nodeId);
    }

    public Option<Tuple7<String, Duration, AuthenticationInfo, Object, Set<ResultOutputType>, I2b2QueryDefinition, Option<XmlNodeName>>> unapply(RunQueryRequest x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.projectId(), (Object)x$0.waitTime(), (Object)x$0.authn(), (Object)BoxesRunTime.boxToLong((long)x$0.networkQueryId()), x$0.outputTypes(), (Object)x$0.queryDefinition(), x$0.nodeId()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RunQueryRequest$.class);
    }

    public static final /* synthetic */ Try $anonfun$fromXml$5(NodeSeq xml$2, String projectId$2, Duration waitTime$2, AuthenticationInfo authn$2, long queryId) {
        return NodeSeqEnrichments.Strictness$.HasStrictNodeSeqEnrichments$.MODULE$.withChild$extension(NodeSeqEnrichments.Strictness$.MODULE$.HasStrictNodeSeqEnrichments(xml$2), "outputTypes").map((Function1 & Serializable)nodeSeq -> MODULE$.determineShrineOutputTypes((NodeSeq)nodeSeq)).flatMap((Function1 & Serializable)outputTypes -> NodeSeqEnrichments.Strictness$.HasStrictNodeSeqEnrichments$.MODULE$.withChild$extension(NodeSeqEnrichments.Strictness$.MODULE$.HasStrictNodeSeqEnrichments(xml$2), I2b2QueryDefinition$.MODULE$.rootTagName()).flatMap((Function1 & Serializable)nodeSeq -> I2b2QueryDefinition$.MODULE$.fromXml(nodeSeq)).flatMap((Function1 & Serializable)queryDef -> XmlNodeName$.MODULE$.fromXmlOption(xml$2.$bslash("nodeId")).map((Function1 & Serializable)nodeId -> new RunQueryRequest(projectId$2, waitTime$2, authn$2, queryId, (Set<ResultOutputType>)outputTypes, (I2b2QueryDefinition)queryDef, (Option<XmlNodeName>)nodeId))));
    }

    private RunQueryRequest$() {
    }
}

