/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.authz;

import cats.effect.IO;
import ch.qos.logback.classic.Logger;
import com.typesafe.config.Config;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import net.shrine.authz.providerService.attributes.AttrProviderTrait;
import net.shrine.authz.providerService.authorize.AuthorizerTrait;
import net.shrine.config.ConfigSource$;
import net.shrine.log.Loggable;
import net.shrine.problem.RawProblem;
import org.http4s.Request;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class AuthorizationCoordinator$
implements Loggable {
    public static final AuthorizationCoordinator$ MODULE$ = new AuthorizationCoordinator$();
    private static final String REMOTE_USER_STRING;
    private static final String userInfoKey;
    private static Logger net$shrine$log$Loggable$$internalLogger;
    private static volatile byte bitmap$init$0;
    private static volatile boolean bitmap$0;

    static {
        Loggable.$init$((Loggable)MODULE$);
        REMOTE_USER_STRING = "REMOTE_USER";
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        userInfoKey = "userInfo";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
    }

    public Logger logger() {
        return Loggable.logger$((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.debugEnabled$((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.infoEnabled$((Loggable)this);
    }

    public void debug(Function0<String> s) {
        Loggable.debug$((Loggable)this, s);
    }

    public final void debug(Function0<String> s, Throwable e) {
        Loggable.debug$((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<String> s) {
        Loggable.info$((Loggable)this, s);
    }

    public final void info(Function0<String> s, Throwable e) {
        Loggable.info$((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<String> s) {
        Loggable.warn$((Loggable)this, s);
    }

    public final void warn(Function0<String> s, Throwable e) {
        Loggable.warn$((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<String> s) {
        Loggable.error$((Loggable)this, s);
    }

    public final void error(Function0<String> s, Throwable e) {
        Loggable.error$((Loggable)this, s, (Throwable)e);
    }

    public void log(RawProblem problem) {
        Loggable.log$((Loggable)this, (RawProblem)problem);
    }

    public <T> T logDuration(String taskName, Function1<String, BoxedUnit> log, Function0<T> f) {
        return (T)Loggable.logDuration$((Loggable)this, (String)taskName, log, f);
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        AuthorizationCoordinator$ authorizationCoordinator$ = this;
        synchronized (authorizationCoordinator$) {
            if (!bitmap$0) {
                net$shrine$log$Loggable$$internalLogger = Loggable.net$shrine$log$Loggable$$internalLogger$((Loggable)this);
                bitmap$0 = true;
            }
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        if (!bitmap$0) {
            return this.net$shrine$log$Loggable$$internalLogger$lzycompute();
        }
        return net$shrine$log$Loggable$$internalLogger;
    }

    public String REMOTE_USER_STRING() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: AuthorizationCoordinator.scala: 27");
        }
        return REMOTE_USER_STRING;
    }

    public String userInfoKey() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: AuthorizationCoordinator.scala: 28");
        }
        return userInfoKey;
    }

    public boolean isAuthorizationRequired() {
        return ConfigSource$.MODULE$.config().getBoolean("shrine.config.authorizer.requireAuthorization");
    }

    public Map<String, Map<String, Seq<String>>> userAuthorizationInfo(String uid, HttpServletRequest httpRequest) {
        List<Tuple2<String, String>> headers = this.getHeadersFromHttpRequest(httpRequest);
        Map<String, Map<String, Seq<String>>> userInfo = this.getAuthorizationInfo(uid, headers);
        boolean result = this.isUserAuthorizedGivenInfo(userInfo);
        if (result) {
            return userInfo;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append("Authorization failed for username '").append(uid).append("'").toString());
        return null;
    }

    public Map<String, Map<String, Seq<String>>> getAuthorizationInfo(String uid, List<Tuple2<String, String>> headers) {
        ObjectRef globalUserInfo = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        java.util.List attrProviderConfigs = ConfigSource$.MODULE$.config().getConfigList("shrine.config.authorizer.attributeProviders");
        CollectionConverters$.MODULE$.ListHasAsScala(attrProviderConfigs).asScala().foreach((Function1 & Serializable)attrProviderConfig -> {
            Class<?> providerClass = Class.forName(attrProviderConfig.getString("class"));
            AttrProviderTrait providerInstance = (AttrProviderTrait)providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (Map)((Map)globalUserInfo$1.elem).$plus$eq(providerInstance.populateAttributes(uid, headers, (Config)attrProviderConfig));
        });
        return (Map)globalUserInfo.elem;
    }

    public List<Tuple2<String, String>> getHeadersFromHttpRequest(HttpServletRequest httpRequest) {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(httpRequest.getHeaderNames()).asScala().map((Function1 & Serializable)name -> new Tuple2((Object)name.toUpperCase(), (Object)httpRequest.getHeader(name).toString().toUpperCase())).toList();
    }

    public Seq<Tuple2<String, String>> getHeadersFromRequestIo(Request<IO> request) {
        return request.headers().map((Function1 & Serializable)h -> new Tuple2((Object)h.name().toString().toUpperCase(), (Object)h.value()));
    }

    public boolean isUserAuthorizedGivenInfo(Map<String, Map<String, Seq<String>>> userInfo) {
        Config authorizerConf = ConfigSource$.MODULE$.config().getConfig("shrine.config.authorizer.authorizer");
        Class<?> authorizerClass = Class.forName(authorizerConf.getString("name"));
        AuthorizerTrait authorizerInstance = (AuthorizerTrait)authorizerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        return authorizerInstance.isAuthorized(userInfo);
    }

    private AuthorizationCoordinator$() {
    }
}

