/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.internal;

import cats.effect.kernel.GenConcurrent;
import cats.syntax.package$all$;
import fs2.Compiler$;
import fs2.Compiler$Target$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.text$;
import java.io.Serializable;
import org.http4s.Charset;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.internal.PosixQuoting$;
import org.typelevel.ci.CIString;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.runtime.Nothing$;

public final class CurlConverter$ {
    public static final CurlConverter$ MODULE$ = new CurlConverter$();

    private String newline() {
        return " \\\n  ";
    }

    private String prepareMethodName(Method method) {
        return new StringBuilder(10).append(this.newline()).append("--request ").append(method.name()).toString();
    }

    private String prepareUri(Uri uri) {
        return new StringBuilder(6).append(this.newline()).append("--url ").append(PosixQuoting$.MODULE$.quote(uri.renderString())).toString();
    }

    private String prepareHeaders(List<Header.Raw> headers, Function1<CIString, Object> redactHeadersWhen) {
        String preparedHeaders = Headers$.MODULE$.redactSensitive$extension(headers, redactHeadersWhen).iterator().map((Function1<Header.Raw, String> & Serializable)header -> new StringBuilder(9).append("--header ").append(PosixQuoting$.MODULE$.quote(new StringBuilder(2).append(header.name()).append(": ").append(header.value()).toString())).toString()).mkString(this.newline());
        if (preparedHeaders.isEmpty()) {
            return "";
        }
        return new StringBuilder(0).append(this.newline()).append(preparedHeaders).toString();
    }

    public <F> String requestToCurlWithoutBody(Request<F> request, Function1<CIString, Object> redactHeadersWhen) {
        String params = new $colon$colon<Nothing$>((Nothing$)((Object)this.prepareMethodName(request.method())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.prepareUri(request.uri())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.prepareHeaders(request.headers(), redactHeadersWhen)), Nil$.MODULE$))).mkString();
        return new StringBuilder(4).append("curl").append(params).toString();
    }

    public <F> F requestToCurlWithBody(Request<F> request, Function1<CIString, Object> redactHeadersWhen, GenConcurrent<F, Throwable> evidence$1, Charset defaultCharset) {
        return package$all$.MODULE$.toFlatMapOps(package$all$.MODULE$.toFunctorOps(request.body().compile(Compiler$.MODULE$.target(Compiler$Target$.MODULE$.forConcurrent(evidence$1))).toVector(), evidence$1).map((Function1<Vector, Stream> & Serializable)x$1 -> Stream$.MODULE$.emits(x$1)), evidence$1).flatMap((Function1<Stream, Object> & Serializable)cachedBodyStream -> {
            java.nio.charset.Charset cs = ((Charset)request.charset().getOrElse((Function0<Charset> & Serializable)() -> defaultCharset)).nioCharset();
            return package$all$.MODULE$.toFunctorOps(cachedBodyStream.through(text$.MODULE$.decodeWithCharset(cs, RaiseThrowable$.MODULE$.fromApplicativeError(evidence$1))).compile(Compiler$.MODULE$.target(Compiler$Target$.MODULE$.forConcurrent(evidence$1))).string($less$colon$less$.MODULE$.refl()), evidence$1).map((Function1<String, Tuple2> & Serializable)bodyString -> {
                String bodyArg = bodyString.isEmpty() ? "" : new StringBuilder(7).append(MODULE$.newline()).append("--data ").append(PosixQuoting$.MODULE$.quote((String)bodyString)).toString();
                String curl = new StringBuilder(0).append(request.asCurl(redactHeadersWhen)).append(bodyArg).toString();
                Request refreshedRequest = (Request)request.withBodyStream((Stream)cachedBodyStream);
                return new Tuple2<String, Request>(curl, refreshedRequest);
            });
        });
    }

    private CurlConverter$() {
    }
}

