/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostAttribute;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyTermsEnum;
import org.apache.lucene.search.MaxNonCompetitiveBoostAttribute;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public class FuzzyLikeThisQuery
extends Query {
    static TFIDFSimilarity sim = new ClassicSimilarity();
    ArrayList<FieldVals> fieldVals = new ArrayList();
    Analyzer analyzer;
    int MAX_VARIANTS_PER_TERM = 50;
    boolean ignoreTF = false;
    private int maxNumTerms;

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = this.classHash();
        result2 = prime * result2 + Objects.hashCode(this.analyzer);
        result2 = prime * result2 + Objects.hashCode(this.fieldVals);
        result2 = prime * result2 + (this.ignoreTF ? 1231 : 1237);
        result2 = prime * result2 + this.maxNumTerms;
        return result2;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((FuzzyLikeThisQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(FuzzyLikeThisQuery other) {
        return Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.fieldVals, other.fieldVals) && this.ignoreTF == other.ignoreTF && this.maxNumTerms == other.maxNumTerms;
    }

    public FuzzyLikeThisQuery(int maxNumTerms, Analyzer analyzer) {
        this.analyzer = analyzer;
        this.maxNumTerms = maxNumTerms;
    }

    public void addTerms(String queryString, String fieldName, float minSimilarity, int prefixLength) {
        int maxEdits = (int)minSimilarity;
        if ((float)maxEdits != minSimilarity || maxEdits < 0 || maxEdits > 2) {
            throw new IllegalArgumentException("minSimilarity must integer value between 0 and 2, inclusive; got " + minSimilarity);
        }
        this.fieldVals.add(new FieldVals(fieldName, maxEdits, prefixLength, queryString));
    }

    private void addTerms(IndexReader reader, FieldVals f, ScoreTermQueue q) throws IOException {
        if (f.queryString == null) {
            return;
        }
        Terms terms = MultiTerms.getTerms(reader, f.fieldName);
        if (terms == null) {
            return;
        }
        try (TokenStream ts = this.analyzer.tokenStream(f.fieldName, f.queryString);){
            CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
            int corpusNumDocs = reader.numDocs();
            HashSet<String> processedTerms = new HashSet<String>();
            ts.reset();
            while (ts.incrementToken()) {
                BytesRef possibleMatch;
                String term = termAtt.toString();
                if (processedTerms.contains(term)) continue;
                processedTerms.add(term);
                ScoreTermQueue variantsQ = new ScoreTermQueue(this.MAX_VARIANTS_PER_TERM);
                float minScore = 0.0f;
                Term startTerm = new Term(f.fieldName, term);
                AttributeSource atts = new AttributeSource();
                MaxNonCompetitiveBoostAttribute maxBoostAtt = atts.addAttribute(MaxNonCompetitiveBoostAttribute.class);
                FuzzyTermsEnum fe = new FuzzyTermsEnum(terms, atts, startTerm, f.maxEdits, f.prefixLength, true);
                int df = reader.docFreq(startTerm);
                int numVariants = 0;
                int totalVariantDocFreqs = 0;
                BoostAttribute boostAtt = fe.attributes().addAttribute(BoostAttribute.class);
                while ((possibleMatch = fe.next()) != null) {
                    ++numVariants;
                    totalVariantDocFreqs += fe.docFreq();
                    float score = boostAtt.getBoost();
                    if (variantsQ.size() < this.MAX_VARIANTS_PER_TERM || score > minScore) {
                        ScoreTerm st = new ScoreTerm(new Term(startTerm.field(), BytesRef.deepCopyOf(possibleMatch)), score, startTerm);
                        variantsQ.insertWithOverflow(st);
                        minScore = ((ScoreTerm)variantsQ.top()).score;
                    }
                    maxBoostAtt.setMaxNonCompetitiveBoost(variantsQ.size() >= this.MAX_VARIANTS_PER_TERM ? minScore : Float.NEGATIVE_INFINITY);
                }
                if (numVariants <= 0) continue;
                int avgDf = totalVariantDocFreqs / numVariants;
                if (df == 0) {
                    df = avgDf;
                }
                int size = variantsQ.size();
                for (int i = 0; i < size; ++i) {
                    ScoreTerm st = (ScoreTerm)variantsQ.pop();
                    st.score = st.score * st.score * sim.idf(df, corpusNumDocs);
                    q.insertWithOverflow(st);
                }
            }
            ts.end();
        }
    }

    private Query newTermQuery(IndexReader reader, Term term) throws IOException {
        if (this.ignoreTF) {
            return new ConstantScoreQuery(new TermQuery(term));
        }
        TermStates context = new TermStates(reader.getContext());
        for (LeafReaderContext leafContext : reader.leaves()) {
            TermsEnum termsEnum;
            Terms terms = leafContext.reader().terms(term.field());
            if (terms == null || !(termsEnum = terms.iterator()).seekExact(term.bytes())) continue;
            int freq = 1 - context.docFreq();
            context.register(termsEnum.termState(), leafContext.ord, freq, freq);
        }
        return new TermQuery(term, context);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        ScoreTermQueue q = new ScoreTermQueue(this.maxNumTerms);
        for (FieldVals f : this.fieldVals) {
            this.addTerms(reader, f, q);
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        HashMap<Term, ArrayList<ScoreTerm>> variantQueries = new HashMap<Term, ArrayList<ScoreTerm>>();
        int size = q.size();
        for (int i = 0; i < size; ++i) {
            ScoreTerm st = (ScoreTerm)q.pop();
            ArrayList<ScoreTerm> l = (ArrayList<ScoreTerm>)variantQueries.get(st.fuzziedSourceTerm);
            if (l == null) {
                l = new ArrayList<ScoreTerm>();
                variantQueries.put(st.fuzziedSourceTerm, l);
            }
            l.add(st);
        }
        for (ArrayList variants : variantQueries.values()) {
            if (variants.size() == 1) {
                ScoreTerm st = (ScoreTerm)variants.get(0);
                Query tq = this.newTermQuery(reader, st.term);
                bq.add(new BoostQuery(tq, st.score), BooleanClause.Occur.SHOULD);
                continue;
            }
            BooleanQuery.Builder termVariants = new BooleanQuery.Builder();
            for (ScoreTerm st : variants) {
                Query tq = this.newTermQuery(reader, st.term);
                termVariants.add(new BoostQuery(tq, st.score), BooleanClause.Occur.SHOULD);
            }
            bq.add(termVariants.build(), BooleanClause.Occur.SHOULD);
        }
        return bq.build();
    }

    @Override
    public String toString(String field2) {
        return null;
    }

    public boolean isIgnoreTF() {
        return this.ignoreTF;
    }

    public void setIgnoreTF(boolean ignoreTF) {
        this.ignoreTF = ignoreTF;
    }

    private static class ScoreTermQueue
    extends PriorityQueue<ScoreTerm> {
        public ScoreTermQueue(int size) {
            super(size);
        }

        @Override
        protected boolean lessThan(ScoreTerm termA, ScoreTerm termB) {
            if (termA.score == termB.score) {
                return termA.term.compareTo(termB.term) > 0;
            }
            return termA.score < termB.score;
        }
    }

    private static class ScoreTerm {
        public Term term;
        public float score;
        Term fuzziedSourceTerm;

        public ScoreTerm(Term term, float score, Term fuzziedSourceTerm) {
            this.term = term;
            this.score = score;
            this.fuzziedSourceTerm = fuzziedSourceTerm;
        }
    }

    static class FieldVals {
        String queryString;
        String fieldName;
        int maxEdits;
        int prefixLength;

        public FieldVals(String name, int maxEdits, int length, String queryString) {
            this.fieldName = name;
            this.maxEdits = maxEdits;
            this.prefixLength = length;
            this.queryString = queryString;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.fieldName == null ? 0 : this.fieldName.hashCode());
            result2 = 31 * result2 + this.maxEdits;
            result2 = 31 * result2 + this.prefixLength;
            result2 = 31 * result2 + (this.queryString == null ? 0 : this.queryString.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldVals other = (FieldVals)obj;
            if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
                return false;
            }
            if (this.maxEdits != other.maxEdits) {
                return false;
            }
            if (this.prefixLength != other.prefixLength) {
                return false;
            }
            return !(this.queryString == null ? other.queryString != null : !this.queryString.equals(other.queryString));
        }
    }
}

