/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.effect.SyncIO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package$all$;
import java.io.Serializable;
import org.http4s.Header;
import org.http4s.Header$Select$;
import org.http4s.Header$ToRaw$;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.ResponseCookie;
import org.http4s.Uri;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Location;
import org.http4s.headers.Location$;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Key;
import org.typelevel.vault.Key$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class FollowRedirect$ {
    public static final FollowRedirect$ MODULE$ = new FollowRedirect$();
    private static final Key<List<Uri>> redirectUrisKey = (Key)Key$.MODULE$.newKey(SyncIO$.MODULE$.syncForSyncIO(), SyncIO$.MODULE$.syncForSyncIO()).unsafeRunSync();

    public <F> Client<F> apply(int maxRedirects, Function1<CIString, Object> sensitiveHeaderFilter, Client<F> client, GenConcurrent<F, Throwable> F2) {
        return Client$.MODULE$.apply((Function1<Request, Resource> & Serializable)req -> Hotswap$.MODULE$.create(F2).flatMap((Function1<Hotswap, Resource> & Serializable)x0$1 -> {
            Hotswap hotswap = x0$1;
            return package$.MODULE$.Resource().eval(FollowRedirect$.redirectLoop$1(req, 0, hotswap, F2, client, maxRedirects, sensitiveHeaderFilter));
        }), F2);
    }

    public <F> Function1<CIString, Object> apply$default$2() {
        return Headers$.MODULE$.SensitiveHeaders();
    }

    private <F> Option<Method> methodForRedirect(Request<F> req, Response<F> resp) {
        int n = resp.status().code();
        switch (n) {
            case 301: 
            case 302: {
                Method method = req.method();
                Method method2 = Method$.MODULE$.POST();
                Method method3 = method;
                if (!(method2 != null ? !((Object)method2).equals(method3) : method3 != null)) {
                    return new Some<Method>(Method$.MODULE$.GET());
                }
                return new Some<Method>(method);
            }
            case 303: {
                Method method = req.method();
                Method method4 = Method$.MODULE$.HEAD();
                Method method5 = method;
                if (!(method4 != null ? !((Object)method4).equals(method5) : method5 != null)) {
                    return new Some<Method>(Method$.MODULE$.HEAD());
                }
                return new Some<Method>(Method$.MODULE$.GET());
            }
            case 307: 
            case 308: {
                return new Some<Method>(req.method());
            }
        }
        return None$.MODULE$;
    }

    private Key<List<Uri>> redirectUrisKey() {
        return redirectUrisKey;
    }

    public <F> List<Uri> getRedirectUris(Response<F> response) {
        return (List)response.attributes().lookup(this.redirectUrisKey()).getOrElse((Function0<Nil$> & Serializable)() -> Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Function1 sensitiveHeaderFilter$1, Header.Raw h) {
        return BoxesRunTime.unboxToBoolean(sensitiveHeaderFilter$1.apply(h.name()));
    }

    private static final Request stripSensitiveHeaders$1(Request req, Uri nextUri$1, Function1 sensitiveHeaderFilter$1) {
        Option<Uri.Authority> option = req.uri().authority();
        Option<Uri.Authority> option2 = nextUri$1.authority();
        if (option == null ? option2 != null : !option.equals(option2)) {
            return (Request)req.transformHeaders((Function1<Headers, Headers>)(Function1<Object, Object> & Serializable)hs -> new Headers(Headers$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.scalaCollectionSeqToRaw(((Headers)hs).headers().filterNot((Function1<Header.Raw, Object> & Serializable)h -> BoxesRunTime.boxToBoolean(FollowRedirect$.$anonfun$apply$5(sensitiveHeaderFilter$1, h))), (Function1<Header.Raw, Header.ToRaw> & Serializable)h -> Header$ToRaw$.MODULE$.rawToRaw((Header.Raw)h))}))));
        }
        return req;
    }

    private static final Request propagateCookies$1(Request req, Uri nextUri$1, List cookies$1) {
        Option<Uri.Authority> option = req.uri().authority();
        Option<Uri.Authority> option2 = nextUri$1.authority();
        if (!(option != null ? !option.equals(option2) : option2 != null)) {
            return cookies$1.foldLeft(req, (Function2<Request, ResponseCookie, Request> & Serializable)(x0$1, x1$1) -> {
                Tuple2<Request, ResponseCookie> tuple2 = new Tuple2<Request, ResponseCookie>((Request)x0$1, (ResponseCookie)x1$1);
                if (tuple2 != null) {
                    Request nextReq = tuple2._1();
                    ResponseCookie cookie = tuple2._2();
                    return nextReq.addCookie(cookie.name(), cookie.content());
                }
                throw new MatchError(tuple2);
            });
        }
        return req;
    }

    private static final Request clearBodyFromGetHead$1(Request req, Method method$1) {
        boolean bl;
        Method method = method$1;
        Method method2 = Method$.MODULE$.GET();
        Method method3 = method;
        if (!(method2 != null ? !((Object)method2).equals(method3) : method3 != null)) {
            bl = true;
        } else {
            Method method4 = Method$.MODULE$.HEAD();
            Method method5 = method;
            bl = !(method4 != null ? !((Object)method4).equals(method5) : method5 != null);
        }
        if (bl) {
            return (Request)req.withEmptyBody();
        }
        return req;
    }

    private static final Request nextRequest$1(Request req, Uri uri, Method method, List cookies, Function1 sensitiveHeaderFilter$1) {
        Option<Uri.Scheme> x$1 = uri.scheme().orElse((Function0<Option> & Serializable)() -> req.uri().scheme());
        Option<Uri.Authority> x$2 = uri.authority().orElse((Function0<Option> & Serializable)() -> req.uri().authority());
        Option<String> x$3 = uri.fragment().orElse((Function0<Option> & Serializable)() -> req.uri().fragment());
        Uri.Path x$4 = uri.copy$default$3();
        Query x$5 = uri.copy$default$4();
        Uri nextUri = uri.copy(x$1, x$2, x$4, x$5, x$3);
        return FollowRedirect$.clearBodyFromGetHead$1(FollowRedirect$.propagateCookies$1(FollowRedirect$.stripSensitiveHeaders$1(req, nextUri, sensitiveHeaderFilter$1), nextUri, cookies).withMethod(method).withUri(nextUri), method);
    }

    private static final Object redirectLoop$1(Request req, int redirects, Hotswap hotswap, GenConcurrent F$1, Client client$1, int maxRedirects$1, Function1 sensitiveHeaderFilter$1) {
        return package$all$.MODULE$.catsSyntaxApply(hotswap.clear(), F$1).$times$greater(package$all$.MODULE$.toFlatMapOps(hotswap.swap(client$1.run(req)), F$1).flatMap((Function1<Response, Object> & Serializable)resp -> {
            Option<Object> l = Headers$.MODULE$.get$extension((List<Header.Raw>)resp.headers(), Header$Select$.MODULE$.singleHeaders(Location$.MODULE$.headerInstance()));
            Tuple2<Option<Method>, Option<Object>> tuple2 = new Tuple2<Option<Method>, Option<Object>>(MODULE$.methodForRedirect(req, (Response)resp), l);
            if (tuple2 != null) {
                Option<Method> option = tuple2._1();
                Option<Object> option2 = tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Method method = (Method)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Location loc = (Location)some2.value();
                        if (redirects < maxRedirects$1) {
                            Request nextReq = FollowRedirect$.nextRequest$1(req, loc.uri(), method, resp.cookies(), sensitiveHeaderFilter$1);
                            return package$all$.MODULE$.toFunctorOps(FollowRedirect$.redirectLoop$1(nextReq, redirects + 1, hotswap, F$1, client$1, maxRedirects$1, sensitiveHeaderFilter$1), F$1).map((Function1<Response, Response> & Serializable)res -> {
                                Uri uri = nextReq.uri();
                                return (Response)res.withAttribute(MODULE$.redirectUrisKey(), MODULE$.getRedirectUris((Response)res).$plus$colon(uri));
                            });
                        }
                    }
                }
            }
            return ApplicativeIdOps$.MODULE$.pure$extension(package$all$.MODULE$.catsSyntaxApplicativeId(resp), F$1);
        }));
    }

    private FollowRedirect$() {
    }
}

