/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.oauth1;

import cats.Monad;
import cats.MonadError;
import cats.Show;
import cats.Show$;
import cats.data.Chain;
import cats.data.NonEmptyList;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.instances.package$order$;
import cats.kernel.Eq$;
import cats.syntax.package$all$;
import java.io.Serializable;
import org.http4s.AuthScheme$;
import org.http4s.Charset;
import org.http4s.Charset$;
import org.http4s.Credentials;
import org.http4s.EntityDecoder;
import org.http4s.Header;
import org.http4s.Header$ToRaw$;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Query$;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.client.oauth1.Consumer;
import org.http4s.client.oauth1.HmacSha1$;
import org.http4s.client.oauth1.ProtocolParameter;
import org.http4s.client.oauth1.ProtocolParameter$;
import org.http4s.client.oauth1.ProtocolParameter$SignatureMethod$;
import org.http4s.client.oauth1.ProtocolParameter$Version$;
import org.http4s.client.oauth1.SignatureAlgorithm;
import org.http4s.client.oauth1.SignatureAlgorithm$;
import org.http4s.client.oauth1.Token;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.headers.Content$minusType;
import org.http4s.internal.CharPredicate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final String OutOfBand = "oob";

    private String OutOfBand() {
        return OutOfBand;
    }

    public <F> F signRequest(Request<F> req, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token, MonadError<F, Throwable> F2, EntityDecoder<F, UrlForm> W) {
        return package$all$.MODULE$.toFlatMapOps(this.getUserParams(req, F2, W), F2).flatMap((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Request req = (Request)tuple2._1();
                Vector params = (Vector)tuple2._2();
                return package$all$.MODULE$.toFunctorOps(MODULE$.genAuthHeader(req.method(), req.uri(), params, consumer, callback, verifier, token, HmacSha1$.MODULE$, F2), F2).map((Function1<Authorization, Request> & Serializable)auth -> (Request)req.putHeaders(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(auth, Authorization$.MODULE$.headerInstance())})));
            }
            throw new MatchError(tuple2);
        });
    }

    public <F> F signRequest(Request<F> req, ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, Option<ProtocolParameter.Realm> realm, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, MonadError<F, Throwable> F2, EntityDecoder<F, UrlForm> W) {
        return package$all$.MODULE$.toFlatMapOps(this.getUserParams(req, F2, W), F2).flatMap((Function1<Tuple2, Object> & Serializable)reqParams -> {
            Tuple2 tuple2 = reqParams;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Request req = (Request)tuple2._1();
            Vector params = (Vector)tuple2._2();
            Tuple3<Tuple2, Request, Vector> tuple3 = new Tuple3<Tuple2, Request, Vector>(tuple2, req, params);
            Tuple2 tuple22 = tuple3._1();
            Request req2 = tuple3._2();
            Vector params2 = tuple3._3();
            return package$all$.MODULE$.toFunctorOps(MODULE$.genAuthHeader(req2.method(), req2.uri(), consumer, token, realm, signatureMethod, timestampGenerator, version, nonceGenerator, callback, verifier, (Seq)params2.map((Function1<Tuple2, ProtocolParameter> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return new ProtocolParameter.Custom(k, v);
                }
                throw new MatchError(tuple2);
            }), F2), F2).map((Function1<Authorization, Request> & Serializable)auth -> (Request)req2.putHeaders(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header$ToRaw$.MODULE$.modelledHeadersToRaw(auth, Authorization$.MODULE$.headerInstance())})));
        });
    }

    public <F> ProtocolParameter.SignatureMethod signRequest$default$5() {
        return new ProtocolParameter.SignatureMethod(ProtocolParameter$SignatureMethod$.MODULE$.apply$default$1());
    }

    public <F> ProtocolParameter.Version signRequest$default$7() {
        return new ProtocolParameter.Version(ProtocolParameter$Version$.MODULE$.apply$default$1());
    }

    public <F> Option<ProtocolParameter.Callback> signRequest$default$9() {
        return None$.MODULE$;
    }

    public <F> Option<ProtocolParameter.Verifier> signRequest$default$10() {
        return None$.MODULE$;
    }

    public <F> F takeSigHeaders(ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, Monad<F> evidence$1) {
        return package$all$.MODULE$.toFlatMapOps(timestampGenerator, evidence$1).flatMap((Function1<ProtocolParameter.Timestamp, Object> & Serializable)timestamp -> package$all$.MODULE$.toFunctorOps(nonceGenerator, evidence$1).map((Function1<ProtocolParameter.Nonce, List> & Serializable)nonce -> {
            $colon$colon<Nothing$> headers = new $colon$colon<Nothing$>((Nothing$)((Object)consumer), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)signatureMethod), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)timestamp), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)nonce), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)version), Nil$.MODULE$)))));
            return (List)headers.$plus$plus((IterableOnce)new $colon$colon<Nothing$>((Nothing$)((Object)token), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)callback), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)verifier), Nil$.MODULE$))).flatten(Predef$.MODULE$.$conforms()));
        }));
    }

    public <F> F genAuthHeader(Method method, Uri uri, ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, Option<ProtocolParameter.Realm> realm, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, Seq<ProtocolParameter> queryParams, MonadError<F, Throwable> evidence$2) {
        return package$all$.MODULE$.toFlatMapOps(this.takeSigHeaders(consumer, token, signatureMethod, timestampGenerator, version, nonceGenerator, callback, verifier, evidence$2), evidence$2).flatMap((Function1<Seq, Object> & Serializable)headers -> {
            Show<ProtocolParameter> show = Show$.MODULE$.apply(ProtocolParameter$.MODULE$.oauth1HeaderShow());
            String baseStr = MODULE$.mkBaseString(method, uri, ((IterableOnce)((SeqOps)headers.$plus$plus(queryParams)).sorted(package$order$.MODULE$.catsKernelOrderingForOrder(ProtocolParameter$.MODULE$.http4sClientOauth1SortForProtocolParameters()))).iterator().map((Function1<ProtocolParameter, String> & Serializable)t -> show.show((ProtocolParameter)t)).mkString("&"));
            SignatureAlgorithm alg = SignatureAlgorithm$.MODULE$.unsafeFromMethod(signatureMethod);
            return package$all$.MODULE$.toFunctorOps(MODULE$.makeSHASig(baseStr, consumer.secret(), token.map((Function1<ProtocolParameter.Token, String> & Serializable)x$4 -> x$4.secret()), alg, evidence$2), evidence$2).map((Function1<String, Authorization> & Serializable)sig -> {
                Credentials.AuthParams creds = new Credentials.AuthParams(AuthScheme$.MODULE$.OAuth(), new NonEmptyList<Tuple2<String, String>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_signature"), MODULE$.encode((String)sig)), ((IterableOnceOps)realm.fold((Function0<Seq> & Serializable)() -> (Seq)headers.map((Function1<ProtocolParameter, Tuple2> & Serializable)x$5 -> x$5.toTuple()), (Function1<ProtocolParameter.Realm, Seq> & Serializable)x$6 -> {
                    Tuple2<String, String> tuple2 = x$6.toTuple();
                    return (Seq)((SeqOps)headers.map((Function1<ProtocolParameter, Tuple2> & Serializable)x$7 -> x$7.toTuple())).$plus$colon(tuple2);
                })).toList()));
                return new Authorization(creds);
            });
        });
    }

    public Authorization genAuthHeader(Method method, Uri uri, Seq<Tuple2<String, String>> userParams, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token) {
        return (Authorization)((SyncIO)this.genAuthHeader(method, uri, userParams, consumer, callback, verifier, token, HmacSha1$.MODULE$, SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }

    public <F> F genAuthHeader(Method method, Uri uri, Seq<Tuple2<String, String>> userParams, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token, SignatureAlgorithm algorithm, MonadError<F, Throwable> evidence$3) {
        ListBuffer<Tuple2<String, String>> params = new ListBuffer<Tuple2<String, String>>();
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_consumer_key"), this.encode(consumer.key())));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_signature_method"), algorithm.name()));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_timestamp"), Long.toString(System.currentTimeMillis() / 1000L)));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_nonce"), Long.toString(System.nanoTime())));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_version"), "1.0"));
        params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_callback"), callback.map((Function1<Uri, String> & Serializable)c -> MODULE$.encode(c.renderString())).getOrElse((Function0<String> & Serializable)() -> MODULE$.OutOfBand())));
        token.foreach((Function1<Token, ListBuffer> & Serializable)t -> (ListBuffer)params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_token"), MODULE$.encode(t.value()))));
        verifier.foreach((Function1<String, ListBuffer> & Serializable)v -> (ListBuffer)params.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_verifier"), MODULE$.encode((String)v))));
        Object params2 = params.result();
        String baseString = this.genBaseString(method, uri, (Seq)((AbstractIterable)params2).$plus$plus((IterableOnce)userParams.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2<String, String>(MODULE$.encode(k), MODULE$.encode(v));
            }
            throw new MatchError(tuple2);
        })));
        return package$all$.MODULE$.toFunctorOps(this.makeSHASig(baseString, consumer.secret(), token.map((Function1<Token, String> & Serializable)x$8 -> x$8.secret()), algorithm, evidence$3), evidence$3).map(arg_0 -> package$.$anonfun$genAuthHeader$15((List)params2, arg_0));
    }

    public String makeSHASig(String baseString, Consumer consumer, Option<Token> token) {
        return this.makeSHASig(baseString, consumer.secret(), token.map((Function1<Token, String> & Serializable)x$9 -> x$9.secret()));
    }

    public String makeSHASig(String baseString, String consumerSecret, Option<String> tokenSecret) {
        return (String)((SyncIO)this.makeSHASig(baseString, consumerSecret, tokenSecret, HmacSha1$.MODULE$, SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }

    public <F> F makeSHASig(String baseString, String consumerSecret, Option<String> tokenSecret, SignatureAlgorithm algorithm, MonadError<F, Throwable> evidence$4) {
        String key = new StringBuilder(1).append(this.encode(consumerSecret)).append("&").append(tokenSecret.map((Function1<String, String> & Serializable)t -> MODULE$.encode((String)t)).getOrElse((Function0<String> & Serializable)() -> "")).toString();
        return algorithm.generate(baseString, key, evidence$4);
    }

    public String genBaseString(Method method, Uri uri, Seq<Tuple2<String, String>> params) {
        String paramsStr = ((IterableOnceOps)((SeqOps)params.map((Function1<Tuple2, String> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append("=").append(v).toString();
            }
            throw new MatchError(tuple2);
        })).sorted(package$order$.MODULE$.catsKernelOrderingForOrder(Eq$.MODULE$.catsKernelInstancesForString()))).mkString("&");
        return this.mkBaseString(method, uri, paramsStr);
    }

    public String mkBaseString(Method method, Uri uri, String paramsStr) {
        Query x$1 = Query$.MODULE$.empty();
        None$ x$2 = None$.MODULE$;
        Option<Uri.Scheme> x$3 = uri.copy$default$1();
        Option<Uri.Authority> x$4 = uri.copy$default$2();
        Uri.Path x$5 = uri.copy$default$3();
        return new $colon$colon<Nothing$>((Nothing$)((Object)method.name()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.encode(uri.copy(x$3, x$4, x$5, x$1, x$2).renderString())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.encode(paramsStr)), Nil$.MODULE$))).mkString("&");
    }

    public String encode(String str) {
        String x$1 = str;
        boolean x$2 = false;
        CharPredicate x$3 = Uri$.MODULE$.Unreserved();
        java.nio.charset.Charset x$4 = Uri$.MODULE$.encode$default$2();
        return Uri$.MODULE$.encode(x$1, x$4, false, x$3);
    }

    public <F> F getUserParams(Request<F> req, MonadError<F, Throwable> F2, EntityDecoder<F, UrlForm> W) {
        Vector qparams;
        block4: {
            Content$minusType t;
            block5: {
                qparams = (Vector)req.uri().query().pairs().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Option ov = (Option)tuple2._2();
                        return new Tuple2(k, ov.getOrElse((Function0<String> & Serializable)() -> ""));
                    }
                    throw new MatchError(tuple2);
                });
                Option<Content$minusType> option = req.contentType();
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                t = (Content$minusType)some.value();
                Method method = req.method();
                Method method2 = Method$.MODULE$.POST();
                if (!(method == null ? method2 != null : !((Object)method).equals(method2))) break block5;
                Method method3 = req.method();
                Method method4 = Method$.MODULE$.PUT();
                if (method3 != null ? !((Object)method3).equals(method4) : method4 != null) break block4;
            }
            MediaType mediaType = t.mediaType();
            MediaType mediaType2 = MediaType$.MODULE$.application().x$minuswww$minusform$minusurlencoded();
            if (!(mediaType != null ? !((Object)mediaType).equals(mediaType2) : mediaType2 != null)) {
                return package$all$.MODULE$.toFunctorOps(req.as(F2, W), F2).map((Function1<Object, Tuple2> & Serializable)urlform -> package$.$anonfun$getUserParams$3(req, qparams, ((UrlForm)urlform).values()));
            }
        }
        return F2.pure(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(req), qparams));
    }

    public static final /* synthetic */ Authorization $anonfun$genAuthHeader$15(List params$2, String sig) {
        Credentials.AuthParams creds = new Credentials.AuthParams(AuthScheme$.MODULE$.OAuth(), new NonEmptyList<Tuple2<String, String>>(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("oauth_signature"), MODULE$.encode(sig)), params$2));
        return new Authorization(creds);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getUserParams$3(Request req$3, Vector qparams$1, Map urlform) {
        Seq bodyparams = (Seq)urlform.toSeq().flatMap((Function1<Tuple2, Seq> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Chain vs = (Chain)tuple2._2();
                if (vs.isEmpty()) {
                    return new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), "")), Nil$.MODULE$);
                }
                return vs.toList().map((Function1<String, Tuple2> & Serializable)x$10 -> new Tuple2<String, String>(k, (String)x$10));
            }
            throw new MatchError(tuple2);
        });
        Charset charset = (Charset)req$3.charset().getOrElse((Function0<Charset> & Serializable)() -> Charset$.MODULE$.UTF$minus8());
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(req$3.withEntity(new UrlForm(urlform), UrlForm$.MODULE$.entityEncoder(charset))), qparams$1.$plus$plus((IterableOnce)bodyparams));
    }

    private package$() {
    }
}

