/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.ThreadInterruptedException;

public class MergeRateLimiter
extends RateLimiter {
    private static final int MIN_PAUSE_CHECK_MSEC = 25;
    private static final long MIN_PAUSE_NS = TimeUnit.MILLISECONDS.toNanos(2L);
    private static final long MAX_PAUSE_NS = TimeUnit.MILLISECONDS.toNanos(250L);
    private volatile double mbPerSec;
    private volatile long minPauseCheckBytes;
    private long lastNS;
    private AtomicLong totalBytesWritten = new AtomicLong();
    private final MergePolicy.OneMergeProgress mergeProgress;

    public MergeRateLimiter(MergePolicy.OneMergeProgress mergeProgress) {
        this.mergeProgress = mergeProgress;
        this.setMBPerSec(Double.POSITIVE_INFINITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMBPerSec(double mbPerSec) {
        MergeRateLimiter mergeRateLimiter = this;
        synchronized (mergeRateLimiter) {
            if (mbPerSec < 0.0) {
                throw new IllegalArgumentException("mbPerSec must be positive; got: " + mbPerSec);
            }
            this.mbPerSec = mbPerSec;
            this.minPauseCheckBytes = Math.min(0x100000L, (long)(0.025 * mbPerSec * 1024.0 * 1024.0));
            assert (this.minPauseCheckBytes >= 0L);
        }
        this.mergeProgress.wakeup();
    }

    @Override
    public double getMBPerSec() {
        return this.mbPerSec;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    @Override
    public long pause(long bytes) throws MergePolicy.MergeAbortedException {
        long delta;
        this.totalBytesWritten.addAndGet(bytes);
        long paused = 0L;
        while ((delta = this.maybePause(bytes, System.nanoTime())) >= 0L) {
            paused += delta;
        }
        return paused;
    }

    public long getTotalStoppedNS() {
        return this.mergeProgress.getPauseTimes().get((Object)MergePolicy.OneMergeProgress.PauseReason.STOPPED);
    }

    public long getTotalPausedNS() {
        return this.mergeProgress.getPauseTimes().get((Object)MergePolicy.OneMergeProgress.PauseReason.PAUSED);
    }

    private long maybePause(long bytes, long curNS) throws MergePolicy.MergeAbortedException {
        if (this.mergeProgress.isAborted()) {
            throw new MergePolicy.MergeAbortedException("Merge aborted.");
        }
        double rate2 = this.mbPerSec;
        double secondsToPause = (double)bytes / 1024.0 / 1024.0 / rate2;
        long targetNS = this.lastNS + (long)(1.0E9 * secondsToPause);
        long curPauseNS = targetNS - curNS;
        if (curPauseNS <= MIN_PAUSE_NS) {
            this.lastNS = curNS;
            return -1L;
        }
        if (curPauseNS > MAX_PAUSE_NS) {
            curPauseNS = MAX_PAUSE_NS;
        }
        long start = System.nanoTime();
        try {
            this.mergeProgress.pauseNanos(curPauseNS, rate2 == 0.0 ? MergePolicy.OneMergeProgress.PauseReason.STOPPED : MergePolicy.OneMergeProgress.PauseReason.PAUSED, () -> rate2 == this.mbPerSec);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
        return System.nanoTime() - start;
    }

    @Override
    public long getMinPauseCheckBytes() {
        return this.minPauseCheckBytes;
    }
}

