/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import org.apache.lucene.analysis.util.StemmerUtil;

public class FrenchLightStemmer {
    public int stem(char[] s2, int len) {
        if (len > 5 && s2[len - 1] == 'x') {
            if (s2[len - 3] == 'a' && s2[len - 2] == 'u' && s2[len - 4] != 'e') {
                s2[len - 2] = 108;
            }
            --len;
        }
        if (len > 3 && s2[len - 1] == 'x') {
            --len;
        }
        if (len > 3 && s2[len - 1] == 's') {
            --len;
        }
        if (len > 9 && StemmerUtil.endsWith(s2, len, "issement")) {
            s2[(len -= 6) - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 8 && StemmerUtil.endsWith(s2, len, "issant")) {
            s2[(len -= 4) - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 6 && StemmerUtil.endsWith(s2, len, "ement")) {
            if ((len -= 4) > 3 && StemmerUtil.endsWith(s2, len, "ive")) {
                s2[--len - 1] = 102;
            }
            return this.norm(s2, len);
        }
        if (len > 11 && StemmerUtil.endsWith(s2, len, "ficatrice")) {
            s2[(len -= 5) - 2] = 101;
            s2[len - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 10 && StemmerUtil.endsWith(s2, len, "ficateur")) {
            s2[(len -= 4) - 2] = 101;
            s2[len - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 9 && StemmerUtil.endsWith(s2, len, "catrice")) {
            s2[(len -= 3) - 4] = 113;
            s2[len - 3] = 117;
            s2[len - 2] = 101;
            return this.norm(s2, len);
        }
        if (len > 8 && StemmerUtil.endsWith(s2, len, "cateur")) {
            s2[(len -= 2) - 4] = 113;
            s2[len - 3] = 117;
            s2[len - 2] = 101;
            s2[len - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 8 && StemmerUtil.endsWith(s2, len, "atrice")) {
            s2[(len -= 4) - 2] = 101;
            s2[len - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 7 && StemmerUtil.endsWith(s2, len, "ateur")) {
            s2[(len -= 3) - 2] = 101;
            s2[len - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 6 && StemmerUtil.endsWith(s2, len, "trice")) {
            s2[--len - 3] = 101;
            s2[len - 2] = 117;
            s2[len - 1] = 114;
        }
        if (len > 5 && StemmerUtil.endsWith(s2, len, "i\u00e8me")) {
            return this.norm(s2, len - 4);
        }
        if (len > 7 && StemmerUtil.endsWith(s2, len, "teuse")) {
            s2[(len -= 2) - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 6 && StemmerUtil.endsWith(s2, len, "teur")) {
            s2[--len - 1] = 114;
            return this.norm(s2, len);
        }
        if (len > 5 && StemmerUtil.endsWith(s2, len, "euse")) {
            return this.norm(s2, len - 2);
        }
        if (len > 8 && StemmerUtil.endsWith(s2, len, "\u00e8re")) {
            s2[--len - 2] = 101;
            return this.norm(s2, len);
        }
        if (len > 7 && StemmerUtil.endsWith(s2, len, "ive")) {
            s2[--len - 1] = 102;
            return this.norm(s2, len);
        }
        if (len > 4 && (StemmerUtil.endsWith(s2, len, "folle") || StemmerUtil.endsWith(s2, len, "molle"))) {
            s2[(len -= 2) - 1] = 117;
            return this.norm(s2, len);
        }
        if (len > 9 && StemmerUtil.endsWith(s2, len, "nnelle")) {
            return this.norm(s2, len - 5);
        }
        if (len > 9 && StemmerUtil.endsWith(s2, len, "nnel")) {
            return this.norm(s2, len - 3);
        }
        if (len > 4 && StemmerUtil.endsWith(s2, len, "\u00e8te")) {
            s2[--len - 2] = 101;
        }
        if (len > 8 && StemmerUtil.endsWith(s2, len, "ique")) {
            len -= 4;
        }
        if (len > 8 && StemmerUtil.endsWith(s2, len, "esse")) {
            return this.norm(s2, len - 3);
        }
        if (len > 7 && StemmerUtil.endsWith(s2, len, "inage")) {
            return this.norm(s2, len - 3);
        }
        if (len > 9 && StemmerUtil.endsWith(s2, len, "isation")) {
            if ((len -= 7) > 5 && StemmerUtil.endsWith(s2, len, "ual")) {
                s2[len - 2] = 101;
            }
            return this.norm(s2, len);
        }
        if (len > 9 && StemmerUtil.endsWith(s2, len, "isateur")) {
            return this.norm(s2, len - 7);
        }
        if (len > 8 && StemmerUtil.endsWith(s2, len, "ation")) {
            return this.norm(s2, len - 5);
        }
        if (len > 8 && StemmerUtil.endsWith(s2, len, "ition")) {
            return this.norm(s2, len - 5);
        }
        return this.norm(s2, len);
    }

    private int norm(char[] s2, int len) {
        if (len > 4) {
            block8: for (int i = 0; i < len; ++i) {
                switch (s2[i]) {
                    case '\u00e0': 
                    case '\u00e1': 
                    case '\u00e2': {
                        s2[i] = 97;
                        continue block8;
                    }
                    case '\u00f4': {
                        s2[i] = 111;
                        continue block8;
                    }
                    case '\u00e8': 
                    case '\u00e9': 
                    case '\u00ea': {
                        s2[i] = 101;
                        continue block8;
                    }
                    case '\u00f9': 
                    case '\u00fb': {
                        s2[i] = 117;
                        continue block8;
                    }
                    case '\u00ee': {
                        s2[i] = 105;
                        continue block8;
                    }
                    case '\u00e7': {
                        s2[i] = 99;
                    }
                }
            }
            char ch = s2[0];
            for (int i = 1; i < len; ++i) {
                if (s2[i] == ch && Character.isLetter(ch)) {
                    len = StemmerUtil.delete(s2, i--, len);
                    continue;
                }
                ch = s2[i];
            }
        }
        if (len > 4 && StemmerUtil.endsWith(s2, len, "ie")) {
            len -= 2;
        }
        if (len > 4) {
            if (s2[len - 1] == 'r') {
                --len;
            }
            if (s2[len - 1] == 'e') {
                --len;
            }
            if (s2[len - 1] == 'e') {
                --len;
            }
            if (s2[len - 1] == s2[len - 2] && Character.isLetter(s2[len - 1])) {
                --len;
            }
        }
        return len;
    }
}

