/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.util.PriorityQueue;

public abstract class DocIDMerger<T extends Sub> {
    public static <T extends Sub> DocIDMerger<T> of(List<T> subs, int maxCount, boolean indexIsSorted) throws IOException {
        if (indexIsSorted && maxCount > 1) {
            return new SortedDocIDMerger(subs, maxCount);
        }
        return new SequentialDocIDMerger(subs);
    }

    public static <T extends Sub> DocIDMerger<T> of(List<T> subs, boolean indexIsSorted) throws IOException {
        return DocIDMerger.of(subs, subs.size(), indexIsSorted);
    }

    public abstract void reset() throws IOException;

    public abstract T next() throws IOException;

    private DocIDMerger() {
    }

    private static class SortedDocIDMerger<T extends Sub>
    extends DocIDMerger<T> {
        private final List<T> subs;
        private final PriorityQueue<T> queue;

        private SortedDocIDMerger(List<T> subs, int maxCount) throws IOException {
            this.subs = subs;
            this.queue = new PriorityQueue<T>(maxCount){

                @Override
                protected boolean lessThan(Sub a, Sub b) {
                    assert (a.mappedDocID != b.mappedDocID);
                    return a.mappedDocID < b.mappedDocID;
                }
            };
            this.reset();
        }

        @Override
        public void reset() throws IOException {
            this.queue.clear();
            boolean first2 = true;
            for (Sub sub : this.subs) {
                if (first2) {
                    sub.mappedDocID = -1;
                    first2 = false;
                } else {
                    int docID;
                    int mappedDocID;
                    do {
                        if ((docID = sub.nextDoc()) != Integer.MAX_VALUE) continue;
                        mappedDocID = Integer.MAX_VALUE;
                        break;
                    } while ((mappedDocID = sub.docMap.get(docID)) == -1);
                    if (mappedDocID == Integer.MAX_VALUE) continue;
                    sub.mappedDocID = mappedDocID;
                }
                this.queue.add(sub);
            }
        }

        @Override
        public T next() throws IOException {
            Sub top;
            block1: {
                int docID;
                int mappedDocID;
                top = (Sub)this.queue.top();
                do {
                    if ((docID = top.nextDoc()) != Integer.MAX_VALUE) continue;
                    this.queue.pop();
                    top = (Sub)this.queue.top();
                    break block1;
                } while ((mappedDocID = top.docMap.get(docID)) == -1);
                top.mappedDocID = mappedDocID;
                top = (Sub)this.queue.updateTop();
            }
            return (T)top;
        }
    }

    private static class SequentialDocIDMerger<T extends Sub>
    extends DocIDMerger<T> {
        private final List<T> subs;
        private T current;
        private int nextIndex;

        private SequentialDocIDMerger(List<T> subs) throws IOException {
            this.subs = subs;
            this.reset();
        }

        @Override
        public void reset() throws IOException {
            if (this.subs.size() > 0) {
                this.current = (Sub)this.subs.get(0);
                this.nextIndex = 1;
            } else {
                this.current = null;
                this.nextIndex = 0;
            }
        }

        @Override
        public T next() throws IOException {
            int mappedDocID;
            while (true) {
                int docID;
                if ((docID = ((Sub)this.current).nextDoc()) == Integer.MAX_VALUE) {
                    if (this.nextIndex == this.subs.size()) {
                        this.current = null;
                        return null;
                    }
                    this.current = (Sub)this.subs.get(this.nextIndex);
                    ++this.nextIndex;
                    continue;
                }
                mappedDocID = ((Sub)this.current).docMap.get(docID);
                if (mappedDocID != -1) break;
            }
            ((Sub)this.current).mappedDocID = mappedDocID;
            return this.current;
        }
    }

    public static abstract class Sub {
        public int mappedDocID;
        final MergeState.DocMap docMap;

        public Sub(MergeState.DocMap docMap) {
            this.docMap = docMap;
        }

        public abstract int nextDoc() throws IOException;
    }
}

