/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import java.util.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00153QAB\u0004\u0001\u000f-A\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006IA\u0006\u0005\u0006A\u0001!\t!\t\u0005\u0006K\u0001!\tE\n\u0005\u0007W\u0001\u0001K\u0011\u0002\u0017\t\r\u0005\u0003\u0001\u0015\"\u0003C\u0005UquN\u001c#bK6|g\u000e\u00165sK\u0006$Gj\\4hKJT!\u0001C\u0005\u0002\r\u00154g-Z2u\u0015\u0005Q\u0011\u0001B2biN\u001c\"\u0001\u0001\u0007\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1A\u000b\u001b:fC\u0012\f\u0001\"\u001b8uKJ4\u0018\r\\\u0002\u0001!\t9b$D\u0001\u0019\u0015\tI\"$\u0001\u0005ekJ\fG/[8o\u0015\tYB$\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?a\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003E\u0011\u0002\"a\t\u0001\u000e\u0003\u001dAQ\u0001\u0006\u0002A\u0002Y\t1A];o)\u00059\u0003C\u0001\u0015*\u001b\u0005a\u0012B\u0001\u0016\u001d\u0005\u0011)f.\u001b;\u0002\u001b\u0011,G/Z2u)\"\u0014X-\u00193t)\u0005i\u0003c\u0001\u00187s9\u0011q\u0006\u000e\b\u0003aMj\u0011!\r\u0006\u0003eU\ta\u0001\u0010:p_Rt\u0014\"A\u000f\n\u0005Ub\u0012a\u00029bG.\fw-Z\u0005\u0003oa\u0012A\u0001T5ti*\u0011Q\u0007\b\t\u0003uyr!a\u000f\u001f\u0011\u0005Ab\u0012BA\u001f\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ub\u0012\u0001\u00049sS:$H\u000b\u001b:fC\u0012\u001cHCA\u0014D\u0011\u0015!U\u00011\u0001.\u0003\u001d!\bN]3bIN\u0004")
public class NonDaemonThreadLogger
extends Thread {
    private final FiniteDuration interval;

    @Override
    public void run() {
        boolean done = false;
        while (!done) {
            Thread.sleep(this.interval.toMillis());
            List<String> runningThreads = this.detectThreads();
            if (runningThreads.isEmpty()) {
                done = true;
                continue;
            }
            this.printThreads(runningThreads);
        }
    }

    private List<String> detectThreads() {
        Set<Thread> threads2 = Thread.getAllStackTraces().keySet();
        ListBuffer nonDaemons = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        threads2.forEach(t -> {
            if (!t.isDaemon()) {
                nonDaemons.$plus$eq(new StringBuilder(5).append(" - ").append(t.getId()).append(": ").append(t).toString());
                return;
            }
        });
        return nonDaemons.toList();
    }

    private void printThreads(List<String> threads2) {
        String msg = threads2.mkString("Non-daemon threads currently preventing JVM termination:", "\n - ", "");
        System.err.println(msg);
    }

    public NonDaemonThreadLogger(FiniteDuration interval) {
        this.interval = interval;
        super("cats-effect-nondaemon-thread-logger");
        this.setDaemon(true);
    }
}

