/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;

public abstract class PointValues {
    public static final int MAX_NUM_BYTES = 16;
    public static final int MAX_DIMENSIONS = 8;

    public static long size(IndexReader reader, String field2) throws IOException {
        long size = 0L;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values2 = ctx.reader().getPointValues(field2);
            if (values2 == null) continue;
            size += values2.size();
        }
        return size;
    }

    public static int getDocCount(IndexReader reader, String field2) throws IOException {
        int count = 0;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values2 = ctx.reader().getPointValues(field2);
            if (values2 == null) continue;
            count += values2.getDocCount();
        }
        return count;
    }

    public static byte[] getMinPackedValue(IndexReader reader, String field2) throws IOException {
        byte[] minValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMinValue;
            PointValues values2 = ctx.reader().getPointValues(field2);
            if (values2 == null || (leafMinValue = values2.getMinPackedValue()) == null) continue;
            if (minValue == null) {
                minValue = (byte[])leafMinValue.clone();
                continue;
            }
            int numDimensions = values2.getNumIndexDimensions();
            int numBytesPerDimension = values2.getBytesPerDimension();
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (Arrays.compareUnsigned(leafMinValue, offset, offset + numBytesPerDimension, minValue, offset, offset + numBytesPerDimension) >= 0) continue;
                System.arraycopy(leafMinValue, offset, minValue, offset, numBytesPerDimension);
            }
        }
        return minValue;
    }

    public static byte[] getMaxPackedValue(IndexReader reader, String field2) throws IOException {
        byte[] maxValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMaxValue;
            PointValues values2 = ctx.reader().getPointValues(field2);
            if (values2 == null || (leafMaxValue = values2.getMaxPackedValue()) == null) continue;
            if (maxValue == null) {
                maxValue = (byte[])leafMaxValue.clone();
                continue;
            }
            int numDimensions = values2.getNumIndexDimensions();
            int numBytesPerDimension = values2.getBytesPerDimension();
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (Arrays.compareUnsigned(leafMaxValue, offset, offset + numBytesPerDimension, maxValue, offset, offset + numBytesPerDimension) <= 0) continue;
                System.arraycopy(leafMaxValue, offset, maxValue, offset, numBytesPerDimension);
            }
        }
        return maxValue;
    }

    protected PointValues() {
    }

    public abstract void intersect(IntersectVisitor var1) throws IOException;

    public abstract long estimatePointCount(IntersectVisitor var1);

    public abstract byte[] getMinPackedValue() throws IOException;

    public abstract byte[] getMaxPackedValue() throws IOException;

    public abstract int getNumDataDimensions() throws IOException;

    public abstract int getNumIndexDimensions() throws IOException;

    public abstract int getBytesPerDimension() throws IOException;

    public abstract long size();

    public abstract int getDocCount();

    public static interface IntersectVisitor {
        public void visit(int var1) throws IOException;

        public void visit(int var1, byte[] var2) throws IOException;

        default public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            int docID;
            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                this.visit(docID, packedValue);
            }
        }

        public Relation compare(byte[] var1, byte[] var2);

        default public void grow(int count) {
        }
    }

    public static enum Relation {
        CELL_INSIDE_QUERY,
        CELL_OUTSIDE_QUERY,
        CELL_CROSSES_QUERY;

    }
}

