/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.util;

import cats.data.NonEmptyList;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.http4s.Header;
import org.http4s.Header$Raw$;
import org.http4s.util.Renderer;
import org.http4s.util.StringWriter;
import org.http4s.util.StringWriter$;
import org.http4s.util.Writer;
import org.typelevel.ci.CIString;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Renderer$ {
    public static final Renderer$ MODULE$ = new Renderer$();
    private static Renderer<Instant> RFC7231InstantRenderer;
    private static final Renderer<String> stringRenderer;
    private static final Renderer<FiniteDuration> finiteDurationRenderer;
    private static final Renderer<Object> longRenderer;
    private static final Renderer<CIString> ciStringRenderer;
    private static volatile boolean bitmap$0;

    static {
        stringRenderer = new Renderer<String>(){

            public Writer render(Writer writer, String string) {
                return writer.$less$less(string);
            }
        };
        finiteDurationRenderer = new Renderer<FiniteDuration>(){

            public Writer render(Writer writer, FiniteDuration d) {
                return writer.$less$less(Long.toString(d.toSeconds()));
            }
        };
        longRenderer = new Renderer<Object>(){

            public Writer render(Writer writer, long d) {
                return writer.$less$less(Long.toString(d));
            }
        };
        ciStringRenderer = new Renderer<CIString>(){

            public Writer render(Writer writer, CIString ciString) {
                return writer.$less$less(ciString);
            }
        };
    }

    public <A> Renderer<A> apply(Renderer<A> ev) {
        return ev;
    }

    public <T> String renderString(T t, Renderer<T> evidence$1) {
        return ((StringWriter)new StringWriter(StringWriter$.MODULE$.$lessinit$greater$default$1()).append(t, evidence$1)).result();
    }

    private Renderer<Instant> RFC7231InstantRenderer$lzycompute() {
        Renderer$ renderer$ = this;
        synchronized (renderer$) {
            if (!bitmap$0) {
                RFC7231InstantRenderer = new Renderer<Instant>(){
                    private final DateTimeFormatter dateFormat;

                    private DateTimeFormatter dateFormat() {
                        return this.dateFormat;
                    }

                    public Writer render(Writer writer, Instant t) {
                        return writer.$less$less(this.dateFormat().format(t));
                    }
                    {
                        this.dateFormat = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz").withLocale(Locale.US).withZone(ZoneId.of("GMT"));
                    }
                };
                bitmap$0 = true;
            }
        }
        return RFC7231InstantRenderer;
    }

    public Renderer<Instant> RFC7231InstantRenderer() {
        if (!bitmap$0) {
            return this.RFC7231InstantRenderer$lzycompute();
        }
        return RFC7231InstantRenderer;
    }

    public Renderer<String> stringRenderer() {
        return stringRenderer;
    }

    public Renderer<FiniteDuration> finiteDurationRenderer() {
        return finiteDurationRenderer;
    }

    public Renderer<Object> longRenderer() {
        return longRenderer;
    }

    public <A, B> Renderer<Either<A, B>> eitherRenderer(Renderer<A> ra, Renderer<B> rb) {
        return new Renderer<Either<A, B>>(ra, rb){
            private final Renderer ra$1;
            private final Renderer rb$1;

            public Writer render(Writer writer, Either<A, B> e) {
                Either<A, B> either2 = e;
                if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    A a = left.value();
                    return this.ra$1.render(writer, a);
                }
                if (either2 instanceof Right) {
                    Right right = (Right)either2;
                    B b = right.value();
                    return this.rb$1.render(writer, b);
                }
                throw new MatchError(either2);
            }
            {
                this.ra$1 = ra$1;
                this.rb$1 = rb$1;
            }
        };
    }

    public Renderer<CIString> ciStringRenderer() {
        return ciStringRenderer;
    }

    public <T> Renderer<NonEmptyList<T>> nelRenderer(Renderer<T> evidence$2) {
        return new Renderer<NonEmptyList<T>>(evidence$2){
            private final Renderer evidence$2$1;

            public Writer render(Writer writer, NonEmptyList<T> values2) {
                return writer.addNel(values2, writer.addNel$default$2(), writer.addNel$default$3(), writer.addNel$default$4(), this.evidence$2$1);
            }
            {
                this.evidence$2$1 = evidence$2$1;
            }
        };
    }

    public <T> Renderer<List<T>> listRenderer(Renderer<T> evidence$3) {
        return new Renderer<List<T>>(evidence$3){
            private final Renderer evidence$3$1;

            public Writer render(Writer writer, List<T> values2) {
                return writer.addList(values2, writer.addList$default$2(), writer.addList$default$3(), writer.addList$default$4(), this.evidence$3$1);
            }
            {
                this.evidence$3$1 = evidence$3$1;
            }
        };
    }

    public <T> Renderer<Set<T>> setRenderer(Renderer<T> evidence$4) {
        return new Renderer<Set<T>>(evidence$4){
            private final Renderer evidence$4$1;

            public Writer render(Writer writer, Set<T> values2) {
                return writer.addSet(values2, writer.addSet$default$2(), writer.addSet$default$3(), writer.addSet$default$4(), this.evidence$4$1);
            }
            {
                this.evidence$4$1 = evidence$4$1;
            }
        };
    }

    public <A> Renderer<A> headerSelectRenderer(Header.Select<A> select) {
        return new Renderer<A>(select){
            private final Header.Select select$1;

            public Writer render(Writer writer, A t) {
                return writer.$less$less(this.select$1.toRaw1(t), (Renderer)((Object)Header$Raw$.MODULE$.catsInstancesForHttp4sHeaderRaw()));
            }
            {
                this.select$1 = select$1;
            }
        };
    }

    private Renderer$() {
    }
}

