/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.Semigroupal;
import cats.effect.SyncIO;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.Message;
import org.http4s.Platform$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class RequestLogger$ {
    public static final RequestLogger$ MODULE$ = new RequestLogger$();
    private static final SelfAwareStructuredLogger<SyncIO> logger = (SelfAwareStructuredLogger)Platform$.MODULE$.loggerFactory().getLogger("org.http4s.client.middleware.RequestLogger");
    private static final String defaultRequestColor = "\u001b[34m";

    private <F> F defaultLogAction(String s, Sync<F> evidence$1) {
        return (F)((SyncIO)logger.info((Function0 & Serializable)() -> s)).to(evidence$1);
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Async<F> evidence$2) {
        return this.impl(client, logBody, (Function1 & Serializable)request -> Logger$.MODULE$.logMessage(request, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$2)), evidence$2), evidence$2);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)RequestLogger$.$anonfun$apply$default$3$1(elem));
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<F>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Async<F> evidence$3) {
        return this.impl(client, true, (Function1 & Serializable)request -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText((Message)request, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$3)), (Monad)evidence$3), evidence$3);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)RequestLogger$.$anonfun$logBodyText$default$3$1(elem));
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, F>> logAction, Function1<Request<F>, F> requestToText, Async<F> evidence$4) {
        return this.impl(client, logBody, (Function1 & Serializable)request -> {
            Function1 log = (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$4));
            return package.all$.MODULE$.toFlatMapOps(requestToText.apply(request), (FlatMap)evidence$4).flatMap(log);
        }, evidence$4);
    }

    public <F> boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Request<F>, F> logMessage, Async<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> {
            if (!logBody) {
                return (Resource)package.all$.MODULE$.catsSyntaxApply((Object)cats.effect.package$.MODULE$.Resource().eval(logMessage.apply(req)), (Apply)Resource$.MODULE$.catsEffectAsyncForResource(F)).$times$greater(client.run((Request)req));
            }
            return cats.effect.package$.MODULE$.Resource().suspend(package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2(F.ref((Object)BoxesRunTime.boxToBoolean((boolean)false)), F.ref((Object)package$.MODULE$.Vector().empty()))).mapN((Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Ref hasLogged = (Ref)tuple2._1();
                    Ref vec = (Ref)tuple2._2();
                    Stream newBody = Stream$.MODULE$.eval(vec.get()).flatMap((Function1 & Serializable)v -> Stream$.MODULE$.emits((Seq)v), NotGiven$.MODULE$.default()).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    Object logOnceAtEnd = IfMOps$.MODULE$.ifM$extension(package.all$.MODULE$.catsSyntaxIfM(hasLogged.getAndSet((Object)BoxesRunTime.boxToBoolean((boolean)true)), (FlatMap)F), (Function0 & Serializable)() -> F.unit(), (Function0 & Serializable)() -> ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(logMessage.apply((Object)req.withBodyStream(newBody)), (ApplicativeError)F), (Function1 & Serializable)x0$2 -> {
                        Throwable throwable = x0$2;
                        return ((SyncIO)logger.error(throwable, (Function0 & Serializable)() -> "Error logging request body")).to((Sync)F);
                    }, (ApplicativeError)F), (FlatMap)F);
                    Function1 & Serializable logPipe = (Function1 & Serializable)x$1 -> Stream.InvariantOps$.MODULE$.observe$extension(Stream$.MODULE$.InvariantOps(x$1), (Function1 & Serializable)x$2 -> x$2.chunks().flatMap((Function1 & Serializable)s -> Stream$.MODULE$.exec(vec.update((Function1 & Serializable)x$3 -> (Vector)x$3.$colon$plus(s))), NotGiven$.MODULE$.default()), (GenConcurrent)F).onFinalizeWeak(logOnceAtEnd, (Applicative)F);
                    Resource resp = client.run((Request)req.pipeBodyThrough((Function1)logPipe));
                    return resp.map((Function1 & Serializable)x$4 -> (Response)x$4.pipeBodyThrough((Function1 & Serializable)x$5 -> x$5.onFinalizeWeak(logOnceAtEnd, (Applicative)F))).onFinalize(logOnceAtEnd, (Applicative)F);
                }
                throw new MatchError((Object)tuple2);
            }, (Functor)F, (Semigroupal)F));
        }, F);
    }

    public String defaultRequestColor() {
        return defaultRequestColor;
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, String color, Option<Function1<String, F>> logAction, Client<F> client, Async<F> F) {
        return this.customized(client, logBody, logAction, (Function1 & Serializable)request -> {
            Object object;
            String methodColor = request.method().isSafe() ? color : "\u001b[33m";
            String prelude = new StringBuilder(14).append(request.httpVersion()).append(" ").append(methodColor).append(request.method()).append("\u001b[0m").append(color).append(" ").append("\u001b[1m").append(request.uri()).append("\u001b[0m").append(color).toString();
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders((Message)request, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody((Message)request, logBody, (GenConcurrent)F);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object textF = some.value();
                object = package.all$.MODULE$.toFunctorOps(textF, (Functor)F).map((Function1 & Serializable)text -> new StringBuilder(7).append("body=\"").append((String)text).append("\"").toString());
            } else if (None$.MODULE$.equals(option)) {
                object = cats.effect.package$.MODULE$.Sync().apply((Sync)F).pure((Object)"");
            } else {
                throw new MatchError((Object)option);
            }
            Object bodyText = object;
            return package.all$.MODULE$.toFunctorOps(bodyText, (Functor)F).map((Function1 & Serializable)body -> new StringBuilder(4).append(color).append(prelude).append(RequestLogger$.spaced$1(headers)).append(RequestLogger$.spaced$1(body)).append("\u001b[0m").toString());
        }, F);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)RequestLogger$.$anonfun$colored$default$3$1(elem));
    }

    public <F> String colored$default$4() {
        return this.defaultRequestColor();
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$logBodyText$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private static final String spaced$1(String x) {
        if (x.isEmpty()) {
            return x;
        }
        return new StringBuilder(1).append(" ").append(x).toString();
    }

    public static final /* synthetic */ boolean $anonfun$colored$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private RequestLogger$() {
    }
}

